/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriservePublish;
import com.farm.bean.AgriservePublishReply;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.mapper.AgriservePublishMapper;
import com.farm.service.AgriservePublishService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="agriservePublishService")
public class AgriservePublishServiceImpl
implements AgriservePublishService {
    @Resource
    private AgriservePublishMapper agriservePublishMapper;

    public JSONObject queryById(Integer id, String phone) {
        AgriservePublish detail = this.agriservePublishMapper.queryById(id);
        detail.setViewCount(Integer.valueOf(detail.getViewCount() + 1));
        Integer count = this.agriservePublishMapper.queryPublishStarByPhone(id, phone);
        if (count != null && count > 0) {
            detail.setUserStar(Boolean.valueOf(true));
        } else {
            detail.setUserStar(Boolean.valueOf(false));
        }
        this.agriservePublishMapper.update(detail);
        JSONObject json = new JSONObject();
        json.put("detail", (Object)detail);
        return json;
    }

    public AgriservePublish insert(AgriservePublish agriservePublish) {
        this.agriservePublishMapper.insert(agriservePublish);
        String publishTypes = agriservePublish.getPublishType();
        if (StringUtils.isNotBlank((String)publishTypes)) {
            String[] pTypeList = publishTypes.split(",");
            this.agriservePublishMapper.insertPTypes(agriservePublish.getId(), pTypeList);
        }
        return agriservePublish;
    }

    public AgriservePublish update(AgriservePublish agriservePublish) {
        this.agriservePublishMapper.update(agriservePublish);
        return this.agriservePublishMapper.queryById(agriservePublish.getId());
    }

    public void removeByIds(List<String> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.agriservePublishMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public List<AgriservePublish> queryPublishList(Integer start, Integer pageSize, String phone, Integer type, List<String> pTypeList, Integer mark) {
        return this.agriservePublishMapper.queryPublishList(start, pageSize, phone, type, pTypeList, mark);
    }

    public Integer queryPublishCount(String phone, Integer type, List<String> pTypeList, Integer mark) {
        return this.agriservePublishMapper.queryPublishCount(phone, type, pTypeList, mark);
    }

    public JSONObject starPublish(String phone, Integer id) {
        Integer count;
        JSONObject json = new JSONObject();
        AgriservePublish publish = this.agriservePublishMapper.queryById(id);
        Integer stars = 0;
        if (publish != null && publish.getStars() != null) {
            stars = publish.getStars();
        }
        if ((count = this.agriservePublishMapper.queryPublishStarByPhone(id, phone)) > 0) {
            publish.setStars(Integer.valueOf(stars - 1));
            this.agriservePublishMapper.deletePublishStarByUser(id, phone);
            json.put("flag", (Object)0);
        } else {
            publish.setStars(Integer.valueOf(stars + 1));
            this.agriservePublishMapper.insertPublishStarByUser(id, phone);
            json.put("flag", (Object)1);
        }
        this.agriservePublishMapper.update(publish);
        return json;
    }

    public JSONObject queryReplyList(Integer id, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        List list = this.agriservePublishMapper.queryReplyList(id, start, pageSize);
        Integer count = this.agriservePublishMapper.queryReplyCount(id);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public AgriservePublishReply addReply(AgriservePublishReply reply) {
        this.agriservePublishMapper.addReply(reply);
        return reply;
    }

    public JSONObject queryReplyListGroupType() {
        List list = this.agriservePublishMapper.queryReplyListGroupType();
        Integer[] sumArray = new Integer[]{0, 0};
        for (LabelResultMap it : list) {
            if (it.getType() == 0) {
                sumArray[0] = it.getCount();
                continue;
            }
            sumArray[1] = it.getCount();
        }
        JSONObject json = new JSONObject();
        json.put("supply", (Object)sumArray[1]);
        json.put("needs", (Object)sumArray[0]);
        return json;
    }

    public List<LabelResultMap> queryReplyListGroupPType(Integer pType) {
        return this.agriservePublishMapper.queryReplyListGroupPType(pType);
    }

    public JSONObject querySearchPublishList(Integer offset, Integer limit, Integer type, String search) {
        List list = this.agriservePublishMapper.querySearchPublishList(type, search, offset, limit);
        Integer count = this.agriservePublishMapper.querySearchPublishCount(type, search);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject querySearchPublishSummary(Integer type, String startDate, String endDate, List<String> typeList) {
        JSONObject json = new JSONObject();
        List allList = this.agriservePublishMapper.querySearchPublishSummary(type, startDate, endDate, typeList);
        List curList = this.agriservePublishMapper.querySearchPublishValidSummary(type, startDate, endDate, typeList);
        List curPublishList = this.agriservePublishMapper.querySearchCurPublishSummary(type, typeList);
        ArrayList list = new ArrayList();
        for (LabelResultMap item : allList) {
            HashMap<String, Integer> itMap = new HashMap<String, Integer>();
            itMap.put("type", item.getType());
            itMap.put("allCount", item.getCount());
            itMap.put("allReadCount", item.getStatus());
            itMap.put("todayPublishCount", 0);
            itMap.put("curCount", 0);
            for (int i = 0; i < curList.size(); ++i) {
                if (((LabelResultMap)curList.get(i)).getType() != item.getType()) continue;
                itMap.put("curCount", ((LabelResultMap)curList.get(i)).getCount());
            }
            for (int j = 0; j < curPublishList.size(); ++j) {
                if (((LabelResultMap)curPublishList.get(j)).getType() != item.getType()) continue;
                itMap.put("todayPublishCount", ((LabelResultMap)curPublishList.get(j)).getCount());
            }
            list.add(itMap);
        }
        json.put("list", list);
        return json;
    }
}

