/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.Configuration;
import com.farm.bean.LytUserActivity;
import com.farm.mapper.ConfigurationMapper;
import com.farm.mapper.LytUserActivityMapper;
import com.farm.service.ConfigService;
import com.farm.util.HttpSendUtil;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="configService")
public class ConfigServiceImpl
implements ConfigService {
    @Autowired
    private ConfigurationMapper configurationMapper;
    @Autowired
    private LytUserActivityMapper activityMapper;

    public Configuration queryByCode(String code) {
        Configuration configuration = this.configurationMapper.queryByCode(code);
        return configuration;
    }

    public void upsertDataMaintenance(Configuration configuration) {
        Configuration itemConfig = this.configurationMapper.queryByCode(configuration.getCode());
        if (itemConfig == null) {
            this.configurationMapper.insert(configuration);
        } else {
            this.configurationMapper.update(configuration);
        }
    }

    public JSONObject queryUserActivities(String[] moduleArray, String date) {
        JSONObject json = new JSONObject();
        List list = this.activityMapper.queryAllGroupLandlord(moduleArray, date);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryModuleActivities(String[] moduleArray, String date) {
        JSONObject json = new JSONObject();
        List list = this.activityMapper.queryAllGroupModule(moduleArray, date);
        json.put("list", (Object)list);
        return json;
    }

    public void postUserActivities(String module, String phone) {
        LytUserActivity userActivity = new LytUserActivity();
        userActivity.setPhone(phone);
        userActivity.setDate(LocalDate.now().toString());
        userActivity.setModule(module);
        Integer count = this.activityMapper.queryAllCount(userActivity);
        if (count == 0) {
            userActivity.setCount(Integer.valueOf(1));
            this.activityMapper.insert(userActivity);
        } else {
            this.activityMapper.addCount(userActivity);
        }
    }

    public JSONObject queryChildModuleActivities(String[] moduleArray, String date) {
        JSONObject json = new JSONObject();
        List list = this.activityMapper.queryChildModuleActivities(moduleArray, date);
        String code = "module_function";
        Configuration configuration = this.configurationMapper.queryByCode(code);
        json.put("list", (Object)list);
        json.put("configuration", (Object)configuration);
        return json;
    }

    public JSONObject postPreDealCenterInfo(String subject, String content, String occurDate, List<String> attachFiles) {
        JSONObject json = new JSONObject();
        json.put("appKey", (Object)"");
        json.put("sourcePlatformCode", (Object)"");
        json.put("departmentNo", (Object)"");
        json.put("oid", (Object)"");
        json.put("issueContent", (Object)content);
        json.put("occurDate", (Object)occurDate);
        json.put("subject", (Object)subject);
        json.put("dealUserMobile", (Object)"");
        json.put("createUser", (Object)"\u9f99\u6e38\u53bf\u519c\u4e1a\u519c\u6751\u5c40");
        json.put("important", (Object)false);
        json.put("isEmergency", (Object)false);
        json.put("issueRelevances", (Object)new JSONArray());
        json.put("lat", (Object)"");
        json.put("lon", (Object)"");
        json.put("addressCode", (Object)"");
        json.put("occurLocation", (Object)"");
        json.put("reportSerialNumber", (Object)"");
        json.put("categoryCode", (Object)"330100001001");
        JSONArray fileArray = new JSONArray();
        if (attachFiles != null && attachFiles.size() > 0) {
            for (int i = 0; i < attachFiles.size(); ++i) {
                JSONObject itJson = new JSONObject();
                Integer pntIdx = attachFiles.get(i).lastIndexOf(".");
                Integer nameIdx = attachFiles.get(i).lastIndexOf("/");
                itJson.put("fileName", (Object)attachFiles.get(i).substring(nameIdx));
                itJson.put("fullUrl", (Object)attachFiles.get(i));
                itJson.put("type", (Object)attachFiles.get(i).substring(pntIdx));
                itJson.put("uri", (Object)"");
                fileArray.add((Object)itJson);
            }
        }
        json.put("attachFileList", (Object)fileArray);
        HttpSendUtil.sendHttpPost((String)"host", (String)"/api/issue-business-server/issue/outside/create/appeal", (String)"", (String)json.toJSONString());
        return null;
    }
}

