/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriserveLandlord;
import com.farm.bean.Company;
import com.farm.bean.DatavFoodProduct;
import com.farm.bean.DatavIndustrialResources;
import com.farm.bean.DatavIndustryPercentage;
import com.farm.bean.DatavOutputValue;
import com.farm.bean.DatavYieldArea;
import com.farm.bean.resultMap.RegionResultMap;
import com.farm.mapper.DatavHomePCMapper;
import com.farm.service.DatavHomePCService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="datavHomePCService")
public class DatavHomePCServiceImpl
implements DatavHomePCService {
    @Autowired
    private DatavHomePCMapper datavHomePCMapper;

    public List<DatavFoodProduct> queryFoodProductOverviewByRegionCode(String regionCode) {
        return this.datavHomePCMapper.queryFoodProductOverviewByRegionCode(regionCode);
    }

    @Transactional
    public void upsertFoodProductOverview(List<DatavFoodProduct> datavFoodProductList) {
        List idList = datavFoodProductList.stream().map(DatavFoodProduct::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.datavHomePCMapper.deleteFoodProductOverviewByRegionCodeAndIdList(idList, datavFoodProductList.get(0).getRegionCode());
        }
        datavFoodProductList.forEach(datavFoodProduct -> {
            if (datavFoodProduct.getId() == null) {
                this.datavHomePCMapper.insertFoodProductOverview(datavFoodProduct);
            } else {
                this.datavHomePCMapper.updateFoodProductOverview(datavFoodProduct);
            }
        });
    }

    public DatavIndustrialResources queryResourceStatisticsByRegionCode(String regionCode) {
        return this.datavHomePCMapper.queryIndustrialResourcesByRegionCode(regionCode);
    }

    public DatavIndustrialResources queryIndustrialResourcesByRegionCode(String regionCode) {
        return this.datavHomePCMapper.queryIndustrialResourcesByRegionCode(regionCode);
    }

    public void upsertIndustrialResources(DatavIndustrialResources datavIndustrialResources) {
        if (datavIndustrialResources.getId() == null) {
            this.datavHomePCMapper.insertIndustrialResources(datavIndustrialResources);
        } else {
            this.datavHomePCMapper.updateIndustrialResources(datavIndustrialResources);
        }
    }

    public List<DatavYieldArea> queryYieldAreaStatistics() {
        return this.datavHomePCMapper.queryYieldList();
    }

    public void upsertYieldAreaStatistics(List<DatavYieldArea> datavYieldAreaList) {
        datavYieldAreaList.forEach(datavYieldArea -> {
            DatavYieldArea item = this.datavHomePCMapper.queryYieldAreaStatisticsByRegionCode(datavYieldArea.getRegionCode(), datavYieldArea.getYears());
            if (item == null) {
                this.datavHomePCMapper.insertYieldAreaStatistics(datavYieldArea);
            } else {
                this.datavHomePCMapper.updateYieldAreaStatistics(datavYieldArea);
            }
        });
    }

    public JSONObject queryUserYieldAreaStatistics(String regionCode, Integer start, Integer pageSize) {
        List landlordList = this.datavHomePCMapper.queryUserYieldAreaStatistics(regionCode);
        Integer count = this.datavHomePCMapper.queryLandlordCount(regionCode);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)landlordList);
        return jsonObject;
    }

    public List<DatavOutputValue> queryOutputTrendByRegionCode(String regionCode) {
        return this.datavHomePCMapper.queryOutputTrendByRegionCode(regionCode);
    }

    public void upsertOutputTrend(List<DatavOutputValue> datavOutputValueList) {
        List idList = datavOutputValueList.stream().map(DatavOutputValue::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.datavHomePCMapper.deleteOutputTrendByRegionCodeAndIdList(datavOutputValueList.get(0).getRegionCode(), idList);
        }
        datavOutputValueList.forEach(datavOutputValue -> {
            if (datavOutputValue.getId() == null) {
                this.datavHomePCMapper.insertOutputTrend(datavOutputValue);
            } else {
                this.datavHomePCMapper.updateOutputTrend(datavOutputValue);
            }
        });
    }

    public DatavIndustryPercentage queryIndustryPercentageByRegionCode(String regionCode) {
        return this.datavHomePCMapper.queryIndustryPercentageByRegionCode(regionCode);
    }

    public void upsertIndustryPercentage(DatavIndustryPercentage datavIndustryPercentage) {
        if (datavIndustryPercentage.getId() == null) {
            this.datavHomePCMapper.insertIndustryPercentage(datavIndustryPercentage);
        } else {
            this.datavHomePCMapper.updateIndustryPercentage(datavIndustryPercentage);
        }
    }

    public List<RegionResultMap> queryLandlordAgribusinessByRegionCode(String regionCode) {
        List regionResultMapList = this.datavHomePCMapper.queryRegionCodeChildren(regionCode);
        regionResultMapList.forEach(regionResultMap -> {
            regionResultMap.setAgriserveLandlordList(this.datavHomePCMapper.queryLandlordListByRegionCode(regionResultMap.getId()));
            regionResultMap.setCompanyList(this.datavHomePCMapper.queryAgribusinessListByRegionCode(regionResultMap.getId()));
        });
        return regionResultMapList;
    }

    public JSONObject queryLandlordAgribusinessDetail(Integer id, Integer type) {
        JSONObject jsonObject = new JSONObject();
        if (type == 1) {
            AgriserveLandlord agriserveLandlord = this.datavHomePCMapper.queryLandlordById(id);
            List fieldDoubleStatusList = this.datavHomePCMapper.queryAgriserveLandlordFieldInfo(agriserveLandlord.getPhone());
            fieldDoubleStatusList.forEach(field -> field.setImg(field.getImg().contains("http") ? field.getImg() : "http://imgs.shuxitech.com/farm/field_img/" + field.getImg()));
            agriserveLandlord.setFieldDoubleStatusList(fieldDoubleStatusList);
            jsonObject.put("landlord", (Object)agriserveLandlord);
        } else if (type == 2) {
            Company company = this.datavHomePCMapper.queryAgribusinessById(id);
            jsonObject.put("company", (Object)company);
        }
        return jsonObject;
    }
}

