/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DownloadService {
    private static final Logger log = LoggerFactory.getLogger(DownloadService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downInChargeOfTemplate(HttpServletResponse response, String fileName) {
        block5: {
            this.responseSetting(response, fileName, ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            InputStream inputStream = null;
            ServletOutputStream outputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("templates/" + fileName + ".xlsx");
                XSSFWorkbook wb = new XSSFWorkbook(inputStream);
                outputStream = response.getOutputStream();
                wb.write((OutputStream)outputStream);
                outputStream.flush();
                IoUtil.close((Closeable)inputStream);
            }
            catch (IOException e) {
                log.error("\u83b7\u53d6\u6a21\u7248\u5931\u8d25!");
                break block5;
            }
            finally {
                IoUtil.close(inputStream);
                IoUtil.close(outputStream);
            }
            IoUtil.close((Closeable)outputStream);
        }
    }

    public void responseSetting(HttpServletResponse response, String fileName, String suffix, String contentType) {
        String newFileName = null;
        try {
            newFileName = URLEncoder.encode(fileName, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u83b7\u53d6\u6a21\u7248\u5931\u8d25!");
        }
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + newFileName + suffix);
        response.setContentType(contentType);
        response.setCharacterEncoding("utf-8");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }
}

