/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmCropPlan;
import com.farm.bean.FarmCropRecord;
import com.farm.bean.FarmResourceClassify;
import com.farm.bean.FarmResourceInfo;
import com.farm.bean.FieldDoubleStatus;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.mapper.FarmCropPlanMapper;
import com.farm.mapper.FarmCropRecordMapper;
import com.farm.mapper.FarmResourceClassifyMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.service.FarmCropPlanService;
import com.farm.util.DateUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="farmCropPlanService")
public class FarmCropPlanServiceImpl
implements FarmCropPlanService {
    @Autowired
    private FarmCropPlanMapper farmCropPlanMapper;
    @Autowired
    private FarmCropRecordMapper farmCropRecordMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private FarmResourceClassifyMapper farmResourceClassifyMapper;

    @Transactional
    public void insert(FarmCropPlan farmCropPlan) {
        this.farmCropPlanMapper.insert(farmCropPlan);
        this.insertCropRecord(farmCropPlan);
    }

    @Transactional
    public void update(FarmCropPlan farmCropPlan) {
        this.farmCropPlanMapper.update(farmCropPlan);
        List farmCropRecordList = this.farmCropPlanMapper.queryCropRecordListByPlanId(farmCropPlan.getId());
        farmCropRecordList.forEach(farmCropRecord -> this.farmCropRecordMapper.deleteInfoRecordList(farmCropRecord.getId()));
        this.farmCropPlanMapper.deleteRecordByPlanId(farmCropPlan.getId());
        this.insertCropRecord(farmCropPlan);
    }

    private void insertCropRecord(FarmCropPlan farmCropPlan) {
        List farmCropRecordList = farmCropPlan.getFarmCropRecordList();
        ArrayList farmInfoRecordList = new ArrayList();
        farmCropRecordList.forEach(farmCropRecord -> {
            farmCropRecord.setPlanId(farmCropPlan.getId());
            farmCropRecord.setUseFlag(Integer.valueOf(farmCropRecord.getType() == 1 ? 0 : 1));
            this.farmCropRecordMapper.insert(farmCropRecord);
            List farmInfoRecordListTemp = farmCropRecord.getFarmInfoRecordList();
            if (farmInfoRecordListTemp.size() < 1) {
                return;
            }
            farmInfoRecordListTemp.forEach(farmInfoRecord -> {
                farmInfoRecord.setRecordId(farmCropRecord.getId());
                farmInfoRecordList.add(farmInfoRecord);
            });
        });
        if (farmInfoRecordList.size() > 0) {
            this.farmCropRecordMapper.insertInfoRecordBatch(farmInfoRecordList);
        }
    }

    public FarmCropPlan queryCropPlanDetail(Integer id) {
        FarmCropPlan farmCropPlan = this.farmCropPlanMapper.queryCropPlanDetail(id);
        List farmCropRecordList = this.farmCropPlanMapper.queryCropRecordListByPlanId(farmCropPlan.getId());
        farmCropRecordList.forEach(farmCropRecord -> farmCropRecord.setFarmInfoRecordList(this.farmCropRecordMapper.queryInfoRecordListByRecordId(farmCropRecord.getId())));
        farmCropPlan.setFarmCropRecordList(farmCropRecordList);
        return farmCropPlan;
    }

    public void disableCropPlan(Integer id, Integer status) {
        this.farmCropPlanMapper.disableCropPlan(id, status);
    }

    @Transactional
    public void useCropRecord(List<String> recordIdList, Integer fieldId, Integer type) {
        this.farmCropRecordMapper.deleteCropRecordByFieldId(fieldId);
        this.farmCropRecordMapper.updateCropRecordByPlanId(fieldId);
        if (type == 1) {
            FieldDoubleStatus fieldDoubleStatus = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(fieldId);
            List farmCropRecordList = this.farmCropRecordMapper.queryCropRecordById(recordIdList);
            this.farmCropRecordMapper.deleteInfoRecordByFieldId(fieldId);
            farmCropRecordList.forEach(farmCropRecord -> {
                List farmInfoRecordList = this.farmCropRecordMapper.queryInfoRecordListByRecordId(farmCropRecord.getId());
                farmCropRecord.setFieldId(fieldId);
                farmCropRecord.setStartTime(DateUtil.addDate((String)fieldDoubleStatus.getSowTime(), (int)farmCropRecord.getDays()));
                farmCropRecord.setEndTime(DateUtil.addDate((String)fieldDoubleStatus.getSowTime(), (int)farmCropRecord.getDays()));
                farmCropRecord.setType(Integer.valueOf(2));
                farmCropRecord.setFinishRate(Double.valueOf(0.0));
                farmCropRecord.setUseFlag(Integer.valueOf(1));
                farmCropRecord.setId(null);
                this.farmCropRecordMapper.insert(farmCropRecord);
                if (farmInfoRecordList.size() > 0) {
                    farmInfoRecordList.forEach(farmInfoRecord -> farmInfoRecord.setRecordId(farmCropRecord.getId()));
                    this.farmCropRecordMapper.insertInfoRecordBatch(farmInfoRecordList);
                }
            });
        } else if (type == 2) {
            this.farmCropRecordMapper.useCropRecord(recordIdList);
        }
    }

    public JSONObject queryFieldRecordList(Integer fieldId, Integer start, Integer pageSize, String date, Integer farmType) {
        List list;
        if (StringUtils.isBlank((String)date) || date.length() == 4) {
            LocalDate beginYear = LocalDate.parse(date + "-01-01");
            list = this.farmCropRecordMapper.queryRecordListByYearMonth(fieldId, start, pageSize, date, farmType, beginYear.toString());
        } else if (date.length() == 7) {
            LocalDate beginMonth = LocalDate.parse(date + "-01");
            list = this.farmCropRecordMapper.queryRecordListByYearMonth(fieldId, start, pageSize, date, farmType, beginMonth.toString());
        } else {
            list = date.length() == 10 ? this.farmCropRecordMapper.queryRecordListByByDate(fieldId, start, pageSize, date, farmType) : new ArrayList();
        }
        JSONObject json = new JSONObject();
        json.put("list", list);
        return json;
    }

    public JSONObject queryFieldRecordCalendar(Integer fieldId, String date) {
        LocalDate beginDate = LocalDate.parse(date + "-01");
        LocalDate endDate = beginDate.plusMonths(1L).minusDays(1L);
        List list = this.farmCropRecordMapper.queryFieldRecordCalendar(fieldId, beginDate.toString(), endDate.toString());
        HashSet<String> dateSet = new HashSet<String>();
        LinkedList<FarmCropRecord> dateList = new LinkedList<FarmCropRecord>();
        for (FarmCropRecord record : list) {
            dateSet.add(record.getStartTime());
            dateSet.add(record.getEndTime());
            if (Objects.equals(record.getStartTime(), record.getEndTime())) continue;
            dateList.add(record);
        }
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        beginDate = beginDate.minusDays(1L);
        while (beginDate.isBefore(endDate)) {
            Boolean flag = false;
            if (dateSet.contains((beginDate = beginDate.plusDays(1L)).toString())) {
                flag = true;
            } else if (dateList != null && dateList.size() > 0) {
                for (FarmCropRecord it : dateList) {
                    LocalDate date0 = LocalDate.parse(it.getStartTime());
                    LocalDate date1 = LocalDate.parse(it.getEndTime());
                    if (beginDate.isBefore(date0) || beginDate.isAfter(date1)) continue;
                    flag = true;
                    break;
                }
            }
            map.put(beginDate.toString(), flag);
        }
        JSONObject json = new JSONObject();
        json.put("calendar", map);
        return json;
    }

    public FarmCropPlan queryCropPlanByCropType(Integer cropType) {
        FarmCropPlan farmCropPlan = this.farmCropPlanMapper.queryCropPlanByCropType(cropType);
        farmCropPlan.setFarmCropRecordList(this.farmCropPlanMapper.queryCropRecordListByPlanId(farmCropPlan.getId()));
        return farmCropPlan;
    }

    public JSONObject queryCropPlanPage(Integer cropType, Integer start, Integer pageSize) {
        Integer count = this.farmCropPlanMapper.queryCropPlanCount(cropType);
        List farmCropPlanList = this.farmCropPlanMapper.queryCropPlanPage(cropType, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)farmCropPlanList);
        return jsonObject;
    }

    @Transactional
    public void deleteCropPlanById(Integer planId) {
        this.farmCropPlanMapper.deleteCropPlanById(planId);
        this.farmCropPlanMapper.deleteRecordByPlanId(planId);
    }

    @Transactional
    public JSONObject queryCropRecordSystem(Integer fieldId, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        FieldDoubleStatus fieldDoubleStatus = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(fieldId);
        Integer count = this.farmCropPlanMapper.queryCropRecordCountByCropType(fieldDoubleStatus.getCropSubId());
        List farmCropRecordList = this.farmCropPlanMapper.queryCropRecordListByCropType(fieldDoubleStatus.getCropSubId(), start, pageSize);
        farmCropRecordList.forEach(farmCropRecord -> {
            farmCropRecord.setStartTime(DateUtil.addDate((String)fieldDoubleStatus.getSowTime(), (int)farmCropRecord.getDays()));
            farmCropRecord.setEndTime(DateUtil.addDate((String)fieldDoubleStatus.getSowTime(), (int)farmCropRecord.getDays()));
        });
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)farmCropRecordList);
        return jsonObject;
    }

    public List<FarmResourceClassify> queryResourceClassifyList() {
        List farmResourceInfoList = this.farmResourceClassifyMapper.queryResourceListBySearch("");
        if (farmResourceInfoList.size() > 0) {
            List classifyIdList = farmResourceInfoList.stream().map(FarmResourceInfo::getClassifyId).collect(Collectors.toList());
            List resourceClassifyList = this.farmResourceClassifyMapper.queryResourceClassifyListByIdList(classifyIdList);
            List parentIdList = resourceClassifyList.stream().map(FarmResourceClassify::getParentId).collect(Collectors.toList());
            List parentClassifyList = this.farmResourceClassifyMapper.queryResourceClassifyListByIdList(parentIdList);
            ArrayList<FarmResourceClassify> childList = new ArrayList<FarmResourceClassify>();
            parentClassifyList.forEach(recordResourceClassify -> {
                List childClassifyList = resourceClassifyList.stream().filter(farmResourceClassify -> farmResourceClassify.getParentId().equals(recordResourceClassify.getId())).collect(Collectors.toList());
                childList.addAll(childClassifyList);
            });
            return childList;
        }
        return new ArrayList<FarmResourceClassify>();
    }

    public List<LabelResultMap> queryClassifyUseRatio(Integer classifyId, String startTime, String endTime) {
        return this.farmCropRecordMapper.queryClassifyUseRatio(classifyId, startTime, endTime);
    }

    public List<LabelResultMap> queryFarmTypeUseRatio(String startTime, String endTime) {
        return this.farmCropRecordMapper.queryFarmTypeUseRatio(startTime, endTime);
    }

    public List<LabelResultMap> queryFarmCountByStat(Integer type) {
        ArrayList<LabelResultMap> labelResultMapList = new ArrayList();
        if (type == 1) {
            labelResultMapList = this.farmCropRecordMapper.queryFarmCountByYear();
        } else if (type == 2) {
            int year = LocalDate.now().getYear();
            for (int i = 1; i < 13; ++i) {
                String mouth = year + (i < 10 ? "-0" : "-") + i;
                Integer count = this.farmCropRecordMapper.queryFarmCountByMouth(mouth);
                labelResultMapList.add(new LabelResultMap(i + "\u6708", count));
            }
        }
        return labelResultMapList;
    }

    public List<LabelResultMap> queryFarmClassifyUseOrder(String time, Integer classifyId) {
        return this.farmCropRecordMapper.queryFarmClassifyUseOrder(time, classifyId);
    }

    @Transactional
    public boolean batchAdd(String body) {
        int falg = 0;
        List planList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)JSONObject.parseObject((String)body).getJSONArray("list")), FarmCropPlan.class);
        if (planList != null && planList.size() > 0) {
            falg = this.farmCropPlanMapper.insertBatch(planList);
            ArrayList allList = new ArrayList();
            planList.stream().map(it -> {
                if (it.getFarmCropRecordList() != null && it.getFarmCropRecordList().size() > 0) {
                    it.getFarmCropRecordList().forEach(cropRecord -> {
                        cropRecord.setPlanId(it.getId());
                        cropRecord.setUseFlag(Integer.valueOf(it.getType() == 1 ? 0 : 1));
                    });
                }
                return it.getFarmCropRecordList();
            }).collect(Collectors.toList()).forEach(it -> {
                if (it != null && it.size() > 0) {
                    allList.addAll(it);
                }
            });
            if (allList.size() > 0) {
                this.farmCropRecordMapper.insertBatch(allList);
            }
            ArrayList infoRecordList = new ArrayList();
            allList.stream().map(it -> {
                if (it.getFarmInfoRecordList() != null && it.getFarmInfoRecordList().size() > 0) {
                    it.getFarmInfoRecordList().forEach(infoRecord -> infoRecord.setRecordId(it.getId()));
                }
                return it.getFarmInfoRecordList();
            }).forEach(li -> {
                if (li != null && li.size() > 0) {
                    infoRecordList.addAll(li);
                }
            });
            if (infoRecordList.size() > 0) {
                this.farmCropRecordMapper.insertInfoRecordBatch(infoRecordList);
            }
        }
        return falg > 0;
    }
}

