/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmCropRecord;
import com.farm.bean.FarmInfoRecord;
import com.farm.mapper.FarmCropRecordMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.service.FarmCropRecordService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="farmCropRecordService")
public class FarmCropRecordServiceImpl
implements FarmCropRecordService {
    @Autowired
    private FarmCropRecordMapper farmCropRecordMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;

    public void insert(FarmCropRecord farmCropRecord) {
        farmCropRecord.setUseFlag(Integer.valueOf(farmCropRecord.getType() == 1 ? 0 : 1));
        this.farmCropRecordMapper.insert(farmCropRecord);
        this.insertInfoRecordBatch(farmCropRecord);
    }

    public void update(FarmCropRecord farmCropRecord) {
        this.farmCropRecordMapper.update(farmCropRecord);
        this.farmCropRecordMapper.deleteInfoRecordList(farmCropRecord.getId());
        this.insertInfoRecordBatch(farmCropRecord);
    }

    private void insertInfoRecordBatch(FarmCropRecord farmCropRecord) {
        List farmInfoRecordList = farmCropRecord.getFarmInfoRecordList();
        if (farmInfoRecordList.size() > 0) {
            farmInfoRecordList.forEach(farmInfoRecord -> farmInfoRecord.setRecordId(farmCropRecord.getId()));
            this.farmCropRecordMapper.insertInfoRecordBatch(farmInfoRecordList);
        }
    }

    public List<FarmCropRecord> queryCropRecordListByFieldId(Integer fieldId, Integer type) {
        return this.farmCropRecordMapper.queryCropRecordListByFieldId(fieldId, type);
    }

    public void deleteCropRecordById(Integer recordId) {
        this.farmCropRecordMapper.deleteCropRecordById(recordId);
    }

    public FarmCropRecord queryCropRecordDetail(Integer id) {
        FarmCropRecord farmCropRecord = this.farmCropRecordMapper.queryCropRecordDetail(id);
        farmCropRecord.setFieldDoubleStatus(this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(farmCropRecord.getFieldId()));
        farmCropRecord.setFarmInfoRecordList(this.farmCropRecordMapper.queryInfoRecordListByRecordId(id));
        return farmCropRecord;
    }

    public Integer queryFarmCropRecordByPhoneAndTodayCount(String phone) {
        return this.farmCropRecordMapper.queryFarmCropRecordByPhoneAndTodayCount(phone);
    }

    public List<FarmCropRecord> queryFarmCropRecordByPhoneAndToday(String phone, Integer start, Integer pageSize) {
        return this.farmCropRecordMapper.queryFarmCropRecordByPhoneAndToday(phone, start, pageSize);
    }

    @Transactional
    public boolean batchAdd(String body) {
        FarmCropRecord record = (FarmCropRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FarmCropRecord.class);
        if (record != null && StringUtils.isNotBlank((CharSequence)record.getFieldIds())) {
            record.setUseFlag(Integer.valueOf(record.getType() == 1 ? 0 : 1));
            ArrayList allList = new ArrayList();
            AtomicReference addRecord = new AtomicReference();
            List<Integer> list = Arrays.stream(record.getFieldIds().trim().split(",")).map(Integer::parseInt).collect(Collectors.toList());
            list.forEach(it -> {
                addRecord.set(new FarmCropRecord());
                BeanUtils.copyProperties((Object)record, addRecord.get());
                ((FarmCropRecord)addRecord.get()).setFieldId(it);
                allList.add(addRecord.get());
            });
            if (allList.size() > 0) {
                this.farmCropRecordMapper.insertBatch(allList);
            }
            ArrayList infoRecordList = new ArrayList();
            allList.forEach(it -> {
                if (it.getFarmInfoRecordList() != null && it.getFarmInfoRecordList().size() > 0) {
                    it.getFarmInfoRecordList().forEach(info -> {
                        FarmInfoRecord infoRecord = new FarmInfoRecord();
                        BeanUtils.copyProperties((Object)info, (Object)infoRecord);
                        infoRecord.setRecordId(it.getId());
                        infoRecordList.add(infoRecord);
                    });
                }
            });
            if (infoRecordList.size() > 0) {
                this.farmCropRecordMapper.insertInfoRecordBatch(infoRecordList);
            }
        }
        return false;
    }
}

