/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmResourceClassify;
import com.farm.bean.FarmResourceInfo;
import com.farm.mapper.FarmResourceClassifyMapper;
import com.farm.service.FarmResourceClassifyService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="resourceClassifyService")
public class FarmResourceClassifyServiceImpl
implements FarmResourceClassifyService {
    @Autowired
    private FarmResourceClassifyMapper farmResourceClassifyMapper;

    @Transactional
    public void insert(FarmResourceClassify farmResourceClassify) {
        this.farmResourceClassifyMapper.insert(farmResourceClassify);
        this.insertChildClassify(farmResourceClassify);
    }

    @Transactional
    public void update(FarmResourceClassify farmResourceClassify) {
        this.farmResourceClassifyMapper.update(farmResourceClassify);
        List childList = this.farmResourceClassifyMapper.queryChildListByParentId(farmResourceClassify.getId());
        this.farmResourceClassifyMapper.deleteClassifyByParentId(farmResourceClassify.getId());
        this.farmResourceClassifyMapper.deleteResourceListByClassifyIdList(childList.stream().map(FarmResourceClassify::getId).collect(Collectors.toList()));
        this.insertChildClassify(farmResourceClassify);
    }

    private void insertChildClassify(FarmResourceClassify farmResourceClassify) {
        List childList = farmResourceClassify.getChildList();
        ArrayList farmResourceInfoList = new ArrayList();
        childList.forEach(item -> {
            item.setParentId(farmResourceClassify.getId());
            this.farmResourceClassifyMapper.insertChild(item);
            item.getFarmResourceInfoList().forEach(farmResourceInfo -> {
                farmResourceInfo.setClassifyId(item.getId());
                farmResourceInfoList.add(farmResourceInfo);
            });
        });
        this.farmResourceClassifyMapper.insertResourceBatch(farmResourceInfoList);
    }

    public void deleteResourceClassify(Integer id) {
        this.farmResourceClassifyMapper.deleteResourceClassify(id);
    }

    public void topResourceClassify(Integer id, Integer topFlag) {
        this.farmResourceClassifyMapper.topResourceClassify(id, topFlag);
    }

    public void disableResourceClassify(Integer id, Integer status) {
        this.farmResourceClassifyMapper.disableResourceClassify(id, status);
    }

    public FarmResourceClassify queryResourceClassifyDetail(Integer id) {
        FarmResourceClassify farmResourceClassify = this.farmResourceClassifyMapper.queryParentClassifyById(id);
        List farmResourceClassifyList = this.farmResourceClassifyMapper.queryChildListByParentId(id);
        farmResourceClassify.setChildList(farmResourceClassifyList);
        farmResourceClassifyList.forEach(item -> item.setFarmResourceInfoList(this.farmResourceClassifyMapper.queryResourceListByClassifyId(item.getId())));
        return farmResourceClassify;
    }

    public JSONObject queryResourceClassifyPage(String name, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.farmResourceClassifyMapper.queryResourceClassifyCount(name);
        List resourceClassifyList = this.farmResourceClassifyMapper.queryResourceClassifyPage(name, start, pageSize);
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)resourceClassifyList);
        return jsonObject;
    }

    public List<FarmResourceClassify> queryResourceClassifyList(String search) {
        List farmResourceInfoList = this.farmResourceClassifyMapper.queryResourceListBySearch(search);
        if (farmResourceInfoList.size() > 0) {
            List classifyIdList = farmResourceInfoList.stream().map(FarmResourceInfo::getClassifyId).collect(Collectors.toList());
            List resourceClassifyList = this.farmResourceClassifyMapper.queryResourceClassifyListByIdList(classifyIdList);
            List parentIdList = resourceClassifyList.stream().map(FarmResourceClassify::getParentId).collect(Collectors.toList());
            List parentClassifyList = this.farmResourceClassifyMapper.queryResourceClassifyListByIdList(parentIdList);
            parentClassifyList.forEach(recordResourceClassify -> {
                List<FarmResourceClassify> childClassifyList = resourceClassifyList.stream().filter(farmResourceClassify -> farmResourceClassify.getParentId().equals(recordResourceClassify.getId())).collect(Collectors.toList());
                childClassifyList.forEach(item -> item.setFarmResourceInfoList(farmResourceInfoList.stream().filter(farmResourceInfo -> farmResourceInfo.getClassifyId().equals(item.getId())).collect(Collectors.toList())));
                recordResourceClassify.setChildList(childClassifyList);
            });
            return parentClassifyList;
        }
        return new ArrayList<FarmResourceClassify>();
    }
}

