/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmserveExpert;
import com.farm.bean.FarmserveExpertImport;
import com.farm.bean.FarmserveExpertQa;
import com.farm.bean.LytRoleUser;
import com.farm.bean.LytUser;
import com.farm.mapper.FarmserveExpertMapper;
import com.farm.mapper.FarmserveExpertQaMapper;
import com.farm.service.FarmserveExpertService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="farmserveExpertService")
public class FarmserveExpertServiceImpl
implements FarmserveExpertService {
    @Resource
    private FarmserveExpertMapper farmserveExpertMapper;
    @Autowired
    private FarmserveExpertQaMapper farmserveExpertQaMapper;

    public FarmserveExpert queryById(Integer id) {
        return this.farmserveExpertMapper.queryById(id);
    }

    public FarmserveExpert insert(FarmserveExpert farmserveExpert) {
        LytRoleUser lytRoleUser;
        LytUser lytUser = this.farmserveExpertMapper.queryUserByPhone(farmserveExpert.getPhone());
        if (lytUser == null) {
            this.farmserveExpertMapper.insertUser(new LytUser("sx" + farmserveExpert.getPhone(), farmserveExpert.getUserName(), farmserveExpert.getAvatar(), farmserveExpert.getPhone()));
            farmserveExpert.setUserId("sx" + farmserveExpert.getPhone());
            lytRoleUser = this.farmserveExpertMapper.queryExpertRole("sx" + farmserveExpert.getPhone());
        } else {
            this.farmserveExpertMapper.updateUser(new LytUser(lytUser.getUserId(), farmserveExpert.getUserName(), farmserveExpert.getAvatar(), farmserveExpert.getPhone()));
            farmserveExpert.setUserId(lytUser.getUserId());
            lytRoleUser = this.farmserveExpertMapper.queryExpertRole(lytUser.getUserId());
        }
        this.farmserveExpertMapper.insert(farmserveExpert);
        if (lytRoleUser == null) {
            this.farmserveExpertMapper.insertExpertRole(farmserveExpert.getUserId());
        }
        return farmserveExpert;
    }

    public FarmserveExpert update(FarmserveExpert farmserveExpert) {
        this.farmserveExpertMapper.updateUser(new LytUser(farmserveExpert.getUserId(), farmserveExpert.getUserName(), farmserveExpert.getAvatar(), farmserveExpert.getPhone()));
        this.farmserveExpertMapper.update(farmserveExpert);
        return this.queryById(farmserveExpert.getId());
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.farmserveExpertMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public List<FarmserveExpert> queryList(Integer offset, Integer limit) {
        return this.farmserveExpertMapper.queryAllByLimit(offset, limit);
    }

    public JSONObject queryExpertQaList(Integer expertId, Integer offset, Integer limit) {
        JSONObject json = new JSONObject();
        FarmserveExpert expertInfo = this.farmserveExpertMapper.queryById(expertId);
        if (expertInfo == null || expertInfo.getBlocked() == null || expertInfo.getBlocked() == 1) {
            throw new RuntimeException("\u4e13\u5bb6\u5df2\u88ab\u51bb\u7ed3\uff01");
        }
        Integer count = this.farmserveExpertQaMapper.queryReplyCount(expertId);
        List list = this.farmserveExpertQaMapper.queryReplyList(expertId, offset, limit);
        if (list != null && list.size() > 0) {
            this.farmserveExpertQaMapper.updateQaLookTimes(list);
            for (FarmserveExpertQa qa : list) {
                Integer id = qa.getId();
                FarmserveExpertQa expertAnswer = this.farmserveExpertQaMapper.queryExpertAnswer(id, expertId);
                ArrayList<FarmserveExpertQa> expertAnswerList = new ArrayList<FarmserveExpertQa>();
                expertAnswerList.add(expertAnswer);
                qa.setExpertAnswerList(expertAnswerList);
                List subIdList = this.farmserveExpertQaMapper.querySubListCountByQaId(id);
                Integer answerCount = subIdList.size();
                if (subIdList.size() > 0) {
                    Integer answerCount1 = this.farmserveExpertQaMapper.queryAnswerSubListCountBySubIdList(subIdList);
                    answerCount = answerCount + answerCount1;
                }
                qa.setAnswerCount(answerCount);
            }
        }
        json.put("expertInfo", (Object)expertInfo);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject tipOffExpertQa(Integer id) {
        this.farmserveExpertQaMapper.tipOffExpertQa(id);
        return null;
    }

    public JSONObject queryExpertQaDetail(Integer id, Integer offset, Integer limit) {
        JSONObject json = new JSONObject();
        FarmserveExpertQa qa = this.farmserveExpertQaMapper.queryById(id);
        ArrayList<FarmserveExpertQa> rlist = new ArrayList<FarmserveExpertQa>();
        rlist.add(qa);
        this.farmserveExpertQaMapper.updateQaLookTimes(rlist);
        List expertQalist = this.farmserveExpertQaMapper.queryExpertAnswerList(id, qa.getExpertId());
        qa.setExpertAnswerList(expertQalist);
        List otherQaList = this.farmserveExpertQaMapper.queryOtherAnswerList(id, qa.getExpertId(), offset, limit);
        json.put("list", (Object)otherQaList);
        json.put("qa", (Object)qa);
        return json;
    }

    public FarmserveExpertQa answerExpertQa(FarmserveExpertQa reply) {
        this.farmserveExpertQaMapper.insert(reply);
        return this.farmserveExpertQaMapper.queryById(reply.getId());
    }

    public JSONObject queryHotQaList(Integer offset, Integer limit, List<String> cropList, String search, String beginDate, String endDate) {
        JSONObject json = new JSONObject();
        Integer count = this.farmserveExpertQaMapper.queryHotQaCount(cropList, search, beginDate, endDate);
        List list = this.farmserveExpertQaMapper.queryHotQaList(cropList, search, beginDate, endDate, offset, limit);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public Integer queryMsgCount(String userId) {
        FarmserveExpert expertInfo = this.farmserveExpertMapper.queryDetailByUserId(userId);
        if (expertInfo != null && expertInfo.getBlocked() == 1) {
            throw new RuntimeException("\u60a8\u7684\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3");
        }
        ArrayList askMsgList = new ArrayList();
        ArrayList replyMsgList = new ArrayList();
        this.extracted(userId, askMsgList, replyMsgList);
        int askCount = askMsgList.size() > 0 ? (int)askMsgList.stream().filter(farmserveExpertQa -> farmserveExpertQa.getReadFlag() == false).count() : 0;
        int replyCount = replyMsgList.size() > 0 ? (int)replyMsgList.stream().filter(farmserveExpertQa -> farmserveExpertQa.getReadFlag() == false).count() : 0;
        return askCount + replyCount;
    }

    private void extracted(String userId, List<FarmserveExpertQa> askMsgList, List<FarmserveExpertQa> replyMsgList) {
        List askMsgIdList = this.farmserveExpertQaMapper.queryAskMsgIdListByUserId(userId);
        askMsgIdList.forEach(msgId -> {
            List replyMsgIdList = this.farmserveExpertQaMapper.queryReplyMsgListByMsgIdAndUserId(msgId, userId, Integer.valueOf(0));
            if (replyMsgIdList.size() > 0) {
                List idList = this.farmserveExpertQaMapper.queryReplyMsgListByMsgIdAndUserId(msgId, userId, Integer.valueOf(1));
                if (idList.size() > 0) {
                    idList.forEach(id -> {
                        FarmserveExpertQa farmserveExpertQa;
                        List msgIdList = this.farmserveExpertQaMapper.queryReplyMsgByUserIdAndParentId(id, userId);
                        if (msgIdList.size() < 1 && (farmserveExpertQa = this.farmserveExpertQaMapper.queryReplyMsgByMsgIdAndUserId(id, userId)) != null) {
                            replyMsgList.add(farmserveExpertQa);
                        }
                    });
                }
            } else {
                FarmserveExpertQa farmserveExpertQa = this.farmserveExpertQaMapper.queryAskMsg(msgId, userId);
                if (farmserveExpertQa != null) {
                    askMsgList.add(farmserveExpertQa);
                }
            }
        });
    }

    public JSONObject queryAskMsgList(String userId, Integer offset, Integer limit) {
        JSONObject jsonObject = new JSONObject();
        ArrayList askMsgList = new ArrayList();
        ArrayList replyMsgList = new ArrayList();
        this.extracted(userId, askMsgList, replyMsgList);
        int askCount = askMsgList.size() > 0 ? (int)askMsgList.stream().filter(farmserveExpertQa -> farmserveExpertQa.getReadFlag() == false).count() : 0;
        int replyCount = replyMsgList.size() > 0 ? (int)replyMsgList.stream().filter(farmserveExpertQa -> farmserveExpertQa.getReadFlag() == false).count() : 0;
        jsonObject.put("askList", askMsgList.stream().sorted(Comparator.comparing(FarmserveExpertQa::getCreateTime).reversed()).collect(Collectors.toList()));
        jsonObject.put("replyMsgList", replyMsgList.stream().sorted(Comparator.comparing(FarmserveExpertQa::getCreateTime).reversed()).collect(Collectors.toList()));
        jsonObject.put("count", (Object)(askCount + replyCount));
        return jsonObject;
    }

    public JSONObject queryReplyMsgList(String userId, Integer offset, Integer limit) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("replyList", (Object)this.farmserveExpertQaMapper.queryReplyMsgList(userId, offset, limit));
        jsonObject.put("count", (Object)this.queryMsgCount(userId));
        return jsonObject;
    }

    public void readMsg(Integer id) {
        this.farmserveExpertQaMapper.readMsg(id);
    }

    public void delAndBlockExpert(Integer id, Integer block) {
        if (block == null) {
            this.farmserveExpertMapper.deleteById(id);
        } else {
            this.farmserveExpertMapper.blockExpert(id, block);
        }
    }

    public JSONObject queryExpertPage(String search, Integer start, Integer pageSize) {
        Integer count = this.farmserveExpertMapper.queryExpertCount(search);
        List farmserveExpertList = this.farmserveExpertMapper.queryExpertPage(search, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)farmserveExpertList);
        return jsonObject;
    }

    public void delAndTopExpertQa(Integer id, Integer top) {
        if (top == null) {
            this.farmserveExpertQaMapper.deleteById(id);
        } else {
            if (top == 1 && this.farmserveExpertQaMapper.queryExpertQaTopCount() >= 5) {
                throw new RuntimeException("\u6700\u591a\u7f6e\u98765\u4e2a\u95ee\u9898");
            }
            this.farmserveExpertQaMapper.topExpertQa(id, top);
        }
    }

    @Transactional
    public void batchInsert(List<FarmserveExpertImport> expertImportList) {
        expertImportList.forEach(expert -> {
            LytRoleUser lytRoleUser;
            LytUser lytUser = this.farmserveExpertMapper.queryUserByPhone(expert.getPhone());
            if (lytUser == null) {
                this.farmserveExpertMapper.insertUser(new LytUser("sx" + expert.getPhone(), expert.getUserName(), expert.getAvatar(), expert.getPhone()));
                expert.setUserId("sx" + expert.getPhone());
                lytRoleUser = this.farmserveExpertMapper.queryExpertRole("sx" + expert.getPhone());
            } else {
                this.farmserveExpertMapper.updateUser(new LytUser(lytUser.getUserId(), expert.getUserName(), expert.getAvatar(), expert.getPhone()));
                expert.setUserId(lytUser.getUserId());
                lytRoleUser = this.farmserveExpertMapper.queryExpertRole(lytUser.getUserId());
            }
            if (lytRoleUser == null) {
                this.farmserveExpertMapper.insertExpertRole(expert.getUserId());
            }
        });
        this.farmserveExpertMapper.batchInsert(expertImportList);
    }

    public JSONObject queryExpertQaPage(Integer tipOff, String search, Integer start, Integer pageSize) {
        Integer count = this.farmserveExpertQaMapper.queryExpertQaCount(tipOff, search);
        List farmserveExpertQaList = this.farmserveExpertQaMapper.queryExpertQaPage(tipOff, search, start, pageSize);
        farmserveExpertQaList.forEach(farmserveExpertQa -> farmserveExpertQa.setAnswerCount(this.farmserveExpertQaMapper.queryListByRootParentId(farmserveExpertQa.getId())));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)farmserveExpertQaList);
        return jsonObject;
    }

    public FarmserveExpert queryDetailByUserId(String userId) {
        return this.farmserveExpertMapper.queryDetailByUserId(userId);
    }

    public List<String> queryExistPhoneList(List<FarmserveExpertImport> list) {
        List phoneList = list.stream().map(FarmserveExpertImport::getPhone).collect(Collectors.toList());
        return this.farmserveExpertMapper.queryExistPhoneList(phoneList);
    }

    public void deleteSelfAndSub(Integer id) {
        this.farmserveExpertQaMapper.deleteSelfAndSub(id);
    }

    public boolean queryExistPhone(String phone) {
        return this.farmserveExpertMapper.queryExistPhone(phone) > 0;
    }
}

