/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FertilizeCard;
import com.farm.bean.FertilizeCropPlan;
import com.farm.bean.FertilizePlan;
import com.farm.bean.FertilizeYield;
import com.farm.bean.WarnType;
import com.farm.bean.fertilize.FertilizePointNew;
import com.farm.mapper.DatavWarningMapper;
import com.farm.mapper.FertilizeCropPlanMapper;
import com.farm.mapper.FertilizePointNewMapper;
import com.farm.service.FertilizeCropPlanService;
import com.farm.util.WarnUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fertilizeCropPlanService")
public class FertilizeCropPlanServiceImpl
implements FertilizeCropPlanService {
    @Autowired
    private FertilizeCropPlanMapper fertilizeCropPlanMapper;
    @Autowired
    private FertilizePointNewMapper fertilizePointNewMapper;
    @Autowired
    private DatavWarningMapper datavWarningMapper;

    @Transactional
    public void insert(FertilizeCropPlan fertilizeCropPlan) {
        this.fertilizeCropPlanMapper.insertCropPlan(fertilizeCropPlan);
        List fertilizeYieldList = fertilizeCropPlan.getFertilizeYieldList();
        fertilizeYieldList.forEach(fertilizeYield -> fertilizeYield.setCropPlanId(fertilizeCropPlan.getId()));
        this.fertilizeCropPlanMapper.insertFertilizeYieldList(fertilizeYieldList);
        ArrayList warnTypes = new ArrayList();
        fertilizeYieldList.forEach(fertilizeYield -> {
            List fertilizePlanList = fertilizeYield.getFertilizePlanList();
            if (fertilizePlanList.size() <= 0) {
                return;
            }
            fertilizePlanList.forEach(fertilizePlan -> fertilizePlan.setYieldId(fertilizeYield.getId()));
            this.fertilizeCropPlanMapper.insertFertilizePlanList(fertilizePlanList);
            fertilizePlanList.forEach(fertilizePlan -> {
                List fertilizeCardList = fertilizePlan.getFertilizeCardList();
                if (fertilizeCardList.size() <= 0) {
                    return;
                }
                fertilizeCardList.forEach(fertilizeCard -> fertilizeCard.setPlanId(fertilizePlan.getId()));
                this.fertilizeCropPlanMapper.insertFertilizeCardList(fertilizeCardList);
                fertilizeCardList.forEach(fertilizeCard -> {
                    List fertilizeCardRecordList = fertilizeCard.getFertilizeCardRecordList();
                    if (fertilizeCardRecordList.size() <= 0) {
                        return;
                    }
                    fertilizeCardRecordList.forEach(fertilizeCardRecord -> fertilizeCardRecord.setCardId(fertilizeCard.getId()));
                    this.fertilizeCropPlanMapper.insertFertilizeCardRecordList(fertilizeCardRecordList);
                });
                warnTypes.addAll(WarnUtil.fertilizeCropPlanWarn((String)fertilizeCropPlan.getCropName(), (FertilizePlan)fertilizePlan));
            });
        });
        if (warnTypes.size() > 0) {
            List<WarnType> distinctList = warnTypes.stream().collect(Collectors.toMap(WarnType::getRule, o -> o, (o1, o2) -> o1)).values().stream().collect(Collectors.toList());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            FertilizePointNew load = this.fertilizePointNewMapper.load(fertilizeCropPlan.getPointId().intValue());
            String pointName = load != null && StringUtils.isNotBlank((CharSequence)load.getPointName()) ? load.getPointName() : "";
            distinctList.forEach(it -> {
                it.setTitle(pointName + it.getTitle());
                it.setStatus(Integer.valueOf(-1));
                it.setCompany("\u8015\u80a5\u7ad9");
                it.setLeader("\u6731\u771f\u4ee4");
                it.setWarningDate(LocalDateTime.now().format(formatter));
                it.setCreateTime(LocalDateTime.now().format(formatter));
                it.setRegion(fertilizeCropPlan.getAddress() != null ? fertilizeCropPlan.getAddress() : null);
                it.setRelId(fertilizeCropPlan.getId());
                it.setContent(it.getTitle());
            });
            this.datavWarningMapper.insertBatch(distinctList);
        }
    }

    @Transactional
    public void update(FertilizeCropPlan fertilizeCropPlan) {
        this.fertilizeCropPlanMapper.updateCropPlan(fertilizeCropPlan);
        List fertilizeYieldList = fertilizeCropPlan.getFertilizeYieldList();
        this.fertilizeCropPlanMapper.updateYieldList(fertilizeYieldList);
        ArrayList warnTypes = new ArrayList();
        fertilizeYieldList.forEach(fertilizeYield -> {
            List fertilizePlanList = fertilizeYield.getFertilizePlanList();
            this.fertilizeCropPlanMapper.updatePlanList(fertilizePlanList);
            fertilizePlanList.forEach(fertilizePlan -> {
                List fertilizeCards = this.fertilizeCropPlanMapper.queryFertilizeCardListByPlanId(fertilizePlan.getId());
                this.fertilizeCropPlanMapper.deleteFertilizeCardByPlanId(fertilizePlan.getId());
                List cardIdList = fertilizeCards.stream().map(FertilizeCard::getId).collect(Collectors.toList());
                if (cardIdList.size() > 0) {
                    this.fertilizeCropPlanMapper.deleteFertilizeCardRecordByCardIdList(cardIdList);
                }
                List fertilizeCardList = fertilizePlan.getFertilizeCardList();
                fertilizeCardList.forEach(fertilizeCard -> fertilizeCard.setPlanId(fertilizePlan.getId()));
                this.fertilizeCropPlanMapper.insertFertilizeCardList(fertilizeCardList);
                fertilizeCardList.forEach(fertilizeCard -> {
                    List fertilizeCardRecordList = fertilizeCard.getFertilizeCardRecordList();
                    fertilizeCardRecordList.forEach(fertilizeCardRecord -> fertilizeCardRecord.setCardId(fertilizeCard.getId()));
                    this.fertilizeCropPlanMapper.insertFertilizeCardRecordList(fertilizeCardRecordList);
                });
                warnTypes.addAll(WarnUtil.fertilizeCropPlanWarn((String)fertilizeCropPlan.getCropName(), (FertilizePlan)fertilizePlan));
            });
        });
        if (warnTypes.size() > 0) {
            List<WarnType> distinctList = warnTypes.stream().collect(Collectors.toMap(WarnType::getRule, o -> o, (o1, o2) -> o1)).values().stream().collect(Collectors.toList());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            FertilizePointNew load = this.fertilizePointNewMapper.load(fertilizeCropPlan.getPointId().intValue());
            String pointName = load != null && StringUtils.isNotBlank((CharSequence)load.getPointName()) ? load.getPointName() : "";
            distinctList.forEach(it -> {
                it.setTitle(pointName + it.getTitle());
                it.setStatus(Integer.valueOf(-1));
                it.setCompany("\u8015\u80a5\u7ad9");
                it.setLeader("\u6731\u771f\u4ee4");
                it.setWarningDate(LocalDateTime.now().format(formatter));
                it.setCreateTime(LocalDateTime.now().format(formatter));
                it.setRegion(fertilizeCropPlan.getAddress() != null ? fertilizeCropPlan.getAddress() : null);
                it.setRelId(fertilizeCropPlan.getId());
                it.setContent(it.getTitle());
            });
            this.datavWarningMapper.insertBatch(distinctList);
        }
    }

    public FertilizeCropPlan queryFertilizeCropPlanDetail(Integer id) {
        FertilizeCropPlan fertilizeCropPlan = this.fertilizeCropPlanMapper.queryFertilizeCropPlanDetail(id);
        if (fertilizeCropPlan == null) {
            return null;
        }
        FertilizePointNew fertilizePointNew = this.fertilizePointNewMapper.load(fertilizeCropPlan.getPointId().intValue());
        fertilizeCropPlan.setFertilizePointNew(fertilizePointNew);
        List fertilizeYieldList = this.fertilizeCropPlanMapper.queryFertilizeYieldListByCropPlanId(id);
        fertilizeYieldList.forEach(fertilizeYield -> {
            List fertilizePlanList = this.fertilizeCropPlanMapper.queryFertilizePlanListByYieldId(fertilizeYield.getId());
            fertilizePlanList.forEach(fertilizePlan -> {
                List fertilizeCardList = this.fertilizeCropPlanMapper.queryFertilizeCardListByPlanId(fertilizePlan.getId());
                fertilizeCardList.forEach(fertilizeCard -> {
                    List fertilizeCardRecordList = this.fertilizeCropPlanMapper.queryFertilizeCardRecordListByCardId(fertilizeCard.getId());
                    fertilizeCard.setFertilizeCardRecordList(fertilizeCardRecordList);
                });
                fertilizePlan.setFertilizeCardList(fertilizeCardList);
            });
            fertilizeYield.setFertilizePlanList(fertilizePlanList);
        });
        fertilizeCropPlan.setFertilizeYieldList(fertilizeYieldList);
        return fertilizeCropPlan;
    }

    public void disableFertilizeCropPlan(Integer id, Integer status) {
        this.fertilizeCropPlanMapper.disableFertilizeCropPlan(id, status);
    }

    @Transactional
    public void deleteFertilizeCropPlan(Integer id) {
        FertilizeCropPlan fertilizeCropPlan = this.queryFertilizeCropPlanDetail(id);
        if (fertilizeCropPlan == null) {
            return;
        }
        List fertilizeYieldList = fertilizeCropPlan.getFertilizeYieldList();
        ArrayList planIdList = new ArrayList();
        ArrayList cardIdList = new ArrayList();
        ArrayList cardRecordIdList = new ArrayList();
        fertilizeYieldList.forEach(fertilizeYield -> {
            List fertilizePlanList = fertilizeYield.getFertilizePlanList();
            fertilizePlanList.forEach(fertilizePlan -> {
                planIdList.add(fertilizePlan.getId());
                List fertilizeCardList = fertilizePlan.getFertilizeCardList();
                fertilizeCardList.forEach(fertilizeCard -> {
                    cardIdList.add(fertilizeCard.getId());
                    List fertilizeCardRecordList = fertilizeCard.getFertilizeCardRecordList();
                    fertilizeCardRecordList.forEach(fertilizeCardRecord -> cardRecordIdList.add(fertilizeCardRecord.getId()));
                });
            });
        });
        if (cardRecordIdList.size() > 0) {
            this.fertilizeCropPlanMapper.deleteFertilizeCardRecord(cardRecordIdList);
        }
        if (cardIdList.size() > 0) {
            this.fertilizeCropPlanMapper.deleteFertilizeCard(cardIdList);
        }
        if (planIdList.size() > 0) {
            this.fertilizeCropPlanMapper.deleteFertilizePlan(planIdList);
        }
        this.fertilizeCropPlanMapper.deleteFertilizeYield(id);
        this.fertilizeCropPlanMapper.deleteFertilizeCropPlan(id);
    }

    public JSONObject queryFertilizeCropPlanPage(List<String> regionCodeList, Integer start, Integer pageSize) {
        Integer count = this.fertilizeCropPlanMapper.queryFertilizeCropPlanCount(regionCodeList);
        List fertilizeCropPlanList = this.fertilizeCropPlanMapper.queryFertilizeCropPlanPage(regionCodeList, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)fertilizeCropPlanList);
        return jsonObject;
    }

    public JSONObject queryFertilizeCropPlanNearList(Double lng, Double lat, Integer start, Integer pageSize) {
        List cropNameList = this.fertilizeCropPlanMapper.queryFertilizeCropGroup();
        ArrayList fertilizeCropPlanList = new ArrayList();
        cropNameList.forEach(cropName -> {
            FertilizeCropPlan fertilizeCropPlan = this.fertilizeCropPlanMapper.queryFertilizeCropPlanListByCropNameAndNear(cropName, lng, lat);
            fertilizeCropPlanList.add(fertilizeCropPlan);
        });
        List fertilizeYieldList = this.fertilizeCropPlanMapper.queryFertilizeYieldList();
        List fertilizePlanList = this.fertilizeCropPlanMapper.queryFertilizePlanList();
        List fertilizeCardList = this.fertilizeCropPlanMapper.queryFertilizeCardList();
        List fertilizeCardRecordList = this.fertilizeCropPlanMapper.queryFertilizeCardRecordList();
        fertilizeCardList.forEach(fertilizeCard -> fertilizeCard.setFertilizeCardRecordList(fertilizeCardRecordList.stream().filter(fertilizeCardRecord -> fertilizeCardRecord.getCardId().equals(fertilizeCard.getId())).collect(Collectors.toList())));
        fertilizePlanList.forEach(fertilizePlan -> fertilizePlan.setFertilizeCardList(fertilizeCardList.stream().filter(Objects::nonNull).filter((Predicate<FertilizeCard>)new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList())));
        fertilizeYieldList.forEach(fertilizeYield -> fertilizeYield.setFertilizePlanList(fertilizePlanList.stream().filter(Objects::nonNull).filter(fertilizePlan -> fertilizePlan.getYieldId().equals(fertilizeYield.getId())).collect(Collectors.toList())));
        fertilizeCropPlanList.forEach(fertilizeCropPlan -> {
            if (fertilizeCropPlan != null) {
                fertilizeCropPlan.setFertilizeYieldList(fertilizeYieldList.stream().filter(Objects::nonNull).filter((Predicate<FertilizeYield>)new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList()));
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)fertilizeCropPlanList.size());
        jsonObject.put("list", fertilizeCropPlanList);
        return jsonObject;
    }
}

