/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.farm.bean.FertilizeCropPlan;
import com.farm.bean.FertilizePointNewImport;
import com.farm.bean.fertilize.FertilizePointNew;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.mapper.DatavWarningMapper;
import com.farm.mapper.FertilizeCropPlanMapper;
import com.farm.mapper.FertilizePointNewMapper;
import com.farm.service.FertilizeCropPlanService;
import com.farm.service.FertilizePointNewService;
import com.farm.service.ProductManageService;
import com.farm.util.WarnUtil;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fertilizePointNewService")
public class FertilizePointNewServiceImpl
implements FertilizePointNewService {
    private static final Logger log = LoggerFactory.getLogger(FertilizePointNewServiceImpl.class);
    private ConcurrentHashMap<String, String> regionMap = new ConcurrentHashMap();
    @Autowired
    private FertilizePointNewMapper fertilizePointNewMapper;
    @Autowired
    ProductManageService productManageService;
    @Autowired
    private DatavWarningMapper datavWarningMapper;
    @Autowired
    private FertilizeCropPlanMapper fertilizeCropPlanMapper;
    @Autowired
    private FertilizeCropPlanService fertilizeCropPlanService;
    @Value(value="${dataService.serverUrl}")
    private String dataServiceServerUrl;
    private static final String planUrl = "http://119.3.228.0:8083/api/ly_fer2024?";

    public FertilizePointNewServiceImpl() {
        this.regionMap.put("", "330825");
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(FertilizePointNew fertilizeNewPoint) throws Exception {
        this.extractRegionCode(fertilizeNewPoint);
        int insert = this.fertilizePointNewMapper.insert(fertilizeNewPoint);
        if (insert > 0) {
            String sampleNo;
            this.saveCropPlanFromDataService(fertilizeNewPoint);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            List warnTypes = WarnUtil.fertilizePointWarn((FertilizePointNew)fertilizeNewPoint);
            String string = sampleNo = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fertilizeNewPoint.getSampleNo()) ? fertilizeNewPoint.getSampleNo() : "";
            if (warnTypes != null && warnTypes.size() > 0) {
                warnTypes.forEach(it -> {
                    it.setContent((fertilizeNewPoint.getAddress() != null ? fertilizeNewPoint.getAddress() + "\u6837\u70b9" : "") + sampleNo + "\u7684" + it.getTitle());
                    it.setStatus(Integer.valueOf(-1));
                    it.setCompany("\u8015\u80a5\u7ad9");
                    it.setLeader("\u6731\u771f\u4ee4");
                    it.setWarningDate(LocalDateTime.now().format(formatter));
                    it.setCreateTime(LocalDateTime.now().format(formatter));
                    it.setRegion(fertilizeNewPoint.getAddress() != null ? fertilizeNewPoint.getAddress() : null);
                    it.setRelId(fertilizeNewPoint.getId());
                });
                this.datavWarningMapper.insertBatch(warnTypes);
            }
        }
    }

    public void saveCropPlanFromDataService(FertilizePointNew fertilizePointNew) throws Exception {
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        jsonObject.put("nitrogen", (Object)fertilizePointNew.getNitrogen());
        jsonObject.put("phosphorus", (Object)fertilizePointNew.getPhosphorus());
        jsonObject.put("potassium", (Object)fertilizePointNew.getPotassium());
        jsonObject.put("cropName", (Object)"");
        com.alibaba.fastjson.JSONObject resultPlans = this.getPlanFromData(jsonObject);
        if ((Integer)resultPlans.get((Object)"status") == 200) {
            JSONArray jsonArray = (JSONArray)resultPlans.get((Object)"data");
            List fertilizeCropPlanList = JSON.parseArray((String)jsonArray.toJSONString(), FertilizeCropPlan.class);
            for (FertilizeCropPlan cropPlan : fertilizeCropPlanList) {
                cropPlan.setPointId(fertilizePointNew.getId());
                this.fertilizeCropPlanService.insert(cropPlan);
            }
        }
        System.out.println(resultPlans.toString());
    }

    public com.alibaba.fastjson.JSONObject getPlanFromData(com.alibaba.fastjson.JSONObject jsonObject) throws URISyntaxException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        CloseableHttpClient httpClient = httpClientBuilder.build();
        URIBuilder uriBuilder = new URIBuilder(this.dataServiceServerUrl + "/api/ly_fer2024");
        uriBuilder.setParameter("TN", (String)jsonObject.get((Object)"nitrogen"));
        uriBuilder.setParameter("AP", (String)jsonObject.get((Object)"phosphorus"));
        uriBuilder.setParameter("AK", (String)jsonObject.get((Object)"potassium"));
        uriBuilder.setParameter("cropName", jsonObject.get((Object)"cropName") == null ? "" : (String)jsonObject.get((Object)"cropName"));
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        com.alibaba.fastjson.JSONObject resultJsonObject = new com.alibaba.fastjson.JSONObject();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity responseEntity = response.getEntity();
                String strResult = EntityUtils.toString((HttpEntity)responseEntity, (String)"utf-8");
                System.out.println(strResult);
                com.alibaba.fastjson.JSONObject data = JSON.parseObject((String)strResult);
                resultJsonObject.put("status", (Object)200);
                if ((Integer)data.get((Object)"code") == 200) {
                    resultJsonObject.put("data", data.get((Object)"content"));
                }
            } else {
                resultJsonObject.put("status", (Object)response.getStatusLine().getStatusCode());
            }
            resultJsonObject.put("msg", (Object)"");
            return resultJsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultJsonObject.put("status", (Object)500);
            resultJsonObject.put("msg", (Object)e.getMessage());
            return resultJsonObject;
        }
    }

    @Transactional
    public void update(FertilizePointNew fertilizeNewPoint) {
        this.extractRegionCode(fertilizeNewPoint);
        fertilizeNewPoint.setCreateTime(null);
        fertilizeNewPoint.setUpdateTime(null);
        int update = this.fertilizePointNewMapper.update(fertilizeNewPoint);
        if (update > 0) {
            String sampleNo;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            List warnTypes = WarnUtil.fertilizePointWarn((FertilizePointNew)fertilizeNewPoint);
            String string = sampleNo = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fertilizeNewPoint.getSampleNo()) ? fertilizeNewPoint.getSampleNo() : "";
            if (warnTypes != null && warnTypes.size() > 0) {
                warnTypes.forEach(it -> {
                    it.setContent((fertilizeNewPoint.getAddress() != null ? fertilizeNewPoint.getAddress() + "\u6837\u70b9" : "") + sampleNo + "\u7684" + it.getTitle());
                    it.setStatus(Integer.valueOf(-1));
                    it.setCompany("\u8015\u80a5\u7ad9");
                    it.setLeader("\u6731\u771f\u4ee4");
                    it.setWarningDate(LocalDateTime.now().format(formatter));
                    it.setCreateTime(LocalDateTime.now().format(formatter));
                    it.setRegion(fertilizeNewPoint.getAddress() != null ? fertilizeNewPoint.getAddress() : null);
                    it.setRelId(fertilizeNewPoint.getId());
                });
                this.datavWarningMapper.insertBatch(warnTypes);
            }
        }
    }

    private void extractRegionCode(FertilizePointNew fertilizeNewPoint) {
        Double xaxis = fertilizeNewPoint.getXaxis();
        Double yaxis = fertilizeNewPoint.getYaxis();
        String regionKey = this.getRegion(xaxis, yaxis);
        fertilizeNewPoint.setRegionCode((String)this.regionMap.get(regionKey));
    }

    private String getRegion(Double xaxis, Double yaxis) {
        StringBuffer sf = new StringBuffer();
        String regionKey = "";
        if (xaxis != null && yaxis != null) {
            String regionCode = "";
            regionKey = sf.append(xaxis).append("_").append(yaxis).toString();
            if (this.regionMap.contains(regionKey) && this.regionMap.get(regionKey) != null) {
                regionCode = (String)this.regionMap.get(regionKey);
            } else {
                try {
                    regionCode = this.productManageService.queryRegionCodeInArea(xaxis, yaxis);
                }
                catch (Exception e) {
                    log.error("queryRegionCodeInArea getRegion error" + e.getMessage());
                }
            }
            this.regionMap.put(regionKey, StringUtils.isEmpty((CharSequence)regionCode) ? (String)this.regionMap.get(regionCode) : regionCode);
        }
        return regionKey;
    }

    public FertilizePointNew queryFertilizePointDetail(Integer id) {
        return this.fertilizePointNewMapper.load(id.intValue());
    }

    public com.alibaba.fastjson.JSONObject queryFertilizePointPage(List<String> regionCodeList, Integer start, Integer pageSize) {
        Integer count = this.fertilizePointNewMapper.queryFertilizePointNewCount(regionCodeList);
        List fertilizePointNews = this.fertilizePointNewMapper.queryFertilizePointNewPage(regionCodeList, start, pageSize);
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)fertilizePointNews);
        return jsonObject;
    }

    public void deleteFertilizePoint(Integer id) {
        this.fertilizePointNewMapper.delete(id.intValue());
    }

    public void disableFertilizePoint(Integer id, Integer status) {
        this.fertilizePointNewMapper.disableFertilizePoint(id, status);
    }

    public void batchInsert(List<FertilizePointNewImport> fertilizePointImports) {
        ExecutorService executor = Executors.newFixedThreadPool(6);
        log.info("import size: {}", (Object)fertilizePointImports.size());
        for (FertilizePointNewImport pointNewImport : fertilizePointImports) {
            if (pointNewImport.getSampleNo() != null && !"".equals(pointNewImport.getSampleNo().trim())) continue;
            pointNewImport.setSampleNo(UUID.randomUUID().toString().replace("-", ""));
        }
        Integer batchSize = 50;
        for (int i = 0; i < fertilizePointImports.size(); i += batchSize.intValue()) {
            List<FertilizePointNewImport> imports = fertilizePointImports.subList(i, Math.min(batchSize + i, fertilizePointImports.size()));
            Vector<FertilizePointNewImport> importVector = new Vector<FertilizePointNewImport>();
            importVector.addAll(imports);
            executor.execute(new Thread(() -> this.batchInsertRunMe(importVector)));
        }
        executor.shutdown();
        log.info("import finish");
    }

    private synchronized void batchInsertRunMe(Vector<FertilizePointNewImport> fertilizePointImports) {
        int i;
        ArrayList<String> sampleNoList = new ArrayList<String>();
        for (i = 0; i < fertilizePointImports.size(); ++i) {
            FertilizePointNewImport importBean = fertilizePointImports.get(i);
            String regionKey = this.getRegion(importBean.getXaxis(), importBean.getYaxis());
            importBean.setRegionCode((String)this.regionMap.get(regionKey));
            sampleNoList.add(importBean.getSampleNo());
        }
        try {
            i = this.fertilizePointNewMapper.batchInsert(fertilizePointImports);
            if (i > 0) {
                FertilizePointNew fertilizePointNew2;
                if (!sampleNoList.isEmpty()) {
                    List fertilizePointNewList = this.fertilizePointNewMapper.getFertilizePointNewList(sampleNoList);
                    for (FertilizePointNew fertilizePointNew2 : fertilizePointNewList) {
                        this.saveCropPlanFromDataService(fertilizePointNew2);
                    }
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                ArrayList allWarnTypes = new ArrayList();
                fertilizePointNew2 = new AtomicReference();
                fertilizePointImports.forEach(arg_0 -> FertilizePointNewServiceImpl.lambda$batchInsertRunMe$4((AtomicReference)fertilizePointNew2, formatter, allWarnTypes, arg_0));
                this.datavWarningMapper.insertBatch(allWarnTypes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<FertilizePointNew> queryFertilizePointList() {
        return this.fertilizePointNewMapper.queryFertilizePointNewList();
    }

    public FertilizePointNew queryFertilizePointBySampleNo(String sampleNo) {
        return this.fertilizePointNewMapper.queryFertilizePointBySampleNo(sampleNo);
    }

    public List<LabelResultMap> queryFertilizePointCountByRegionCode() {
        return this.fertilizePointNewMapper.queryFertilizePointCountNewByRegionCode();
    }

    public FertilizePointNew queryFertilizePointAvgByRegionCode(String code) {
        FertilizePointNew fertilizePointNew = this.fertilizePointNewMapper.queryFertilizePointAvgByRegionCode(code);
        fertilizePointNew.setPh(new BigDecimal(fertilizePointNew.getPh()).setScale(2, 4).toString());
        fertilizePointNew.setPhosphorus(new BigDecimal(fertilizePointNew.getPhosphorus()).setScale(2, 4).toString());
        fertilizePointNew.setOrganicMatter(new BigDecimal(fertilizePointNew.getOrganicMatter()).setScale(2, 4).toString());
        fertilizePointNew.setNitrogen(new BigDecimal(fertilizePointNew.getNitrogen()).setScale(2, 4).toString());
        fertilizePointNew.setPotassium(new BigDecimal(fertilizePointNew.getPotassium()).setScale(2, 4).toString());
        return fertilizePointNew;
    }

    public List<FertilizePointNew> queryAvgListByRegionCode(String code) {
        List list = this.fertilizePointNewMapper.queryAvgListByRegionCode(code);
        if (list != null && list.size() > 0) {
            list.forEach(it -> {
                it.setPh(new BigDecimal(it.getPh()).setScale(2, 4).toString());
                it.setPhosphorus(new BigDecimal(it.getPhosphorus()).setScale(2, 4).toString());
                it.setOrganicMatter(new BigDecimal(it.getOrganicMatter()).setScale(2, 4).toString());
                it.setNitrogen(new BigDecimal(it.getNitrogen()).setScale(2, 4).toString());
                it.setPotassium(new BigDecimal(it.getPotassium()).setScale(2, 4).toString());
            });
        }
        return list;
    }

    public List<FertilizePointNew> queryAvgListByRegionCodePeriod(String code, String type, String period) {
        List list = this.fertilizePointNewMapper.queryAvgListByRegionCodePeriod(code, type, period);
        if (list != null && list.size() > 0) {
            list.forEach(it -> {
                it.setPh(new BigDecimal(it.getPh()).setScale(2, 4).toString());
                it.setPhosphorus(new BigDecimal(it.getPhosphorus()).setScale(2, 4).toString());
                it.setOrganicMatter(new BigDecimal(it.getOrganicMatter()).setScale(2, 4).toString());
                it.setNitrogen(new BigDecimal(it.getNitrogen()).setScale(2, 4).toString());
                it.setPotassium(new BigDecimal(it.getPotassium()).setScale(2, 4).toString());
            });
        }
        return list;
    }

    public boolean refreshData() {
        List list = this.fertilizePointNewMapper.queryFertilizePointNewWarnList();
        if (list != null && list.size() > 0) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            ArrayList allWarnTypes = new ArrayList();
            list.forEach(it -> {
                String sampleNo;
                List warnTypes = WarnUtil.fertilizePointWarn((FertilizePointNew)it);
                String string = sampleNo = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)it.getSampleNo()) ? it.getSampleNo() : "";
                if (warnTypes != null && warnTypes.size() > 0) {
                    warnTypes.forEach(warn -> {
                        warn.setContent((it.getAddress() != null ? it.getAddress() + "\u6837\u70b9" : "") + sampleNo + "\u7684" + warn.getTitle());
                        warn.setStatus(Integer.valueOf(-1));
                        warn.setCompany("\u8015\u80a5\u7ad9");
                        warn.setLeader("\u6731\u771f\u4ee4");
                        warn.setWarningDate(LocalDateTime.now().format(formatter));
                        warn.setCreateTime(LocalDateTime.now().format(formatter));
                        warn.setRegion(it.getAddress() != null ? it.getAddress() : null);
                        warn.setRelId(it.getId());
                    });
                    allWarnTypes.addAll(warnTypes);
                }
            });
            return this.datavWarningMapper.insertBatch(allWarnTypes) > 0;
        }
        return false;
    }

    public List<FertilizeCropPlan> getPlanByPoint(Integer pointId) {
        Object cropPlan = null;
        ArrayList<Integer> pointList = new ArrayList<Integer>();
        pointList.add(pointId);
        ArrayList<FertilizeCropPlan> resultCropPlanList = new ArrayList<FertilizeCropPlan>();
        List fertilizeCropPlanList = this.fertilizeCropPlanMapper.queryFertilizeCropPlanList(pointList);
        if (!fertilizeCropPlanList.isEmpty()) {
            for (FertilizeCropPlan crop : fertilizeCropPlanList) {
                resultCropPlanList.add(this.fertilizeCropPlanService.queryFertilizeCropPlanDetail(crop.getId()));
            }
        }
        return resultCropPlanList;
    }

    public FertilizeCropPlan getPlanInfoByCropPlanId(Integer cropPlanId) {
        FertilizeCropPlan cropPlan = this.fertilizeCropPlanMapper.queryFertilizeCropPlanDetail(cropPlanId);
        return cropPlan == null ? new FertilizeCropPlan() : cropPlan;
    }

    public String getPlanInfoBySampleNo(String TN, String AP, String AK, String crop) {
        String url = "http://119.3.228.0:8083/api/ly_fer2024?TN=" + TN + "&AP=" + AP + "&AK=" + AK + "&cropName=" + crop;
        log.error("\u8bf7\u6c42\u83b7\u53d6\u65bd\u80a5\u65b9\u6848url:={}", (Object)url);
        HttpResponse response = HttpRequest.get((String)url).execute();
        log.error("\u8bf7\u6c42\u83b7\u53d6\u65bd\u80a5\u65b9\u6848\u54cd\u5e94:={}", (Object)response);
        String str = Convert.unicodeToStr((String)response.body());
        JSONObject entries = JSONUtil.parseObj((String)str);
        String jsonStr = null;
        if (200 == (Integer)entries.get((Object)"code")) {
            jsonStr = JSONUtil.toJsonStr((Object)entries.get((Object)"content"));
        }
        return jsonStr;
    }

    private static /* synthetic */ void lambda$batchInsertRunMe$4(AtomicReference fertilizePointNew, DateTimeFormatter formatter, List allWarnTypes, FertilizePointNewImport it) {
        String sampleNo;
        fertilizePointNew.set(new FertilizePointNew());
        BeanUtils.copyProperties((Object)it, fertilizePointNew.get());
        List warnTypes = WarnUtil.fertilizePointWarn((FertilizePointNew)((FertilizePointNew)fertilizePointNew.get()));
        String string = sampleNo = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((FertilizePointNew)fertilizePointNew.get()).getSampleNo()) ? ((FertilizePointNew)fertilizePointNew.get()).getSampleNo() : "";
        if (warnTypes != null && warnTypes.size() > 0) {
            warnTypes.forEach(warn -> {
                warn.setContent((((FertilizePointNew)fertilizePointNew.get()).getAddress() != null ? ((FertilizePointNew)fertilizePointNew.get()).getAddress() + "\u6837\u70b9" : "") + sampleNo + "\u7684" + warn.getTitle());
                warn.setStatus(Integer.valueOf(-1));
                warn.setCompany("\u8015\u80a5\u7ad9");
                warn.setLeader("\u6731\u771f\u4ee4");
                warn.setWarningDate(LocalDateTime.now().format(formatter));
                warn.setCreateTime(LocalDateTime.now().format(formatter));
                warn.setRegion(((FertilizePointNew)fertilizePointNew.get()).getAddress() != null ? ((FertilizePointNew)fertilizePointNew.get()).getAddress() : null);
                warn.setRelId(((FertilizePointNew)fertilizePointNew.get()).getId());
            });
            allWarnTypes.addAll(warnTypes);
        }
    }
}

