/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.fertilize.LandGovernanceEffectivenessBAPVO;
import com.farm.bean.fertilize.LandGovernanceEffectivenessBKVO;
import com.farm.bean.fertilize.LandGovernanceEffectivenessBOMVO;
import com.farm.bean.fertilize.LandGovernanceEffectivenessBTNVO;
import com.farm.bean.fertilize.LandGovernanceEffectivenessPHVO;
import com.farm.bean.fertilize.SoilRemediation;
import com.farm.bean.fertilize.SoilRemediationMap;
import com.farm.bean.fertilize.SoilRemediationPage;
import com.farm.config.MonitorConfig;
import com.farm.mapper.FertilizeSoilRemediationMapper;
import com.farm.service.FertilizeSoilRemediationService;
import com.farm.util.EasyExcelUtil;
import com.farm.util.ExcelUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FertilizeSoilRemediationServiceImpl
implements FertilizeSoilRemediationService {
    @Autowired
    FertilizeSoilRemediationMapper fertilizeSoilRemediationMapper;
    private static final String ISCHECK = "-?[0-9]+.*[0-9]*";

    public long getListPageCount(SoilRemediationPage page) {
        return this.fertilizeSoilRemediationMapper.getListPageCount(page);
    }

    public List<SoilRemediation> getListPage(SoilRemediationPage page) {
        return this.fertilizeSoilRemediationMapper.getListPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public JSONObject importFileData(MultipartFile file) {
        JSONObject jSONObject;
        block9: {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            JSONObject json = new JSONObject();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getBytes());
            try {
                List SoilRemediationList = ExcelUtil.importExcelByInputStream((InputStream)inputStream, (Integer)0, (Integer)1, SoilRemediation.class);
                ArrayList successList = new ArrayList();
                ArrayList errorList = new ArrayList();
                Date dealDate = new Date();
                if (SoilRemediationList.size() > 0) {
                    SoilRemediationList.forEach(e -> {
                        e.setId(UUID.randomUUID().toString().replace("-", ""));
                        e.setDealDate(dealDate);
                        if (e.getCreatedTimeStr() == null || "".equals(e.getCreatedTimeStr())) {
                            e.setCreatedTime(new Date());
                        } else {
                            try {
                                e.setCreatedTime(sdf.parse(e.getCreatedTimeStr()));
                            }
                            catch (ParseException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        e.setUpdatedTime(new Date());
                    });
                    SoilRemediationPage page = new SoilRemediationPage();
                    List soilRemediationList = this.getListPage(page);
                    ArrayList<String> deleteByIdList = new ArrayList<String>();
                    for (SoilRemediation v : soilRemediationList) {
                        deleteByIdList.add(v.getId());
                    }
                    if (!deleteByIdList.isEmpty()) {
                        this.fertilizeSoilRemediationMapper.deleteByIdList(deleteByIdList);
                    }
                    this.upsertSoilRemediation(SoilRemediationList);
                }
                json.put("error", errorList);
                json.put("success", successList);
                jSONObject = json;
                if (Collections.singletonList(inputStream).get(0) == null) break block9;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    ((InputStream)inputStream).close();
                }
                throw throwable;
            }
            ((InputStream)inputStream).close();
        }
        return jSONObject;
    }

    public void exportSoilRemediationData(HttpServletResponse response, SoilRemediationPage page) throws IOException {
        List soilRemediationList = this.getListPage(page);
        ArrayList soilRemediationMapList = new ArrayList();
        soilRemediationList.forEach(soilRemediation -> {
            SoilRemediationMap soilRemediationMap = SoilRemediationMap.generateExportMap((SoilRemediation)soilRemediation);
            soilRemediationMapList.add(soilRemediationMap);
        });
        EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u571f\u58e4\u6cbb\u7406\u6210\u6548", SoilRemediationMap.class, (String)"\u6cbb\u7406\u524d\u540e\u5bf9\u6bd4", soilRemediationMapList);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void upsertSoilRemediation(List<SoilRemediation> SoilRemediationList) {
        int pageSize = 50;
        int start = 0;
        int end = start + pageSize;
        for (int i = 0; i < SoilRemediationList.size(); i += pageSize) {
            start = i;
            end = start + pageSize;
            if (end > SoilRemediationList.size()) {
                end = SoilRemediationList.size();
            }
            List<SoilRemediation> subList = SoilRemediationList.subList(start, end);
            this.fertilizeSoilRemediationMapper.batchInsert(subList);
        }
    }

    public List<LandGovernanceEffectivenessPHVO> getLandGovernanceEffectivenessPh(SoilRemediationPage soilRemediationPage) {
        return this.fertilizeSoilRemediationMapper.getLandGovernanceEffectivenessPh(soilRemediationPage);
    }

    public List<LandGovernanceEffectivenessBOMVO> getLandGovernanceEffectivenessBOM(SoilRemediationPage soilRemediationPage) {
        return this.fertilizeSoilRemediationMapper.getLandGovernanceEffectivenessBOM(soilRemediationPage);
    }

    public List<LandGovernanceEffectivenessBTNVO> getLandGovernanceEffectivenessBTN(SoilRemediationPage soilRemediationPage) {
        return this.fertilizeSoilRemediationMapper.getLandGovernanceEffectivenessBTN(soilRemediationPage);
    }

    public List<LandGovernanceEffectivenessBAPVO> getLandGovernanceEffectivenessBAP(SoilRemediationPage soilRemediationPage) {
        return this.fertilizeSoilRemediationMapper.getLandGovernanceEffectivenessBAP(soilRemediationPage);
    }

    public List<LandGovernanceEffectivenessBKVO> getLandGovernanceEffectivenessBK(SoilRemediationPage soilRemediationPage) {
        return this.fertilizeSoilRemediationMapper.getLandGovernanceEffectivenessBK(soilRemediationPage);
    }

    public List<LandGovernanceEffectivenessBKVO> getLandGovernanceEffectivenessBSK(SoilRemediationPage soilRemediationPage) {
        return this.fertilizeSoilRemediationMapper.getLandGovernanceEffectivenessBSK(soilRemediationPage);
    }

    private void checkImpData(List<SoilRemediation> successList, List<SoilRemediation> errorList, SoilRemediation item) {
        boolean bl = true;
        MonitorConfig.regionList.forEach(m -> {
            if (item.getVillageName() == null || item.getVillageName().isEmpty()) {
                if (m.getName().equals(item.getTownName())) {
                    item.setRegionCode(m.getId());
                    return;
                }
            } else if (m.getName().equals(item.getVillageName())) {
                item.setRegionCode(m.getId());
                return;
            }
        });
        if (StringUtil.isBlank((CharSequence)item.getRegionCode()) || !bl) {
            errorList.add(item);
        } else {
            successList.add(item);
        }
    }
}

