/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.GpCondition;
import com.farm.bean.GrainNews;
import com.farm.bean.GrainOverview;
import com.farm.bean.GrainOverviewMap;
import com.farm.bean.GrainPurchaseCondition;
import com.farm.bean.Warning;
import com.farm.bean.vo.WarnDetailVo;
import com.farm.config.MonitorConfig;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.GrainStorageMapper;
import com.farm.mapper.MessageMapper;
import com.farm.mapper.PestNewsMapper;
import com.farm.mapper.RecycleNewsMapper;
import com.farm.mapper.SubsidyNewsMapper;
import com.farm.mapper.TransferNewsMapper;
import com.farm.service.FarmCropRecordService;
import com.farm.service.GrainStorageService;
import com.farm.service.SubsidyFormInfoService;
import com.farm.util.ExcelUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dreamlu.mica.core.utils.StringUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="grainStorageService")
public class GrainStorageServiceImpl
implements GrainStorageService {
    @Autowired
    private GrainStorageMapper grainStorageMapper;
    @Autowired
    private SubsidyFormInfoService subsidyFormInfoService;
    @Autowired
    private FarmCropRecordService farmCropRecordService;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private SubsidyNewsMapper subsidyNewsMapper;
    @Autowired
    private RecycleNewsMapper recycleNewsMapper;
    @Autowired
    private TransferNewsMapper transferNewsMapper;
    @Autowired
    private PestNewsMapper pestNewsMapper;
    @Autowired
    private MessageMapper messageMapper;
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    private static final String ISCHECK = "-?[0-9]+.*[0-9]*";

    public List<GrainOverviewMap> queryGrainStorageStatisticsMap() {
        return this.grainStorageMapper.queryGrainStorageStatisticsMap();
    }

    public void upsertGrainStorageStatisticsMap(List<GrainOverviewMap> grainOverviewMapList) {
        grainOverviewMapList.forEach(grainOverviewMap -> {
            if (grainOverviewMap.getId() == null) {
                this.grainStorageMapper.insertGrainStorageStatisticsMap(grainOverviewMap);
            } else {
                this.grainStorageMapper.updateGrainStorageStatisticsMap(grainOverviewMap);
            }
        });
    }

    public List<GrainOverview> queryGrainOverview(Integer type) {
        return this.grainStorageMapper.queryGrainOverview(type);
    }

    public void upsertGrainOverview(List<GrainOverview> grainOverviewList) {
        grainOverviewList.forEach(grainOverview -> {
            if (grainOverview.getId() == null) {
                this.grainStorageMapper.insertGrainOverview(grainOverview);
            } else {
                this.grainStorageMapper.updateGrainOverview(grainOverview);
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void upsertGrainPurchaseCondition(List<GrainPurchaseCondition> grainPurchaseConditionList) {
        grainPurchaseConditionList.forEach(grainPurchaseCondition -> {
            double bl;
            if (grainPurchaseCondition.getId() == null) {
                this.grainStorageMapper.insertGrainPurchaseCondition(grainPurchaseCondition);
            } else {
                this.grainStorageMapper.updateGrainPurchaseCondition(grainPurchaseCondition);
            }
            Double yield = grainPurchaseCondition.getYield();
            yield = yield == null ? 0.0 : yield;
            Double saleNumber = grainPurchaseCondition.getSaleNumber();
            saleNumber = saleNumber == null ? 0.0 : saleNumber;
            Warning warning = null;
            if (yield != null && yield > 0.0 && saleNumber != null && saleNumber > 0.0 && ((bl = (saleNumber - yield) / saleNumber) < -0.25 || bl > 0.25)) {
                warning = new Warning();
                warning.setStatus(Integer.valueOf(-1));
                warning.setRelId(String.valueOf(grainPurchaseCondition.getId()));
                warning.setLeader("\u9648\u5b8f\u4f1f");
                warning.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                warning.setModule(Integer.valueOf(5));
                warning.setCopyValue(grainPurchaseCondition.getDeclareArea() + "," + yield + "," + saleNumber);
                if (bl < -0.25) {
                    warning.setContent("\u7cae\u5e93\u8ba2\u5355\u65e9\u7a3b\u6536\u8d2d\u91cf\u6bd4\u89c4\u6a21\u79cd\u7cae\u5927\u6237\u65e9\u7a3b\u4ea7\u91cf\u4f4e" + String.format("%.2f", bl * 100.0).replace("-", "") + "%");
                    warning.setWarningType(Integer.valueOf(0));
                    warning.setRule(Integer.valueOf(1));
                } else if (bl > 0.25) {
                    warning.setContent("\u7cae\u5e93\u8ba2\u5355\u65e9\u7a3b\u6536\u8d2d\u91cf\u6bd4\u89c4\u6a21\u79cd\u7cae\u5927\u6237\u65e9\u7a3b\u4ea7\u91cf\u8d85\u51fa" + String.format("%.2f", bl * 100.0).replace("-", "") + "%");
                    warning.setWarningType(Integer.valueOf(1));
                    warning.setRule(Integer.valueOf(2));
                }
            }
            if (warning != null) {
                this.grainStorageMapper.addWarning(warning);
            }
        });
    }

    public JSONObject queryGrainPurchaseCondition(Integer year, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.grainStorageMapper.queryGrainPurchaseConditionCount(year);
        List grainPurchaseConditionList = this.grainStorageMapper.queryGrainPurchaseConditionPage(year, start, pageSize);
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)grainPurchaseConditionList);
        return jsonObject;
    }

    public void upsertGrainNotice(GrainNews grainNews) {
        if (grainNews.getId() == null) {
            this.grainStorageMapper.insertGrainNotice(grainNews);
        } else {
            this.grainStorageMapper.updateGrainNotice(grainNews);
        }
    }

    public GrainNews queryGrainNoticeDetail(Integer id, String userId) {
        Integer noticeReadId;
        GrainNews grainNews = this.grainStorageMapper.queryGrainNoticeDetail(id);
        if (StringUtils.isNotBlank((String)userId) && (noticeReadId = this.messageMapper.queryNoticeReadByUserId(id, userId, Integer.valueOf(1))) == null) {
            this.messageMapper.insertMsgReadByUserId(userId, id, Integer.valueOf(1));
        }
        return grainNews;
    }

    public void deleteGrainNotice(Integer id) {
        this.grainStorageMapper.deleteGrainNotice(id);
    }

    public void disableGrainNotice(Integer id, Integer top, Integer status) {
        if (top == null) {
            this.grainStorageMapper.disableGrainNotice(id, status);
        } else {
            this.grainStorageMapper.topGrainNotice(id, top);
        }
    }

    public JSONObject queryGrainNoticePage(String title, Integer status, String type, String startTime, String endTime, Integer isTop, Integer start, Integer pageSize, Integer apiType) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.grainStorageMapper.queryGrainNoticeCount(title, status, type, startTime, endTime, apiType);
        List grainNewsList = this.grainStorageMapper.queryGrainNoticePage(title, status, type, startTime, endTime, isTop, start, pageSize, apiType);
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)grainNewsList);
        return jsonObject;
    }

    public List<GrainNews> queryGrainNoticeNew(String startTime, String endTime) {
        return this.grainStorageMapper.queryGrainNoticeNew(startTime, endTime);
    }

    public void generateNew() {
        List subsidyNewsList = this.subsidyNewsMapper.querySubsidyNewsList();
        subsidyNewsList.forEach(item -> item.setContentType(Integer.valueOf(item.getContentType() == null ? 1 : item.getContentType())));
        List recycleNewsList = this.recycleNewsMapper.queryRecycleNewsList();
        recycleNewsList.forEach(item -> {
            item.setType(Integer.valueOf(5));
            item.setContentType(Integer.valueOf(item.getContentType() == null ? 1 : item.getContentType()));
        });
        List transferNewsList = this.transferNewsMapper.queryTransferNewsList();
        transferNewsList.forEach(item -> {
            item.setType(Integer.valueOf(6));
            item.setContentType(Integer.valueOf(item.getContentType() == null ? 1 : item.getContentType()));
        });
        List pestNewsList = this.pestNewsMapper.queryPestNewsList();
        pestNewsList.forEach(item -> {
            item.setType(Integer.valueOf(7));
            item.setContentType(Integer.valueOf(item.getContentType() == null ? 1 : item.getContentType()));
        });
        ArrayList result = new ArrayList();
        result.addAll(subsidyNewsList);
        result.addAll(recycleNewsList);
        result.addAll(transferNewsList);
        result.addAll(pestNewsList);
        this.grainStorageMapper.insertGrainNoticeBatch(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject importFileData(MultipartFile file) {
        JSONObject jSONObject;
        block7: {
            JSONObject json = new JSONObject();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getBytes());
            try {
                List gpConditions = ExcelUtil.importExcelByInputStream((InputStream)inputStream, (Integer)0, (Integer)1, GpCondition.class);
                ArrayList successList = new ArrayList();
                ArrayList errorList = new ArrayList();
                gpConditions.forEach(item -> this.checkImpData(successList, errorList, item));
                if (gpConditions.size() > 0) {
                    List grainPurchaseConditions = JSONObject.parseArray((String)JSONObject.toJSONString(successList), GrainPurchaseCondition.class);
                    this.upsertGrainPurchaseCondition(grainPurchaseConditions);
                }
                json.put("error", errorList);
                json.put("success", successList);
                jSONObject = json;
                if (Collections.singletonList(inputStream).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(inputStream).get(0) != null) {
                    ((InputStream)inputStream).close();
                }
                throw throwable;
            }
            ((InputStream)inputStream).close();
        }
        return jSONObject;
    }

    private void checkImpData(List<GpCondition> successList, List<GpCondition> errorList, GpCondition item) {
        item.setType(Integer.valueOf(1));
        boolean bl = true;
        if (StringUtil.isBlank((CharSequence)item.getName()) || item.getName().length() > 10) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getPhone()) || !item.getPhone().matches(ISCHECK)) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getYield()) || !item.getYield().matches(ISCHECK)) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getSaleNumber()) || !item.getSaleNumber().matches(ISCHECK)) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getYear()) || !item.getYear().matches(ISCHECK)) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getMonth()) || !item.getMonth().matches(ISCHECK)) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getIdCode()) || item.getIdCode().length() != 18) {
            bl = false;
        } else if (StringUtil.isBlank((CharSequence)item.getDeclareArea()) || !item.getDeclareArea().matches(ISCHECK)) {
            bl = false;
        }
        MonitorConfig.regionList.forEach(m -> {
            if (m.getName().equals(item.getRegionName())) {
                item.setRegionCode(m.getId());
                return;
            }
        });
        if (StringUtil.isBlank((CharSequence)item.getRegionCode()) || !bl) {
            errorList.add(item);
        } else {
            successList.add(item);
        }
    }

    public JSONObject noticeList(Long regionCode, Integer dateType, String date, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        if (regionCode != null) {
            regionCode = this.handleRegion(regionCode);
        }
        List list = this.grainStorageMapper.queryNoticeList(regionCode, dateType, date, start, pageSize);
        Integer count = this.grainStorageMapper.queryNoticeListCount(regionCode, dateType, date);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject list(String roleId, Integer status, String phone, String idCode, String username, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = this.grainStorageMapper.waringList(roleId, status, phone, idCode, username, start, pageSize);
        Integer count = this.grainStorageMapper.waringListCount(roleId, status, phone, idCode, username);
        Integer whsCount = this.grainStorageMapper.waringListCount(roleId, Integer.valueOf(0), "", "", "");
        Integer yhsCount = this.grainStorageMapper.waringListCount(roleId, Integer.valueOf(1), "", "", "");
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        json.put("whsCount", (Object)whsCount);
        json.put("yhsCount", (Object)yhsCount);
        return json;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Integer verify(Integer id, Integer relUnit, String solution, String userId) {
        Integer count;
        Integer verify = this.grainStorageMapper.verify(id, relUnit, solution, userId);
        if (verify == 0) {
            this.grainStorageMapper.updateVerify(id, relUnit, solution, userId);
        }
        count = (count = this.grainStorageMapper.queryWaringLogCount(id)) <= 1 ? 0 : 1;
        this.grainStorageMapper.updateWarningStatus(count, id);
        return 1;
    }

    public WarnDetailVo warnDetail(Integer id, Integer relUnit) {
        return this.grainStorageMapper.warnDetail(id, relUnit);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public int delData(Integer id) {
        this.grainStorageMapper.delData(id);
        return 1;
    }

    @Transactional
    public void countPlus(Integer id) {
        this.grainStorageMapper.countPlus(id);
    }

    private Long handleRegion(Long regionCode) {
        Long returnCode = null;
        while (regionCode > 0L && regionCode % 10L == 0L) {
            returnCode = regionCode / 10L;
        }
        return returnCode;
    }
}

