/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DeviceMonitorInsect;
import com.farm.bean.FieldDoubleStatus;
import com.farm.bean.InsectStatisticsInfo;
import com.farm.bean.MedicationRecord;
import com.farm.bean.insect.InsectArticle;
import com.farm.bean.insect.InsectArticleDetail;
import com.farm.bean.resultMap.DeviceCropDiscernResultMap;
import com.farm.bean.resultMap.InsectCountDataResultMap;
import com.farm.bean.resultMap.InsectDetailResultMap;
import com.farm.bean.resultMap.InsectDeviceCountResultMap;
import com.farm.bean.resultMap.InsectDeviceInfoResultMap;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.dto.DeviceMonitorSite;
import com.farm.dto.InsectAvgReq;
import com.farm.dto.InsectAvgRes;
import com.farm.dto.InsectDetailReq;
import com.farm.dto.InsectInOrUpReq;
import com.farm.dto.InsectReq;
import com.farm.dto.InsectTrendsReq;
import com.farm.mapper.DeviceMonitorInsectMapper;
import com.farm.mapper.DeviceMonitorSiteMapper;
import com.farm.mapper.FarmCropRecordMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.InsectMapper;
import com.farm.service.InsectService;
import com.farm.util.DateUtil;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="insectService")
public class InsectServiceImpl
implements InsectService {
    private static final Logger log = LoggerFactory.getLogger(InsectServiceImpl.class);
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Autowired
    private InsectMapper insectMapper;
    @Autowired
    private DeviceMonitorSiteMapper deviceMonitorSiteMapper;
    @Autowired
    private DeviceMonitorInsectMapper monitorInsectMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private FarmCropRecordMapper farmCropRecordMapper;
    @Autowired
    private InsectService insectService;
    private static final List<Integer> deviceIdList = Arrays.asList(4561, 4562, 4327, 4328);
    private final Integer needDelYearCount = 3;

    public JSONObject queryInsectByDate() {
        List list = this.insectMapper.queryInsectDatav();
        for (int i = 0; i < list.size(); ++i) {
            InsectDetailResultMap idrm = (InsectDetailResultMap)list.get(i);
            List insectLevel = this.insectMapper.queryInsectLevel(idrm.getId());
            List insectPrevention = this.insectMapper.queryInsectPrevention(idrm.getId());
            List insectFormula = this.insectMapper.queryInsectFormula(idrm.getId());
            idrm.setInsectLevel(insectLevel);
            idrm.setInsectPrevention(insectPrevention);
            idrm.setInsectFormula(insectFormula);
            if (null == idrm.getEndTime()) {
                if (i < list.size() - 1) {
                    idrm.setEndTime(((InsectDetailResultMap)list.get(i + 1)).getStartTime());
                } else {
                    idrm.setEndTime("2021-11-30 11:17:35");
                }
            }
            list.set(i, idrm);
        }
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    @Transactional
    public ResultVo inOrUpInsectTimeOrLev(InsectTrendsReq trendsReq) {
        log.info("start to inOrUp insect time and level");
        try {
            InsectArticle article = new InsectArticle();
            article.setId(trendsReq.getId());
            article.setAreaType(trendsReq.getAreaType());
            article.setShowTime(trendsReq.getStartTime());
            article.setShowEndTime(trendsReq.getEndTime());
            int count = this.insectMapper.insertOrUpArticle(article);
            InsectArticleDetail detail = new InsectArticleDetail();
            if (null == trendsReq.getId()) {
                detail.setId(trendsReq.getArticleDetailId());
                detail.setArticleId(article.getId());
                this.insectMapper.insertOrUpArticleDetail(detail);
                trendsReq.setId(article.getId());
                trendsReq.setArticleDetailId(detail.getId());
            } else {
                detail.setId(trendsReq.getArticleDetailId());
            }
            log.info("update insect article :{}", (Object)count);
            List insectLevel = trendsReq.getInsectLevel();
            List maps = this.insectMapper.queryInsectLevel(detail.getId());
            log.info("old articleDetailDis count: {},new articleDetailDis count:{}", (Object)maps.size(), (Object)insectLevel.size());
            if (!CollectionUtils.isEmpty((Collection)insectLevel)) {
                insectLevel.stream().forEach(item -> item.setArticleDetailId(detail.getId()));
                List allIds = maps.stream().filter(item -> null != item && null != item.get("disId")).map(item -> item.get("disId").toString()).collect(Collectors.toList());
                List existIds = insectLevel.stream().filter(item -> item.getId() != null).map(item -> item.getId().toString()).collect(Collectors.toList());
                List removeList = allIds.stream().filter(item -> !existIds.contains(item)).collect(Collectors.toList());
                log.info("del articleDetailDis count: {}", (Object)removeList.size());
                if (!CollectionUtils.isEmpty(removeList)) {
                    int n = this.insectMapper.deleteAtDetailDisById(removeList);
                }
                int insert = this.insectMapper.insertOrUpAtDetailDis(insectLevel);
                log.info("inOrUp articleDetailDis success:{}", (Object)insert);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.error("inOrUpInsectTimeOrLev error msg:{}", (Object)e.getMessage());
            return ResultVo.error((String)"\u7f16\u8f91\u5931\u8d25");
        }
        return ResultVo.success();
    }

    @Transactional
    public ResultVo inOrUpInsectDetail(InsectDetailReq detailReq) {
        log.info("start to inOrUpInsectDetail  ");
        List<Object> oldIds = new ArrayList();
        List<Object> existIds = new ArrayList();
        try {
            List preventMaps = this.insectMapper.queryInsectPrevention(detailReq.getArticleDetailId());
            oldIds = preventMaps.stream().filter(item -> null != item && null != item.get("preId")).map(item -> item.get("preId").toString()).collect(Collectors.toList());
            List preventionList = detailReq.getInsectPrevention();
            existIds = preventionList.stream().filter(item -> null != item.getId()).map(item -> item.getId().toString()).collect(Collectors.toList());
            oldIds.removeAll(existIds);
            if (!CollectionUtils.isEmpty(oldIds)) {
                int n = this.insectMapper.deleteAtPreventionByIds(oldIds);
            }
            preventionList.stream().forEach(item -> item.setArticleDetailId(detailReq.getArticleDetailId()));
            int preventionCount = this.insectMapper.insertOrUpAtPrevention(preventionList);
            log.info("delete preventionDetail count:{},update count {}", (Object)oldIds.size(), (Object)preventionCount);
            List formulaMaps = this.insectMapper.queryInsectFormula(detailReq.getArticleDetailId());
            oldIds = formulaMaps.stream().filter(item -> null != item && null != item.get("formulaId")).map(item -> item.get("formulaId").toString()).collect(Collectors.toList());
            List formulaList = detailReq.getInsectFormula();
            existIds = formulaList.stream().filter(item -> null != item.getId()).map(item -> item.getId().toString()).collect(Collectors.toList());
            oldIds.removeAll(existIds);
            if (!CollectionUtils.isEmpty(oldIds)) {
                int delete = this.insectMapper.deleteFormulaByIds(oldIds);
                log.info("delete formula count:{},update count {}", (Object)oldIds.size(), (Object)delete);
            }
            formulaList.stream().forEach(item -> item.setArticleDetailId(detailReq.getArticleDetailId()));
            int formulaCount = this.insectMapper.insertOrUpFormula(formulaList);
            log.info("insert formula count:{}", (Object)formulaCount);
        }
        catch (RuntimeException e) {
            log.error("inOrUpInsectDetail error msg:{}", (Object)e.getMessage());
            return ResultVo.error((String)"\u7f16\u8f91\u5931\u8d25");
        }
        return ResultVo.success();
    }

    @Transactional
    public ResultVo inOrUpInsect(InsectInOrUpReq inOrUpReq) {
        int areaType = ((InsectReq)inOrUpReq.getList().get(0)).getInsectTrendsReq().getAreaType();
        List insectList = inOrUpReq.getList();
        this.insectService.deleteArticleAndDetail(areaType, insectList);
        for (InsectReq req : insectList) {
            InsectTrendsReq insectTrendsReq = req.getInsectTrendsReq();
            InsectDetailReq insectDetailReq = new InsectDetailReq();
            ResultVo timeOrLevReturn = this.insectService.inOrUpInsectTimeOrLev(insectTrendsReq);
            BeanUtils.copyProperties((Object)insectTrendsReq, (Object)insectDetailReq);
            ResultVo resultVo = this.insectService.inOrUpInsectDetail(insectDetailReq);
        }
        return ResultVo.success();
    }

    @Transactional
    public ResultVo deleteArticleAndDetail(int areaType, List<InsectReq> insectList) {
        List existIdList = insectList.stream().filter(item -> item.getInsectTrendsReq().getId() != null).map(item -> item.getInsectTrendsReq().getId().toString()).collect(Collectors.toList());
        List existDetailIds = insectList.stream().filter(item -> item.getInsectTrendsReq().getArticleDetailId() != null).map(item -> item.getInsectTrendsReq().getArticleDetailId().toString()).collect(Collectors.toList());
        List allIdAndDetailIds = this.insectMapper.queryInsectDatav();
        List allArticleIds = allIdAndDetailIds.stream().filter(item -> item.getAreaType() == areaType).map(item -> item.getArticleId().toString()).collect(Collectors.toList());
        List allDetailIds = allIdAndDetailIds.stream().filter(item -> item.getAreaType() == areaType).map(item -> item.getId().toString()).collect(Collectors.toList());
        allArticleIds.removeAll(existIdList);
        allDetailIds.removeAll(existDetailIds);
        if (!CollectionUtils.isEmpty(allArticleIds)) {
            int deleteArticleCount = this.insectMapper.deleteArticleByIds(allArticleIds);
            log.info("delete article count:{}", (Object)deleteArticleCount);
        }
        if (!CollectionUtils.isEmpty(allDetailIds)) {
            int allDetailCount = this.insectMapper.deleteArticleDetailByIds(allDetailIds);
            log.info("delete article detail count:{}", (Object)allDetailCount);
        }
        return ResultVo.success();
    }

    public JSONObject queryInsectDeviceList() {
        List list = this.insectMapper.queryAllDevice();
        String temp = "7697,7951,7952,7953,4298,4299,4476,4477,4324,4332,4554,4555,4327,4328,4561,4562";
        List<String> tempList = Arrays.asList(temp.split(","));
        ArrayList resultList = new ArrayList();
        list.forEach(item -> {
            if (item.getDeviceType() != 2 || tempList.contains(item.getWlwDeviceId())) {
                resultList.add(item);
            }
        });
        JSONObject json = new JSONObject();
        json.put("list", resultList);
        return json;
    }

    public JSONObject queryInsectDevicesData() {
        List list = this.insectMapper.queryAllDevice();
        String temp = "18059,18060,18061,18062,18091,18092,18093,18094,17844,19087,19088,19089";
        List<String> tempList = Arrays.asList(temp.split(","));
        list.stream().map(item -> {
            if (tempList.contains(item.getWlwDeviceId())) {
                item.setDeviceType(Integer.valueOf(Integer.parseInt("4")));
            }
            return item;
        });
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryInsectInfoList() {
        List list = this.insectMapper.queryAllInsectInfo();
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryInsectCountData(Integer insectType, Integer deviceId, String startTime, String endTime) {
        String[] startSplit = startTime.split("-");
        String[] endSplit = endTime.split("-");
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime) || startSplit.length != 3 || endSplit.length != 3) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate formatDate = LocalDate.now();
            endTime = startTime = formatDate.format(df);
        }
        InsectDeviceInfoResultMap insectDeviceInfoResultMap = this.insectMapper.queryDeviceInfoByDeviceId(deviceId);
        JSONObject json = new JSONObject();
        if (insectDeviceInfoResultMap.getDeviceType() == 1) {
            List resultMaps = this.insectMapper.queryInsectCountData(insectType, deviceId, startTime, endTime);
            resultMaps.stream().forEach(item -> {
                if (null != item.getCount() && item.getCount() > 1000) {
                    item.setCount(Integer.valueOf(0));
                }
            });
            this.getReturnRes(insectType, deviceId, json, startTime, endTime);
            json.put("list", (Object)resultMaps);
        } else if (insectDeviceInfoResultMap.getDeviceType() == 2) {
            List resultMaps = this.insectMapper.queryInsectTrapperData(deviceId, startTime, endTime);
            resultMaps.stream().forEach(item -> {
                if (null != item.getCount() && item.getCount() > 1000) {
                    item.setCount(Integer.valueOf(0));
                }
            });
            this.getReturnRes(insectType, deviceId, json, startTime, endTime);
            json.put("list", (Object)resultMaps);
        }
        return json;
    }

    private void getReturnRes(Integer insectType, Integer deviceId, JSONObject json, String startTime, String endTime) {
        Date now = new Date();
        Date startTimeDate = DateUtil.string2Date((String)startTime, (DateFormat)DateUtil.DEFAULT_FORMAT_Y_M_D);
        Date endTimeDate = DateUtil.string2Date((String)endTime, (DateFormat)DateUtil.DEFAULT_FORMAT_Y_M_D);
        Date lstYearStartDate = DateUtil.addYears((Date)startTimeDate, (int)-1);
        Date lstYearEndDate = DateUtil.addYears((Date)endTimeDate, (int)-1);
        Integer thisYear = DateUtil.getYear((Date)startTimeDate);
        Date BeginYearDate = DateUtil.getYearFirst((int)(thisYear - this.needDelYearCount));
        Date EndYearDate = DateUtil.getYearLast((int)thisYear);
        InsectAvgReq avgCountReq = new InsectAvgReq();
        avgCountReq.setInsectType(insectType);
        avgCountReq.setStartTime(DateUtil.date2String((Date)BeginYearDate));
        avgCountReq.setEndTime(DateUtil.date2String((Date)EndYearDate));
        avgCountReq.setDeviceId(deviceId);
        avgCountReq.setNeedAvg("0");
        List listOf4Year = insectType != null ? this.insectMapper.queryInsectAvgCountData(avgCountReq) : this.insectMapper.queryInsectAvgTrapperData(avgCountReq);
        List thisYearList = this.getFilterList(startTimeDate, endTimeDate, thisYear, listOf4Year);
        Integer lastYear = thisYear - 1;
        List lstYearList = this.getFilterList(lstYearStartDate, lstYearEndDate, lastYear, listOf4Year);
        Date lst3YearBeginTime = DateUtil.getYearFirst((int)(lastYear - 2));
        Date lastYearEndTime = DateUtil.getYearLast((int)lastYear);
        avgCountReq.setNeedAvg("1");
        avgCountReq.setStartTime(DateUtil.date2String((Date)lst3YearBeginTime));
        avgCountReq.setEndTime(DateUtil.date2String((Date)lastYearEndTime));
        List lst3AvgList = new ArrayList();
        lst3AvgList = insectType != null ? this.insectMapper.queryInsectAvgCountData(avgCountReq) : this.insectMapper.queryInsectAvgTrapperData(avgCountReq);
        List filterlist = lst3AvgList.stream().filter(item -> {
            StringBuffer sbf = new StringBuffer();
            String strDate = sbf.append(thisYear).append("-").append(item.getSubStrDate()).toString();
            return DateUtil.between((Date)DateUtil.string2Date((String)strDate, (DateFormat)DateUtil.DEFAULT_FORMAT_Y_M_D), (Date)startTimeDate, (Date)endTimeDate);
        }).collect(Collectors.toList());
        json.put("thisYearList", (Object)thisYearList);
        json.put("lstYearList", (Object)lstYearList);
        json.put("lst3AvgList", filterlist);
    }

    private List getFilterList(Date startTimeDate, Date endTimeDate, Integer thisYear, List<InsectAvgRes> listOf4Year) {
        List returnList = listOf4Year.stream().filter(item -> item.getYear().equals(String.valueOf(thisYear))).filter(item -> {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date string2Date = DateUtil.string2Date((String)item.getRecordTime(), (DateFormat)dateFormat);
            return null != string2Date && DateUtil.between((Date)string2Date, (Date)startTimeDate, (Date)endTimeDate);
        }).collect(Collectors.toList());
        return returnList;
    }

    public JSONObject queryInsectTrapperData(Integer deviceId, String startTime, String endTime) {
        List list = this.insectMapper.queryInsectTrapperData(deviceId, startTime, endTime);
        JSONObject json = new JSONObject();
        this.getReturnRes(null, deviceId, json, startTime, endTime);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryDeviceCropDiscern(Integer deviceId) {
        JSONObject json = new JSONObject();
        DeviceCropDiscernResultMap dcd = this.insectMapper.queryDeviceCropDiscernByDeviceId(deviceId);
        if (dcd == null) {
            return json;
        }
        String url = this.farmServerUrl + "field/queryGrowthPeriod?xAxis=" + dcd.getLng() + "&yAxis=" + dcd.getLat() + "&cropSubName=" + dcd.getCropSubName();
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            json.put("result", (Object)result);
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            return json;
        }
    }

    public JSONObject listInsectCountGroupDay(Integer insectType, String startTime, String endTime) {
        List list2;
        JSONObject json = new JSONObject();
        List list1 = this.insectMapper.listInsectCountGroupDay(insectType, startTime, endTime);
        if ((insectType == null || insectType == 7) && (list2 = this.insectMapper.listInsectCount2GroupDay(deviceIdList, startTime, endTime)) != null) {
            list1.addAll(list2);
        }
        Map<String, List<InsectCountDataResultMap>> map = list1.stream().collect(Collectors.groupingBy(InsectCountDataResultMap::getRecordTime));
        ArrayList<JSONObject> resList = new ArrayList<JSONObject>();
        for (String key : map.keySet()) {
            JSONObject resJson = new JSONObject();
            resJson.put("date", (Object)key);
            resJson.put("list", map.get(key));
            resList.add(resJson);
        }
        json.put("list", resList);
        return json;
    }

    public JSONObject queryMachineSumDataByYear(Integer deviceType, Integer deviceId, String startDate, String endDate) {
        JSONObject json = new JSONObject();
        List list = new ArrayList();
        list = deviceType == 1 ? this.insectMapper.listMachine1SumDataByYear(deviceType, deviceId, startDate, endDate) : this.insectMapper.listMachine2SumDataByYear(deviceType, deviceId, startDate, endDate);
        json.put("list", list);
        return json;
    }

    public JSONObject queryMachineSumDataByMonth(Integer deviceType, Integer deviceId, String startDate, String endDate) {
        JSONObject json = new JSONObject();
        List list = new ArrayList();
        list = deviceType == 1 ? this.insectMapper.listMachine1SumDataByMonth(deviceType, deviceId, startDate, endDate) : this.insectMapper.listMachine2SumDataByMonth(deviceType, deviceId, startDate, endDate);
        json.put("list", list);
        return json;
    }

    public JSONObject queryMonitorList() {
        JSONObject json = new JSONObject();
        List list = this.deviceMonitorSiteMapper.queryParentSiteByParentId(Integer.valueOf(0));
        list.forEach(item -> {
            List deviceMonitorSites = this.deviceMonitorSiteMapper.queryParentSiteByParentId(item.getId());
            if (deviceMonitorSites.size() > 0) {
                item.setChildList(deviceMonitorSites);
            } else {
                ArrayList<DeviceMonitorSite> childList = new ArrayList<DeviceMonitorSite>();
                childList.add(DeviceMonitorSite.generateNew((DeviceMonitorSite)item));
                item.setChildList(childList);
            }
        });
        json.put("list", (Object)list);
        return json;
    }

    public List<InsectCountDataResultMap> queryCountListNearly(Integer monitorId, Integer insectType) {
        List list2;
        List list = this.deviceMonitorSiteMapper.queryCountListNearly(monitorId, insectType);
        if (insectType == 7 && (list2 = this.deviceMonitorSiteMapper.queryTrapperCountListNearly(monitorId)) != null && list2.size() > 0) {
            list.addAll(list2);
        }
        return list;
    }

    public List<InsectDeviceCountResultMap> queryCountListNearlyByDevice(Integer insectType) {
        List list = this.deviceMonitorSiteMapper.queryCountListNearlyByPoint(insectType);
        if (insectType == 7) {
            List list2 = this.deviceMonitorSiteMapper.queryTrapperCountListNearlyByPoint();
            for (InsectDeviceCountResultMap it2 : list2) {
                Boolean addFlag = true;
                for (InsectCountDataResultMap it : list) {
                    if (!it2.getWlwDeviceId().equals(it.getWlwDeviceId())) continue;
                    it.setCount(Integer.valueOf(Integer.max(it2.getCount(), it.getCount())));
                    addFlag = false;
                    break;
                }
                if (!addFlag.booleanValue()) continue;
                list.add(it2);
            }
        }
        return list;
    }

    public JSONObject queryById(Integer monitorId, Integer maxCount, Integer insectType) {
        JSONObject json = new JSONObject();
        DeviceMonitorSite site = this.deviceMonitorSiteMapper.queryById(monitorId);
        Integer level = 0;
        double predictCount = Math.ceil((double)maxCount.intValue() * 1.1);
        if (0 < maxCount && maxCount < 50) {
            level = 1;
        } else if (maxCount <= 80) {
            level = 2;
        } else if (maxCount <= 100) {
            level = 3;
        } else if (maxCount > 100) {
            level = 4;
        }
        Date date = new Date();
        Integer year = DateUtil.getYear((Date)date);
        boolean between1T7 = DateUtil.between((Date)date, (Date)DateUtil.string2Date((String)(year + "-1-1 00:00:00"), (DateFormat)DateUtil.DEFAULT_FORMAT), (Date)DateUtil.string2Date((String)(year + "-07-20 23:59:59"), (DateFormat)DateUtil.DEFAULT_FORMAT));
        boolean between7T12 = DateUtil.between((Date)date, (Date)DateUtil.string2Date((String)(year + "-07-21 00:00:00"), (DateFormat)DateUtil.DEFAULT_FORMAT), (Date)DateUtil.string2Date((String)(year + "-12-31 23:59:59"), (DateFormat)DateUtil.DEFAULT_FORMAT));
        if (between1T7) {
            site.setCropInfo("\u5355\u5b63\u7a3b\u65e9\u7a3b\u54c1\u79cd\u4e2d\u5609\u65e917");
        } else if (between7T12) {
            site.setCropInfo("\u5355\u5b63\u7a3b\u65e9\u7a3b\u54c1\u79cd\u752c\u4f181540");
        }
        json.put("siteInfo", (Object)site);
        json.put("level", (Object)"\u96f6");
        json.put("preventCureLevel", (Object)"\u96f6");
        json.put("nowInsectCount", (Object)0);
        json.put("predictInsectCount", (Object)0);
        Double damagedSinglePlantRatio = this.getDamagedSinglePlantRatio(maxCount);
        Double damagedGroupRatio = this.getDamagedGroupRatio(maxCount);
        json.put("fieldPestStatus", (Object)String.format("\u5371\u5bb3\u4e1b\u7387%.2f%%,\u682a\u5371\u5bb3\u7387%.2f%%", 0.0, 0.0));
        json.put("cropPestStatus", (Object)"\u65e0");
        json.put("insectType", (Object)insectType);
        boolean insectStatus1T4 = DateUtil.between((Date)date, (Date)DateUtil.string2Date((String)(year + "-1-1 00:00:00"), (DateFormat)DateUtil.DEFAULT_FORMAT), (Date)DateUtil.string2Date((String)(year + "-04-05   23:59:59"), (DateFormat)DateUtil.DEFAULT_FORMAT));
        boolean insectStatus11T12 = DateUtil.between((Date)date, (Date)DateUtil.string2Date((String)(year + "-11-1 00:00:00"), (DateFormat)DateUtil.DEFAULT_FORMAT), (Date)DateUtil.string2Date((String)(year + "-12-31 23:59:59"), (DateFormat)DateUtil.DEFAULT_FORMAT));
        if (insectStatus1T4 || insectStatus11T12) {
            json.put("insectStatus", (Object)"\u86f9");
        } else {
            json.put("insectStatus", (Object)"\u5e7c\u866b1-3\u9f84");
        }
        DeviceMonitorInsect insectInfo = this.monitorInsectMapper.queryBySiteId(monitorId);
        json.put("insectInfo", (Object)insectInfo);
        return json;
    }

    public JSONObject queryDataHistoryToday(Integer deviceType, Integer deviceId) {
        List list2022;
        List list2021;
        ArrayList<Object> list2020;
        JSONObject json = new JSONObject();
        if (deviceType == 1) {
            list2020 = this.insectMapper.queryDataHistoryToday(deviceId, "2020");
            list2021 = this.insectMapper.queryDataHistoryToday(deviceId, "2021");
            list2022 = this.insectMapper.queryDataHistoryToday(deviceId, "2022");
        } else {
            list2020 = this.insectMapper.queryData2HistoryToday(deviceId, "2020");
            List list = DateUtil.findDates((String)"2020-01-01", (String)"2020-12-31");
            ArrayList<Object> tempList = new ArrayList<Object>();
            if (list.size() != list2020.size()) {
                for (String str : list) {
                    if (!list2020.stream().noneMatch(item -> item.getRecordTime().equals(str))) continue;
                    InsectCountDataResultMap temp = new InsectCountDataResultMap();
                    temp.setCount(Integer.valueOf(0));
                    temp.setRecordTime(str);
                    temp.setWlwDeviceId(deviceId);
                    tempList.add(temp);
                }
                tempList.addAll(list2020);
                list2020 = tempList;
            }
            list2021 = this.insectMapper.queryData2HistoryToday(deviceId, "2021");
            list2022 = this.insectMapper.queryData2HistoryToday(deviceId, "2022");
        }
        ArrayList<InsectCountDataResultMap> dateList = new ArrayList<InsectCountDataResultMap>();
        InsectCountDataResultMap item2 = null;
        DateTimeFormatter dft = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDate = LocalDateTime.parse("2022-01-01 00:00:00", dft);
        for (int i = 0; i < 365; ++i) {
            item2 = new InsectCountDataResultMap();
            item2.setRecordTime(dft.format(localDate));
            dateList.add(item2);
            localDate = localDate.plusDays(1L);
        }
        list2022.addAll(dateList);
        ArrayList finalList = new ArrayList();
        list2022.parallelStream().filter(e -> e.getRecordTime() != null).collect(Collectors.groupingBy(e -> e.getRecordTime(), Collectors.toList())).forEach((id, transfer) -> transfer.stream().reduce((a, b) -> new InsectCountDataResultMap(a.getRecordTime(), a.getCount(), b.getCount(), a.getWlwDeviceId(), b.getWlwDeviceId())).ifPresent(finalList::add));
        List collect = finalList.stream().sorted(Comparator.comparing(InsectCountDataResultMap::getRecordTime)).collect(Collectors.toList());
        json.put("list2020", list2020);
        json.put("list2021", (Object)list2021);
        json.put("list2022", collect);
        return json;
    }

    public JSONObject queryInsectHistoryList(Integer fieldId, Integer siteId, String beginDate, String endDate, Integer cropType) throws IOException {
        String response;
        JSONObject json = new JSONObject();
        if (siteId == null) {
            FieldDoubleStatus fieldInfo = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(fieldId);
            response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/fieldpesthistory?lng=" + fieldInfo.getLng() + "&lat=" + fieldInfo.getLat() + "&startDate=" + beginDate + "&endDate=" + endDate + "&insectType=7&cropType=" + cropType));
        } else {
            DeviceMonitorSite deviceMonitorSite = this.deviceMonitorSiteMapper.queryById(siteId);
            response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/fieldpesthistory?lng=" + deviceMonitorSite.getLng() + "&lat=" + deviceMonitorSite.getLat() + "&startDate=" + beginDate + "&endDate=" + endDate + "&insectType=7&cropType=" + cropType));
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        json.put("list", (Object)jsonObject.getJSONArray("list"));
        return json;
    }

    public JSONObject queryFieldDetail(Integer fieldId, String startDate, String endDate, Integer cropType) throws IOException {
        JSONObject json = new JSONObject();
        FieldDoubleStatus fieldInfo = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(fieldId);
        String response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/fieldpesthistory?lng=" + fieldInfo.getLng() + "&lat=" + fieldInfo.getLat() + "&startDate=" + startDate + "&endDate=" + endDate + "&insectType=7&cropType=" + cropType));
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)fieldId);
        Query query = Query.query((CriteriaDefinition)criteria);
        query.fields().exclude("_id");
        JSONObject fieldJson = (JSONObject)this.mongoTemplate.findOne(query, JSONObject.class, "t_field_double_status");
        if (fieldInfo != null) {
            String dutyMan = fieldInfo.getDutyMan() == null || fieldInfo.getDutyMan().equals("") ? "\u5f90\u7ea2\u6e05" : fieldInfo.getDutyMan();
            String dutyPhone = fieldInfo.getDutyPhone() == null || fieldInfo.getDutyPhone().equals("") ? "13454020608" : fieldInfo.getDutyPhone();
            fieldJson.put("dutyMan", (Object)dutyMan);
            fieldJson.put("dutyPhone", (Object)dutyPhone);
        }
        List farmCropRecordList = this.farmCropRecordMapper.queryRecordListByFieldIdDate(fieldId, Integer.valueOf(0), Integer.valueOf(20), "", Integer.valueOf(7));
        String predictResponse = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/fieldpestpredict?lng=" + fieldInfo.getLng() + "&lat=" + fieldInfo.getLat() + "&cropType=" + cropType));
        JSONObject predictJson = JSONObject.parseObject((String)predictResponse);
        fieldJson.put("recommendInterveneDate", (Object)predictJson.getString("recommendInterveneDate"));
        fieldJson.put("recommendInterveneStartDate", (Object)predictJson.getString("recommendInterveneStartDate"));
        fieldJson.put("recommendInterveneEndDate", (Object)predictJson.getString("recommendInterveneEndDate"));
        fieldJson.put("record", (Object)farmCropRecordList);
        fieldJson.put("cropType", (Object)this.getFieldNowCropTypeById(fieldId));
        json.put("fieldInfo", (Object)fieldJson);
        json.put("historyList", (Object)jsonObject.getJSONArray("list"));
        return json;
    }

    private Integer getFieldNowCropTypeById(Integer fieldId) {
        int cropType = 0;
        int year = LocalDate.now().getYear();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List labelResultMapList = this.fieldDoubleStatusMapper.queryFieldPlantHistory(fieldId);
        if (labelResultMapList.size() > 0) {
            List allCropTypeList = labelResultMapList.stream().map(LabelResultMap::getType).collect(Collectors.toList());
            cropType = allCropTypeList.contains(3) ? 3 : 2;
        }
        if (cropType == 1 || cropType == 3 || cropType == 0) {
            try {
                Date compareDate = dateFormat.parse(year + "-07-20");
                cropType = new Date().after(compareDate) ? 3 : 1;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return cropType;
    }

    public void upsertMonitorInsect(DeviceMonitorInsect deviceMonitorInsect) {
        if (deviceMonitorInsect.getId() == null) {
            this.monitorInsectMapper.insert(deviceMonitorInsect);
        } else {
            this.monitorInsectMapper.update(deviceMonitorInsect);
        }
    }

    public Integer queryFieldNearSite(Integer fieldId) {
        FieldDoubleStatus fieldInfo = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(fieldId);
        DeviceMonitorSite siteDto = this.deviceMonitorSiteMapper.queryNearSiteByLoc(fieldInfo.getLng(), fieldInfo.getLat());
        return siteDto.getId();
    }

    public JSONObject queryAllDeviceInsectCountByTime(Integer deviceId, String startTime, String endTime) {
        JSONObject jsonObject = new JSONObject();
        List resultMapList1 = this.deviceMonitorSiteMapper.queryAllDeviceInsectCountByTime1(deviceId, startTime, endTime);
        List resultMapList2 = this.deviceMonitorSiteMapper.queryAllDeviceInsectCountByTime2(deviceId, startTime, endTime);
        jsonObject.put("list1", (Object)resultMapList1);
        jsonObject.put("list2", (Object)resultMapList2);
        return jsonObject;
    }

    public DeviceMonitorSite querySiteNameBySiteId(Integer itemSiteId) {
        return this.deviceMonitorSiteMapper.querySiteNameBySiteId(itemSiteId);
    }

    private Double getDamagedGroupRatio(Integer pestCount) {
        if (pestCount <= 0) {
            return 0.0;
        }
        if (pestCount < 50) {
            return (double)pestCount.intValue() * 3.0 / 50.0;
        }
        if (pestCount < 80) {
            return (double)(pestCount - 50) * 2.0 / 30.0 + 3.0;
        }
        if (pestCount < 100) {
            return (double)(pestCount - 80) * 2.0 / 20.0 + 5.0;
        }
        return Math.min((double)(pestCount - 100) * 13.0 / 200.0 * 13.0 + 7.0, 20.0);
    }

    private Double getDamagedSinglePlantRatio(Integer pestCount) {
        if (pestCount <= 0) {
            return 0.0;
        }
        if (pestCount < 50) {
            return (double)pestCount.intValue() * 0.5 / 50.0;
        }
        if (pestCount < 80) {
            return (double)((pestCount - 50) / 30) + 0.5;
        }
        if (pestCount < 100) {
            return (double)(pestCount - 80) * 1.5 / 20.0 + 3.0;
        }
        return Math.min((double)(pestCount - 100) * 3.0 / 200.0 + 3.0, 6.0);
    }

    public JSONObject queryTypeAndAddress() {
        JSONObject jsonObject = new JSONObject();
        List typeList = this.insectMapper.queryType();
        jsonObject.put("type", (Object)typeList);
        List addressList = this.insectMapper.queryAddress();
        jsonObject.put("address", (Object)addressList);
        return jsonObject;
    }

    @Transactional
    public void upsert(MedicationRecord record) {
        if (Objects.isNull(record.getId())) {
            record.setDel(Integer.valueOf(0));
            this.insectMapper.insertRecord(record);
        } else {
            this.insectMapper.updateRecord(record);
        }
    }

    public JSONObject queryAllRecords(String type, String operate, String startTime, String endTime, Integer start, Integer pageSize) {
        List list = this.insectMapper.queryAllRecords(type, operate, startTime, endTime, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)list);
        return jsonObject;
    }

    @Transactional
    public void deleteRecords(List<Integer> list) {
        MedicationRecord record = new MedicationRecord();
        record.setDelList(list);
        record.setDel(Integer.valueOf(1));
        this.insectMapper.updateRecord(record);
    }

    public ResultVo getStatistics(Integer type) {
        List mapList = this.insectMapper.getStatistics(type);
        List collect = mapList.stream().map(map -> {
            HashMap hm = new HashMap();
            hm.put(map.get("bug_type"), map.get("total_count"));
            return hm;
        }).collect(Collectors.toList());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", collect);
        return ResultVo.success((Object)jsonObject);
    }

    public ResultVo getResult(Integer dateType, String date) {
        InsectStatisticsInfo info = this.insectMapper.getResult(dateType, date);
        return ResultVo.success((Object)info);
    }
}

