/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriservMachineEx;
import com.farm.bean.AgriserveMachine;
import com.farm.bean.AgriserveMachineArea;
import com.farm.bean.AgriserveMachineInspectImport;
import com.farm.bean.Warning;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.bean.resultMap.ParentLabelResultMap;
import com.farm.mapper.AgriserveLandlordMapper;
import com.farm.mapper.AgriserveMachineMapper;
import com.farm.mapper.AgriservePublishMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.MachineService;
import com.farm.util.ResultVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="machineService")
public class MachineServiceImpl
implements MachineService {
    @Autowired
    private AgriserveMachineMapper machineMapper;
    @Autowired
    private AgriservePublishMapper publishMapper;
    @Autowired
    private AgriserveLandlordMapper landlordMapper;
    @Autowired
    private WarningMapper warningMapper;

    public JSONObject queryMachineByType(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.machineMapper.queryMachineByType(regionCode);
        for (LabelResultMap it : list) {
            if (it.getType().equals(0)) {
                it.setLabel("\u62d6\u62c9\u673a");
                continue;
            }
            if (it.getType().equals(1)) {
                it.setLabel("\u63d2\u79e7\u673a");
                continue;
            }
            if (it.getType().equals(2)) {
                it.setLabel("\u6536\u5272\u673a");
                continue;
            }
            if (it.getType().equals(3)) {
                it.setLabel("\u70d8\u5e72\u673a");
                continue;
            }
            it.setLabel("\u65e0\u4eba\u673a");
        }
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryMachineByStatus(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.machineMapper.queryMachineByStatus(regionCode);
        int useSum = list.stream().filter(labelResultMap -> labelResultMap.getStatus() != 3).mapToInt(LabelResultMap::getCount).sum();
        int noUseSum = list.stream().filter(labelResultMap -> labelResultMap.getStatus() == 3).mapToInt(LabelResultMap::getCount).sum();
        ArrayList<LabelResultMap> resultList = new ArrayList<LabelResultMap>();
        resultList.add(new LabelResultMap("\u5728\u7528", Integer.valueOf(useSum)));
        resultList.add(new LabelResultMap("\u505c\u7528", Integer.valueOf(noUseSum)));
        json.put("list", resultList);
        return json;
    }

    public JSONObject queryMachineByLandlord(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.machineMapper.queryMachineByLandlord(regionCode);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryMachineList(String regionCode, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        List list = this.machineMapper.queryAllByLimit(start.intValue(), pageSize.intValue(), regionCode);
        Integer count = this.machineMapper.queryCount(regionCode);
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySocialMsgSummaryList(String regionCode) {
        JSONObject json = new JSONObject();
        List list0 = this.publishMapper.queryListByCrop();
        List<Integer> types1 = Arrays.asList(0, 1, 2, 3, 4);
        List list1 = this.publishMapper.queryListByTypes(types1);
        List<Integer> types2 = Arrays.asList(5, 6, 7);
        List list2 = this.publishMapper.queryListByTypes(types2);
        for (LabelResultMap it : list0) {
            if (it.getType().equals(1)) {
                it.setLabel("\u6c34\u7a3b");
                continue;
            }
            if (Objects.equals(it.getType(), 106)) {
                it.setLabel("\u6cb9\u83dc");
                continue;
            }
            it.setLabel("\u6bdb\u8c46");
        }
        for (LabelResultMap it : list1) {
            if (it.getType().equals(0)) {
                it.setLabel("\u62d6\u62c9\u673a");
                continue;
            }
            if (it.getType().equals(1)) {
                it.setLabel("\u63d2\u79e7\u673a");
                continue;
            }
            if (it.getType().equals(2)) {
                it.setLabel("\u6536\u5272\u673a");
                continue;
            }
            if (it.getType().equals(3)) {
                it.setLabel("\u70d8\u5e72\u673a");
                continue;
            }
            it.setLabel("\u65e0\u4eba\u673a");
        }
        for (LabelResultMap it : list2) {
            if (it.getType().equals(5)) {
                it.setLabel("\u80b2\u79e7");
                continue;
            }
            if (it.getType().equals(6)) {
                it.setLabel("\u80b2\u82d7");
                continue;
            }
            it.setLabel("\u4e34\u65f6\u7528\u5de5");
        }
        json.put("list0", (Object)list0);
        json.put("list1", (Object)list1);
        json.put("list2", (Object)list2);
        Integer todayCount = this.publishMapper.queryCount(LocalDate.now().toString());
        Integer count = this.publishMapper.queryCount("");
        json.put("allCount", (Object)count);
        json.put("todayCount", (Object)todayCount);
        return json;
    }

    public JSONObject queryMachineSummaryListByLandlord(String regionCode, List<String> machineTypeList) {
        JSONObject json = new JSONObject();
        List list = new ArrayList();
        if (machineTypeList.size() > 0) {
            list = this.landlordMapper.queryMachineSummaryListByLandlord(regionCode, machineTypeList);
        }
        json.put("list", list);
        return json;
    }

    public JSONObject queryMachineListByLandlord(String phone) {
        AgriserveMachine machine = new AgriserveMachine();
        machine.setPhone(phone);
        List list = this.machineMapper.queryAll(machine);
        Map<Integer, List<AgriserveMachine>> map = list.stream().collect(Collectors.groupingBy(it -> it.getType()));
        JSONObject json = new JSONObject();
        json.put("list", map);
        return json;
    }

    public JSONObject queryMachineByLandlordAndType(String regionCode) {
        List list = this.machineMapper.queryMachineByLandlordAndType(regionCode);
        Map<String, List<LabelResultMap>> map = list.stream().collect(Collectors.groupingBy(it -> it.getPhone()));
        List<Object> resList = new ArrayList();
        for (String phone : map.keySet()) {
            ParentLabelResultMap resultMap = new ParentLabelResultMap();
            resultMap.setCount(Integer.valueOf(map.get(phone).stream().mapToInt(it -> it.getCount()).sum()));
            resultMap.setPhone(phone);
            resultMap.setList(map.get(phone));
            resultMap.setName(map.get(phone).get(0).getLabel());
            resList.add(resultMap);
        }
        resList = resList.stream().sorted(Comparator.comparing(ParentLabelResultMap::getCount).reversed()).collect(Collectors.toList());
        JSONObject json = new JSONObject();
        json.put("list", resList);
        return json;
    }

    public JSONObject queryMachineWorkAreas(String regionCode, Integer year) {
        JSONObject json = new JSONObject();
        List list = this.machineMapper.queryMachineWorkAreas(regionCode, year);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryMachineInsureList(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.machineMapper.queryMachineInsureList(regionCode);
        List resultList = list.stream().filter(labelResultMap -> labelResultMap.getLabel() != null && !labelResultMap.getLabel().equals("")).collect(Collectors.toList());
        json.put("list", resultList);
        return json;
    }

    public void upsertMachineWorkArea(List<AgriserveMachineArea> agriserveMachineAreaList) {
        List idList = agriserveMachineAreaList.stream().filter(agriserveMachineArea -> agriserveMachineArea.getId() != null).map(AgriserveMachineArea::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.machineMapper.deleteMachineWorkAreaByIdListAndRegionCode(idList, agriserveMachineAreaList.get(0).getRegionCode());
        }
        agriserveMachineAreaList.forEach(agriserveMachineArea -> {
            if (agriserveMachineArea.getId() == null) {
                this.machineMapper.insertMachineWorkArea(agriserveMachineArea);
            } else {
                this.machineMapper.updateMachineWorkArea(agriserveMachineArea);
            }
        });
    }

    @Transactional
    public ResultVo batchInsertMachine(List<AgriserveMachineInspectImport> list) {
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        list.forEach(a -> {
            String s = a.getRegisterDate().split(" ")[0];
            a.setRegisterDate(s);
            if (a.getCarType().contains("\u62d6\u62c9\u673a")) {
                a.setType(Integer.valueOf(0));
            } else if (a.getCarType().contains("\u63d2\u79e7\u673a")) {
                a.setType(Integer.valueOf(1));
            } else if (a.getCarType().contains("\u6536\u5272\u673a")) {
                a.setType(Integer.valueOf(2));
            } else if (a.getCarType().contains("\u70d8\u5e72\u673a")) {
                a.setType(Integer.valueOf(3));
            } else if (a.getCarType().contains("\u65e0\u4eba\u673a")) {
                a.setType(Integer.valueOf(4));
            }
        });
        this.machineMapper.batchInsertMachine(list);
        for (AgriserveMachineInspectImport dto : list) {
            String regex = "^(19\\d{2}|20\\d{2})$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(dto.getInspection());
            if (matcher.matches()) continue;
            return ResultVo.error((String)"\u5e74\u68c0\u65f6\u95f4\u8bf7\u4f20\u51651999\u5e74\u6837\u5f0f\u7684");
        }
        List warnList = list.stream().map(a -> {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Date registerDate = null;
            LocalDate registerLocalDate = null;
            long years = 0L;
            try {
                registerDate = sf.parse(a.getRegisterDate());
                registerLocalDate = registerDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                years = ChronoUnit.YEARS.between(registerLocalDate, LocalDate.now());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (a.getType() == 0 || a.getType() == 2) {
                Warning warning = new Warning();
                warning.setCompany("\u519c\u673a\u53d1\u5c55\u4e2d\u5fc3");
                warning.setLeader("\u65b9\u8d85");
                warning.setWarningDate(time);
                warning.setRelId(a.getId().toString());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(6));
                warning.setRule(Integer.valueOf(1));
                warning.setStatus(Integer.valueOf(-1));
                warning.setInspection(a.getInspection());
                if (years > 10L) {
                    warning.setWarningType(Integer.valueOf(0));
                    warning.setContent((a.getType() == 0 ? "\u62d6\u62c9\u673a" : "\u6536\u5272\u673a") + a.getEngineNumber() + "\u5e74\u9650\u5df2\u8fbe10\u5e74");
                    return warning;
                }
                if (LocalDate.now().getYear() - Integer.parseInt(a.getInspection()) > 1) {
                    warning.setWarningType(Integer.valueOf(0));
                    warning.setContent((a.getType() == 0 ? "\u62d6\u62c9\u673a" : "\u6536\u5272\u673a") + a.getEngineNumber() + "\u5df2\u7ecf\u8d85\u8fc7\u4e00\u5e74\u672a\u5e74\u68c0");
                    return warning;
                }
            } else if ((a.getType() == 1 || a.getType() == 3 || a.getType() == 4) && LocalDate.now().getYear() - Integer.parseInt(a.getInspection()) > 1) {
                Warning warning = new Warning();
                warning.setCompany("\u519c\u673a\u53d1\u5c55\u4e2d\u5fc3");
                warning.setLeader("\u65b9\u8d85");
                warning.setWarningDate(time);
                warning.setRelId(a.getId().toString());
                warning.setCreateTime(time);
                warning.setModule(Integer.valueOf(6));
                warning.setRule(Integer.valueOf(2));
                warning.setStatus(Integer.valueOf(-1));
                warning.setInspection(a.getInspection());
                warning.setWarningType(Integer.valueOf(1));
                warning.setContent(a.getType() == 1 ? "\u63d2\u79e7\u673a" : (a.getType() == 3 ? "\u70d8\u5e72\u673a" : "\u65e0\u4eba\u673a" + a.getEngineNumber() + "\u5df2\u7ecf\u8d85\u8fc7\u4e00\u5e74\u672a\u5e74\u68c0"));
                return warning;
            }
            return null;
        }).distinct().filter(warning -> !Objects.isNull(warning)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(warnList)) {
            this.warningMapper.batchInsert(warnList);
            List collect = warnList.stream().map(warning -> {
                AgriservMachineEx ex = new AgriservMachineEx();
                ex.setMachineId(Integer.valueOf(Integer.parseInt(warning.getRelId())));
                ex.setInspection(warning.getInspection());
                ex.setIsInspect(Integer.valueOf(0));
                ex.setIsSign(Integer.valueOf(0));
                return ex;
            }).collect(Collectors.toList());
            this.machineMapper.batchInsertMachineEx(collect);
        }
        return ResultVo.success();
    }
}

