/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.GrainNews;
import com.farm.bean.resultMap.MessageCenterResultMap;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.MessageMapper;
import com.farm.service.MessageService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="messageService")
public class MessageServiceImpl
implements MessageService {
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;

    public JSONObject queryMessageUnreadNumByUserId(String userId) {
        JSONObject jsonObject = new JSONObject();
        List messageCenterResultMapList = this.messageMapper.queryAllWeatherMsgList("2022-07-01");
        List weatherMsgIdList = messageCenterResultMapList.stream().map(MessageCenterResultMap::getId).collect(Collectors.toList());
        List weatherMsgReadIdList = this.messageMapper.queryMessageReadNumByUserIdAndType(userId, Integer.valueOf(0));
        jsonObject.put("weatherNum", (Object)weatherMsgIdList.stream().filter(msgId -> !weatherMsgReadIdList.contains(msgId)).count());
        jsonObject.put("weatherMsg", this.messageMapper.queryAllWeatherMsgList("").get(0));
        List grainNewsList = this.messageMapper.queryAllNoticeList("2022-07-01");
        List noticeMsgIdList = grainNewsList.stream().map(GrainNews::getId).collect(Collectors.toList());
        List noticeMsgReadIdList = this.messageMapper.queryMessageReadNumByUserIdAndType(userId, Integer.valueOf(1));
        jsonObject.put("noticeNum", (Object)noticeMsgIdList.stream().filter(msgId -> !noticeMsgReadIdList.contains(msgId)).count());
        jsonObject.put("noticeMsg", this.messageMapper.queryAllNoticeList("").get(0));
        return jsonObject;
    }

    public JSONObject queryMessageList(String userId, Integer type, String phone, String noticeTypes, String title, String startTime, String endTime, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        if (type == 0) {
            this.readMessageByUserId(userId);
            Integer count = this.messageMapper.queryAllWeatherMsgCount();
            List weatherMsgResult = this.messageMapper.queryAllWeatherMsgPage(start, pageSize);
            List fieldDoubleStatusList = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByPhone(phone);
            weatherMsgResult.forEach(messageCenterResultMap -> messageCenterResultMap.setFieldDoubleStatusList(fieldDoubleStatusList));
            jsonObject.put("count", (Object)count);
            jsonObject.put("list", (Object)weatherMsgResult);
        } else {
            List grainNewsList = this.messageMapper.queryAllNoticeList("2022-07-01");
            List noticeMsgIdList = grainNewsList.stream().map(GrainNews::getId).collect(Collectors.toList());
            List noticeMsgReadIdList = this.messageMapper.queryMessageReadNumByUserIdAndType(userId, Integer.valueOf(1));
            Integer count = this.messageMapper.queryAllNoticeCount(noticeTypes, title, startTime, endTime);
            List allNoticeList = this.messageMapper.queryAllNoticePage(noticeTypes, title, startTime, endTime, start, pageSize);
            allNoticeList.forEach(item -> {
                if (!noticeMsgIdList.contains(item.getId()) || noticeMsgReadIdList.contains(item.getId())) {
                    item.setReadStatus(Integer.valueOf(1));
                } else {
                    item.setReadStatus(Integer.valueOf(0));
                }
            });
            jsonObject.put("count", (Object)count);
            jsonObject.put("list", (Object)allNoticeList);
        }
        return jsonObject;
    }

    private void readMessageByUserId(String userId) {
        List messageCenterResultMapList = this.messageMapper.queryAllWeatherMsgList("2022-07-01");
        List<Integer> weatherMsgIdList = messageCenterResultMapList.stream().map(MessageCenterResultMap::getId).collect(Collectors.toList());
        List weatherMsgReadIdList = this.messageMapper.queryMessageReadNumByUserIdAndType(userId, Integer.valueOf(0));
        weatherMsgIdList.forEach(itemId -> {
            if (!weatherMsgReadIdList.contains(itemId)) {
                this.messageMapper.insertMsgReadByUserId(userId, itemId, Integer.valueOf(0));
            }
        });
    }
}

