/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.PestControlIdentify;
import com.farm.bean.PestControlInfo;
import com.farm.bean.PestControlRemind;
import com.farm.mapper.PestControlMapper;
import com.farm.service.PestControlService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pestControlService")
public class PestControlServiceImpl
implements PestControlService {
    private static final Logger log = LoggerFactory.getLogger(PestControlServiceImpl.class);
    @Autowired
    private PestControlMapper pestControlMapper;

    @Transactional
    public void insert(PestControlInfo pestControlInfo) {
        this.pestControlMapper.insert(pestControlInfo);
        this.pestControlMapper.insertFormula(Arrays.asList(pestControlInfo.getFormulaList().split(",")), pestControlInfo.getId());
    }

    @Transactional
    public void update(PestControlInfo pestControlInfo) {
        this.pestControlMapper.update(pestControlInfo);
        this.pestControlMapper.deleteFormulaById(pestControlInfo.getId());
        this.pestControlMapper.insertFormula(Arrays.asList(pestControlInfo.getFormulaList().split(",")), pestControlInfo.getId());
    }

    public PestControlInfo queryPestLibraryDetail(Integer id) {
        PestControlInfo pestControlInfo = this.pestControlMapper.queryPestLibraryDetail(id);
        pestControlInfo.setFormulaList(StringUtils.join((Object[])this.pestControlMapper.queryFormulaListById(id).toArray(), (String)","));
        this.pestControlMapper.updatePestLibraryReadCount(id);
        return pestControlInfo;
    }

    public JSONObject queryPestLibraryPage(String name, Integer status, Integer type, List<String> cropIdList, Integer remindId, Integer dangerLevel, String startTime, String endTime, Integer start, Integer pageSize) {
        List<Object> pestInfoIdList = new ArrayList();
        if (remindId != null) {
            PestControlRemind pestControlRemind = this.pestControlMapper.queryPestRemindInfo(remindId);
            pestInfoIdList = Arrays.asList(pestControlRemind.getPestInfoId().split(","));
        }
        Integer count = this.pestControlMapper.queryPestLibraryCount(name, status, type, cropIdList, pestInfoIdList, dangerLevel);
        List pestControlInfoList = this.pestControlMapper.queryPestLibraryPage(name, status, type, cropIdList, pestInfoIdList, dangerLevel, start, pageSize);
        if (StringUtils.isNotBlank((String)endTime)) {
            String format = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            pestControlInfoList.forEach(pestControlInfo -> {
                Integer startReadTime = this.pestControlMapper.queryReadCountByTime(pestControlInfo.getId(), startTime);
                if (endTime.equals(format)) {
                    pestControlInfo.setReadCount(Integer.valueOf(pestControlInfo.getReadCount() - startReadTime));
                } else {
                    Integer endReadTime = this.pestControlMapper.queryReadCountByTime(pestControlInfo.getId(), endTime);
                    pestControlInfo.setReadCount(Integer.valueOf((endReadTime == null ? 0 : endReadTime) - (startReadTime == null ? 0 : startReadTime)));
                }
            });
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)pestControlInfoList);
        return jsonObject;
    }

    public void delDisableTopPestLibrary(Integer id, Integer type, Integer top, Integer status) {
        if (type == null) {
            this.pestControlMapper.deletePestLibrary(id);
        } else {
            this.pestControlMapper.disableTopPestLibrary(id, type, top, status);
        }
    }

    public JSONObject queryPestSummary(String name, Integer type, List<String> cropIdList, String startTime, String endTime, Integer start, Integer pageSize) {
        Integer count = this.pestControlMapper.queryPestLibraryCount(name, null, type, cropIdList, new ArrayList(), null);
        List pestControlInfoList = this.pestControlMapper.queryPestLibraryPage(name, null, type, cropIdList, new ArrayList(), null, start, pageSize);
        if (!endTime.equals("")) {
            String format = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            pestControlInfoList.forEach(pestControlInfo -> {
                Integer startReadTime = this.pestControlMapper.queryReadCountByTime(pestControlInfo.getId(), startTime);
                if (endTime.equals(format)) {
                    pestControlInfo.setReadCount(Integer.valueOf(pestControlInfo.getReadCount() - startReadTime));
                } else {
                    Integer endReadTime = this.pestControlMapper.queryReadCountByTime(pestControlInfo.getId(), endTime);
                    pestControlInfo.setReadCount(Integer.valueOf((endReadTime == null ? 0 : endReadTime) - (startReadTime == null ? 0 : startReadTime)));
                }
            });
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", pestControlInfoList.stream().sorted(Comparator.comparing(PestControlInfo::getReadCount).reversed()).collect(Collectors.toList()));
        return jsonObject;
    }

    public JSONObject insertPestIdentify(JSONObject resJson, String cropType, String imageUrl, String cameraAngle, String userId) {
        int status = 0;
        Double score = 0.0;
        String conclusion = "";
        if (resJson.getJSONArray("similarPDs") != null) {
            status = 1;
            JSONArray array = resJson.getJSONArray("similarPDs");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject itJson = array.getJSONObject(i);
                conclusion = itJson.getString("pdName");
                score = itJson.getDouble("dconf");
                this.pestControlMapper.insertPestIdentify(new PestControlIdentify(userId, cropType, imageUrl, cameraAngle, Integer.valueOf(status), conclusion, score));
            }
        }
        return resJson;
    }

    public void insertDiseaseDetail(JSONArray jsonArray) {
        ArrayList<PestControlInfo> insertList = new ArrayList<PestControlInfo>();
        PestControlInfo insertInfo = null;
        JSONObject jsonObject = null;
        JSONArray array = null;
        JSONObject object = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject == null) continue;
            insertInfo = new PestControlInfo();
            insertInfo.setName(jsonObject.getString("pdName"));
            if (jsonObject.getString("type").equals("D")) {
                insertInfo.setType(Integer.valueOf(1));
            } else if (jsonObject.getString("type").equals("P")) {
                insertInfo.setType(Integer.valueOf(2));
            }
            insertInfo.setClassificationAlias(jsonObject.getString("commonNameSort"));
            switch (jsonObject.getString("cropId")) {
                case "GJ": {
                    insertInfo.setCropId("301");
                    break;
                }
                case "XG": {
                    insertInfo.setCropId("300");
                    break;
                }
                case "FQ": {
                    insertInfo.setCropId("303");
                    break;
                }
                case "CM": {
                    insertInfo.setCropId("302");
                    break;
                }
                case "CHA": {
                    insertInfo.setCropId("99");
                    break;
                }
                case "SD": {
                    insertInfo.setCropId("3");
                }
            }
            if (jsonObject.getJSONArray("outline") != null && jsonObject.getJSONArray("outline").size() > 0) {
                array = jsonObject.getJSONArray("outline");
                block45: for (int i1 = 0; i1 < array.size(); ++i1) {
                    object = array.getJSONObject(i1);
                    switch (object.getString("keyName")) {
                        case "\u5371\u5bb3\u7279\u5f81": {
                            insertInfo.setHarmShape(object.getString("value"));
                            continue block45;
                        }
                        case "\u53d1\u75c5\u5468\u671f": {
                            insertInfo.setOccurrenceLaw(object.getString("value"));
                            continue block45;
                        }
                        case "\u53d1\u75c5\u6761\u4ef6\u53ca\u4f20\u67d3\u6027": {
                            insertInfo.setOccurrenceLaw(object.getString("value"));
                            continue block45;
                        }
                        case "\u5371\u5bb3\u4f5c\u7269": {
                            insertInfo.setHarmCrop(object.getString("value"));
                            continue block45;
                        }
                        case "\u5371\u5bb3\u866b\u6001\u53ca\u5371\u5bb3\u72b6": {
                            insertInfo.setHarmShape(object.getString("value"));
                            continue block45;
                        }
                        case "\u53d1\u751f\u89c4\u5f8b": {
                            insertInfo.setOccurrenceLaw(object.getString("value"));
                        }
                    }
                }
            }
            if (jsonObject.getJSONArray("preventionAdvice") != null && jsonObject.getJSONArray("preventionAdvice").size() > 0) {
                array = jsonObject.getJSONArray("preventionAdvice");
                block46: for (int i2 = 0; i2 < array.size(); ++i2) {
                    object = array.getJSONObject(i2);
                    switch (object.getString("keyName")) {
                        case "\u519c\u4e1a\u9632\u6cbb": {
                            insertInfo.setAgriculturalControl(object.getString("value"));
                            continue block46;
                        }
                        case "\u7269\u7406\u9632\u6cbb": {
                            insertInfo.setPhysicalControl(object.getString("value"));
                            continue block46;
                        }
                        case "\u751f\u7269\u9632\u6cbb": {
                            insertInfo.setBiologicalControl(object.getString("value"));
                            continue block46;
                        }
                        case "\u5316\u5b66\u9632\u6cbb": {
                            insertInfo.setChemicalControl(object.getString("value"));
                        }
                    }
                }
            }
            if (jsonObject.getJSONArray("insectStateImgs") != null && jsonObject.getJSONArray("insectStateImgs").size() > 0) {
                array = jsonObject.getJSONArray("insectStateImgs");
                StringBuffer buffer = new StringBuffer();
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    object = array.getJSONObject(i2);
                    if (object == null) continue;
                    buffer.append(object.getString("imgUrl"));
                    buffer.append(",");
                }
                buffer.deleteCharAt(buffer.length() - 1);
                insertInfo.setPics(buffer.toString());
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jsonObject.getString("typicalImg"))) {
                insertInfo.setPics(jsonObject.getString("typicalImg"));
            }
            insertList.add(insertInfo);
        }
        if (insertList != null && insertList.size() > 0) {
            this.pestControlMapper.batchInsert(insertList);
        }
    }

    public JSONObject insertDiseaseDetailNew(JSONObject json, String cropId) {
        ArrayList<PestControlInfo> insertList = new ArrayList<PestControlInfo>();
        PestControlInfo insertInfo = new PestControlInfo();
        if (json != null && json.getJSONObject("disInsPesDetailRVO") != null) {
            insertInfo.setName(json.getJSONObject("disInsPesDetailRVO").getString("title"));
            if (json.getJSONObject("disInsPesDetailRVO").getString("infoType") != null) {
                switch (json.getJSONObject("disInsPesDetailRVO").getString("infoType")) {
                    case "disease": {
                        insertInfo.setType(Integer.valueOf(1));
                        break;
                    }
                    case "pest": {
                        insertInfo.setType(Integer.valueOf(2));
                    }
                }
            }
            switch (cropId) {
                case "GJ": {
                    insertInfo.setCropId("301");
                    break;
                }
                case "XG": {
                    insertInfo.setCropId("300");
                    break;
                }
                case "FQ": {
                    insertInfo.setCropId("303");
                    break;
                }
                case "CM": {
                    insertInfo.setCropId("302");
                    break;
                }
                case "CHA": {
                    insertInfo.setCropId("99");
                    break;
                }
                case "SD": {
                    insertInfo.setCropId("3");
                }
            }
            insertInfo.setHarmShape(json.getJSONObject("disInsPesDetailRVO").getString("symptom"));
            insertInfo.setOccurrenceLaw(json.getJSONObject("disInsPesDetailRVO").getString("route"));
            if (json.getJSONArray("disInsPesPrvMethodRVOList") != null && json.getJSONArray("disInsPesPrvMethodRVOList").size() > 0) {
                JSONArray array = json.getJSONArray("disInsPesPrvMethodRVOList");
                StringBuffer buffer = new StringBuffer();
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    buffer.append(array.getJSONObject(i2).getString("content"));
                }
                insertInfo.setChemicalControl(buffer.toString());
            }
            if (StringUtils.isNotBlank((String)json.getJSONObject("disInsPesDetailRVO").getString("imgs"))) {
                String[] split = json.getJSONObject("disInsPesDetailRVO").getString("imgs").split(",");
                StringBuffer buffer = new StringBuffer();
                String url = "http://imgs.shuxitech.com/farm/crop_imgs/";
                for (int i2 = 0; i2 < split.length; ++i2) {
                    buffer.append(url + split[i2]);
                    buffer.append(",");
                }
                buffer.deleteCharAt(buffer.length() - 1);
                insertInfo.setPics(buffer.toString());
                json.getJSONObject("disInsPesDetailRVO").put("imgs", (Object)buffer.toString());
            }
            insertList.add(insertInfo);
            try {
                this.pestControlMapper.batchInsert(insertList);
            }
            catch (Exception e) {
                log.error("\u8bc6\u522b\u75c5\u866b\u5bb3\u8be6\u60c5\u5165\u5e93\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return json;
    }
}

