/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DatavFieldFertilize;
import com.farm.bean.DatavFieldYieldLevel;
import com.farm.bean.DatavFieldYieldLevelImBo;
import com.farm.bean.ZnmField;
import com.farm.bean.resultMap.FieldAddInfoResultMap;
import com.farm.bean.resultMap.FieldDoubleStatusResultMap;
import com.farm.bean.resultMap.FieldInfoResultMap;
import com.farm.bean.resultMap.InsectArticleResultMap;
import com.farm.bean.resultMap.RegionResultMap;
import com.farm.mapper.AgriserveLandlordMapper;
import com.farm.mapper.DatavFieldFertilizeMapper;
import com.farm.mapper.DatavFieldFertilizerLevelMapper;
import com.farm.mapper.DatavFieldYieldLevelMapper;
import com.farm.mapper.DatavHomePCMapper;
import com.farm.mapper.DoubleFieldFileMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.service.ProductManageService;
import com.farm.util.HttpSendUtil;
import com.farm.util.MongodbUtil;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="productManageService")
public class ProductManageServiceImpl
implements ProductManageService {
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Autowired
    private DoubleFieldFileMapper doubleFieldFileMapper;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DatavFieldFertilizeMapper fieldFertilizeMapper;
    @Autowired
    private DatavFieldFertilizerLevelMapper fieldFertilizerLevelMapper;
    @Autowired
    private DatavFieldYieldLevelMapper fieldYieldLevelMapper;
    @Autowired
    private AgriserveLandlordMapper landlordMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private DatavHomePCMapper datavHomePCMapper;
    @Value(value="${farm.datasync}")
    private String datasyncUrl;

    public JSONObject queryFieldByDistance(String xAxis, String yAxis, String cropSubId, String search, Integer page, Integer pageSize, String phone, Integer mark, String regionCode) {
        JSONObject json = new JSONObject();
        Integer start = (page - 1) * pageSize;
        Integer count = this.fieldDoubleStatusMapper.queryFieldCount(cropSubId, search, phone, mark, regionCode);
        List fieldDoubleStatusList = this.fieldDoubleStatusMapper.queryFieldByDistancePage(xAxis, yAxis, cropSubId, search, start, pageSize, phone, mark, regionCode);
        fieldDoubleStatusList.forEach(item -> {
            item.setDistance(Double.valueOf(Double.parseDouble(new DecimalFormat("0.00").format(item.getDistance() / 1000.0))));
            item.setImg(item.getImg().contains("http") ? item.getImg() : "http://imgs.shuxitech.com/farm/field_img/" + item.getImg());
        });
        json.put("count", (Object)count);
        json.put("list", (Object)fieldDoubleStatusList);
        return json;
    }

    public JSONObject queryFieldByArea(String cropSubId, Integer page, Integer pageSize, String search, String phone, Integer mark, String regionCode) {
        JSONObject json = new JSONObject();
        Integer start = (page - 1) * pageSize;
        Integer count = this.fieldDoubleStatusMapper.queryFieldCount(cropSubId, search, phone, mark, regionCode);
        List fieldDoubleStatusList = this.fieldDoubleStatusMapper.queryFieldByAreaPage(cropSubId, start, pageSize, search, phone, mark, regionCode);
        fieldDoubleStatusList.forEach(item -> item.setImg(item.getImg().contains("http") ? item.getImg() : "http://imgs.shuxitech.com/farm/field_img/" + item.getImg()));
        json.put("count", (Object)count);
        json.put("list", (Object)fieldDoubleStatusList);
        return json;
    }

    public JSONObject queryFieldDetailInfo(Integer fieldDoubleStatusId, String phone) {
        JSONObject json = new JSONObject();
        FieldInfoResultMap fieldInfo = this.doubleFieldFileMapper.queryFieldDoubleStatusInfoById(fieldDoubleStatusId, phone);
        if (fieldInfo == null) {
            return json;
        }
        if (StringUtils.isBlank((String)fieldInfo.getSoilInfo())) {
            String url = this.farmServerUrl + "field/querySoilInfo?yAxis=" + fieldInfo.getLat() + "&xAxis=" + fieldInfo.getLng() + "&boundary=" + fieldInfo.getBoundary();
            try {
                String result = HttpSendUtil.sendHttpGet((String)url);
                if (result.indexOf("resCode") == -1) {
                    result = result.replaceAll("NaN", "0");
                    FieldInfoResultMap f = new FieldInfoResultMap();
                    f.setFieldDoubleStatusId(fieldDoubleStatusId);
                    f.setSoilInfo(result);
                    this.doubleFieldFileMapper.updateFieldAddInfo(f);
                    fieldInfo.setSoilInfo(result);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        fieldInfo.setImg(fieldInfo.getImg().indexOf("http") > -1 ? fieldInfo.getImg() : "http://imgs.shuxitech.com/farm/field_img/" + fieldInfo.getImg());
        if (!StringUtil.isNullOrEmpty((String)fieldInfo.getCropSubImg())) {
            fieldInfo.setCropSubImg(fieldInfo.getCropSubImg().indexOf("http") > -1 ? fieldInfo.getCropSubImg() : "https://imgs.shuxitech.com/farm/crop_img/" + fieldInfo.getCropSubImg());
        }
        FieldAddInfoResultMap fieldAdd = this.doubleFieldFileMapper.queryFieldAddInfoById(fieldDoubleStatusId);
        json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)fieldInfo));
        if (fieldAdd != null) {
            json.putAll((Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fieldAdd)));
        }
        return json;
    }

    @Transactional
    public void addFieldInfo(FieldInfoResultMap fieldInfo) {
        fieldInfo.setCreateType(Integer.valueOf(1));
        this.doubleFieldFileMapper.insertFieldDoubleStatus(fieldInfo);
        fieldInfo.setFieldDoubleStatusId(fieldInfo.getId());
        this.doubleFieldFileMapper.insertFieldAddInfo(fieldInfo);
        this.syncSubsidyFormField(FieldInfoResultMap.generateJson((FieldInfoResultMap)fieldInfo).toJSONString(), "ly/subsidy/field-sync");
        LocalDateTime ld = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        FieldDoubleStatusResultMap fd = new FieldDoubleStatusResultMap(fieldInfo.getId(), fieldInfo.getCompanyId(), fieldInfo.getName(), fieldInfo.getGridUserId(), new Double[]{Double.valueOf(fieldInfo.getLng()), Double.valueOf(fieldInfo.getLat())}, fieldInfo.getArea(), MongodbUtil.getFieldPolygonGeoJsonDto((String)fieldInfo.getBoundary()), fieldInfo.getAddress(), fieldInfo.getImg(), fieldInfo.getStatus(), fieldInfo.getType(), fieldInfo.getAreaType(), dtf.format(ld), dtf.format(ld), fieldInfo.getRegionCode(), fieldInfo.getDkbm(), fieldInfo.getLandType(), fieldInfo.getCreateType(), fieldInfo.getPhone(), fieldInfo.getCropSubId());
        this.mongoTemplate.insert((Object)fd);
    }

    public void updateFieldInfo(FieldInfoResultMap fieldInfo) {
        fieldInfo.setSoilInfo(null);
        this.doubleFieldFileMapper.updateFieldDoubleStatus(fieldInfo);
        this.doubleFieldFileMapper.updateFieldAddInfo(fieldInfo);
        this.syncSubsidyFormField(FieldInfoResultMap.generateJson((FieldInfoResultMap)fieldInfo).toJSONString(), "ly/subsidy/field-sync");
        LocalDateTime ld = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        Query query = new Query();
        Update update = new Update();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"field_double_status_id").is((Object)fieldInfo.getId()));
        update.set("fieldDoubleStatusId", (Object)fieldInfo.getId());
        update.set("companyId", (Object)fieldInfo.getCompanyId());
        update.set("name", (Object)fieldInfo.getName());
        update.set("gridUserId", (Object)fieldInfo.getGridUserId());
        update.set("location", (Object)new Double[]{Double.valueOf(fieldInfo.getLng()), Double.valueOf(fieldInfo.getLat())});
        update.set("area", (Object)fieldInfo.getArea());
        update.set("boundary", (Object)MongodbUtil.getFieldPolygonGeoJsonDto((String)fieldInfo.getBoundary()));
        update.set("address", (Object)fieldInfo.getAddress());
        update.set("img", (Object)fieldInfo.getImg());
        update.set("updateTime", (Object)dtf.format(ld));
        update.set("regionCode", (Object)fieldInfo.getRegionCode());
        update.set("landType", (Object)fieldInfo.getLandType());
        update.set("cropSubId", (Object)fieldInfo.getCropSubId());
        this.mongoTemplate.updateFirst(query, update, "t_field_double_status");
    }

    public JSONObject queryInsectList(Integer begin, Integer pageSize, String cropSubId) {
        Integer count = this.doubleFieldFileMapper.queryInsectListCount(cropSubId);
        List list = this.doubleFieldFileMapper.queryInsectList(begin, pageSize, cropSubId);
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryInsectDetail(Integer id) {
        InsectArticleResultMap detail = this.doubleFieldFileMapper.queryInsectDetail(id);
        JSONObject json = new JSONObject();
        json.put("detail", (Object)detail);
        return json;
    }

    public JSONObject queryFieldFertilizeList(String regionCode, String year) {
        JSONObject json = new JSONObject();
        List list = this.fieldFertilizeMapper.queryFieldFertilizeList(regionCode);
        list.stream().forEach(it -> {
            Integer count = it.getCount();
            it.setCompound(Double.valueOf(BigDecimal.valueOf(it.getCompound() / (double)count.intValue()).setScale(2, 4).doubleValue()));
            it.setN(Double.valueOf(BigDecimal.valueOf(it.getN() / (double)count.intValue()).setScale(2, 4).doubleValue()));
            it.setP(Double.valueOf(BigDecimal.valueOf(it.getP() / (double)count.intValue()).setScale(2, 4).doubleValue()));
            it.setK(Double.valueOf(BigDecimal.valueOf(it.getK() / (double)count.intValue()).setScale(2, 4).doubleValue()));
            it.setOrganic(Double.valueOf(BigDecimal.valueOf(it.getOrganic() / (double)count.intValue()).setScale(2, 4).doubleValue()));
        });
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryFieldFertilizePercent(String regionCode, String year) {
        JSONObject json = new JSONObject();
        DatavFieldFertilize fieldFertilize = this.fieldFertilizeMapper.queryFieldFertilizePercent(regionCode, year);
        Double n = fieldFertilize.getN();
        Double p = fieldFertilize.getP();
        Double k = fieldFertilize.getK();
        Double compound = fieldFertilize.getCompound();
        Double organic = fieldFertilize.getOrganic();
        json.put("n", (Object)new BigDecimal(n));
        json.put("p", (Object)new BigDecimal(p));
        json.put("k", (Object)new BigDecimal(k));
        json.put("compound", (Object)new BigDecimal(compound));
        json.put("organic", (Object)new BigDecimal(organic));
        return json;
    }

    public JSONObject queryFieldYieldLevelList(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.fieldYieldLevelMapper.queryFieldYieldLevelList(regionCode);
        json.put("item", list.get(0));
        list.remove(0);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryFieldFertilizerLevelList(String regionCode, String element) {
        JSONObject json = new JSONObject();
        List list = this.fieldFertilizerLevelMapper.queryFieldFertilizerLevelList(regionCode, element);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryLandlordList(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.landlordMapper.queryLandlordListByRegion(regionCode);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryLandlordFieldList(String phone, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        List list = this.landlordMapper.queryLandlordFieldList(phone, start, pageSize);
        Integer count = this.landlordMapper.queryLandlordFieldCount(phone);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryMessageCenter(String phone, Integer begin, Integer pageSize, String types, String fieldDoubleStatusId) {
        List<Object> typeList = new ArrayList();
        if (!StringUtils.isBlank((String)types)) {
            typeList = Arrays.asList(types.split(","));
        }
        String date = LocalDate.now().minusDays(7L).toString();
        Integer count = this.doubleFieldFileMapper.queryMessageCenterCount(phone, date, typeList, fieldDoubleStatusId);
        List list = this.doubleFieldFileMapper.queryMessageCenterList(phone, date, begin, pageSize, typeList, fieldDoubleStatusId);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryDisasterWeatherCount(Integer year) {
        List list = this.doubleFieldFileMapper.queryDisasterWeatherCount(year);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public void upsertDisasterWeatherCount(String label, Integer count, Integer year) {
        Map map = this.doubleFieldFileMapper.queryDisasterWeatherCountByLabelAndYear(label, year);
        if (map != null) {
            this.doubleFieldFileMapper.updateDisasterWeatherCount(label, count, year);
        } else {
            this.doubleFieldFileMapper.insertDisasterWeatherCount(label, count, year);
        }
    }

    public Object queryFieldSoilInfo(Integer fieldDoubleStatusId, String phone) {
        JSONObject json = new JSONObject();
        String soilInfo = this.doubleFieldFileMapper.queryFieldSoilInfo(fieldDoubleStatusId, phone);
        if (!StringUtils.isBlank((String)soilInfo)) {
            json.put("soilInfo", (Object)soilInfo);
            return json;
        }
        FieldInfoResultMap fieldInfo = this.doubleFieldFileMapper.queryFieldDoubleStatusInfoById(fieldDoubleStatusId, phone);
        if (fieldInfo == null) {
            return json;
        }
        String url = this.farmServerUrl + "field/querySoilInfo?yAxis=" + fieldInfo.getLat() + "&xAxis=" + fieldInfo.getLng() + "&boundary=" + fieldInfo.getBoundary();
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            FieldInfoResultMap f = new FieldInfoResultMap();
            f.setFieldDoubleStatusId(fieldDoubleStatusId);
            f.setSoilInfo(result);
            this.doubleFieldFileMapper.updateFieldAddInfo(fieldInfo);
            json.put("soilInfo", (Object)result);
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            return json;
        }
    }

    public Object querySolieSqTemp(String xAxis, String yAxis, Integer year, Integer cropSubId) {
        JSONObject json = new JSONObject();
        String url = this.farmServerUrl + "reptdata/querySolieSqTempLy?lat=" + yAxis + "&lng=" + xAxis + "&year=" + year;
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            json = JSONObject.parseObject((String)result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (cropSubId != null && (cropSubId == 3 || cropSubId == 4 || cropSubId == 5)) {
            url = this.farmServerUrl + "field/querySoilInfo?yAxis=" + yAxis + "&xAxis=" + xAxis;
            try {
                String res = HttpSendUtil.sendHttpGet((String)url);
                JSONObject resData = JSONObject.parseObject((String)res);
                JSONObject rd = json.getJSONObject("resData");
                rd.put("TH1500", resData.get((Object)"TH1500"));
                rd.put("warning_line", resData.get((Object)"warning_line"));
                rd.put("valueArray20", resData.get((Object)"valueArray20"));
                rd.put("valueArray40", resData.get((Object)"valueArray40"));
                json.put("resData", (Object)rd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return json;
    }

    public Object getAccuWeather(String xAxis, String yAxis, Integer year) {
        JSONObject json = new JSONObject();
        String url = this.farmServerUrl + "field/getAccuWeatherLy?yAxis=" + yAxis + "&xAxis=" + xAxis + "&year=" + year + "&hash=x";
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            json = JSONObject.parseObject((String)result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return json;
    }

    public JSONObject queryInsectListByFieldId(String phone, Integer begin, Integer pageSize, String fieldDoubleStatusId, String cropSubId) {
        Integer count = this.doubleFieldFileMapper.queryInsectListCount(cropSubId);
        List list = this.doubleFieldFileMapper.queryInsectList(begin, pageSize, cropSubId);
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryUserFieldRange(String phone, Integer code) {
        Criteria criteria = Criteria.where((String)"adcode").is((Object)String.valueOf(code));
        Query query = Query.query((CriteriaDefinition)criteria);
        query.fields().exclude("_id");
        query.fields().exclude("adcode");
        query.fields().exclude("lng");
        query.fields().exclude("lat");
        query.fields().exclude("name");
        query.fields().exclude("level");
        query.fields().exclude("parent");
        query.fields().exclude("parent_id");
        JSONObject json = (JSONObject)this.mongoTemplate.findOne(query, JSONObject.class, "district");
        return json;
    }

    public boolean validateFieldInArea(String boundary, Integer code) throws Exception {
        ArrayList<Object> pointList = new ArrayList<Object>();
        String[] axises = boundary.split(",");
        for (int i = 0; i < axises.length; ++i) {
            pointList.add(new Point(Double.parseDouble(axises[i]), Double.parseDouble(axises[++i])));
        }
        pointList.add(pointList.get(0));
        Criteria criteria = new Criteria();
        criteria.and("adcode").is((Object)String.valueOf(code));
        criteria.and("bound").intersects((GeoJson)new GeoJsonPolygon(pointList));
        Query query = new Query((CriteriaDefinition)criteria);
        JSONObject json = null;
        json = (JSONObject)this.mongoTemplate.findOne(query, JSONObject.class, "district");
        return json != null;
    }

    public String queryFieldPhone(Integer fieldDoubleStatusId) {
        String phone = "";
        if (fieldDoubleStatusId != null) {
            phone = this.doubleFieldFileMapper.queryFieldPhone(fieldDoubleStatusId);
        }
        return phone;
    }

    public String queryRegionCodeInArea(Double lng, Double lat) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"bound").intersects((GeoJson)new GeoJsonPoint(lng.doubleValue(), lat.doubleValue())));
        query.fields().include("adcode").include("name").exclude("_id");
        List list = this.mongoTemplate.find(query, JSONObject.class, "district");
        String regionCode = list.stream().map(it -> it.getString("adcode")).max((it, it1) -> it.length() - it1.length()).get();
        return regionCode;
    }

    public void delUserField(String phone, Integer fieldId) {
        FieldInfoResultMap fieldInfo = this.doubleFieldFileMapper.queryFieldInfo(fieldId);
        if (fieldInfo != null && fieldInfo.getCreateType() == 0) {
            if (Objects.equals(phone, fieldInfo.getPhone())) {
                this.doubleFieldFileMapper.updateFieldPhone(fieldId, "");
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"field_double_status_id").is((Object)fieldId));
                Update update = Update.update((String)"phone", (Object)"");
                this.mongoTemplate.updateFirst(query, update, "t_field_double_status");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("fieldId", (Object)fieldId);
                jsonObject.put("createType", (Object)0);
                this.syncSubsidyFormField(jsonObject.toJSONString(), "/ly/subsidy/field-del");
            }
        } else if (fieldInfo != null && fieldInfo.getCreateType() == 1 && Objects.equals(phone, fieldInfo.getPhone())) {
            this.doubleFieldFileMapper.deleteField(fieldId);
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"field_double_status_id").is((Object)fieldId));
            this.mongoTemplate.remove(query, "t_field_double_status");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fieldId", (Object)fieldId);
            jsonObject.put("createType", (Object)1);
            this.syncSubsidyFormField(jsonObject.toJSONString(), "/ly/subsidy/field-del");
        }
    }

    public ZnmField detailFieldIdByZnm(String code) {
        return this.fieldDoubleStatusMapper.detailFieldIdByZnm(code);
    }

    private void syncSubsidyFormField(String jsonStr, String url) {
        try {
            HttpSendUtil.sendHttpPost((String)(this.datasyncUrl + url), (String)"", (String)"", (String)jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<JSONObject> querySelectValue() {
        JSONObject json = new JSONObject();
        List regions = this.datavHomePCMapper.queryRegionCodeChildren("330825");
        List datas = regions.stream().map(RegionResultMap::getName).collect(Collectors.toList());
        json.put("index", (Object)0);
        json.put("datas", datas);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        list.add(json);
        return list;
    }

    public JSONObject queryFieldYieldLevelListAll(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.fieldYieldLevelMapper.queryFieldYieldLevelListAll(regionCode);
        json.put("list", (Object)list);
        return json;
    }

    @Transactional
    public boolean saveByFile(List<DatavFieldYieldLevelImBo> list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        int delNum = this.fieldYieldLevelMapper.deleteAll();
        List adNameList = list.stream().map(item -> item.getRegionName()).collect(Collectors.toList());
        List regions = this.datavHomePCMapper.queryRegionCodeByName("330825", adNameList);
        ArrayList produceList = new ArrayList();
        AtomicReference add = new AtomicReference();
        list.forEach(data -> {
            add.set(new DatavFieldYieldLevel());
            regions.forEach(it -> {
                if (StringUtils.equals((String)data.getRegionName(), (String)it.getName())) {
                    ((DatavFieldYieldLevel)add.get()).setRegionCode(it.getId());
                    ((DatavFieldYieldLevel)add.get()).setHighArea(data.getHighArea());
                    ((DatavFieldYieldLevel)add.get()).setMidArea(data.getMidArea());
                    ((DatavFieldYieldLevel)add.get()).setLowArea(data.getLowArea());
                }
            });
            if (((DatavFieldYieldLevel)add.get()).getRegionCode() != null) {
                produceList.add(add.get());
            }
        });
        int i = 0;
        if (produceList != null && produceList.size() > 0) {
            i = this.fieldYieldLevelMapper.insertBatch(produceList);
        }
        return i > 0;
    }
}

