/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.RecycleFormInfo;
import com.farm.bean.RecycleLitterInfo;
import com.farm.bean.RecyclePointInfo;
import com.farm.bean.RecycleSummaryStorageAmount;
import com.farm.bean.RecycleTimeData;
import com.farm.mapper.RecycleFormInfoMapper;
import com.farm.mapper.RecyclePointInfoMapper;
import com.farm.service.RecycleFormInfoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="recycleFormInfoService")
public class RecycleFormInfoServiceImpl
implements RecycleFormInfoService {
    @Resource
    private RecycleFormInfoMapper recycleFormInfoMapper;
    @Autowired
    private RecyclePointInfoMapper pointInfoMapper;

    public RecycleFormInfo queryById(Integer id) {
        return this.recycleFormInfoMapper.queryById(id);
    }

    public List<RecycleFormInfo> queryAllByLimit(int offset, int limit) {
        return this.recycleFormInfoMapper.queryAllByLimit(offset, limit);
    }

    @Transactional
    public JSONObject insert(RecycleFormInfo form) {
        RecyclePointInfo point;
        JSONObject json = new JSONObject();
        json.put("flag", (Object)0);
        if (form.getRecycleCompanyId() != null) {
            form.setStatus(Integer.valueOf(2));
            form.setStorageTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        } else {
            form.setStatus(Integer.valueOf(0));
        }
        if (form.getPointId() != null && (point = this.pointInfoMapper.queryById(form.getPointId())).getType() == 2) {
            Double glassBottle = point.getNowGlassBottle() - form.getGlassBottle();
            Double plasticBottle = point.getNowPlasticBottle() - form.getPlasticBottle();
            Double tinFoilBag = point.getNowTinFoilBag() - form.getTinFoilBag();
            Double membrane = point.getNowMembrane() - form.getMembrane();
            point.setNowGlassBottle(glassBottle);
            point.setNowPlasticBottle(plasticBottle);
            point.setNowTinFoilBag(tinFoilBag);
            point.setNowMembrane(membrane);
            this.pointInfoMapper.update(point);
        }
        if (form.getDesPointId() != null) {
            RecyclePointInfo desPoint = this.pointInfoMapper.queryById(form.getDesPointId());
            form.setRegionCode(desPoint.getRegionCode());
        }
        this.recycleFormInfoMapper.insert(form);
        return json;
    }

    @Transactional
    public RecycleFormInfo update(RecycleFormInfo form) {
        RecycleFormInfo formInfo = this.recycleFormInfoMapper.queryById(form.getId());
        if (formInfo != null && formInfo.getStatus() == 3) {
            form.setStatus(Integer.valueOf(0));
        }
        this.recycleFormInfoMapper.update(form);
        return form;
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.recycleFormInfoMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public JSONObject queryUserRecycleFormList(String userId, Integer offset, Integer pageSize, Integer status, Integer pointId) {
        Integer count = 0;
        List list = new ArrayList();
        if (StringUtils.isNotBlank((String)userId)) {
            count = this.recycleFormInfoMapper.queryRecycleFormCount(userId, status, null);
            list = this.recycleFormInfoMapper.queryRecycleFormList(userId, status, null, offset, pageSize);
        } else if (pointId != null) {
            count = this.recycleFormInfoMapper.queryRecycleFormCount(null, status, pointId);
            list = this.recycleFormInfoMapper.queryRecycleFormList(null, status, pointId, offset, pageSize);
        }
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", list);
        return json;
    }

    public JSONObject auditRecycleForm(Integer status, Integer id, String auditComment, String recycleTime, Integer desPointId) {
        JSONObject json = new JSONObject();
        RecycleFormInfo formInfo = this.recycleFormInfoMapper.queryById(id);
        if (!Objects.equals(formInfo.getDesPointId(), desPointId)) {
            throw new RuntimeException("\u7533\u62a5\u5355\u5df2\u53d8\u66f4\u7ad9\u70b9");
        }
        formInfo.setStatus(status);
        formInfo.setRecycleTime(recycleTime);
        formInfo.setAuditComment(auditComment);
        this.recycleFormInfoMapper.update(formInfo);
        return json;
    }

    public JSONObject queryPointRecycleFormList(Integer offset, Integer pageSize, Integer status, Integer pointId) {
        Integer count = this.recycleFormInfoMapper.queryPointRecycleFormCount(status, pointId);
        List list = this.recycleFormInfoMapper.queryPointRecycleFormList(status, pointId, offset, pageSize);
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public List<RecycleFormInfo> selectFormListByYearsAndPointIdList(List<Integer> desPointIdList, List<String> timeList) {
        return this.recycleFormInfoMapper.selectFormListByYearsAndPointIdList(desPointIdList, timeList);
    }

    public List<RecycleFormInfo> selectFormListByMonthAndYearsAndPointIdList(List<Integer> desPointIdList, List<RecycleTimeData> recycleTimeDataList) {
        return this.recycleFormInfoMapper.selectFormListByMonthAndYearsAndPointIdList(desPointIdList, recycleTimeDataList);
    }

    public void submitWareHouse(Integer id, String remarks) {
        Double membrane;
        Double tinFoilBag;
        Double plasticBottle;
        Double glassBottle;
        RecycleFormInfo formInfo = this.recycleFormInfoMapper.queryById(id);
        if (formInfo.getPointId() != null) {
            RecyclePointInfo point = this.pointInfoMapper.queryById(formInfo.getPointId());
            glassBottle = point.getNowGlassBottle() - formInfo.getGlassBottle();
            plasticBottle = point.getNowPlasticBottle() - formInfo.getPlasticBottle();
            tinFoilBag = point.getNowTinFoilBag() - formInfo.getTinFoilBag();
            membrane = point.getNowMembrane() - formInfo.getMembrane();
            point.setNowGlassBottle(glassBottle);
            point.setNowPlasticBottle(plasticBottle);
            point.setNowTinFoilBag(tinFoilBag);
            point.setNowMembrane(membrane);
            this.pointInfoMapper.update(point);
        }
        if (formInfo.getDesPointId() != null) {
            RecyclePointInfo point1 = this.pointInfoMapper.queryById(formInfo.getDesPointId());
            glassBottle = point1.getNowGlassBottle() + formInfo.getGlassBottle();
            plasticBottle = point1.getNowPlasticBottle() + formInfo.getPlasticBottle();
            tinFoilBag = point1.getNowTinFoilBag() + formInfo.getTinFoilBag();
            membrane = point1.getNowMembrane() + formInfo.getMembrane();
            point1.setNowGlassBottle(glassBottle);
            point1.setNowPlasticBottle(plasticBottle);
            point1.setNowTinFoilBag(tinFoilBag);
            point1.setNowMembrane(membrane);
            this.pointInfoMapper.update(point1);
        }
        this.recycleFormInfoMapper.submitWareHouse(id, remarks);
    }

    public List<RecycleSummaryStorageAmount> queryFormListByMonthTimeAndPointId(List<Integer> desPointIdList, List<String> timeList, Integer type) {
        return this.recycleFormInfoMapper.queryFormListByMonthTimeAndPointId(desPointIdList, timeList, type);
    }

    public List<RecycleSummaryStorageAmount> queryFormListByYearTimeAndPointId(List<Integer> desPointIdList, List<String> timeList, Integer type) {
        return this.recycleFormInfoMapper.queryFormListByYearTimeAndPointId(desPointIdList, timeList, type);
    }

    public List<RecycleLitterInfo> selectFormListByDesPointIdListAndStatus(List<Integer> recyclePointIdList, int status) {
        return this.recycleFormInfoMapper.selectFormListByDesPointIdListAndStatus(recyclePointIdList, status);
    }

    public RecycleLitterInfo selectRecycleLitterByDesPointIdAndStatus(Integer pointId, int status, String startTime, String endTime) {
        return this.recycleFormInfoMapper.selectRecycleLitterByDesPointIdAndStatus(pointId, status, startTime, endTime);
    }

    public RecycleLitterInfo selectFormListByPointIdAndNoReject(Integer pointId, String startTime, String endTime) {
        return this.recycleFormInfoMapper.selectFormListByPointIdAndNoReject(pointId, startTime, endTime);
    }
}

