/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.RecycleLitterInfo;
import com.farm.bean.RecyclePointInfo;
import com.farm.bean.RecyclePointSummaryData;
import com.farm.bean.RecycleStatistics;
import com.farm.bean.RecycleSummaryRealTimeData;
import com.farm.bean.RecycleTown;
import com.farm.mapper.RecyclePointInfoMapper;
import com.farm.service.ProductManageService;
import com.farm.service.RecycleFormInfoService;
import com.farm.service.RecycleLitterAttritionRateService;
import com.farm.service.RecyclePointInfoService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="recyclePointInfoService")
public class RecyclePointInfoServiceImpl
implements RecyclePointInfoService {
    @Resource
    private RecyclePointInfoMapper recyclePointInfoMapper;
    @Autowired
    private RecycleFormInfoService recycleFormInfoService;
    @Autowired
    private RecycleLitterAttritionRateService recycleLitterAttritionRateService;
    @Autowired
    private ProductManageService productManageService;

    public RecyclePointInfo queryById(Integer id) {
        return this.recyclePointInfoMapper.queryById(id);
    }

    public List<RecyclePointInfo> queryAllByLimit(int offset, int limit) {
        return this.recyclePointInfoMapper.queryAllByLimit(offset, limit);
    }

    public RecyclePointInfo insert(RecyclePointInfo recyclePointInfo) {
        String regionCode = this.productManageService.queryRegionCodeInArea(recyclePointInfo.getXaxis(), recyclePointInfo.getYaxis());
        recyclePointInfo.setRegionCode(regionCode);
        this.recyclePointInfoMapper.insert(recyclePointInfo);
        return recyclePointInfo;
    }

    public RecyclePointInfo update(RecyclePointInfo recyclePointInfo) {
        String regionCode = this.productManageService.queryRegionCodeInArea(recyclePointInfo.getXaxis(), recyclePointInfo.getYaxis());
        recyclePointInfo.setRegionCode(regionCode);
        this.recyclePointInfoMapper.update(recyclePointInfo);
        return this.queryById(recyclePointInfo.getId());
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.recyclePointInfoMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public JSONObject queryNearRecycleList(Double lng, Double lat, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        typeList.add(0);
        typeList.add(1);
        typeList.add(2);
        List list = this.recyclePointInfoMapper.queryNearRecycleList(lng, lat, start, pageSize, typeList);
        Integer count = this.recyclePointInfoMapper.queryCount(typeList);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryRecycleCompanyList(Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        List list = this.recyclePointInfoMapper.queryRecycleCompanyList(start, pageSize);
        Integer count = this.recyclePointInfoMapper.queryRecycleCompanyCount();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public RecyclePointInfo queryByUserId(String userId) {
        RecyclePointInfo dto = new RecyclePointInfo();
        dto.setUserId(userId);
        List list = this.recyclePointInfoMapper.queryAll(dto);
        if (list != null && list.size() > 0) {
            dto = (RecyclePointInfo)list.get(0);
        }
        return dto;
    }

    public JSONObject queryRecyclePointListByType(List<String> types, String name, Integer start, Integer pageSize) {
        Integer count = this.recyclePointInfoMapper.queryRecyclePointCountByType(types, name);
        List recyclePointInfoList = this.recyclePointInfoMapper.queryRecyclePointListByTypeAndPage(types, name, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)recyclePointInfoList);
        return jsonObject;
    }

    public JSONObject queryAmountByType(String regionCode) {
        return null;
    }

    public JSONObject queryPointsByType(String regionCode, Integer offset, Integer limit) {
        JSONObject json = new JSONObject();
        Integer count = this.recyclePointInfoMapper.queryPointCount(regionCode);
        List list = this.recyclePointInfoMapper.queryPointList(regionCode, offset, limit);
        List typeList = this.recyclePointInfoMapper.queryPointCountsByType(regionCode);
        JSONArray jsonArray = new JSONArray();
        json.put("typeCount", (Object)typeList);
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject selectSummaryRealTimeData(List<String> pointIdList, List<String> regionCodeList, Integer type, Integer start, Integer pageSize) {
        Integer count = this.recyclePointInfoMapper.selectPointList(pointIdList, regionCodeList, type).size();
        List recyclePointInfoPage = this.recyclePointInfoMapper.selectPointByPage(pointIdList, regionCodeList, type, start, pageSize);
        List recyclePointIdList = recyclePointInfoPage.stream().map(RecyclePointInfo::getId).collect(Collectors.toList());
        List recycleLitterInfoList = this.recycleFormInfoService.selectFormListByDesPointIdListAndStatus(recyclePointIdList, 1);
        ArrayList recycleSummaryRealTimeDataList = new ArrayList();
        recyclePointInfoPage.forEach(recyclePointInfo -> {
            List collect = recycleLitterInfoList.stream().filter(recycleFormInfo -> recycleFormInfo.getPointId().equals(recyclePointInfo.getId())).collect(Collectors.toList());
            recycleSummaryRealTimeDataList.add(new RecycleSummaryRealTimeData(recyclePointInfo.getId(), collect.size() > 0 ? (RecycleLitterInfo)collect.get(0) : null, recyclePointInfo));
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", recycleSummaryRealTimeDataList);
        return jsonObject;
    }

    public RecyclePointSummaryData selectPointSummaryDataByPointId(Integer pointId, String startTime, String endTime) {
        RecyclePointInfo recyclePointInfo = this.recyclePointInfoMapper.selectPointById(pointId);
        List recycleLitterAttritionRateList = this.recycleLitterAttritionRateService.selectRecycleLitterAttritionRateList(pointId);
        RecycleLitterInfo toCollectRecycleLitterInfo = this.recycleFormInfoService.selectRecycleLitterByDesPointIdAndStatus(pointId, 1, null, null);
        RecycleLitterInfo collectedRecycleLitterInfo = this.recycleFormInfoService.selectRecycleLitterByDesPointIdAndStatus(pointId, 2, startTime, endTime);
        RecycleLitterInfo outRecycleLitterInfo = this.recycleFormInfoService.selectFormListByPointIdAndNoReject(pointId, startTime, endTime);
        String format = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        RecycleLitterInfo stockLitterInfo = endTime != null && !endTime.equals("") && !endTime.equals(format) ? this.recyclePointInfoMapper.queryStatisticsPointInfo(pointId, endTime) : this.recyclePointInfoMapper.queryStatisticsPointInfoByPointId(pointId);
        return new RecyclePointSummaryData(recyclePointInfo, recycleLitterAttritionRateList, toCollectRecycleLitterInfo, collectedRecycleLitterInfo, outRecycleLitterInfo, stockLitterInfo);
    }

    public JSONObject selectSummaryStorageAmountData(List<String> pointIdList, List<String> regionCodeList, Integer type, Integer timeType, List<String> timeList, Integer start, Integer pageSize) {
        List desPointIdList = this.recyclePointInfoMapper.selectPointList(pointIdList, regionCodeList, type);
        List recycleSummaryStorageAmountList = new ArrayList();
        if (desPointIdList.size() > 0) {
            recycleSummaryStorageAmountList = timeType == 1 ? this.recycleFormInfoService.queryFormListByMonthTimeAndPointId(desPointIdList, timeList, type) : this.recycleFormInfoService.queryFormListByYearTimeAndPointId(desPointIdList, timeList, type);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)recycleSummaryStorageAmountList.size());
        jsonObject.put("list", recycleSummaryStorageAmountList);
        return jsonObject;
    }

    public List<RecycleTown> queryRecycleTown() {
        return this.recyclePointInfoMapper.queryRecycleTown();
    }

    public void upsertRecycleTown(List<RecycleTown> recycleTownList) {
        recycleTownList.forEach(recycleTown -> {
            if (recycleTown.getId() == null) {
                this.recyclePointInfoMapper.insertRecycleTown(recycleTown);
            } else {
                this.recyclePointInfoMapper.updateRecycleTown(recycleTown);
            }
        });
    }

    public RecycleStatistics queryRecycleStatistics() {
        return this.recyclePointInfoMapper.queryRecycleStatistics();
    }

    public void upsertRecycleStatistics(RecycleStatistics recycleStatistics) {
        if (recycleStatistics.getId() == null) {
            this.recyclePointInfoMapper.insertRecycleStatistics(recycleStatistics);
        } else {
            this.recyclePointInfoMapper.updateRecycleStatistics(recycleStatistics);
        }
    }
}

