/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DpChildrenDataInfo;
import com.farm.bean.DpDataInfo;
import com.farm.bean.HSLYInfo;
import com.farm.bean.RecycleRecordInfo;
import com.farm.bean.Warning;
import com.farm.mapper.RecycleRecordInfoMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.RecycleRecordInfoService;
import com.farm.util.ResultVo;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecycleRecordInfoServiceImpl
implements RecycleRecordInfoService {
    @Autowired
    private RecycleRecordInfoMapper recycleRecordInfoMapper;
    @Autowired
    private WarningMapper warningMapper;

    @Transactional
    public ResultVo upsertRecycleRecord(RecycleRecordInfo info) {
        if (Objects.isNull(info.getId())) {
            info.setRecycleCode(System.currentTimeMillis() + "");
            this.recycleRecordInfoMapper.insert(info);
            List collect = Stream.of(info).map(o -> {
                HSLYInfo hslyInfo = new HSLYInfo();
                hslyInfo.setL(o.getRecycleOrigin());
                Integer category = o.getRecycleCategory();
                if (!Objects.isNull(category)) {
                    hslyInfo.setJ(category == 1 ? "\u5851\u6599\u74f6" : (category == 2 ? "\u9521\u7b94\u888b" : (category == 3 ? "\u73bb\u7483\u74f6" : "\u5730\u819c")));
                }
                hslyInfo.setH(o.getNum());
                hslyInfo.setTime(o.getRecycleTime());
                return hslyInfo;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect) && collect.size() > 0) {
                Integer id;
                DpChildrenDataInfo dateInfo = new DpChildrenDataInfo();
                dateInfo.setUuId(UUID.randomUUID().toString().replace("-", ""));
                dateInfo.setData(JSONObject.toJSONString(collect.get(0)));
                if (!Objects.isNull(((HSLYInfo)collect.get(0)).getTime()) && StringUtils.isNotBlank((CharSequence)((HSLYInfo)collect.get(0)).getTime())) {
                    dateInfo.setTime(((HSLYInfo)collect.get(0)).getTime());
                }
                if (Objects.isNull(id = this.recycleRecordInfoMapper.judgeCode(Integer.valueOf("60001")))) {
                    DpDataInfo data = new DpDataInfo();
                    data.setTypeCode(Integer.valueOf("60001"));
                    data.setData(CollectionUtils.isNotEmpty(collect) && collect.size() > 0 ? JSONObject.toJSONString(collect.get(0)) : "");
                    Integer dateId = this.recycleRecordInfoMapper.insertData(data);
                    dateInfo.setParentId(dateId);
                } else {
                    dateInfo.setParentId(id);
                }
                Integer relId = this.recycleRecordInfoMapper.insertList(dateInfo);
                List hList = this.warningMapper.queryListAllWarning("60001");
                List cList = this.warningMapper.queryListAllWarning("60002");
                double hSum = this.getSum(hList);
                double cSum = this.getSum(cList);
                if (hSum - cSum >= 50.0) {
                    Warning warning = new Warning();
                    warning.setStatus(Integer.valueOf(-1));
                    warning.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                    warning.setLeader("\u90d1\u7490\u83b9");
                    warning.setWarningDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    warning.setWarningType(Integer.valueOf(0));
                    warning.setContent("\u5e93\u5bb9\u91cf\u226550KG");
                    warning.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    warning.setModule(Integer.valueOf(7));
                    warning.setRule(Integer.valueOf(1));
                    this.warningMapper.batchInsert(Arrays.asList(warning));
                }
            }
            return ResultVo.success((Object)"\u65b0\u589e\u6210\u529f");
        }
        this.recycleRecordInfoMapper.update(info);
        return ResultVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    private double getSum(List<String> list) {
        double sum = 0.0;
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0) {
            for (String s : list) {
                double h = Double.parseDouble(JSONObject.parseObject((String)s).get((Object)"h") + "");
                sum += h;
            }
        }
        return sum;
    }

    public ResultVo readAll(Integer recycleOrigin, Integer recycleCategory, String startTime, String endTime) {
        List list = this.recycleRecordInfoMapper.readAll(recycleOrigin, recycleCategory, startTime, endTime);
        return ResultVo.success((Object)list);
    }
}

