/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriserveLandlord;
import com.farm.bean.AgriserveMachine;
import com.farm.bean.resultMap.ProductMechineResultMap;
import com.farm.bean.resultMap.ShopInfoResultMap;
import com.farm.bean.resultMap.ShopProductResultMap;
import com.farm.bean.resultMap.UseAddInfoResultMap;
import com.farm.mapper.AgriserveLandlordMapper;
import com.farm.mapper.ServeMapper;
import com.farm.service.ProductManageService;
import com.farm.service.ServeService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="serveService")
public class ServeServiceImpl
implements ServeService {
    @Autowired
    private ServeMapper serveMapper;
    @Value(value="${lyt.governUrl}")
    private String lytGovernUrl;
    @Autowired
    private AgriserveLandlordMapper agriserveLandlordMapper;
    @Autowired
    private ProductManageService productManageService;

    public ResultVo queryUserShopInfo(String phone) {
        JSONObject json = new JSONObject();
        List useAddInfoResultMaps = this.serveMapper.queryUserAddInfoByPhone(phone);
        UseAddInfoResultMap uai = null;
        for (UseAddInfoResultMap resultMap : useAddInfoResultMaps) {
            if (resultMap.getType() != 1) continue;
            uai = resultMap;
        }
        if (uai == null || uai.getType() != 1) {
            return ResultVo.error((String)"\u7528\u6237\u4e0d\u5c5e\u4e8e\u5408\u4f5c\u793e\uff0c\u65e0\u6743\u9650");
        }
        ShopInfoResultMap shopInfo = this.serveMapper.queryShopInfoByPhone(phone);
        if (shopInfo != null) {
            json.put("shopInfo", (Object)shopInfo);
        }
        return ResultVo.success((Object)json);
    }

    public JSONObject queryShopProductList(Integer shopId, String productType, Integer begin, Integer pageSize) {
        List<Object> typeList = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)productType)) {
            typeList = Arrays.asList(productType.split(","));
        }
        Integer count = this.serveMapper.queryShopProductListCount(shopId, typeList);
        List list = this.serveMapper.queryShopProductList(shopId, typeList, begin, pageSize);
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public void addOrUpdateProduct(ShopProductResultMap product) {
        if (product.getId() == null) {
            this.serveMapper.addProduct(product);
        } else {
            this.serveMapper.updateProduct(product);
            this.serveMapper.delProdcutType(product.getId());
        }
        List<String> list = Arrays.asList(product.getShopProductType().split(","));
        this.serveMapper.addProductType(list, product.getId());
    }

    public ResultVo addOrUpdateShopInfo(ShopInfoResultMap shopInfo) {
        List useAddInfoResultMaps = this.serveMapper.queryUserAddInfoByPhone(shopInfo.getPhone());
        UseAddInfoResultMap uai = null;
        for (UseAddInfoResultMap resultMap : useAddInfoResultMaps) {
            if (resultMap.getType() != 1) continue;
            uai = resultMap;
        }
        if (uai == null || uai.getType() != 1) {
            return ResultVo.error((String)"\u7528\u6237\u4e0d\u5c5e\u4e8e\u5408\u4f5c\u793e\uff0c\u65e0\u6743\u9650");
        }
        if (shopInfo.getId() == null) {
            this.serveMapper.addShopInfo(shopInfo);
        } else {
            this.serveMapper.updateShopInfo(shopInfo);
        }
        return ResultVo.success();
    }

    public void delProduct(Integer shopId, String productId) {
        List<String> list = Arrays.asList(productId.split(","));
        this.serveMapper.delProduct(shopId, list);
    }

    public Object queryMatchingShop(String types, String xAxis, String yAxis) {
        List<String> typeList = Arrays.asList(types.split(","));
        Integer pageSize = 10;
        List list = this.serveMapper.queryMatchingShop(typeList, pageSize, xAxis, yAxis);
        for (ShopInfoResultMap s : list) {
            String productType = this.serveMapper.queryProductTypeByShopId(s.getId());
            s.setProductType(productType);
        }
        return ResultVo.success((Object)list);
    }

    public Object sendShopMsg(String shopIds, String sendUserPhone, String cropSubId, String productType) {
        List<String> list = Arrays.asList(shopIds.split(","));
        this.serveMapper.insertShopMsg(sendUserPhone, list, cropSubId, productType);
        try {
            List phoneList = this.serveMapper.queryShopPhoneListByIds(list);
            String toPhones = String.join((CharSequence)",", phoneList);
            StringBuffer paramMap = new StringBuffer(this.lytGovernUrl + "/farm_lyt/notice/push");
            paramMap.append("?content=\u624b\u673a\u5c3e\u53f7\u4e3a").append(sendUserPhone.substring(7, 11)).append("\u7684\u7528\u6237\u53d1\u5e03\u519c\u673a\u65b0\u9700\u6c42\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\uff01").append("&resourceUrl=").append(this.lytGovernUrl + "/farm_lyt/#").append("&title=\u519c\u673a\u65b0\u9700\u6c42\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b").append("&mobiles=" + toPhones);
            HttpSendUtil.sendHttpGet((String)paramMap.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResultVo.success();
    }

    public JSONObject queryShopProductListByPhone(String phone, String productType, Integer begin, Integer pageSize) {
        List<Object> typeList = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)productType)) {
            typeList = Arrays.asList(productType.split(","));
        }
        Integer count = this.serveMapper.queryShopProductListByPhoneCount(phone, typeList);
        List list = this.serveMapper.queryShopProductListByPhone(phone, typeList, begin, pageSize);
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryShopMsgList(String phone, Integer begin, Integer pageSize) {
        List list = this.serveMapper.queryShopMsgList(phone, begin, pageSize);
        Integer count = this.serveMapper.queryShopMsgListCount(phone);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void updateShopMsg(String phone, Integer id, Integer status) {
        this.serveMapper.updateShopMsgStatus(phone, id, status);
    }

    public void updateShopAndProduct(String phone) {
        List list = this.serveMapper.queryAllMachine();
        ArrayList<ProductMechineResultMap> dataList = new ArrayList<ProductMechineResultMap>();
        for (AgriserveMachine a : list) {
            ProductMechineResultMap p = new ProductMechineResultMap();
            p.setPhone(a.getPhone());
            p.setMachineId(a.getId());
            if (a.getType() == 0) {
                p.setPrice("100");
                p.setPriceUnit("\u5143/\u4ea9");
                p.setTitle("\u62d6\u62c9\u673a");
            } else if (a.getType() == 1) {
                p.setPrice("60");
                p.setPriceUnit("\u5143/\u4ea9");
                p.setTitle("\u63d2\u79e7\u673a");
            } else if (a.getType() == 2) {
                p.setPrice("70");
                p.setPriceUnit("\u5143/\u4ea9");
                p.setTitle("\u6536\u5272\u673a");
            } else if (a.getType() == 3) {
                p.setPrice("60");
                p.setPriceUnit("\u5143/\u4ea9");
                p.setTitle("\u70d8\u5e72\u673a");
            } else if (a.getType() == 4) {
                p.setPrice("10");
                p.setPriceUnit("\u5143/\u4ea9");
                p.setTitle("\u65e0\u4eba\u673a");
            }
            dataList.add(p);
        }
        if (dataList.size() > 0) {
            this.serveMapper.insertShopProductList(dataList);
        }
    }

    public JSONObject queryShopList(String search, Integer offset, Integer limit) {
        JSONObject json = new JSONObject();
        List list = this.serveMapper.queryShopList(search, offset, limit);
        Integer count = this.serveMapper.queryShopCount(search);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void delShop(List<Integer> idList) {
        this.serveMapper.delShopById(idList);
        this.serveMapper.delShopProductType(idList);
        this.serveMapper.delShopProduct(idList);
    }

    public ShopInfoResultMap addOrUpdateShop(ShopInfoResultMap shopInfo) {
        if (shopInfo.getId() == null) {
            AgriserveLandlord agriserveLandlord = new AgriserveLandlord();
            agriserveLandlord.setLng(Double.valueOf(shopInfo.getxAxis()));
            agriserveLandlord.setLat(Double.valueOf(shopInfo.getyAxis()));
            agriserveLandlord.setAddress(shopInfo.getAddress());
            agriserveLandlord.setPhone(shopInfo.getPhone());
            agriserveLandlord.setName(shopInfo.getShopkeeper());
            String regionCode = this.productManageService.queryRegionCodeInArea(agriserveLandlord.getLng(), agriserveLandlord.getLat());
            agriserveLandlord.setRegionCode(regionCode);
            this.agriserveLandlordMapper.insert(agriserveLandlord);
            this.serveMapper.addShopInfo(shopInfo);
        } else {
            this.serveMapper.updateShopInfo(shopInfo);
        }
        return shopInfo;
    }
}

