/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.resultMap.StatisticsYieldResultMap;
import com.farm.mapper.RecycleFormInfoMapper;
import com.farm.mapper.StatisticsMapper;
import com.farm.mapper.SubsidyFormInfoMapper;
import com.farm.mapper.TransferLandInfoMapper;
import com.farm.service.ConfigService;
import com.farm.service.StatisticsService;
import java.text.DecimalFormat;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="statisticsService")
public class StatisticsServiceImpl
implements StatisticsService {
    @Autowired
    private StatisticsMapper statisticsMapper;
    @Autowired
    private SubsidyFormInfoMapper subsidyFormInfoMapper;
    @Autowired
    private TransferLandInfoMapper transferLandInfoMapper;
    @Autowired
    private RecycleFormInfoMapper recycleFormInfoMapper;
    @Autowired
    private ConfigService configService;

    public JSONObject queryStatisticsArea(Integer year, Integer cropSubId, String regionCode) {
        List list = this.statisticsMapper.queryStatisticsArea(year, cropSubId, regionCode, Integer.valueOf(regionCode.length() + 3));
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsPlantMode(Integer year) {
        List list = this.statisticsMapper.queryStatisticsPlantMode(year);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsYield(Integer cropSubId, Integer begin, Integer pageSize) {
        Integer count = this.statisticsMapper.queryStatisticsYieldCount(cropSubId);
        List list = this.statisticsMapper.queryStatisticsYieldListCount(cropSubId, begin, pageSize);
        for (StatisticsYieldResultMap s : list) {
            s.setYield(new DecimalFormat("#.00").format(Double.valueOf(s.getYield())));
        }
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryStatisticsFertilizer(Integer year) {
        List list = this.statisticsMapper.queryStatisticsFertilizer(year);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsFertilizerUsed() {
        List list = this.statisticsMapper.queryStatisticsFertilizerUsed();
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsInsect(Integer year) {
        List list = this.statisticsMapper.queryStatisticsInsect(year);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsUserGroup() {
        Integer landlordCount = this.statisticsMapper.queryLandLordCount();
        Integer userCount = this.statisticsMapper.queryUserCount();
        JSONObject json = new JSONObject();
        json.put("landlordCount", (Object)landlordCount);
        json.put("userCount", (Object)userCount);
        return json;
    }

    public JSONObject querySystematicResearch() {
        List list = this.statisticsMapper.querySystematicResearch();
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsFieldMemo(Integer cropSubId) {
        List list = this.statisticsMapper.queryStatisticsFieldMemo(cropSubId);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryStatisticsZzdHome(String regionCode) {
        JSONObject json = new JSONObject();
        Double fixedArea = this.statisticsMapper.queryDsArea(regionCode);
        Double transferLandArea = this.transferLandInfoMapper.queryTransferLandArea(regionCode);
        Double subsidyAmount = this.subsidyFormInfoMapper.querySubsidyYearAmount(regionCode);
        Integer subsidyCount = this.subsidyFormInfoMapper.querySubsidyYearCount(regionCode);
        Double recycleAmount = this.recycleFormInfoMapper.queryRecycleAmount(regionCode);
        Double dealAmount = this.recycleFormInfoMapper.queryRecycleDealAmount(regionCode);
        json.put("fixedArea", (Object)fixedArea);
        json.put("transferLandArea", (Object)transferLandArea);
        json.put("subsidyAmount", (Object)String.format("%.2f", subsidyAmount));
        json.put("subsidyCount", (Object)subsidyCount);
        json.put("recycleAmount", (Object)recycleAmount);
        json.put("dealAmount", (Object)dealAmount);
        return json;
    }

    public JSONObject queryPlantModeArea(Integer year, String regionCode) {
        List list = this.statisticsMapper.queryPlantModeArea(year, regionCode, Integer.valueOf(regionCode.length()));
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }
}

