/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.Company;
import com.farm.bean.FieldDoubleStatus;
import com.farm.bean.LytUser;
import com.farm.bean.SubsidyAmountSummary;
import com.farm.bean.SubsidyCompanyExport;
import com.farm.bean.SubsidyFertilizerExport;
import com.farm.bean.SubsidyFormAgrimachine;
import com.farm.bean.SubsidyFormBusiness;
import com.farm.bean.SubsidyFormFarmer;
import com.farm.bean.SubsidyFormField;
import com.farm.bean.SubsidyFormInfo;
import com.farm.bean.SubsidyFormInfoExport;
import com.farm.bean.SubsidyFormMachineExport;
import com.farm.bean.SubsidyFormProtect;
import com.farm.bean.SubsidyFormProtectHistory;
import com.farm.bean.SubsidyImportDto;
import com.farm.bean.SubsidyMapData;
import com.farm.bean.SubsidyProject;
import com.farm.bean.SubsidyReportFertilizer;
import com.farm.bean.SubsidyReportYear;
import com.farm.bean.SubsidySummaryYear;
import com.farm.bean.SubsidyYearExport;
import com.farm.bean.resultMap.FieldResultMap;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.SubsidyAmountSummaryMapper;
import com.farm.mapper.SubsidyFormInfoMapper;
import com.farm.mapper.SubsidyReportFertilizerMapper;
import com.farm.mapper.SubsidyReportYearMapper;
import com.farm.service.CompanyService;
import com.farm.service.SubsidyFormAgrimachineService;
import com.farm.service.SubsidyFormBusinessService;
import com.farm.service.SubsidyFormFarmerService;
import com.farm.service.SubsidyFormFieldService;
import com.farm.service.SubsidyFormInfoService;
import com.farm.service.SubsidyFormProtectService;
import com.farm.service.SubsidyProjectService;
import com.farm.service.UserCenterService;
import com.farm.util.EasyExcelUtil;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="subsidyFormInfoService")
public class SubsidyFormInfoServiceImpl
implements SubsidyFormInfoService {
    @Resource
    private SubsidyFormInfoMapper subsidyFormInfoMapper;
    @Autowired
    private SubsidyFormFarmerService formFarmerService;
    @Autowired
    private SubsidyFormBusinessService formBusinessService;
    @Autowired
    private SubsidyFormAgrimachineService formAgrimachineService;
    @Autowired
    private SubsidyFormFieldService formFieldService;
    @Autowired
    private SubsidyFormProtectService subsidyFormProtectService;
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private SubsidyProjectService subsidyProjectService;
    @Autowired
    private SubsidyReportYearMapper subsidyReportYearMapper;
    @Autowired
    private SubsidyReportFertilizerMapper subsidyReportFertilizerMapper;
    @Autowired
    private SubsidyAmountSummaryMapper amountSummaryMapper;
    @Autowired
    private SubsidyAmountSummaryMapper subsidyAmountSummaryMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Value(value="${farm.datasync}")
    private String datasyncUrl;

    public SubsidyFormInfo queryById(Integer id) {
        SubsidyFormInfo formInfo = this.subsidyFormInfoMapper.queryById(id);
        if (formInfo == null) {
            return null;
        }
        Integer relateId = formInfo.getRelateId();
        String userId = formInfo.getUserId();
        formInfo.setUserCenter(this.userCenterService.queryUserInfoByUserId(userId));
        formInfo.setSubsidyProject(this.subsidyProjectService.queryById(formInfo.getProjectId()));
        formInfo.setSubsidyAuditLogList(this.subsidyFormInfoMapper.queryAuditLogListByInfoId(id));
        switch (formInfo.getType()) {
            case 0: {
                formInfo.setFormField(this.formFieldService.queryById(relateId));
                Double area = this.subsidyFormInfoMapper.queryFieldsAreaByFormId(relateId);
                if (area == null) break;
                formInfo.setFieldArea(area);
                break;
            }
            case 1: {
                formInfo.setFormProtect(this.subsidyFormProtectService.queryById(relateId));
                break;
            }
            case 2: {
                formInfo.setFormFarmer(this.formFarmerService.queryById(relateId));
                break;
            }
            case 3: {
                formInfo.setFormBusiness(this.formBusinessService.queryById(relateId));
                formInfo.setCompany(this.companyService.queryCompanyInfoByCompanyId(null, userId));
                break;
            }
            case 4: {
                formInfo.setFormAgrimachine(this.formAgrimachineService.queryById(relateId));
                break;
            }
            case 5: {
                formInfo.setReportYear(this.subsidyReportYearMapper.querySubsidyReportYearById(relateId));
                formInfo.setCompany(this.companyService.queryCompanyInfoByCompanyId(null, userId));
                break;
            }
            case 6: {
                formInfo.setReportFertilizer(this.subsidyReportFertilizerMapper.querySubsidyReportFertilizerById(relateId));
                formInfo.setCompany(this.companyService.queryCompanyInfoByCompanyId(null, userId));
                break;
            }
        }
        return formInfo;
    }

    public JSONObject queryFieldListByFormId(Integer id, Integer offset, Integer pageSize) {
        JSONObject json = new JSONObject();
        SubsidyFormInfo formInfo = this.subsidyFormInfoMapper.queryById(id);
        List list = null;
        Integer count = null;
        if (formInfo != null && formInfo.getRelateId() != null) {
            list = this.subsidyFormInfoMapper.queryFieldsByFormId(formInfo.getRelateId(), offset, pageSize);
            count = this.subsidyFormInfoMapper.queryFieldsByFormIdCount(count);
        }
        json.put("list", list);
        json.put("count", count);
        return json;
    }

    public SubsidyFormInfo insert(SubsidyFormInfo subsidyFormInfo) {
        this.subsidyFormInfoMapper.insert(subsidyFormInfo);
        return subsidyFormInfo;
    }

    public SubsidyFormInfo update(SubsidyFormInfo subsidyFormInfo) {
        this.subsidyFormInfoMapper.update(subsidyFormInfo);
        return this.queryById(subsidyFormInfo.getId());
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.subsidyFormInfoMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public JSONObject queryUserFormList(String userId, String phone, Integer status, Integer offset, Integer pageSize) {
        JSONObject json = new JSONObject();
        ArrayList list = new ArrayList();
        List subsidyFormProtectList = this.subsidyFormProtectService.queryList(status);
        subsidyFormProtectList.forEach(subsidyFormProtect -> {
            List userIdList = this.subsidyFormProtectService.queryUserIdByFormProtectId(subsidyFormProtect.getId());
            if (userIdList.contains(userId)) {
                SubsidyFormInfo subsidyFormInfo = this.subsidyFormInfoMapper.queryFormInfoByRelateId(subsidyFormProtect.getId());
                list.add(subsidyFormInfo);
            }
        });
        List subsidyFormInfoList = this.subsidyFormInfoMapper.queryUserFormList(userId, phone, status);
        list.addAll(subsidyFormInfoList);
        list.forEach(item -> {
            if (item.getType() == 0) {
                SubsidyFormField subsidyFormField = this.formFieldService.queryById(item.getRelateId());
                item.setCropId(subsidyFormField == null ? null : subsidyFormField.getCropId());
            }
        });
        json.put("list", list.stream().sorted(Comparator.comparing(SubsidyFormInfo::getCreateTime).reversed()).skip(offset.intValue()).limit(pageSize.intValue()).collect(Collectors.toList()));
        return json;
    }

    public JSONObject queryPublicList(Integer status, Integer offset, Integer pageSize, String search, List<String> projectIdList, String startDate, String endDate) {
        JSONObject json = new JSONObject();
        List list = this.subsidyFormInfoMapper.queryPublicList(offset, pageSize, status, search, projectIdList, startDate, endDate);
        list.forEach(item -> {
            if (item.getType() == 0) {
                SubsidyFormField subsidyFormField = this.formFieldService.queryById(item.getRelateId());
                item.setCropId(subsidyFormField == null ? null : subsidyFormField.getCropId());
            }
        });
        Integer count = this.subsidyFormInfoMapper.queryPublicCount(status, search, projectIdList, startDate, endDate);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryAuditList(Integer status, Integer type, Integer offset, Integer limit, String roleId, String search, List<String> regionCodeList, List<String> projectIdList, String userMnRegCode) {
        List<Object> list = new ArrayList();
        Integer count = 0;
        if (type != 0 || !Objects.equals(roleId, "605")) {
            userMnRegCode = null;
        }
        if (StringUtils.isBlank((String)roleId)) {
            if (type != 1) {
                list = this.subsidyFormInfoMapper.queryAuditList(offset, limit, status, type, search, regionCodeList, projectIdList);
                count = this.subsidyFormInfoMapper.queryAuditCount(status, type, search, regionCodeList, projectIdList);
            } else {
                list = this.subsidyFormInfoMapper.queryProtectAuditList(status, null, regionCodeList, projectIdList);
            }
        } else if ((type == 0 || type == 1) && (Objects.equals(roleId, "605") || Objects.equals(roleId, "606"))) {
            Integer segStatus = null;
            if (Objects.equals(roleId, "605")) {
                segStatus = status == 0 ? Integer.valueOf(0) : (status == 1 ? Integer.valueOf(2) : (status == 2 ? Integer.valueOf(1) : null));
            } else if (Objects.equals(roleId, "606")) {
                segStatus = status == 0 ? Integer.valueOf(0) : (status == 1 ? Integer.valueOf(2) : (status == 2 ? Integer.valueOf(2) : null));
            }
            if (type == 0) {
                list = this.subsidyFormInfoMapper.queryFieldFormAuditList(offset, limit, status, type, segStatus, search, userMnRegCode);
                count = this.subsidyFormInfoMapper.queryFieldFormAuditCount(status, type, segStatus, search, userMnRegCode);
            } else {
                list = this.subsidyFormInfoMapper.queryProtectAuditList(status, segStatus, regionCodeList, projectIdList);
            }
        } else if (Objects.equals(roleId, "607") && (type == 2 || type == 3) || Objects.equals(roleId, "608") && type == 4) {
            list = this.subsidyFormInfoMapper.queryAuditList(offset, limit, status, type, search, regionCodeList, projectIdList);
            count = this.subsidyFormInfoMapper.queryAuditCount(status, type, search, regionCodeList, projectIdList);
        }
        if (type == 1) {
            list.forEach(subsidyFormInfo -> {
                List userNameList = this.subsidyFormInfoMapper.queryUserNameList(subsidyFormInfo.getRelateId());
                subsidyFormInfo.setUserNameList(userNameList);
                String temp = userNameList.size() > 0 ? (String)userNameList.get(0) + "..." : (StringUtils.isNotBlank((String)subsidyFormInfo.getUserName()) ? subsidyFormInfo.getUserName() + "..." : "");
                subsidyFormInfo.setUserName(temp);
            });
            if (StringUtils.isNotBlank((String)search)) {
                List collect = list.stream().filter(item -> {
                    String usernameList = String.join((CharSequence)",", item.getUserNameList());
                    return usernameList.contains(search) || item.getUserName().contains(search);
                }).collect(Collectors.toList());
                count = collect.size();
                list = collect.stream().skip(offset.intValue()).limit(limit.intValue()).collect(Collectors.toList());
            } else {
                count = list.size();
                list = list.stream().skip(offset.intValue()).limit(limit.intValue()).collect(Collectors.toList());
            }
        }
        list.forEach(item -> {
            if (item.getType() == 0) {
                SubsidyFormField subsidyFormField = this.formFieldService.queryById(item.getRelateId());
                item.setCropId(subsidyFormField == null ? null : subsidyFormField.getCropId());
            }
        });
        JSONObject json = new JSONObject();
        json.put("list", list);
        json.put("count", (Object)count);
        return json;
    }

    public void exportSubsidyAuditList(HttpServletResponse response, Integer status, String search, Integer type, String roleId, List<String> regionCodeList, List<String> projectIdList, String userMnRegCode) {
        List<Object> list = new ArrayList();
        if (type != 0 || !Objects.equals(roleId, "605")) {
            userMnRegCode = null;
        }
        if (StringUtils.isBlank((String)roleId)) {
            list = type != 1 ? this.subsidyFormInfoMapper.queryAuditList(null, null, status, type, search, regionCodeList, projectIdList) : this.subsidyFormInfoMapper.queryProtectAuditList(status, null, regionCodeList, projectIdList);
        } else if ((type == 0 || type == 1) && (Objects.equals(roleId, "605") || Objects.equals(roleId, "606"))) {
            Integer segStatus = null;
            if (Objects.equals(roleId, "605")) {
                segStatus = status == 0 ? 0 : (status == 1 ? 2 : (status == 2 ? Integer.valueOf(1) : null));
            } else if (Objects.equals(roleId, "606")) {
                segStatus = status == 0 ? 1 : (status == 1 ? 2 : (status == 2 ? Integer.valueOf(2) : null));
            }
            list = type == 0 ? this.subsidyFormInfoMapper.queryFieldFormAuditList(null, null, status, type, segStatus, search, userMnRegCode) : this.subsidyFormInfoMapper.queryProtectAuditList(status, segStatus, regionCodeList, projectIdList);
        } else if (Objects.equals(roleId, "607") && (type == 2 || type == 3) || Objects.equals(roleId, "608") && type == 4) {
            list = this.subsidyFormInfoMapper.queryAuditList(null, null, status, type, search, regionCodeList, projectIdList);
        }
        if (type == 1) {
            list.forEach(subsidyFormInfo -> {
                List userNameList = this.subsidyFormInfoMapper.queryUserNameList(subsidyFormInfo.getRelateId());
                subsidyFormInfo.setUserNameList(userNameList);
                String temp = userNameList.size() > 0 ? (String)userNameList.get(0) + "..." : (StringUtils.isNotBlank((String)subsidyFormInfo.getUserName()) ? subsidyFormInfo.getUserName() + "..." : "");
                subsidyFormInfo.setUserName(temp);
            });
            if (StringUtils.isNotBlank((String)search)) {
                list = list.stream().filter(item -> {
                    String usernameList = String.join((CharSequence)",", item.getUserNameList());
                    return usernameList.contains(search) || item.getUserName().contains(search);
                }).collect(Collectors.toList());
            }
        }
        if (type != 4) {
            ArrayList<SubsidyFormInfoExport> subsidyFormInfoExportList = new ArrayList<SubsidyFormInfoExport>();
            for (int i = 0; i < list.size(); ++i) {
                SubsidyFormInfoExport subsidyFormInfoExport = SubsidyFormInfoExport.genExport((SubsidyFormInfo)((SubsidyFormInfo)list.get(i)));
                subsidyFormInfoExport.setIndex(Integer.valueOf(i + 1));
                subsidyFormInfoExportList.add(subsidyFormInfoExport);
            }
            try {
                EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u8865\u8d34\u5ba1\u6279\u5217\u8868", SubsidyFormInfoExport.class, (String)"\u8865\u8d34\u5ba1\u6279\u5217\u8868", subsidyFormInfoExportList);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<SubsidyFormMachineExport> subsidyFormMachineExportList = new ArrayList<SubsidyFormMachineExport>();
        for (int i = 0; i < list.size(); ++i) {
            SubsidyFormMachineExport subsidyFormMachineExport = SubsidyFormMachineExport.genExport((SubsidyFormInfo)((SubsidyFormInfo)list.get(i)));
            subsidyFormMachineExport.setIndex(Integer.valueOf(i + 1));
            subsidyFormMachineExportList.add(subsidyFormMachineExport);
        }
        try {
            EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u8865\u8d34\u5ba1\u6279\u5217\u8868", SubsidyFormMachineExport.class, (String)"\u8865\u8d34\u5ba1\u6279\u5217\u8868", subsidyFormMachineExportList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void auditForm(Integer id, Integer status, String auditComment, String userId) {
        this.validateSubsidyFormIsAudit(id);
        this.subsidyFormInfoMapper.auditForm(id, status, auditComment);
        this.subsidyFormInfoMapper.insertAuditLog(id, status, Integer.valueOf(0), auditComment, userId);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void auditFormField(Integer id, Integer status, Integer segStatus, String auditComment, String userId, Double area, Double planAmount) {
        this.validateSubsidyFormIsAudit(id);
        if (segStatus == 0) {
            this.subsidyFormInfoMapper.auditFormFieldOneLevel(id, status, auditComment);
            this.subsidyFormInfoMapper.insertAuditLog(id, status, Integer.valueOf(1), auditComment, userId);
        } else if (segStatus == 1) {
            this.subsidyFormInfoMapper.auditFormFieldTwoLevel(id, status, auditComment);
            this.subsidyFormInfoMapper.insertAuditLog(id, status, Integer.valueOf(2), auditComment, userId);
            if (status == 2) {
                this.subsidyFormInfoMapper.insertAuditLog(id, Integer.valueOf(4), Integer.valueOf(2), "", userId);
            }
        }
        this.subsidyFormInfoMapper.updateFormFieldArea(id, area);
        this.subsidyFormInfoMapper.updateFormInfoPlanAmount(id, planAmount);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id);
        jsonObject.put("status", (Object)status);
        jsonObject.put("segStatus", (Object)segStatus);
        jsonObject.put("auditComment", (Object)auditComment);
        jsonObject.put("userId", (Object)userId);
        jsonObject.put("area", (Object)area);
        jsonObject.put("planAmount", (Object)planAmount);
        this.syncSubsidyFormField(jsonObject.toJSONString(), "ly/subsidy/audit");
    }

    @Transactional
    public void deleteSubsidyFormFieldById(Integer id, String delFieldIds) {
        this.subsidyFormInfoMapper.deleteSubsidyFormFieldById(id, delFieldIds);
        List fieldIdList = this.subsidyFormInfoMapper.querySubsidyFormFieldById(id);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id);
        jsonObject.put("fieldIdList", (Object)fieldIdList);
        this.syncSubsidyFormField(jsonObject.toJSONString(), "ly/subsidy/field/del");
    }

    private void validateSubsidyFormIsAudit(Integer id) {
        Integer status = this.subsidyFormInfoMapper.queryById(id).getStatus();
        if (status == 1 || status == 2 || status == 3) {
            throw new RuntimeException("\u8be5\u8865\u8d34\u7533\u62a5\u5df2\u88ab\u5ba1\u6838\uff01");
        }
    }

    public List<SubsidyFormInfo> queryAuditPassList() {
        return this.subsidyFormInfoMapper.queryAuditPassList();
    }

    public List<SubsidyFormInfo> queryListByProjectId(Integer projectId, Integer status, String startTime, String endTime) {
        return this.subsidyFormInfoMapper.queryListByProjectId(projectId, status, startTime, endTime);
    }

    @Transactional
    public void cancelPublicFormField(Integer id, String auditComment, String userId) {
        this.subsidyFormInfoMapper.cancelPublicFormField(id, auditComment);
        this.subsidyFormInfoMapper.insertAuditLog(id, Integer.valueOf(6), Integer.valueOf(0), auditComment, userId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id);
        jsonObject.put("auditComment", (Object)auditComment);
        this.syncSubsidyFormField(jsonObject.toJSONString(), "ly/subsidy/cancel-public");
    }

    @Transactional
    public Integer insertForm(JSONObject json) {
        int flag = 0;
        Integer type = json.getInteger("type");
        Double planAmount = 0.0;
        Integer formId = 0;
        SubsidyProject project = this.subsidyProjectService.queryById(json.getInteger("projectId"));
        List<Object> fieldIdList = new ArrayList();
        if (type == 0) {
            SubsidyFormField subsidyFormField = (SubsidyFormField)JSONObject.toJavaObject((JSON)json, SubsidyFormField.class);
            JSONArray fieldArray = json.getJSONArray("fieldArray");
            planAmount = project.getSubsidyMoney() * subsidyFormField.getCirculateArea();
            if (planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            List fieldList = fieldArray.toJavaList(FieldResultMap.class);
            fieldIdList = fieldList.stream().map(FieldResultMap::getFieldId).collect(Collectors.toList());
            this.formFieldService.insert(subsidyFormField, fieldArray);
            formId = subsidyFormField.getId();
        } else if (type == 1) {
            SubsidyFormProtect subsidyFormProtect = (SubsidyFormProtect)JSONObject.toJavaObject((JSON)json, SubsidyFormProtect.class);
            this.subsidyFormProtectService.insert(subsidyFormProtect);
            formId = subsidyFormProtect.getId();
        } else if (type == 2) {
            SubsidyFormFarmer subsidyFormFarmer = (SubsidyFormFarmer)JSONObject.toJavaObject((JSON)json, SubsidyFormFarmer.class);
            planAmount = project.getSubsidyMoney() * subsidyFormFarmer.getPurchaseAmount();
            if (planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formFarmerService.insert(subsidyFormFarmer);
            formId = subsidyFormFarmer.getId();
        } else if (type == 3) {
            SubsidyFormBusiness formBusiness = (SubsidyFormBusiness)JSONObject.toJavaObject((JSON)json, SubsidyFormBusiness.class);
            planAmount = formBusiness.getLargePurchaseAmount() * project.getLargePurchase() + formBusiness.getRetailPurchaseAmount() * project.getRetailPurchase();
            if (planAmount == null || planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formBusinessService.insert(formBusiness);
            formId = formBusiness.getId();
        } else if (type == 4) {
            SubsidyFormAgrimachine subsidyFormAgrimachine = (SubsidyFormAgrimachine)JSONObject.toJavaObject((JSON)json, SubsidyFormAgrimachine.class);
            Integer buyYear = Integer.valueOf(subsidyFormAgrimachine.getBuyTime().split("-")[0]);
            planAmount = (double)(project.getScrappedYears() - LocalDate.now().getYear() + buyYear) * project.getSubsidyMoney();
            if (planAmount == null || planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formAgrimachineService.insert(subsidyFormAgrimachine);
            formId = subsidyFormAgrimachine.getId();
        }
        Integer projectId = json.getInteger("projectId");
        String userId = json.getString("userId");
        String frontPic = json.getString("frontPic");
        String backPic = json.getString("backPic");
        String supportPics = json.getString("supportPics");
        String pic1 = json.getString("pic1");
        String pic2 = json.getString("pic2");
        String pic3 = json.getString("pic3");
        SubsidyFormInfo formInfo = new SubsidyFormInfo(type, projectId, formId, userId, planAmount, Integer.valueOf(0), frontPic, backPic, supportPics, pic1, pic2, pic3);
        if (json.containsKey((Object)"regionCode")) {
            formInfo.setRegionCode(json.getString("regionCode"));
            formInfo.setRegionName(json.getString("regionName"));
        }
        this.subsidyFormInfoMapper.insert(formInfo);
        if (type == 0 || type == 1) {
            json.put("relateId", (Object)formId);
            json.put("planAmount", (Object)planAmount);
            json.put("status", (Object)0);
            json.put("id", (Object)formInfo.getId());
            json.put("fieldIdList", fieldIdList);
            this.syncSubsidyFormField(json.toJSONString(), "/ly/subsidy/info/upsert");
        }
        return flag;
    }

    @Transactional
    public Integer updateForm(JSONObject json) {
        Integer flag = 0;
        Integer type = json.getInteger("type");
        Integer id = json.getInteger("id");
        Double planAmount = 0.0;
        SubsidyFormInfo formInfo = this.subsidyFormInfoMapper.queryById(id);
        SubsidyProject project = this.subsidyProjectService.queryById(formInfo.getProjectId());
        if (formInfo == null) {
            return flag;
        }
        Integer formId = formInfo.getRelateId();
        if (type == 0) {
            SubsidyFormField subsidyFormField = (SubsidyFormField)JSONObject.toJavaObject((JSON)json, SubsidyFormField.class);
            JSONArray fieldArray = json.getJSONArray("fieldArray");
            subsidyFormField.setId(formId);
            formInfo.setSegStatus(Integer.valueOf(0));
            planAmount = project.getSubsidyMoney() * subsidyFormField.getCirculateArea();
            if (planAmount == null || planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formFieldService.update(subsidyFormField, fieldArray, id);
        } else if (type == 1) {
            SubsidyFormProtect subsidyFormProtect = (SubsidyFormProtect)JSONObject.toJavaObject((JSON)json, SubsidyFormProtect.class);
            this.subsidyFormProtectService.update(subsidyFormProtect);
        } else if (type == 2) {
            SubsidyFormFarmer subsidyFormFarmer = (SubsidyFormFarmer)JSONObject.toJavaObject((JSON)json, SubsidyFormFarmer.class);
            subsidyFormFarmer.setId(formId);
            planAmount = project.getSubsidyMoney() * subsidyFormFarmer.getPurchaseAmount();
            if (planAmount == null || planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formFarmerService.update(subsidyFormFarmer);
        } else if (type == 3) {
            SubsidyFormBusiness formBusiness = (SubsidyFormBusiness)JSONObject.toJavaObject((JSON)json, SubsidyFormBusiness.class);
            formBusiness.setId(formId);
            planAmount = formBusiness.getLargePurchaseAmount() * project.getLargePurchase() + formBusiness.getRetailPurchaseAmount() * project.getRetailPurchase();
            if (planAmount == null || planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formBusinessService.update(formBusiness);
        } else if (type == 4) {
            SubsidyFormAgrimachine subsidyFormAgrimachine = (SubsidyFormAgrimachine)JSONObject.toJavaObject((JSON)json, SubsidyFormAgrimachine.class);
            subsidyFormAgrimachine.setId(formId);
            Integer buyYear = Integer.valueOf(subsidyFormAgrimachine.getBuyTime().split("-")[0]);
            planAmount = (double)(project.getScrappedYears() - LocalDate.now().getYear() + buyYear) * project.getSubsidyMoney();
            if (planAmount == null || planAmount <= 0.0) {
                flag = 1;
                return flag;
            }
            this.formAgrimachineService.update(subsidyFormAgrimachine);
        }
        formInfo.setProjectId(json.getInteger("projectId"));
        formInfo.setPlanAmount(planAmount);
        formInfo.setFrontPic(json.getString("frontPic"));
        formInfo.setBackPic(json.getString("backPic"));
        formInfo.setSupportPics(json.getString("supportPics"));
        formInfo.setPic1(json.getString("pic1"));
        formInfo.setPic2(json.getString("pic2"));
        formInfo.setPic3(json.getString("pic3"));
        formInfo.setStatus(Integer.valueOf(0));
        formInfo.setRegionCode(json.getString("regionCode"));
        formInfo.setRegionName(json.getString("regionName"));
        this.subsidyFormInfoMapper.update(formInfo);
        this.subsidyFormInfoMapper.insertAuditLog(id, Integer.valueOf(7), Integer.valueOf(0), null, null);
        if (type == 0 || type == 1) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)id);
            this.syncSubsidyFormField(jsonObject.toJSONString(), "ly/subsidy/info/status");
        }
        return flag;
    }

    public Integer querySubsidyReportCount(String userId, Integer status, String companyName, Integer type) {
        return this.subsidyFormInfoMapper.querySubsidyReportCount(userId, status, companyName, type);
    }

    public List<SubsidyFormInfo> querySubsidyReportByCondAndPage(String userId, Integer status, String companyName, Integer type, Integer start, Integer pageSize) {
        List subsidyFormInfoList = this.subsidyFormInfoMapper.querySubsidyReportYearByCondAndPage(userId, status, companyName, type, start, pageSize);
        List userIdList = subsidyFormInfoList.stream().map(SubsidyFormInfo::getUserId).collect(Collectors.toList());
        List relateIdList = subsidyFormInfoList.stream().map(SubsidyFormInfo::getRelateId).collect(Collectors.toList());
        List companyList = this.companyService.queryCompanyListByUserIdList(userIdList);
        subsidyFormInfoList.forEach(subsidyFormInfo -> subsidyFormInfo.setCompany((Company)companyList.stream().filter(company -> company.getUserId().equals(subsidyFormInfo.getUserId())).collect(Collectors.toList()).get(0)));
        if (type == 5) {
            List subsidyReportYearList = this.subsidyReportYearMapper.querySubsidyReportYearByIdList(relateIdList);
            subsidyFormInfoList.forEach(subsidyFormInfo -> subsidyFormInfo.setReportYear((SubsidyReportYear)subsidyReportYearList.stream().filter(subsidyReportYear -> subsidyReportYear.getId().equals(subsidyFormInfo.getRelateId())).collect(Collectors.toList()).get(0)));
        } else if (type == 6) {
            List subsidyReportFertilizerList = this.subsidyReportFertilizerMapper.querySubsidyReportFertilizerByIdList(relateIdList);
            subsidyFormInfoList.forEach(subsidyFormInfo -> subsidyFormInfo.setReportFertilizer((SubsidyReportFertilizer)subsidyReportFertilizerList.stream().filter(subsidyReportFertilizer -> subsidyReportFertilizer.getId().equals(subsidyFormInfo.getRelateId())).collect(Collectors.toList()).get(0)));
        }
        return subsidyFormInfoList;
    }

    public void updateFormStatus(Integer id, Integer status) {
        this.subsidyFormInfoMapper.updateFormStatus(id, status);
    }

    public JSONObject queryCompanyAuditList(Integer status, Integer offset, Integer limit, String search, List<String> regionCodeList, List<String> projectIdList) {
        JSONObject json = new JSONObject();
        List list = this.subsidyFormInfoMapper.queryCompanyAuditList(offset, limit, status, search, regionCodeList, projectIdList);
        Integer count = this.subsidyFormInfoMapper.queryAuditCount(status, Integer.valueOf(3), search, regionCodeList, projectIdList);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void exportCompanyAuditList(HttpServletResponse response, String search, Integer status, List<String> regionCodeList, List<String> projectIdList) {
        List list = this.subsidyFormInfoMapper.queryCompanyAuditList(null, null, status, search, regionCodeList, projectIdList);
        ArrayList<SubsidyCompanyExport> subsidyCompanyExportList = new ArrayList<SubsidyCompanyExport>();
        String tempStatus = status == 0 ? "\u5f85\u5904\u7406" : (status == 2 ? "\u5df2\u901a\u8fc7" : (status == 3 ? "\u5df2\u9a73\u56de" : ""));
        for (int i = 0; i < list.size(); ++i) {
            SubsidyCompanyExport subsidyCompanyExport = SubsidyCompanyExport.genExport((SubsidyFormInfo)((SubsidyFormInfo)list.get(i)));
            subsidyCompanyExport.setIndex(Integer.valueOf(i + 1));
            subsidyCompanyExport.setStatus(tempStatus);
            subsidyCompanyExportList.add(subsidyCompanyExport);
        }
        try {
            EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u519c\u8d44\u4ea7\u54c1\u8865\u8d34\u5ba1\u6279\u5217\u8868", SubsidyCompanyExport.class, (String)"\u519c\u8d44\u4ea7\u54c1\u8865\u8d34\u5ba1\u6279\u5217\u8868", subsidyCompanyExportList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryReportYearAuditList(Integer status, Integer offset, Integer limit, String search, List<String> regionCodeList, List<String> projectIdList) {
        JSONObject json = new JSONObject();
        List list = this.subsidyFormInfoMapper.queryReportYearAuditList(offset, limit, status, search, regionCodeList, projectIdList);
        Integer count = this.subsidyFormInfoMapper.queryAuditCount(status, Integer.valueOf(5), search, regionCodeList, projectIdList);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void exportReportYearAuditList(HttpServletResponse response, String search, Integer status, List<String> regionCodeList, List<String> projectIdList) {
        List list = this.subsidyFormInfoMapper.queryReportYearAuditList(null, null, status, search, regionCodeList, projectIdList);
        ArrayList<SubsidyYearExport> subsidyYearExportList = new ArrayList<SubsidyYearExport>();
        String tempStatus = status == 0 ? "\u5f85\u5904\u7406" : (status == 2 ? "\u5df2\u901a\u8fc7" : (status == 3 ? "\u5df2\u9a73\u56de" : ""));
        for (int i = 0; i < list.size(); ++i) {
            SubsidyYearExport subsidyYearExport = SubsidyYearExport.genExport((SubsidyFormInfo)((SubsidyFormInfo)list.get(i)));
            subsidyYearExport.setIndex(Integer.valueOf(i + 1));
            subsidyYearExport.setStatus(tempStatus);
            subsidyYearExportList.add(subsidyYearExport);
        }
        try {
            EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u5e74\u5ea6\u62a5\u5907\u5ba1\u6279\u5217\u8868", SubsidyYearExport.class, (String)"\u5e74\u5ea6\u62a5\u5907\u5ba1\u6279\u5217\u8868", subsidyYearExportList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryReportFertilizerAuditList(Integer status, Integer offset, Integer limit, String search, List<String> regionCodeList, List<String> projectIdList) {
        JSONObject json = new JSONObject();
        List list = this.subsidyFormInfoMapper.queryReportFertilizerAuditList(offset, limit, status, search, regionCodeList, projectIdList);
        Integer count = this.subsidyFormInfoMapper.queryAuditCount(status, Integer.valueOf(6), search, regionCodeList, projectIdList);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public void exportFertilizerAuditList(HttpServletResponse response, String search, Integer status, List<String> regionCodeList, List<String> projectIdList) {
        List list = this.subsidyFormInfoMapper.queryReportFertilizerAuditList(null, null, status, search, regionCodeList, projectIdList);
        ArrayList<SubsidyFertilizerExport> subsidyFertilizerExportList = new ArrayList<SubsidyFertilizerExport>();
        String tempStatus = status == 0 ? "\u5f85\u5904\u7406" : (status == 2 ? "\u5df2\u901a\u8fc7" : (status == 3 ? "\u5df2\u9a73\u56de" : ""));
        for (int i = 0; i < list.size(); ++i) {
            SubsidyFertilizerExport subsidyFertilizerExport = SubsidyFertilizerExport.genExport((SubsidyFormInfo)((SubsidyFormInfo)list.get(i)));
            subsidyFertilizerExport.setIndex(Integer.valueOf(i + 1));
            subsidyFertilizerExport.setStatus(tempStatus);
            subsidyFertilizerExportList.add(subsidyFertilizerExport);
        }
        try {
            EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u80a5\u6599\u62a5\u5907\u5ba1\u6279\u5217\u8868", SubsidyFertilizerExport.class, (String)"\u80a5\u6599\u62a5\u5907\u5ba1\u6279\u5217\u8868", subsidyFertilizerExportList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SubsidySummaryYear> querySubsidySummaryByYear(String regionCode) {
        return this.subsidyFormInfoMapper.querySubsidySummaryByYear(regionCode);
    }

    public void upsertSubsidySummaryByYear(List<SubsidySummaryYear> subsidySummaryYearList) {
        List idList = subsidySummaryYearList.stream().map(SubsidySummaryYear::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.subsidyFormInfoMapper.deleteSubsidySummaryYearByIdList(idList, subsidySummaryYearList.get(0).getRegionCode());
        }
        subsidySummaryYearList.forEach(subsidySummaryYear -> {
            if (subsidySummaryYear.getId() == null) {
                this.subsidyFormInfoMapper.insertSubsidySummaryYear(subsidySummaryYear);
            } else {
                this.subsidyFormInfoMapper.updateSubsidySummaryYear(subsidySummaryYear);
            }
        });
    }

    public JSONObject querySubsidySummaryByTown(String regionCode, Integer year, Integer type) {
        JSONObject json = new JSONObject();
        List list = this.subsidyFormInfoMapper.querySubsidySummaryByTown(regionCode, year, type);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySubsidySummaryByPlant(String regionCode, Integer year) {
        JSONObject json = new JSONObject();
        List list = this.subsidyAmountSummaryMapper.querySubsidySummaryByPlant(regionCode, year);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySubsidySummaryByMachine(String regionCode, Integer year) {
        JSONObject json = new JSONObject();
        List list = this.subsidyAmountSummaryMapper.querySubsidySummaryByMachine(regionCode, year);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySubsidySummaryByAgriProduct(String regionCode, Integer year) {
        JSONObject json = new JSONObject();
        List list = this.subsidyAmountSummaryMapper.querySubsidySummaryByAgriProduct(regionCode, year);
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySubsidyLandlord(String userId, Integer offset, Integer limit, Integer type, String userName) {
        List list = type == null || type != 1 ? this.subsidyFormInfoMapper.querySubsidyLandlord(offset, limit, userId, type, userName) : this.subsidyFormInfoMapper.querySubsidyLandlordByProtect(offset, limit, userId, userName);
        for (SubsidyFormInfo formInfo : list) {
            Integer relateId = formInfo.getRelateId();
            switch (formInfo.getType()) {
                case 0: {
                    SubsidyFormField subsidyFormField = this.formFieldService.queryById(relateId);
                    formInfo.setFormField(subsidyFormField);
                    if (subsidyFormField == null) break;
                    formInfo.setAreaSum(formInfo.getFormField().getAreaSum());
                    break;
                }
                case 1: {
                    formInfo.setFormProtect(this.subsidyFormProtectService.queryProtectHistoryByUserId(relateId, userId));
                    break;
                }
                case 2: {
                    formInfo.setFormFarmer(this.formFarmerService.queryById(relateId));
                    break;
                }
                case 3: {
                    formInfo.setFormBusiness(this.formBusinessService.queryById(relateId));
                    formInfo.setCompany(this.companyService.queryCompanyInfoByCompanyId(null, userId));
                    break;
                }
                case 4: {
                    formInfo.setFormAgrimachine(this.formAgrimachineService.queryById(relateId));
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject queryUserSumByRegion(Integer year, Integer type) {
        List list = this.subsidyFormInfoMapper.queryUserSumByRegion(year, type);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySummaryTypeAll(Integer year, Integer regionCode) {
        SubsidyAmountSummary amountSummary = new SubsidyAmountSummary();
        amountSummary.setYears(year);
        amountSummary.setRegionCode(regionCode);
        List list = this.amountSummaryMapper.queryAll(amountSummary);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySummarySingleType(Integer type, Integer year) {
        SubsidyAmountSummary amountSummary = new SubsidyAmountSummary();
        amountSummary.setYears(year);
        amountSummary.setType(type);
        List list = this.amountSummaryMapper.queryAll(amountSummary);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public JSONObject querySummaryApplyList(Integer type, String regionCode, Integer offset, Integer limit, String years) {
        JSONObject json = new JSONObject();
        List list = type == 3 ? this.subsidyFormInfoMapper.querySummaryApplyListByCompany(type, regionCode, offset, limit, years) : (type != 1 ? this.subsidyFormInfoMapper.querySummaryApplyListByPerson(type, regionCode, offset, limit, years) : this.subsidyFormInfoMapper.querySummaryApplyListByProtect(regionCode, offset, limit, years));
        json.put("list", (Object)list);
        return json;
    }

    public List<SubsidyFormProtectHistory> queryProtectUserList(String regionCode) {
        List subsidyFormProtectHistoryList = this.subsidyFormProtectService.queryUserListByRegionCode(regionCode);
        subsidyFormProtectHistoryList.forEach(subsidyFormProtectHistory -> {
            subsidyFormProtectHistory.setConfirmArea(this.fieldDoubleStatusMapper.queryConfirmFieldDoubleByPhone(subsidyFormProtectHistory.getPhone()));
            subsidyFormProtectHistory.setDoubleArea(this.fieldDoubleStatusMapper.queryDoubleFieldDoubleByPhone(subsidyFormProtectHistory.getPhone()));
        });
        return subsidyFormProtectHistoryList;
    }

    @Transactional
    public void insertFormProtect(SubsidyFormProtect subsidyFormProtect, JSONObject json) {
        SubsidyFormInfo subsidyFormInfo = null;
        if (subsidyFormProtect.getId() != null) {
            subsidyFormInfo = this.subsidyFormInfoMapper.queryFromInfoByRelateIdAndType(subsidyFormProtect.getId(), Integer.valueOf(1));
            this.subsidyFormProtectService.deleteProtectById(subsidyFormProtect.getId());
            this.subsidyFormInfoMapper.deleteByRelateId(subsidyFormProtect.getId());
            this.subsidyFormProtectService.deleteHistoryByProtectId(subsidyFormProtect.getId());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("infoId", (Object)subsidyFormProtect.getId());
            this.syncSubsidyFormField(jsonObject.toJSONString(), "/ly/subsidy/info/delete");
        }
        this.subsidyFormProtectService.insert(subsidyFormProtect);
        SubsidyFormInfo formInfo = new SubsidyFormInfo(Integer.valueOf(0), Integer.valueOf(1), subsidyFormProtect.getProjectId(), subsidyFormProtect.getId(), subsidyFormProtect.getRegionCode());
        this.subsidyFormInfoMapper.insert(formInfo);
        JSONObject jsonObject = new JSONObject();
        List fieldIdList = new ArrayList();
        jsonObject.put("status", (Object)0);
        jsonObject.put("segStatus", (Object)0);
        jsonObject.put("type", (Object)1);
        jsonObject.put("projectId", (Object)subsidyFormProtect.getProjectId());
        jsonObject.put("relateId", (Object)subsidyFormProtect.getId());
        jsonObject.put("regionCode", (Object)subsidyFormProtect.getRegionCode());
        jsonObject.put("id", (Object)formInfo.getId());
        if (subsidyFormInfo != null) {
            this.subsidyFormInfoMapper.updateFormInfoCreateTimeById(formInfo.getId(), subsidyFormInfo.getCreateTime());
            this.subsidyFormInfoMapper.updateFormInfoLogListByInfoId(subsidyFormInfo.getId(), formInfo.getId());
            this.subsidyFormInfoMapper.insertAuditLog(formInfo.getId(), Integer.valueOf(7), Integer.valueOf(0), null, null);
        }
        SubsidyProject subsidyProject = this.subsidyProjectService.queryById(subsidyFormProtect.getProjectId());
        JSONArray jsonArray = json.getJSONArray("protectHistory");
        if (jsonArray != null && jsonArray.size() > 0) {
            List subsidyFormProtectHistoryList = jsonArray.toJavaList(SubsidyFormProtectHistory.class);
            subsidyFormProtectHistoryList.forEach(subsidyFormProtectHistory -> {
                subsidyFormProtectHistory.setFormProtectId(subsidyFormProtect.getId());
                subsidyFormProtectHistory.setAmount(Double.valueOf((subsidyFormProtectHistory.getConfirmArea() - subsidyFormProtectHistory.getDoubleArea()) * subsidyProject.getSubsidyMoney()));
            });
            this.subsidyFormProtectService.insertProtectHistoryBatch(subsidyFormProtectHistoryList);
            List userIdList = subsidyFormProtectHistoryList.stream().map(SubsidyFormProtectHistory::getUserId).collect(Collectors.toList());
            fieldIdList = this.subsidyFormInfoMapper.queryFieldIdListByUserIdList(userIdList);
        }
        jsonObject.put("fieldIdList", fieldIdList);
        this.syncSubsidyFormField(jsonObject.toJSONString(), "/ly/subsidy/info/upsert");
    }

    public JSONObject queryFormProtectPage(List<String> statusList, List<String> regionCodeList, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.subsidyFormInfoMapper.queryFormProtectCount(statusList, regionCodeList);
        List subsidyFormInfoList = this.subsidyFormInfoMapper.queryFormProtectPage(statusList, regionCodeList, start, pageSize);
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)subsidyFormInfoList);
        return jsonObject;
    }

    @Transactional
    public void upsertSubsidySummaryByPlant(List<LabelResultMap> labelResultMapList) {
        List idList = labelResultMapList.stream().filter(labelResultMap -> labelResultMap.getId() != null).map(LabelResultMap::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.subsidyAmountSummaryMapper.deleteSubsidySummaryPlantByRegionCodeAndId(idList, labelResultMapList.get(0).getRegionCode());
        }
        labelResultMapList.forEach(labelResultMap -> {
            if (labelResultMap.getId() == null) {
                this.subsidyAmountSummaryMapper.insertSubsidySummaryByPlant(labelResultMap);
            } else {
                this.subsidyAmountSummaryMapper.updateSubsidySummaryByPlant(labelResultMap);
            }
        });
    }

    @Transactional
    public void upsertSubsidySummaryByMachine(List<LabelResultMap> labelResultMapList) {
        List idList = labelResultMapList.stream().filter(labelResultMap -> labelResultMap.getId() != null).map(LabelResultMap::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.subsidyAmountSummaryMapper.deleteSubsidySummaryMachineByRegionCodeAndId(idList, labelResultMapList.get(0).getRegionCode());
        }
        labelResultMapList.forEach(labelResultMap -> {
            if (labelResultMap.getId() == null) {
                this.subsidyAmountSummaryMapper.insertSubsidySummaryByMachine(labelResultMap);
            } else {
                this.subsidyAmountSummaryMapper.updateSubsidySummaryByMachine(labelResultMap);
            }
        });
    }

    @Transactional
    public void upsertSubsidySummaryByAgriProduct(List<LabelResultMap> labelResultMapList) {
        List idList = labelResultMapList.stream().filter(labelResultMap -> labelResultMap.getId() != null).map(LabelResultMap::getId).collect(Collectors.toList());
        if (idList.size() > 0) {
            this.subsidyAmountSummaryMapper.deleteSubsidySummaryAgriProductByRegionCodeAndId(idList, labelResultMapList.get(0).getRegionCode());
        }
        labelResultMapList.forEach(labelResultMap -> {
            if (labelResultMap.getId() == null) {
                this.subsidyAmountSummaryMapper.insertSubsidySummaryByAgriProduct(labelResultMap);
            } else {
                this.subsidyAmountSummaryMapper.updateSubsidySummaryByAgriProduct(labelResultMap);
            }
        });
    }

    @Transactional
    public void upsertSummaryTypeAll(List<SubsidyAmountSummary> subsidySummaryAmountList) {
        subsidySummaryAmountList.forEach(subsidySummaryAmount -> {
            if (subsidySummaryAmount.getId() == null) {
                this.subsidyAmountSummaryMapper.insertSummaryTypeAll(subsidySummaryAmount);
            } else {
                this.subsidyAmountSummaryMapper.updateSummaryTypeAll(subsidySummaryAmount);
            }
        });
    }

    public void importSubsidyForm(List<SubsidyImportDto> list, Integer type) {
        if (list.size() > 0) {
            String projectName = list.get(0).getProjectName();
            SubsidyProject subsidyProject = new SubsidyProject();
            subsidyProject.setName(projectName);
            List subsidyProjects = this.subsidyProjectService.queryAll(subsidyProject);
            String projectId = "";
            if (!CollectionUtils.isEmpty((Collection)subsidyProjects)) {
                SubsidyProject project = (SubsidyProject)subsidyProjects.get(0);
                String finalProjectId = projectId = project.getId().toString();
                list.stream().forEach(item -> item.setProjectId(finalProjectId));
                String crop_name = project.getCropName();
                HashMap<String, Integer> searchMap = new HashMap<String, Integer>();
                searchMap.put("\u65e9\u7a3b", 1);
                searchMap.put("\u5355\u5b63\u665a\u7a3b", 2);
                searchMap.put("\u7389\u7c73", 3);
                searchMap.put("\u756a\u85af", 4);
                searchMap.put("\u5c0f\u9ea6", 5);
                searchMap.put("\u5927\u8c46", 6);
                searchMap.put("\u8695\u8c46", 7);
                searchMap.put("\u6cb9\u83dc", 8);
                searchMap.put("\u8fde\u4f5c\u665a\u7a3b", 9);
                searchMap.put("\u665a\u7a3b", 9);
                if (null != searchMap.get(crop_name)) {
                    list.stream().forEach(item -> item.setCropId((Integer)searchMap.get(crop_name)));
                }
            }
            List regionResultMaps = this.fieldDoubleStatusMapper.queryAllDownRegions("330825");
            for (SubsidyImportDto importDto : list) {
                List lytUsers = this.userCenterService.queryUserInfoByInfo(importDto.getPhone(), null);
                if (!CollectionUtils.isEmpty((Collection)lytUsers)) {
                    importDto.setUserId(((LytUser)lytUsers.get(0)).getUserId());
                }
                SubsidyFormField field = new SubsidyFormField();
                if (!StringUtils.isEmpty((String)projectId)) {
                    field.setProjectId(Integer.valueOf(Integer.parseInt(projectId)));
                    importDto.setProjectId(projectId);
                }
                field.setUserId(importDto.getUserId());
                field.setCropId(importDto.getCropId());
                if (!StringUtils.isEmpty((String)importDto.getArea())) {
                    field.setCirculateArea(Double.valueOf(Double.parseDouble(importDto.getArea())));
                    field.setAreaSum(Double.valueOf(Double.parseDouble(importDto.getArea())));
                }
                regionResultMaps.stream().forEach(item -> {
                    if (item.getName().contains(importDto.getAddress())) {
                        importDto.setRegionCode(item.getId());
                    }
                });
                field.setType(type);
                SubsidyFormField insert = this.formFieldService.insert(field, null);
                importDto.setRelateId(insert.getId());
            }
            this.subsidyFormInfoMapper.importSubsidyForm(list, type);
        }
    }

    public void deleteSubsidyFormInfoById(Integer id) {
        this.subsidyFormInfoMapper.deleteSubsidyFormInfoById(id);
    }

    public JSONObject querySubsidyFieldMap(String regionCode, String username, String projectIdStr, Integer type) {
        JSONObject jsonObject = new JSONObject();
        List fieldDoubleStatusList = this.subsidyFormInfoMapper.queryFieldByRegionCodeAndUsername(regionCode, username);
        jsonObject.put("allCount", (Object)fieldDoubleStatusList.size());
        jsonObject.put("allArea", (Object)fieldDoubleStatusList.stream().mapToDouble(FieldDoubleStatus::getArea).sum());
        if (StringUtils.isNotBlank((String)projectIdStr)) {
            List subsidyFormInfoList = this.subsidyFormInfoMapper.querySubsidyFormInfoListByProjectId(projectIdStr, type);
            List passRelateIdList = subsidyFormInfoList.stream().filter(item -> item.getStatus() == 2 || item.getStatus() == 4).map(SubsidyFormInfo::getRelateId).collect(Collectors.toList());
            List waitRelateIdList = subsidyFormInfoList.stream().filter(item -> item.getStatus() != 2 && item.getStatus() != 4).map(SubsidyFormInfo::getRelateId).collect(Collectors.toList());
            if (type == 0) {
                List passFieldIdList = new ArrayList();
                if (passRelateIdList.size() > 0) {
                    passFieldIdList = this.subsidyFormInfoMapper.queryFieldIdListByRelateIdList(passRelateIdList, regionCode, username);
                    jsonObject.put("passCount", (Object)passFieldIdList.size());
                    Double passArea = passFieldIdList.size() > 0 ? this.subsidyFormInfoMapper.queryFieldAreaByFieldIdList(passFieldIdList) : 0.0;
                    jsonObject.put("passArea", (Object)passArea);
                } else {
                    jsonObject.put("passCount", (Object)0);
                    jsonObject.put("passArea", (Object)0);
                }
                if (waitRelateIdList.size() > 0) {
                    List waitFieldIdListTemp = this.subsidyFormInfoMapper.queryFieldIdListByRelateIdList(waitRelateIdList, regionCode, username);
                    ArrayList<Integer> waitFieldIdListResult = new ArrayList<Integer>();
                    for (Integer fieldId : waitFieldIdListTemp) {
                        if (passFieldIdList.contains(fieldId)) continue;
                        waitFieldIdListResult.add(fieldId);
                    }
                    Double waitArea = waitFieldIdListResult.size() > 0 ? this.subsidyFormInfoMapper.queryFieldAreaByFieldIdList(waitFieldIdListResult) : 0.0;
                    jsonObject.put("waitCount", (Object)waitFieldIdListResult.size());
                    jsonObject.put("waitArea", (Object)waitArea);
                } else {
                    jsonObject.put("waitCount", (Object)0);
                    jsonObject.put("waitArea", (Object)0);
                }
            } else if (type == 1) {
                List passUserIdList = new ArrayList();
                if (passRelateIdList.size() > 0) {
                    passUserIdList = this.subsidyFormInfoMapper.queryUserIdListByRelateIdList(passRelateIdList, username);
                    List fieldResultMapList = this.subsidyFormInfoMapper.queryFieldListByUserIdList(passUserIdList, regionCode);
                    jsonObject.put("passCount", (Object)fieldResultMapList.size());
                    Double passArea = fieldResultMapList.size() > 0 ? fieldResultMapList.stream().mapToDouble(FieldResultMap::getArea).sum() : 0.0;
                    jsonObject.put("passArea", (Object)passArea);
                } else {
                    jsonObject.put("passCount", (Object)0);
                    jsonObject.put("passArea", (Object)0);
                }
                if (waitRelateIdList.size() > 0) {
                    List waitUserIdListTemp = this.subsidyFormInfoMapper.queryUserIdListByRelateIdList(waitRelateIdList, username);
                    ArrayList<String> waitUserIdListResult = new ArrayList<String>();
                    for (String userId : waitUserIdListTemp) {
                        if (passUserIdList.contains(userId)) continue;
                        waitUserIdListResult.add(userId);
                    }
                    List fieldResultMapList = this.subsidyFormInfoMapper.queryFieldListByUserIdList(waitUserIdListResult, regionCode);
                    jsonObject.put("waitCount", (Object)fieldResultMapList.size());
                    Double passArea = fieldResultMapList.size() > 0 ? fieldResultMapList.stream().mapToDouble(FieldResultMap::getArea).sum() : 0.0;
                    jsonObject.put("waitArea", (Object)passArea);
                } else {
                    jsonObject.put("waitCount", (Object)0);
                    jsonObject.put("waitArea", (Object)0);
                }
            }
        }
        return jsonObject;
    }

    private void syncSubsidyFormField(String jsonStr, String url) {
        try {
            HttpSendUtil.sendHttpPost((String)(this.datasyncUrl + url), (String)"", (String)"", (String)jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SubsidyMapData> querySubsidyMapData(String regionCode) {
        return this.subsidyFormInfoMapper.querySubsidyMapData(regionCode);
    }

    public void upsertSubsidyMapData(List<SubsidyMapData> subsidyMapDataList) {
        subsidyMapDataList.forEach(item -> {
            if (item.getId() == null) {
                this.subsidyFormInfoMapper.insertSubsidyMapData(item);
            } else {
                this.subsidyFormInfoMapper.updateSubsidyMapData(item);
            }
        });
    }

    public void syncSubsidyFormInfo() {
        List subsidyFormInfoList = this.subsidyFormInfoMapper.querySubsidyFormInfoList();
        subsidyFormInfoList.forEach(item -> {
            List userIdList;
            List fieldIdList = new ArrayList();
            if (item.getType() == 0) {
                fieldIdList = this.subsidyFormInfoMapper.queryFieldIdListByRelateId(item.getRelateId());
            } else if (item.getType() == 1 && (userIdList = this.subsidyFormInfoMapper.queryUserIdListByRelateId(item.getRelateId())) != null && userIdList.size() > 0) {
                fieldIdList = this.subsidyFormInfoMapper.queryFieldIdListByUserIdList(userIdList);
            }
            item.setFieldIds(String.format("{%s}", String.join((CharSequence)",", fieldIdList)));
        });
        if (subsidyFormInfoList.size() > 0) {
            this.syncSubsidyFormField(JSONArray.toJSONString((Object)subsidyFormInfoList), "ly/subsidy/sync-batch");
        }
    }

    public JSONObject queryAuditCount(Integer status, String roleId) {
        JSONObject jsonObject = new JSONObject();
        Integer segStatus = null;
        if (Objects.equals(roleId, "605")) {
            segStatus = 0;
        } else if (Objects.equals(roleId, "606")) {
            segStatus = 1;
        }
        int subsidyAudit2 = this.subsidyFormInfoMapper.querySubsidyAuditCount(Integer.valueOf(2), null);
        int subsidyAudit3 = this.subsidyFormInfoMapper.querySubsidyAuditCount(Integer.valueOf(3), null);
        int subsidyAudit4 = this.subsidyFormInfoMapper.querySubsidyAuditCount(Integer.valueOf(4), null);
        int subsidyAudit0 = this.subsidyFormInfoMapper.querySubsidyAuditCount(Integer.valueOf(0), segStatus);
        int subsidyAudit5 = this.subsidyFormInfoMapper.queryReportAuditCount(Integer.valueOf(5));
        int subsidyAudit6 = this.subsidyFormInfoMapper.queryReportAuditCount(Integer.valueOf(6));
        int fileldAudit = this.subsidyFormInfoMapper.queryFieldAuditCount();
        jsonObject.put("subsidyAudit2", (Object)subsidyAudit2);
        jsonObject.put("subsidyAudit3", (Object)subsidyAudit3);
        jsonObject.put("subsidyAudit4", (Object)subsidyAudit4);
        jsonObject.put("subsidyAudit0", (Object)subsidyAudit0);
        jsonObject.put("subsidyAudit5", (Object)subsidyAudit5);
        jsonObject.put("subsidyAudit6", (Object)subsidyAudit6);
        jsonObject.put("fileldAudit", (Object)fileldAudit);
        return jsonObject;
    }
}

