/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.SubsidyFormInfo;
import com.farm.bean.SubsidyFormProtect;
import com.farm.bean.SubsidyFormProtectHistory;
import com.farm.mapper.SubsidyFormInfoMapper;
import com.farm.mapper.SubsidyFormProtectMapper;
import com.farm.service.SubsidyFormProtectService;
import com.farm.service.SubsidyProjectService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="subsidyFormProtectService")
public class SubsidyFormProtectServiceImpl
implements SubsidyFormProtectService {
    @Autowired
    private SubsidyFormProtectMapper subsidyFormProtectMapper;
    @Autowired
    private SubsidyFormInfoMapper subsidyFormInfoMapper;
    @Autowired
    private SubsidyProjectService subsidyProjectService;
    @Value(value="${farm.datasync}")
    private String datasyncUrl;

    public void insert(SubsidyFormProtect subsidyFormProtect) {
        this.subsidyFormProtectMapper.insert(subsidyFormProtect);
    }

    public void update(SubsidyFormProtect subsidyFormProtect) {
        this.subsidyFormProtectMapper.update(subsidyFormProtect);
    }

    public SubsidyFormProtect queryById(Integer relateId) {
        return this.subsidyFormProtectMapper.queryById(relateId);
    }

    public List<SubsidyFormProtect> queryList(Integer status) {
        return this.subsidyFormProtectMapper.queryList(status);
    }

    public List<String> queryUserIdByFormProtectId(Integer formProtectId) {
        return this.subsidyFormProtectMapper.queryUserIdByFormProtectId(formProtectId);
    }

    public SubsidyFormInfo queryProtectDetail(Integer id, String userId) {
        SubsidyFormInfo formInfo = this.subsidyFormInfoMapper.queryById(id);
        Integer relateId = formInfo.getRelateId();
        formInfo.setSubsidyProject(this.subsidyProjectService.queryById(formInfo.getProjectId()));
        SubsidyFormProtect subsidyFormProtect = this.subsidyFormProtectMapper.queryById(relateId);
        List subsidyFormProtectHistoryList = this.subsidyFormProtectMapper.queryProtectHistoryListById(subsidyFormProtect.getId(), null);
        subsidyFormProtectHistoryList.forEach(subsidyFormProtectHistory -> {
            BigDecimal b = new BigDecimal(subsidyFormProtectHistory.getConfirmArea() - subsidyFormProtectHistory.getDoubleArea());
            subsidyFormProtectHistory.setSubsidyArea(Double.valueOf(b.setScale(2, 4).doubleValue()));
        });
        subsidyFormProtect.setFormProtectHistoryList(subsidyFormProtectHistoryList);
        formInfo.setFormProtect(subsidyFormProtect);
        formInfo.setSubsidyAuditLogList(this.subsidyFormInfoMapper.queryAuditLogListByInfoId(id));
        return formInfo;
    }

    public void insertProtectHistoryBatch(List<SubsidyFormProtectHistory> subsidyFormProtectHistoryList) {
        this.subsidyFormProtectMapper.insertProtectHistoryBatch(subsidyFormProtectHistoryList);
    }

    public List<SubsidyFormProtectHistory> queryUserListByRegionCode(String regionCode) {
        return this.subsidyFormProtectMapper.queryUserListByRegionCode(regionCode);
    }

    public void deleteProtectById(Integer id) {
        this.subsidyFormProtectMapper.deleteProtectById(id);
    }

    public void deleteHistoryByProtectId(Integer protectId) {
        this.subsidyFormProtectMapper.deleteHistoryByProtectId(protectId);
    }

    public SubsidyFormProtect queryProtectHistoryByUserId(Integer relateId, String userId) {
        return this.subsidyFormProtectMapper.queryProtectHistoryByUserId(relateId, userId);
    }
}

