/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.SubsidyDataSummaryExport;
import com.farm.bean.SubsidyFormInfo;
import com.farm.bean.SubsidyProject;
import com.farm.mapper.SubsidyFormInfoMapper;
import com.farm.mapper.SubsidyFormProtectMapper;
import com.farm.mapper.SubsidyProjectMapper;
import com.farm.service.SubsidyFormInfoService;
import com.farm.service.SubsidyProjectService;
import com.farm.util.EasyExcelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subsidyProjectService")
public class SubsidyProjectServiceImpl
implements SubsidyProjectService {
    @Resource
    private SubsidyProjectMapper subsidyProjectMapper;
    @Resource
    private SubsidyFormInfoMapper subsidyFormInfoMapper;
    @Autowired
    private SubsidyFormInfoService subsidyFormInfoService;
    @Resource
    private SubsidyFormProtectMapper subsidyFormProtectMapper;

    public SubsidyProject queryById(Integer id) {
        return this.subsidyProjectMapper.queryById(id);
    }

    public List<SubsidyProject> queryAll(SubsidyProject subsidyProject) {
        return this.subsidyProjectMapper.queryAll(subsidyProject);
    }

    public JSONObject queryAllByLimit(Integer offset, Integer limit, List<String> types, String search, Integer status, Integer year) {
        List list = this.subsidyProjectMapper.queryAllByLimit(offset, limit, types, search, status, year);
        Integer count = this.subsidyProjectMapper.queryAllCount(types, search, status, year);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public SubsidyProject insert(SubsidyProject subsidyProject) {
        this.subsidyProjectMapper.insert(subsidyProject);
        return subsidyProject;
    }

    public SubsidyProject update(SubsidyProject subsidyProject) {
        this.subsidyProjectMapper.update(subsidyProject);
        return this.queryById(subsidyProject.getId());
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.subsidyProjectMapper.deleteById(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public JSONObject querySubsidyDataSummary(String name, List<String> years, List<String> typeList, Integer start, Integer pageSize) {
        List subsidyProjects = this.subsidyProjectMapper.querySubsidyDataSummaryCount(typeList, name, years);
        List subsidyFormInfoList = this.subsidyFormInfoService.queryAuditPassList();
        List subsidyProjectList = this.getSubsidyDataSummary(name, years, typeList, start, pageSize);
        AtomicReference<Double> money = new AtomicReference<Double>(0.0);
        subsidyProjects.forEach(subsidyProject -> {
            List subsidyFormInfos = subsidyFormInfoList.stream().filter(subsidyFormInfo -> subsidyFormInfo.getProjectId().equals(subsidyProject.getId())).collect(Collectors.toList());
            subsidyProject.setTotalCount(Integer.valueOf(subsidyFormInfos.size()));
            AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
            if (1 == subsidyProject.getType()) {
                sum.set(0.0);
                subsidyFormInfos.stream().forEach(subsidyFormInfo -> {
                    List subsidyFormProtectHistoryList = this.subsidyFormProtectMapper.queryProtectHistoryListById(subsidyFormInfo.getRelateId(), null);
                    double total = subsidyFormProtectHistoryList.stream().mapToDouble(h -> null == h.getAmount() ? 0.0 : h.getAmount()).sum();
                    sum.updateAndGet(v -> new Double(v + total));
                });
            } else {
                sum.set(subsidyFormInfos.stream().filter(subsidyFormInfo -> subsidyFormInfo.getPlanAmount() != null).mapToDouble(SubsidyFormInfo::getPlanAmount).sum());
            }
            subsidyProject.setTotalAmount(sum.get());
            money.updateAndGet(v -> new Double(v + (Double)sum.get()));
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)subsidyProjects.size());
        jsonObject.put("money", money);
        jsonObject.put("list", (Object)subsidyProjectList);
        return jsonObject;
    }

    private List<SubsidyProject> getSubsidyDataSummary(String name, List<String> years, List<String> typeList, Integer start, Integer pageSize) {
        List subsidyProjectList = this.subsidyProjectMapper.querySubsidyDataSummaryByPage(start, pageSize, typeList, name, years);
        List subsidyFormInfoList = this.subsidyFormInfoService.queryAuditPassList();
        subsidyProjectList.forEach(subsidyProject -> {
            List subsidyFormInfos = subsidyFormInfoList.stream().filter(subsidyFormInfo -> subsidyFormInfo.getProjectId().equals(subsidyProject.getId())).collect(Collectors.toList());
            subsidyProject.setTotalCount(Integer.valueOf(subsidyFormInfos.size()));
            AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
            if (1 == subsidyProject.getType()) {
                sum.set(0.0);
                subsidyFormInfos.stream().forEach(subsidyFormInfo -> {
                    List subsidyFormProtectHistoryList = this.subsidyFormProtectMapper.queryProtectHistoryListById(subsidyFormInfo.getRelateId(), null);
                    double total = subsidyFormProtectHistoryList.stream().mapToDouble(h -> null == h.getAmount() ? 0.0 : h.getAmount()).sum();
                    sum.updateAndGet(v -> new Double(v + total));
                });
            } else {
                sum.set(subsidyFormInfos.stream().filter(subsidyFormInfo -> subsidyFormInfo.getPlanAmount() != null).mapToDouble(SubsidyFormInfo::getPlanAmount).sum());
            }
            subsidyProject.setTotalAmount(sum.get());
        });
        return subsidyProjectList;
    }

    public void exportSubsidyDataSummary(HttpServletResponse response, String name, List<String> yearList, List<String> typeList) {
        List subsidyProjectList = this.getSubsidyDataSummary(name, yearList, typeList, null, null);
        ArrayList<SubsidyDataSummaryExport> subsidyDataSummaryExportList = new ArrayList<SubsidyDataSummaryExport>();
        for (int i = 0; i < subsidyProjectList.size(); ++i) {
            SubsidyDataSummaryExport subsidyDataSummaryExport = SubsidyDataSummaryExport.genExport((SubsidyProject)((SubsidyProject)subsidyProjectList.get(i)));
            subsidyDataSummaryExport.setIndex(Integer.valueOf(i + 1));
            subsidyDataSummaryExportList.add(subsidyDataSummaryExport);
        }
        try {
            EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u8865\u8d34\u6570\u636e\u6c47\u603b", SubsidyDataSummaryExport.class, (String)"\u8865\u8d34\u6570\u636e\u6c47\u603b", subsidyDataSummaryExportList);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject querySubsidyProjectById(Integer id, String startTime, String endTime) {
        SubsidyProject subsidyProject = this.subsidyProjectMapper.queryById(id);
        List allSubsidyFormInfoList = this.subsidyFormInfoService.queryListByProjectId(id, null, null, null);
        subsidyProject.setTotalCount(Integer.valueOf(allSubsidyFormInfoList.size()));
        subsidyProject.setTotalAmount(Double.valueOf(allSubsidyFormInfoList.stream().filter(subsidyFormInfo -> subsidyFormInfo.getPlanAmount() != null).mapToDouble(SubsidyFormInfo::getPlanAmount).sum()));
        List auditPassSubsidyList = this.subsidyFormInfoService.queryListByProjectId(id, Integer.valueOf(2), startTime, endTime);
        if (1 == subsidyProject.getType()) {
            auditPassSubsidyList.forEach(subsidyFormInfo -> {
                Integer relateId = subsidyFormInfo.getRelateId();
                List userNameList = this.subsidyFormInfoMapper.queryUserNameList(relateId);
                subsidyFormInfo.setUserNameList(userNameList);
                String temp = userNameList.size() > 0 ? (String)userNameList.get(0) + "..." : (StringUtils.isNotBlank((String)subsidyFormInfo.getUserName()) ? subsidyFormInfo.getUserName() + "..." : "");
                subsidyFormInfo.setUserName(temp);
                List subsidyFormProtectHistoryList = this.subsidyFormProtectMapper.queryProtectHistoryListById(relateId, null);
                double sum = subsidyFormProtectHistoryList.stream().mapToDouble(t -> null == t.getAmount() ? 0.0 : t.getAmount()).sum();
                subsidyFormInfo.setPlanAmount(Double.valueOf(sum));
            });
        }
        double totalAmount = auditPassSubsidyList.stream().mapToDouble(SubsidyFormInfo::getPlanAmount).sum();
        subsidyProject.setTotalCount(Integer.valueOf(auditPassSubsidyList.size()));
        subsidyProject.setTotalAmount(Double.valueOf(totalAmount));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("obj", (Object)subsidyProject);
        jsonObject.put("auditPassSubsidyList", (Object)auditPassSubsidyList);
        return jsonObject;
    }

    public JSONObject querySubsidyProjectName(String name, Integer start, Integer pageSize) {
        List nameList = this.subsidyProjectMapper.querySubsidyProjectName(name, start, pageSize);
        Integer count = this.subsidyProjectMapper.querySubsidyProjectNameCount(name);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)nameList);
        return jsonObject;
    }
}

