/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.TransferLandInfo;
import com.farm.bean.TransferLandStatistics;
import com.farm.bean.TransferLandTrade;
import com.farm.bean.resultMap.FieldResultMap;
import com.farm.mapper.TransferLandInfoMapper;
import com.farm.mapper.UserCenterMapper;
import com.farm.service.ProductManageService;
import com.farm.service.TransferLandInfoService;
import com.farm.util.EasyExcelUtil;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="transferLandInfoService")
public class TransferLandInfoServiceImpl
implements TransferLandInfoService {
    @Resource
    private TransferLandInfoMapper transferLandInfoMapper;
    @Autowired
    private ProductManageService productManageService;
    @Autowired
    private UserCenterMapper userCenterMapper;

    public TransferLandInfo queryById(Integer id) {
        TransferLandInfo landInfo = this.transferLandInfoMapper.queryById(id);
        landInfo.setReadTime(Integer.valueOf(landInfo.getReadTime() + 1));
        this.transferLandInfoMapper.update(landInfo);
        try {
            if (landInfo.getType() == 0) {
                landInfo.setLowTotalPrice(Double.valueOf(landInfo.getTransferArea() * landInfo.getPrice()));
            } else {
                landInfo.setLowTotalPrice(Double.valueOf(landInfo.getLowPrice() * landInfo.getLowArea()));
                landInfo.setHighTotalPrice(Double.valueOf(landInfo.getHighPrice() * landInfo.getHighArea()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        landInfo.setUserInfo(this.userCenterMapper.queryUserInfoById(landInfo.getUserId()));
        landInfo.setFieldList(this.transferLandInfoMapper.queryFieldListById(id));
        landInfo.setTransferLandTrade(this.transferLandInfoMapper.queryTradeInfo(id));
        return landInfo;
    }

    public TransferLandInfo insert(TransferLandInfo land, JSONArray fieldIdArray) {
        if (land.getType() == 0) {
            String regionCode = this.productManageService.queryRegionCodeInArea(land.getLng(), land.getLat());
            land.setRegionCode(regionCode);
        }
        if (land.getSyncTown() == null) {
            land.setSyncTown(Boolean.valueOf(false));
        }
        land.setStatus(Integer.valueOf(0));
        this.transferLandInfoMapper.insert(land);
        if (fieldIdArray != null && fieldIdArray.size() > 0) {
            List fieldList = fieldIdArray.toJavaList(FieldResultMap.class);
            this.transferLandInfoMapper.insertBatchField(fieldList, land.getId());
        }
        return land;
    }

    public TransferLandInfo update(TransferLandInfo land, JSONArray fieldIdArray) {
        if (land.getLng() != null && land.getLat() != null) {
            String regionCode = this.productManageService.queryRegionCodeInArea(land.getLng(), land.getLat());
            land.setRegionCode(regionCode);
        }
        this.transferLandInfoMapper.update(land);
        if (fieldIdArray != null && fieldIdArray.size() > 0) {
            this.transferLandInfoMapper.delBatchField(land.getId());
            List fieldList = fieldIdArray.toJavaList(FieldResultMap.class);
            this.transferLandInfoMapper.insertBatchField(fieldList, land.getId());
        }
        return this.queryById(land.getId());
    }

    public void removeByIds(List<Integer> idList) {
        Integer i = 0;
        while (i < idList.size()) {
            this.transferLandInfoMapper.deleteById(idList.get(i));
            this.transferLandInfoMapper.deleteTradeByMainId(idList.get(i));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    public void insertLandTrade(TransferLandTrade dto) {
        this.transferLandInfoMapper.insertLandTrade(dto);
    }

    public JSONObject queryUserList(String userId, Integer offset, Integer limit) {
        Integer count = this.transferLandInfoMapper.queryUserCount(userId);
        List list = this.transferLandInfoMapper.queryAllByLimit(offset, limit, userId);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryTransferList0(Integer offset, Integer limit, List<String> regionList, List<String> fieldTypeList, List<String> transferTypeList, String areaTypes, String yearTypes, String lowPrice, String highPrice, String search, Integer platform, Integer statusType) {
        if (StringUtils.isNotBlank((String)yearTypes)) {
            if (yearTypes.contains("0,1,2")) {
                yearTypes = "";
            } else if (yearTypes.contains("0,1")) {
                yearTypes = "l.use_year between 1 and 10";
            } else if (yearTypes.contains("1,2")) {
                yearTypes = "l.use_year >= 5";
            } else if (yearTypes.contains("0,2")) {
                yearTypes = "((l.use_year between 1 and 5) or (l.use_year > 10))";
            } else if (yearTypes.contains("0")) {
                yearTypes = "l.use_year between 1 and 5";
            } else if (yearTypes.contains("1")) {
                yearTypes = "l.use_year between 5 and 10";
            } else if (yearTypes.contains("2")) {
                yearTypes = "l.use_year > 10";
            }
        }
        if (StringUtils.isNotBlank((String)areaTypes)) {
            if (areaTypes.contains("0,1,2,3")) {
                areaTypes = "";
            } else if (areaTypes.contains("0,1,2")) {
                areaTypes = "l.transfer_area <= 1000";
            } else if (areaTypes.contains("1,2,3")) {
                areaTypes = "l.transfer_area >= 10";
            } else if (areaTypes.contains("0,2,3")) {
                areaTypes = "((l.transfer_area < 10) or (l.transfer_area > 100))";
            } else if (areaTypes.contains("0,1,3")) {
                areaTypes = "((l.transfer_area <= 100) or (l.transfer_area > 100))";
            } else if (areaTypes.contains("0,1")) {
                areaTypes = "l.transfer_area <= 100";
            } else if (areaTypes.contains("1,2")) {
                areaTypes = "l.transfer_area between 10 and 1000";
            } else if (areaTypes.contains("2,3")) {
                areaTypes = "l.transfer_area >=100";
            } else if (areaTypes.contains("0,2")) {
                areaTypes = "((l.transfer_area < 10) or (l.transfer_area between 100 and 1000))";
            } else if (areaTypes.contains("0,3")) {
                areaTypes = "((l.transfer_area < 10) or (l.transfer_area > 1000))";
            } else if (areaTypes.contains("1,3")) {
                areaTypes = "((l.transfer_area between 10 and 100) or (l.transfer_area > 1000))";
            } else if (areaTypes.equals("0")) {
                areaTypes = "l.transfer_area < 10";
            } else if (areaTypes.equals("1")) {
                areaTypes = "l.transfer_area between 10 and 100";
            } else if (areaTypes.equals("2")) {
                areaTypes = "l.transfer_area between 100 and 1000";
            } else if (areaTypes.equals("3")) {
                areaTypes = "l.transfer_area > 1000";
            }
        }
        JSONObject json = new JSONObject();
        List list = this.transferLandInfoMapper.queryTransferList0(offset, limit, regionList, fieldTypeList, transferTypeList, areaTypes, yearTypes, lowPrice, highPrice, search, platform, statusType);
        Integer count = this.transferLandInfoMapper.queryTransferCount0(regionList, fieldTypeList, transferTypeList, areaTypes, yearTypes, lowPrice, highPrice, search, platform, statusType);
        list.forEach(item -> item.setAddress(this.transferLandInfoMapper.queryTransferInfoAddressById(item.getId())));
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryTransferList1(Integer offset, Integer limit, List<String> regionList, List<String> fieldTypeList, String yearTypes, String search, Integer platform, Integer statusType, List<String> transferTypeList) {
        if (StringUtils.isNotBlank((String)yearTypes)) {
            if (yearTypes.contains("0,1,2")) {
                yearTypes = "";
            } else if (yearTypes.contains("0,1")) {
                yearTypes = "l.use_year between 1 and 10";
            } else if (yearTypes.contains("1,2")) {
                yearTypes = "l.use_year >= 5";
            } else if (yearTypes.contains("0,2")) {
                yearTypes = "((l.use_year between 1 and 5) or (l.use_year > 10))";
            } else if (yearTypes.contains("0")) {
                yearTypes = "l.use_year between 1 and 5";
            } else if (yearTypes.contains("1")) {
                yearTypes = "l.use_year between 5 and 10";
            } else if (yearTypes.contains("2")) {
                yearTypes = "l.use_year > 10";
            }
        }
        JSONObject json = new JSONObject();
        List list = this.transferLandInfoMapper.queryTransferList1(offset, limit, regionList, fieldTypeList, yearTypes, search, platform, statusType, transferTypeList);
        Integer count = this.transferLandInfoMapper.queryTransferCount1(regionList, fieldTypeList, yearTypes, search, platform, statusType, transferTypeList);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public JSONObject queryTransferLandStatisticsInfo(List<String> fieldTypeList, List<String> transferTypeList, List<String> transferYearList, List<String> regionCodeList, String startTime, String endTime, Integer start, Integer pageSize) {
        Integer count = this.transferLandInfoMapper.queryTransferLandCountByType(fieldTypeList, transferTypeList, transferYearList, regionCodeList, startTime, endTime);
        List transferLandStatisticsList = this.transferLandInfoMapper.queryTransferLandInfoByType(fieldTypeList, transferTypeList, transferYearList, regionCodeList, startTime, endTime, start, pageSize);
        this.generateStatisticsInfo(transferYearList, regionCodeList, startTime, endTime, transferLandStatisticsList);
        JSONObject json = new JSONObject();
        json.put("count", (Object)count);
        json.put("list", (Object)transferLandStatisticsList);
        return json;
    }

    public void exportTransferLandStatisticsInfo(HttpServletResponse response, List<String> fieldTypeList, List<String> transferTypeList, List<String> transferYearList, List<String> regionCodeList, String startTime, String endTime) throws IOException {
        List transferLandStatisticsList = this.transferLandInfoMapper.queryTransferLandInfoByType(fieldTypeList, transferTypeList, transferYearList, regionCodeList, startTime, endTime, Integer.valueOf(0), Integer.valueOf(100));
        this.generateStatisticsInfo(transferYearList, regionCodeList, startTime, endTime, transferLandStatisticsList);
        EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u571f\u5730\u6d41\u8f6c\u6570\u636e\u7edf\u8ba1", TransferLandStatistics.class, (String)"\u6570\u636e\u6c47\u603b", (List)transferLandStatisticsList);
    }

    private void generateStatisticsInfo(List<String> transferYearList, List<String> regionCodeList, String startTime, String endTime, List<TransferLandStatistics> transferLandStatisticsList) {
        transferLandStatisticsList.forEach(transferLandStatistics -> {
            TransferLandStatistics transferInfo = this.transferLandInfoMapper.queryTransferInfo(transferLandStatistics.getFieldType(), transferLandStatistics.getTransferType(), transferYearList, regionCodeList, startTime, endTime);
            transferLandStatistics.setTransferArea(Double.valueOf(transferInfo == null ? 0.0 : transferInfo.getTransferArea()));
            transferLandStatistics.setTransferMoney(Double.valueOf(transferInfo == null ? 0.0 : transferInfo.getTransferMoney() / 10000.0));
            TransferLandStatistics dealInfo = this.transferLandInfoMapper.queryDealInfo(transferLandStatistics.getFieldType(), transferLandStatistics.getTransferType(), transferYearList, regionCodeList, startTime, endTime);
            transferLandStatistics.setDealArea(Double.valueOf(dealInfo == null ? 0.0 : dealInfo.getDealArea()));
            transferLandStatistics.setDealMoney(Double.valueOf(dealInfo == null ? 0.0 : dealInfo.getDealMoney() / 10000.0));
            transferLandStatistics.changeFieldTypeAndTransferType(transferLandStatistics);
        });
    }

    public void downTransfeiLand(TransferLandInfo landInfo) {
        this.transferLandInfoMapper.update(landInfo);
    }

    public TransferLandInfo dealPcTransfeiLand(TransferLandInfo landInfo) {
        this.transferLandInfoMapper.insert(landInfo);
        return landInfo;
    }

    public JSONObject queryTradeList(Integer offset, Integer limit, List<String> fieldTypeList, List<String> transferTypeList, String search) {
        JSONObject json = new JSONObject();
        List list = this.transferLandInfoMapper.queryTradeList(offset, limit, fieldTypeList, search, transferTypeList);
        Integer count = this.transferLandInfoMapper.queryTradeCount(fieldTypeList, search, transferTypeList);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }
}

