/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.Company;
import com.farm.bean.LytUser;
import com.farm.bean.UserCenter;
import com.farm.bean.resultMap.FieldResultMap;
import com.farm.mapper.UserCenterMapper;
import com.farm.service.SubsidyReportFertilizerService;
import com.farm.service.UserCenterService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userCenterService")
public class UserCenterServiceImpl
implements UserCenterService {
    @Autowired
    private UserCenterMapper userCenterMapper;
    @Autowired
    private SubsidyReportFertilizerService subsidyReportFertilizerService;

    public UserCenter queryUserInfoByUserId(String userId) {
        return this.userCenterMapper.queryUserInfoByUserId(userId);
    }

    @Transactional
    public void upsertUserInfo(String name, String phone, String card, String address, String accountBank, String bankCard, String userId, String avatar) {
        UserCenter userCenter = this.userCenterMapper.queryByUserId(userId);
        if (userCenter != null) {
            this.userCenterMapper.updateUserCenterInfo(card, address, accountBank, bankCard, userId);
        } else {
            this.userCenterMapper.insertUserInfo(card, address, accountBank, bankCard, userId);
        }
        this.userCenterMapper.updateUserInfo(name, phone, userId, avatar);
    }

    public JSONObject queryUserNearFieldList(Integer offset, Integer limit, Double lng, Double lat, String regionCode, String userId, String fieldName, Integer cropSubId) {
        JSONObject json = new JSONObject();
        List list = this.userCenterMapper.queryUserNearFieldList(lng, lat, regionCode, offset, limit, userId, fieldName, cropSubId);
        if (regionCode != null && !regionCode.equals("")) {
            list.forEach(item -> {
                if (item.getRegionCode().contains(regionCode)) {
                    item.setStatus(Integer.valueOf(1));
                } else {
                    item.setStatus(Integer.valueOf(0));
                }
            });
        }
        Integer count = this.userCenterMapper.queryUserNearFieldCount(regionCode, userId, fieldName, cropSubId);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public List<FieldResultMap> queryFieldListByFormId(Integer relateId) {
        return this.userCenterMapper.queryFieldListByFormId(relateId);
    }

    public List<Company> queryFertilizerPassCompany() {
        List userIdList = this.subsidyReportFertilizerService.queryFertilizerPassCompany();
        return this.userCenterMapper.queryCompanyByUserIdList(userIdList);
    }

    public JSONObject queryFormRepresentedUserList(String name, Integer start, Integer pageSize) {
        Integer count = this.userCenterMapper.queryFormRepresentedUserCount(name);
        List userCenterList = this.userCenterMapper.queryFormRepresentedUserList(name, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)userCenterList);
        jsonObject.put("count", (Object)count);
        return jsonObject;
    }

    public JSONObject queryUserListBySearch(String search, Integer start, Integer pageSize) {
        List userCenterList = this.userCenterMapper.queryUserListBySearch(search, start, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)userCenterList);
        return jsonObject;
    }

    public List<LytUser> queryUserInfoByInfo(String phone, String name) {
        return this.userCenterMapper.queryUserInfoByInfo(phone, name);
    }
}

