/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.UserDataStatistics;
import com.farm.bean.UserDataStatisticsMap;
import com.farm.mapper.UserDataStatisticsMapper;
import com.farm.service.UserDataStatisticsService;
import com.farm.util.EasyExcelUtil;
import com.farm.util.RedisUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="userDataStatisticsService")
public class UserDataStatisticsServiceImpl
implements UserDataStatisticsService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserDataStatisticsMapper userDataStatisticsMapper;

    @Transactional
    public void insertUserDataStatistics(String userId, Integer statModule, Integer type) {
        Integer id;
        this.redisUtil.increaseValuesZSet("page_view", statModule + "," + type, Double.valueOf(1.0));
        this.redisUtil.putValuesSet(statModule + "," + type, new Object[]{userId});
        if (statModule == 0 && (id = this.userDataStatisticsMapper.queryUserLoginInfoByUserId(userId, type)) == null) {
            this.userDataStatisticsMapper.insertUserLoginInfo(userId, type);
            if (type == 1) {
                this.redisUtil.increaseStr("user_login_add", 1L);
            } else {
                this.redisUtil.increaseStr("user_login_add_zzd", 1L);
            }
        }
    }

    public List<UserDataStatistics> queryUserDataStatisticsPage(String startTime, String endTime, Integer type) {
        return this.getUserDataStatistics(startTime, endTime, type, Integer.valueOf(1));
    }

    public void exportUserDataStatistics(HttpServletResponse response, Integer type, String startTime, String endTime) throws IOException {
        List userDataStatisticsList = this.queryUserDataStatisticsPage(startTime, endTime, type);
        ArrayList userDataStatisticsMapList = new ArrayList();
        userDataStatisticsList.forEach(userDataStatistics -> {
            UserDataStatisticsMap userDataStatisticsMapOne = UserDataStatisticsMap.generateExportMap((UserDataStatistics)userDataStatistics);
            userDataStatisticsMapOne.setCreateTime(startTime.replace("-", ".") + "-" + endTime.replace("-", "."));
            userDataStatisticsMapList.add(userDataStatisticsMapOne);
        });
        EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u7528\u6237\u6570\u636e\u7edf\u8ba1", UserDataStatisticsMap.class, (String)"\u6570\u636e\u6c47\u603b", userDataStatisticsMapList);
    }

    public List<UserDataStatistics> queryUserDataStatisticsTrend(Integer type, String startTime, String endTime) {
        return this.getUserDataStatistics(startTime, endTime, type, Integer.valueOf(2));
    }

    public UserDataStatistics queryUserDataStatisticsGrandTotal(Integer type) {
        return this.userDataStatisticsMapper.queryUserDataStatisticsGrandTotal(type);
    }

    private List<UserDataStatistics> getUserDataStatistics(String startTime, String endTime, Integer type, Integer dataType) {
        List<Object> result = new ArrayList();
        String format = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        if (startTime.equals(endTime) && startTime.equals(format)) {
            Set pageViewSet = this.redisUtil.getZSetValue("page_view");
            for (Object item : pageViewSet) {
                Object obj;
                int userView = this.redisUtil.getSizeSet(item.toString()).intValue();
                int pageView = this.redisUtil.getZSetValueScore("page_view", item.toString()).intValue();
                List<String> list = Arrays.asList(item.toString().split(","));
                int userAddCount = 0;
                if (list.get(0).equals("0") && list.get(1).equals("1")) {
                    obj = this.redisUtil.getStr("user_login_add");
                    userAddCount = Integer.parseInt(obj == null ? "0" : obj.toString());
                } else if (list.get(0).equals("0") && list.get(1).equals("2")) {
                    obj = this.redisUtil.getStr("user_login_add_zzd");
                    userAddCount = Integer.parseInt(obj == null ? "0" : obj.toString());
                }
                if (Integer.parseInt(list.get(1)) != type) continue;
                result.add(new UserDataStatistics(Integer.valueOf(Integer.parseInt(list.get(0))), Integer.valueOf(pageView), Integer.valueOf(userView), Integer.valueOf(userAddCount), type, startTime));
            }
            result = result.stream().sorted(Comparator.comparing(UserDataStatistics::getStatModule)).collect(Collectors.toList());
        } else {
            result = dataType == 1 ? this.userDataStatisticsMapper.queryUserDataStatisticsPage(startTime, endTime, type) : this.userDataStatisticsMapper.queryUserDataStatisticsTrend(startTime, endTime, type);
        }
        return result;
    }
}

