/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.StringUtils;
import com.farm.bean.GrowthPeriod;
import com.farm.bean.PestControlInfo;
import com.farm.bean.PestControlRemind;
import com.farm.bean.PestRemindModel;
import com.farm.bean.resultMap.InsectArticleResultMap;
import com.farm.bean.resultMap.InsectCountDataResultMap;
import com.farm.bean.resultMap.InsectDeviceInfoResultMap;
import com.farm.bean.resultMap.InsectInfoResultMap;
import com.farm.bean.resultMap.InsectTrapperDataResultMap;
import com.farm.bean.resultMap.MessageCenterResultMap;
import com.farm.mapper.DoubleFieldFileMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.GrowthPeriodMapper;
import com.farm.mapper.InsectMapper;
import com.farm.mapper.MessageMapper;
import com.farm.mapper.PestControlMapper;
import com.farm.mapper.PestRemindMapper;
import com.farm.mapper.RecyclePointInfoMapper;
import com.farm.mapper.SubsidyFormInfoMapper;
import com.farm.mapper.UserDataStatisticsMapper;
import com.farm.util.HttpSendUtil;
import com.farm.util.RedisUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DataDealTask {
    private static final Logger log = LoggerFactory.getLogger(DataDealTask.class);
    @Autowired
    private DoubleFieldFileMapper doubleFieldFileMapper;
    @Autowired
    private InsectMapper insectMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Resource
    private SubsidyFormInfoMapper subsidyFormInfoMapper;
    @Resource
    private RecyclePointInfoMapper recyclePointInfoMapper;
    @Autowired
    private PestControlMapper pestControlMapper;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private GrowthPeriodMapper growthPeriodMapper;
    @Autowired
    private PestRemindMapper pestRemindMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserDataStatisticsMapper userDataStatisticsMapper;
    @Autowired
    private MessageMapper messageMapper;
    @Value(value="${farm.datasync}")
    private String datasyncUrl;
    private static String URL = "https://gview.zjtpyun.com/micros/api";
    private static String UUID = "lyzbdzdp";
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;

    public Boolean putLock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)("lym" + key), (Object)"", 2L, TimeUnit.SECONDS);
    }

    public void s1() throws Exception {
        Boolean flag = this.putLock("s1");
        if (!flag.booleanValue()) {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u76d1\u6d4b\u70b9\u3001\u6027\u8bf1\u5242\u8bbe\u5907");
            return;
        }
        String url = URL + "/api?action=com.top.gview.ViewDevice.list";
        JSONObject param = new JSONObject();
        param.put("uuid", (Object)UUID);
        String str = HttpSendUtil.postFormUrlEncoded((String)url, null, (String)("param=" + param.toJSONString()));
        JSONObject json = JSONObject.parseObject((String)str);
        JSONArray data = json.getJSONArray("data");
        ArrayList<InsectDeviceInfoResultMap> list = new ArrayList<InsectDeviceInfoResultMap>();
        for (int i = 0; i < data.size(); ++i) {
            JSONObject js = data.getJSONObject(i);
            InsectDeviceInfoResultMap id = new InsectDeviceInfoResultMap();
            id.setAreaCode(js.getString("area_code"));
            id.setDeviceName(js.getString("device_name"));
            id.setDeviceType(js.getInteger("device_type"));
            id.setLat(js.getString("lat"));
            id.setLng(js.getString("lng"));
            id.setViewDeviceId(js.getString("view_device_id"));
            id.setWlwDeviceId(js.getString("wlw_device_id"));
            id.setWlwLandId(js.getString("wlw_land_id"));
            list.add(id);
        }
        if (list.size() > 0) {
            this.doubleFieldFileMapper.insertInsectDeviceInfoList(list);
        }
    }

    @Scheduled(cron="0 0 0 * * ? ")
    public void s2() throws Exception {
        Boolean flag = this.putLock("s2");
        if (!flag.booleanValue()) {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u5b9a\u65f6\u901a\u77e5\u7f51\u683c\u957f\u5df2\u786e\u8ba4");
            return;
        }
        String url = URL + "?action=com.top.gview.ViewApi.openApi";
        Integer deviceType = 1;
        List deviceList = this.insectMapper.queryDeviceByType(deviceType);
        LocalDate ld = LocalDate.now();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyyMMdd");
        String endDate = ld.format(fmt);
        String startDate = ld.minusDays(1L).format(fmt);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<InsectInfoResultMap> list = new ArrayList<InsectInfoResultMap>();
        ArrayList<InsectCountDataResultMap> dList = new ArrayList<InsectCountDataResultMap>();
        for (String deviceId : deviceList) {
            JSONObject param = new JSONObject();
            param.put("api", (Object)"com.top.gview.ViewApi.device.insect.list");
            param.put("uuid", (Object)UUID);
            param.put("area_code", (Object)"330825");
            param.put("user_id", (Object)"1");
            param.put("device_id", (Object)deviceId);
            param.put("start_date", (Object)startDate);
            param.put("end_date", (Object)endDate);
            String str = HttpSendUtil.postFormUrlEncoded((String)url, null, (String)("param=" + param.toJSONString()));
            JSONObject json = JSONObject.parseObject((String)str);
            JSONArray result = json.getJSONObject("data").getJSONArray("result");
            for (int i = 0; i < result.size(); ++i) {
                JSONObject js = result.getJSONObject(i);
                InsectInfoResultMap ir = new InsectInfoResultMap();
                ir.setColor(js.getString("color"));
                ir.setInsectName(js.getString("insect_name"));
                ir.setInsectType(js.getInteger("insect_type"));
                list.add(ir);
                JSONArray data = js.getJSONArray("data");
                for (int j = 0; j < data.size(); ++j) {
                    JSONObject son = data.getJSONObject(j);
                    InsectCountDataResultMap ic = new InsectCountDataResultMap();
                    ic.setCount(son.getInteger("y"));
                    ic.setInsectType(js.getInteger("insect_type"));
                    date.setTime(son.getLongValue("x"));
                    ic.setRecordTime(sdf.format(date));
                    ic.setWlwDeviceId(Integer.valueOf(deviceId));
                    dList.add(ic);
                }
            }
        }
        if (list.size() >= 0) {
            this.insectMapper.insertInsectInfo(list);
        }
        if (dList.size() >= 0) {
            this.insectMapper.insertInsectCountData(dList);
        }
    }

    @Scheduled(cron="0 0 0/2 * * ? ")
    public void s3() throws Exception {
        Boolean flag = this.putLock("s3");
        if (!flag.booleanValue()) {
            log.error("\u672c\u673a\u4e0d\u6267\u884c \u67e5\u8be2\u4e00\u6bb5\u65f6\u95f4\u5185\u6bcf\u5929\u6027\u8bf1\u5242\u6355\u6349\u7684\u866b\u5b50\u6570\u91cf");
            return;
        }
        String url = URL + "?action=com.top.gview.ViewApi.openApi";
        LocalDate ld = LocalDate.now();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy/MM/dd");
        String start_date = ld.minusDays(300L).format(fmt);
        String end_date = ld.format(fmt);
        Integer deviceType = 2;
        List deviceList = this.insectMapper.queryDeviceByType(deviceType);
        ArrayList<InsectTrapperDataResultMap> list = new ArrayList<InsectTrapperDataResultMap>();
        for (String deviceId : deviceList) {
            JSONObject param = new JSONObject();
            param.put("api", (Object)"com.top.gview.ViewApi.trapper.listDailyCounts");
            param.put("uuid", (Object)UUID);
            param.put("area_code", (Object)"330825");
            param.put("user_id", (Object)"1");
            param.put("start_date", (Object)start_date);
            param.put("end_date", (Object)end_date);
            param.put("trapper_id", (Object)deviceId);
            String str = HttpSendUtil.postFormUrlEncoded((String)url, null, (String)("param=" + param.toJSONString()));
            JSONObject json = JSONObject.parseObject((String)str);
            JSONArray result = json.getJSONObject("data").getJSONArray("result");
            for (int i = 0; i < result.size(); ++i) {
                JSONObject js = result.getJSONObject(i);
                InsectTrapperDataResultMap it = new InsectTrapperDataResultMap();
                it.setCount(js.getInteger("dayCount"));
                it.setRecordTime(js.getString("date"));
                it.setWlwDeviceId(Integer.valueOf(deviceId));
                list.add(it);
            }
        }
        if (list.size() >= 0) {
            this.insectMapper.insertInsectTrapperData(list);
        }
    }

    public void s4() throws Exception {
        Boolean flag = this.putLock("s4");
        if (!flag.booleanValue()) {
            log.error("\u672c\u673a\u4e0d\u6267\u884c \u866b\u5bb3\u60c5\u62a5 ");
            return;
        }
        String url = URL + "?action=com.top.gview.ViewApi.openApi";
        JSONObject param = new JSONObject();
        param.put("api", (Object)"com.top.gview.ViewApi.ly.getInfoByUserId");
        param.put("uuid", (Object)UUID);
        param.put("user_id", (Object)"5454");
        String str = HttpSendUtil.postFormUrlEncoded((String)url, null, (String)("param=" + param.toJSONString()));
        JSONObject json = JSONObject.parseObject((String)str);
        JSONArray result = json.getJSONObject("data").getJSONArray("result");
        ArrayList<InsectArticleResultMap> list = new ArrayList<InsectArticleResultMap>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < result.size(); ++i) {
            JSONObject js = result.getJSONObject(i);
            InsectArticleResultMap ia = new InsectArticleResultMap();
            ia.setHappenTxt(js.getString("happenTxt"));
            ia.setHappenUrls(js.getString("happenUrls"));
            ia.setInfoId(js.getInteger("infoId"));
            ia.setIssueUnit(js.getString("punishUnit"));
            ia.setMedicalTxt(js.getString("medicalTxt"));
            ia.setMedicalUrls(js.getString("medicalUrls"));
            ia.setPreventTxt(js.getString("preventTxt"));
            ia.setPreventUrls(js.getString("preventUrls"));
            ia.setShowTime(format.format(new Date(js.getLongValue("punishTime"))));
            ia.setTitle(js.getString("infoName"));
            list.add(ia);
        }
        if (list.size() > 0) {
            this.doubleFieldFileMapper.insertInsectArticleList(list);
        }
    }

    @Scheduled(cron="0 0 1 * * ?")
    public void updatePublicToFinish() {
        Boolean flag = this.putLock("updatePublicToFinish");
        if (flag.booleanValue()) {
            List idList = this.subsidyFormInfoMapper.queryPublicFormInfoFinish();
            if (idList.size() > 0) {
                this.subsidyFormInfoMapper.updatePublicToFinish(idList);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("idList", (Object)idList);
                this.syncSubsidyFormField(jsonObject.toJSONString(), "/ly/subsidy/info/finish");
                idList.forEach(id -> this.subsidyFormInfoMapper.insertAuditLog(id, Integer.valueOf(5), Integer.valueOf(0), "", null));
            }
            log.info("\u672c\u673a\u6267\u884c\uff1a\u60e0\u519c\u8865\u8d34\u516c\u793a\u53d8\u66f4\u5df2\u5b8c\u6210");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u60e0\u519c\u8865\u8d34\u516c\u793a\u53d8\u66f4\u5df2\u5b8c\u6210");
        }
    }

    @Scheduled(cron="0 0 23 * * ?")
    public void statisticsPointInfo() {
        Boolean flag = this.putLock("statisticsPointInfo");
        if (flag.booleanValue()) {
            List recyclePointInfoList = this.recyclePointInfoMapper.queryAllPoint();
            this.recyclePointInfoMapper.insertStatisticsPointInfo(recyclePointInfoList);
            log.info("\u672c\u673a\u6267\u884c\uff1a\u7edf\u8ba1\u7ad9\u70b9\u7684\u56db\u79cd\u5e9f\u5f03\u7269\u73b0\u5b58\u91cf");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u7edf\u8ba1\u7ad9\u70b9\u7684\u56db\u79cd\u5e9f\u5f03\u7269\u73b0\u5b58\u91cf");
        }
    }

    @Scheduled(cron="0 30 23 * * ?")
    public void statisticsPestControlInfo() {
        Boolean flag = this.putLock("statisticsPestControlInfo");
        if (flag.booleanValue()) {
            List pestControlInfoList = this.pestControlMapper.queryAllPestControlInfo();
            if (pestControlInfoList.size() > 0) {
                this.pestControlMapper.insertStatistics(pestControlInfoList);
            }
            log.info("\u672c\u673a\u6267\u884c\uff1a\u7edf\u8ba1\u75c5\u866b\u5bb3\u5e93\u6570\u636e");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u7edf\u8ba1\u75c5\u866b\u5bb3\u5e93\u6570\u636e");
        }
    }

    public void generatePestRemindInfo() {
        Boolean flag = this.putLock("generatePestRemindInfo");
        if (flag.booleanValue()) {
            ArrayList pestRemindModelList = new ArrayList();
            List pestControlInfoList = this.pestControlMapper.queryPestControlInfoList();
            List<String> growthPeriodIdList = pestControlInfoList.stream().filter(pestControlInfo -> pestControlInfo.getGrowthPeriodId() != null).map(PestControlInfo::getGrowthPeriodId).collect(Collectors.toList());
            if (growthPeriodIdList.size() > 0) {
                growthPeriodIdList.forEach(growthPeriodId -> {
                    List<String> idList = Arrays.asList(growthPeriodId.split(","));
                    if (idList.size() < 1) {
                        return;
                    }
                    List growthPeriodList = this.growthPeriodMapper.queryGrowthPeriodByIdList(idList);
                    List cropTypeList = growthPeriodList.stream().map(GrowthPeriod::getCropType).collect(Collectors.toList());
                    if (cropTypeList.size() < 1) {
                        return;
                    }
                    List fieldDoubleStatusList = this.fieldDoubleStatusMapper.queryFieldDoubleStatusInfoByCropSubId(cropTypeList);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    fieldDoubleStatusList.forEach(fieldDoubleStatus -> {
                        if (fieldDoubleStatus.getSowTime() == null) {
                            return;
                        }
                        int days = 0;
                        try {
                            Date sowTime = sdf.parse(fieldDoubleStatus.getSowTime());
                            days = (int)((new Date().getTime() - sowTime.getTime()) / 86400000L);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        List list = this.growthPeriodMapper.queryGrowthPeriodByCropTypeAndDay(fieldDoubleStatus.getCropSubId(), Integer.valueOf(days));
                        if (list.size() > 0) {
                            List pestInfoIdList = this.pestControlMapper.queryPestInfoByGrowthPeriodId(((GrowthPeriod)list.get(0)).getId());
                            if (fieldDoubleStatus.getFieldPhone() != null && pestInfoIdList.size() > 0) {
                                pestRemindModelList.add(new PestRemindModel(fieldDoubleStatus.getFieldPhone(), fieldDoubleStatus.getId(), StringUtils.join((Collection)pestInfoIdList, (String)",")));
                            }
                        }
                    });
                    Map<String, List<PestRemindModel>> remindMap = pestRemindModelList.stream().collect(Collectors.groupingBy(PestRemindModel::getPhone));
                    remindMap.keySet().forEach(key -> {
                        List pestRemindModelList1 = (List)remindMap.get(key);
                        Map<String, List<PestRemindModel>> pestInfoMap = pestRemindModelList1.stream().collect(Collectors.groupingBy(PestRemindModel::getPestInfoId));
                        pestInfoMap.keySet().forEach(pestKey -> {
                            List fieldIdList;
                            String fieldIdString;
                            List pestRemindModelList2 = (List)pestInfoMap.get(pestKey);
                            String userId = this.pestRemindMapper.queryUserIdByPhone(key);
                            PestControlRemind pestControlRemind = this.pestRemindMapper.queryRemindByUserIdAndPestInfoId(userId, pestKey, fieldIdString = StringUtils.join(fieldIdList = pestRemindModelList2.stream().map(PestRemindModel::getFieldId).collect(Collectors.toList()), (String)","));
                            if (pestControlRemind == null) {
                                this.pestRemindMapper.insertRemind(userId, pestKey, fieldIdString);
                            }
                        });
                    });
                });
            }
            log.info("\u672c\u673a\u6267\u884c\uff1a\u75c5\u866b\u5bb3\u63d0\u9192");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u75c5\u866b\u5bb3\u63d0\u9192");
        }
    }

    @Scheduled(cron="0 30 23 * * ?")
    public void statisticsUserData() {
        Boolean flag = this.putLock("statisticsUserData");
        if (flag.booleanValue()) {
            HashMap<String, String> map1 = new HashMap<String, String>();
            HashMap<String, String> map2 = new HashMap<String, String>();
            for (int i = 0; i < 5; ++i) {
                map1.put(i + "", "1");
                map2.put(i + "", "2");
            }
            map2.put("5", "2");
            Set pageViewSet = this.redisUtil.getZSetValue("page_view");
            if (pageViewSet.size() > 0) {
                pageViewSet.forEach(item -> {
                    Long userView = this.redisUtil.getSizeSet(item.toString());
                    Double pageView = this.redisUtil.getZSetValueScore("page_view", item.toString());
                    List<String> stringList = Arrays.asList(item.toString().split(","));
                    int userAddCount = 0;
                    if (stringList.get(0).equals("0") && stringList.get(1).equals("1")) {
                        Object str = this.redisUtil.getStr("user_login_add");
                        userAddCount = str == null ? 0 : Integer.parseInt(str.toString());
                    } else if (stringList.get(0).equals("0") && stringList.get(1).equals("2")) {
                        Object str = this.redisUtil.getStr("user_login_add_zzd");
                        userAddCount = str == null ? 0 : Integer.parseInt(str.toString());
                    }
                    map1.remove(stringList.get(0), stringList.get(1));
                    map2.remove(stringList.get(0), stringList.get(1));
                    this.userDataStatisticsMapper.insertDataStatistics(stringList.get(0), pageView, userView, Integer.valueOf(userAddCount), stringList.get(1));
                    this.redisUtil.del(new String[]{item.toString()});
                });
                this.redisUtil.del(new String[]{"page_view", "user_login_add", "user_login_add_zzd"});
                log.info("\u672c\u673a\u6267\u884c\uff1a\u7edf\u8ba1\u7528\u6237\u6570\u636e");
            }
            if (map1.size() > 0) {
                map1.keySet().forEach(key -> this.userDataStatisticsMapper.insertDataStatistics(key, Double.valueOf(0.0), Long.valueOf(0L), Integer.valueOf(0), (String)map1.get(key)));
            }
            if (map2.size() > 0) {
                map2.keySet().forEach(key -> this.userDataStatisticsMapper.insertDataStatistics(key, Double.valueOf(0.0), Long.valueOf(0L), Integer.valueOf(0), (String)map2.get(key)));
            }
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u7edf\u8ba1\u7528\u6237\u6570\u636e");
        }
    }

    @Scheduled(cron="0 0/30 * * * ?")
    public void syncWeatherMsg() throws IOException {
        Boolean flag = this.putLock("syncWeatherMsg");
        if (flag.booleanValue()) {
            MessageCenterResultMap messageCenterResultMap = this.messageMapper.queryWeatherMsgNewest();
            String url = this.farmServerUrl + "messagecenter/list/region?regionName=\u9f99\u6e38&type=20011&createTime=" + messageCenterResultMap.getCreateTime();
            String result = HttpSendUtil.sendHttpGet((String)url.replace(" ", "%20"));
            JSONArray resData = JSONObject.parseObject((String)result).getJSONArray("resData");
            ArrayList messageCenterResultMapList = new ArrayList();
            resData.forEach(item -> {
                JSONObject jsonObject = JSONObject.parseObject((String)item.toString());
                MessageCenterResultMap resultMap = MessageCenterResultMap.generateResultMap((JSONObject)jsonObject);
                resultMap.setRelationType(Integer.valueOf(3));
                messageCenterResultMapList.add(resultMap);
            });
            if (messageCenterResultMapList.size() > 0) {
                this.messageMapper.insertWeatherMsgBatch(messageCenterResultMapList);
            }
            log.info("\u672c\u673a\u6267\u884c\uff1a\u540c\u6b65\u6167\u79cd\u7530\u9f99\u6e38\u5929\u6c14\u9884\u8b66");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u540c\u6b65\u6167\u79cd\u7530\u9f99\u6e38\u5929\u6c14\u9884\u8b66");
        }
    }

    private void syncSubsidyFormField(String jsonStr, String url) {
        try {
            HttpSendUtil.sendHttpPost((String)(this.datasyncUrl + url), (String)"", (String)"", (String)jsonStr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String url = "https://gview.zjtpyun.com/micros/api/api?action=com.top.gview.ViewDevice.list";
        JSONObject param = new JSONObject();
        param.put("uuid", (Object)UUID);
        String str = HttpSendUtil.postFormUrlEncoded((String)url, null, (String)("param=" + param.toJSONString()));
        System.out.println(str);
    }
}

