/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.springframework.web.multipart.MultipartFile;

public class Base64ToMulti
implements MultipartFile {
    private String suffix;
    private byte[] content;
    private String contentType;

    public Base64ToMulti(String base64) {
        String[] data = base64.split(",");
        this.content = Base64.getDecoder().decode(data[1].getBytes());
        this.suffix = data[0].split(";")[0].split("/")[1];
        this.contentType = data[0].split(";")[0].split(":")[1];
    }

    public Base64ToMulti(String base64, String suffix, String contentType) {
        this.content = Base64.getDecoder().decode(base64.getBytes());
        this.suffix = suffix;
        this.contentType = contentType;
    }

    public String getName() {
        return "temp_" + System.currentTimeMillis();
    }

    public String getOriginalFilename() {
        return "temp_" + System.currentTimeMillis() + "." + this.suffix;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content == null || this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File file) throws IOException, IllegalStateException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(this.content);
        }
    }

    public static MultipartFile getMultipartFile(String base64) {
        return new Base64ToMulti(base64);
    }

    public static MultipartFile getMultipartFile(String base64, String suffix, String contentType) {
        return new Base64ToMulti(base64, suffix, contentType);
    }
}

