/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.nacos.common.utils.StringUtils;
import com.farm.util.EasyExcelValidateHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExpertListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelExpertListener.class);
    private static final int BATCH_COUNT = 1000;
    private final List<T> list = new ArrayList();
    private String errMsg = null;

    public void invoke(T data, AnalysisContext context) {
        try {
            this.errMsg = EasyExcelValidateHelper.validateEntity(data);
        }
        catch (Exception e) {
            log.error("import valid error:{}", (Object)e.getMessage());
            this.errMsg = "\u89e3\u6790\u6570\u636e\u51fa\u9519";
        }
        if (StringUtils.isNotBlank((String)this.errMsg)) {
            throw new ExcelAnalysisStopException();
        }
        this.list.add(data);
        if (this.list.size() >= 1000) {
            this.errMsg = "\u6700\u5927\u9650\u5ea6:1000\u6761,\u8bf7\u5206\u6279\u5bfc\u5165";
            throw new ExcelAnalysisStopException();
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<T> getList() {
        return this.list;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

