/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    public static <T> List<T> importExcelByInputStream(InputStream inputStream, Integer titleRows, Integer headerRows, Class<T> pojoClass) throws Exception {
        if (inputStream == null) {
            return null;
        }
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        List list = null;
        list = ExcelImportUtil.importExcel((InputStream)inputStream, pojoClass, (ImportParams)params);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportListData(HttpServletRequest request, HttpServletResponse response, Object data, String exportFileName, String modelFile) {
        ServletOutputStream out = null;
        InputStream fileInputStream = null;
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        XSSFWorkbook workbook = null;
        try {
            out = response.getOutputStream();
            response.setContentType("mutipart/form-data");
            response.setCharacterEncoding("utf-8");
            LocalDateTime now = LocalDateTime.now();
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(exportFileName + ".xlsx", "UTF-8"));
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("model/" + modelFile + ".xlsx");
            bos = new ByteArrayOutputStream();
            workbook = new XSSFWorkbook(fileInputStream);
            workbook.write((OutputStream)bos);
            byte[] bArray = bos.toByteArray();
            is = new ByteArrayInputStream(bArray);
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)out).withTemplate(is).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((Integer)0).build();
            excelWriter.fill(data, writeSheet);
            excelWriter.finish();
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                is.close();
                bos.close();
                out.close();
                workbook.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

