/*
 * Decompiled with CFR 0.152.
 */
package com.farm.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.farm.bean.LytUser;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);
    private static final String SECRET = "lyt_secret";
    private static final long EXPIRATION = 3600L;

    public static String createToken(LytUser user) {
        Date expireDate = new Date(System.currentTimeMillis() + 3600000L);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alg", "HS256");
        map.put("typ", "JWT");
        String token = JWT.create().withHeader(map).withClaim("mobile", user.getMobile()).withExpiresAt(expireDate).withIssuedAt(new Date()).sign(Algorithm.HMAC256((String)SECRET));
        return token;
    }

    public static Map<String, Claim> verifyToken(String token) {
        DecodedJWT jwt = null;
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET)).build();
            jwt = verifier.verify(token);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error("token\u89e3\u7801\u5f02\u5e38");
            return null;
        }
        return jwt.getClaims();
    }
}

