/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.farm.config.BeanCopyUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public interface BaseMapperPlus<M, T, V>
extends BaseMapper<T> {
    public static final Log log = LogFactory.getLog(BaseMapperPlus.class);
    public static final int DEFAULT_BATCH_SIZE = 1000;

    default public Class<V> currentVoClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapperPlus.class, (int)2);
    }

    default public Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapperPlus.class, (int)1);
    }

    default public Class<M> currentMapperClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), BaseMapperPlus.class, (int)0);
    }

    default public List<T> selectList() {
        return this.selectList((Wrapper)new QueryWrapper());
    }

    default public boolean insertBatch(Collection<T> entityList) {
        return this.insertBatch(entityList, 1000);
    }

    default public boolean updateBatchById(Collection<T> entityList) {
        return this.updateBatchById(entityList, 1000);
    }

    default public boolean insertOrUpdateBatch(Collection<T> entityList) {
        return this.insertOrUpdateBatch(entityList, 1000);
    }

    default public boolean insertBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement((Class)this.currentMapperClass(), (SqlMethod)SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch((Class)this.currentModelClass(), (Log)log, entityList, (int)batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    default public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = SqlHelper.getSqlStatement((Class)this.currentMapperClass(), (SqlMethod)SqlMethod.UPDATE_BY_ID);
        return SqlHelper.executeBatch((Class)this.currentModelClass(), (Log)log, entityList, (int)batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    default public boolean insertOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.currentModelClass());
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return SqlHelper.saveOrUpdateBatch((Class)this.currentModelClass(), (Class)this.currentMapperClass(), (Log)log, entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
            String sqlStatement = SqlHelper.getSqlStatement((Class)this.currentMapperClass(), (SqlMethod)SqlMethod.SELECT_BY_ID);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(sqlStatement, entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            String sqlStatement = SqlHelper.getSqlStatement((Class)this.currentMapperClass(), (SqlMethod)SqlMethod.UPDATE_BY_ID);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    default public boolean insertOrUpdate(T entity) {
        if (null != entity) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.currentModelClass());
            Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
            Object idVal = tableInfo.getPropertyValue(entity, tableInfo.getKeyProperty());
            return StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.selectById((Serializable)idVal)) ? this.insert(entity) > 0 : this.updateById(entity) > 0;
        }
        return false;
    }

    default public V selectVoById(Serializable id) {
        return (V)this.selectVoById(id, this.currentVoClass());
    }

    default public <C> C selectVoById(Serializable id, Class<C> voClass) {
        Object obj = this.selectById(id);
        if (ObjectUtil.isNull((Object)obj)) {
            return null;
        }
        return (C)BeanCopyUtils.copy((Object)obj, voClass);
    }

    default public List<V> selectVoBatchIds(Collection<? extends Serializable> idList) {
        return this.selectVoBatchIds(idList, this.currentVoClass());
    }

    default public <C> List<C> selectVoBatchIds(Collection<? extends Serializable> idList, Class<C> voClass) {
        List list = this.selectBatchIds(idList);
        if (CollUtil.isEmpty((Collection)list)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return BeanCopyUtils.copyList((List)list, voClass);
    }

    default public List<V> selectVoByMap(Map<String, Object> map) {
        return this.selectVoByMap(map, this.currentVoClass());
    }

    default public <C> List<C> selectVoByMap(Map<String, Object> map, Class<C> voClass) {
        List list = this.selectByMap(map);
        if (CollUtil.isEmpty((Collection)list)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return BeanCopyUtils.copyList((List)list, voClass);
    }

    default public V selectVoOne(Wrapper<T> wrapper) {
        return (V)this.selectVoOne(wrapper, this.currentVoClass());
    }

    default public <C> C selectVoOne(Wrapper<T> wrapper, Class<C> voClass) {
        Object obj = this.selectOne(wrapper);
        if (ObjectUtil.isNull((Object)obj)) {
            return null;
        }
        return (C)BeanCopyUtils.copy((Object)obj, voClass);
    }

    default public List<V> selectVoList(Wrapper<T> wrapper) {
        return this.selectVoList(wrapper, this.currentVoClass());
    }

    default public <C> List<C> selectVoList(Wrapper<T> wrapper, Class<C> voClass) {
        List list = this.selectList(wrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return BeanCopyUtils.copyList((List)list, voClass);
    }

    default public <P extends IPage<V>> P selectVoPage(IPage<T> page, Wrapper<T> wrapper) {
        return (P)this.selectVoPage(page, wrapper, this.currentVoClass());
    }

    default public <C, P extends IPage<C>> P selectVoPage(IPage<T> page, Wrapper<T> wrapper, Class<C> voClass) {
        IPage pageData = this.selectPage(page, wrapper);
        Page voPage = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        if (CollUtil.isEmpty((Collection)pageData.getRecords())) {
            return (P)voPage;
        }
        voPage.setRecords(BeanCopyUtils.copyList((List)pageData.getRecords(), voClass));
        return (P)voPage;
    }
}

