/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.farm.config.BeanCopyUtils;
import com.farm.util.StreamUtils;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeanCopyUtils {
    public static <T, V> V copy(T source, Class<V> desc) {
        if (ObjectUtil.isNull(source)) {
            return null;
        }
        if (ObjectUtil.isNull(desc)) {
            return null;
        }
        Object target = ReflectUtil.newInstanceIfPossible(desc);
        return (V)BeanCopyUtils.copy(source, (Object)target);
    }

    public static <T, V> V copy(T source, V desc) {
        if (ObjectUtil.isNull(source)) {
            return null;
        }
        if (ObjectUtil.isNull(desc)) {
            return null;
        }
        BeanCopier beanCopier = BeanCopierCache.INSTANCE.get(source.getClass(), desc.getClass(), null);
        beanCopier.copy(source, desc, null);
        return desc;
    }

    public static <T, V> List<V> copyList(List<T> sourceList, Class<V> desc) {
        if (ObjectUtil.isNull(sourceList)) {
            return null;
        }
        if (CollUtil.isEmpty(sourceList)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return StreamUtils.toList(sourceList, source -> {
            Object target = ReflectUtil.newInstanceIfPossible((Class)desc);
            BeanCopyUtils.copy((Object)source, (Object)target);
            return target;
        });
    }

    public static <T> Map<String, Object> copyToMap(T bean) {
        if (ObjectUtil.isNull(bean)) {
            return null;
        }
        return BeanMap.create(bean);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (ObjectUtil.isNull(beanClass)) {
            return null;
        }
        Object bean = ReflectUtil.newInstanceIfPossible(beanClass);
        return (T)BeanCopyUtils.mapToBean(map, (Object)bean);
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        if (ObjectUtil.isNull(bean)) {
            return null;
        }
        BeanMap.create(bean).putAll(map);
        return bean;
    }

    private BeanCopyUtils() {
    }
}

