/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config.excelhandler;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CustomSheetWriteHandler
implements SheetWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomSheetWriteHandler.class);
    private Map<Integer, List<String>> map = new HashMap();
    private int index;

    private CustomSheetWriteHandler() {
    }

    public CustomSheetWriteHandler(List<JSONObject> list) {
        this.index = 0;
        list.forEach(item -> {
            Integer index1 = item.getInteger("index");
            JSONArray array = item.getJSONArray("datas");
            List datas = null;
            if (array != null && !array.isEmpty()) {
                datas = JSON.parseArray((String)JSONObject.toJSONString((Object)array), String.class);
                this.map.put(index1, datas);
            }
        });
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        DataValidationHelper helper = writeSheetHolder.getSheet().getDataValidationHelper();
        this.map.forEach((k, v) -> {
            Workbook workbook = writeWorkbookHolder.getWorkbook();
            String sheetName = "sheet_" + k;
            Sheet proviceSheet = workbook.createSheet(sheetName);
            ++this.index;
            workbook.setSheetHidden(this.index, true);
            int length = v.size();
            for (int i = 0; i < length; ++i) {
                proviceSheet.createRow(i).createCell(0).setCellValue((String)v.get(i));
            }
            Name category1Name = workbook.createName();
            category1Name.setNameName(sheetName);
            category1Name.setRefersToFormula(sheetName + "!$A$1:$A$" + v.size());
            CellRangeAddressList addressList = new CellRangeAddressList(1, 65535, k.intValue(), k.intValue());
            DataValidationConstraint constraint8 = helper.createFormulaListConstraint(sheetName);
            DataValidation dataValidation3 = helper.createValidation(constraint8, addressList);
            dataValidation3.setErrorStyle(0);
            dataValidation3.setShowErrorBox(true);
            dataValidation3.setSuppressDropDownArrow(true);
            dataValidation3.createErrorBox("\u63d0\u793a", "\u6b64\u503c\u4e0e\u5355\u5143\u683c\u5b9a\u4e49\u683c\u5f0f\u4e0d\u4e00\u81f4");
            writeSheetHolder.getSheet().addValidationData(dataValidation3);
        });
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        String sheetName = "sheet999";
        Sheet proviceSheet = workbook.createSheet(sheetName);
        ++this.index;
        workbook.setSheetHidden(this.index, true);
    }
}

