/*
 * Decompiled with CFR 0.152.
 */
package com.farm.config.excelhandler;

import cn.hutool.core.lang.Validator;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExcelListenerForField<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelListenerForField.class);
    public List<JSONObject> list = new ArrayList();
    private Class toClass;
    private List<String> fieldList = new ArrayList();
    private JSONObject modelObject = new JSONObject();

    public List<String> getFieldList() {
        return this.fieldList;
    }

    private void init() {
        Field[] fields;
        for (Field field : fields = this.toClass.getDeclaredFields()) {
            this.fieldList.add(field.getName());
            this.modelObject.put(field.getName(), (Object)"");
        }
    }

    private ExcelListenerForField() {
    }

    public ExcelListenerForField(Class c) {
        this.toClass = c;
        this.init();
    }

    public void invoke(T data, AnalysisContext context) {
        JSONObject object = JSONObject.parseObject((String)JSON.toJSONString(data));
        DecimalFormat df = new DecimalFormat("0.##");
        JSONObject newJson = JSONObject.parseObject((String)this.modelObject.toJSONString());
        this.fieldList.forEach(f -> {
            if (!Objects.isNull(object.get(f)) && Validator.isNumber((CharSequence)object.get(f).toString())) {
                newJson.put(f, (Object)(object.get(f) == null ? "" : df.format(Double.parseDouble(object.get(f).toString()))));
            } else {
                newJson.put(f, (Object)(object.get(f) == null ? "" : object.get(f).toString()));
            }
        });
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)newJson.toJSONString());
        this.list.add(newJson);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

