/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import cn.hutool.core.codec.Base64;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DoubleLabelResultMap;
import com.farm.bean.GridUserInfo;
import com.farm.bean.LytUser;
import com.farm.bean.SysOperLog;
import com.farm.service.ConfigService;
import com.farm.service.LytUserService;
import com.farm.service.OperLogService;
import com.farm.service.OrganService;
import com.farm.service.RoleService;
import com.farm.util.JwtUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@Api(tags={"\u9f99\u6e38\u901a\u7528\u6237\u76f8\u5173"})
public class AppUserInfoController {
    private static final Logger log = LoggerFactory.getLogger(AppUserInfoController.class);
    @Value(value="${farm.companyId}")
    private Integer companyId;
    @Autowired
    private LytUserService lytUserService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganService organService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private OperLogService operLogService;

    @GetMapping(value={"/token"})
    @ApiOperation(value="\u83b7\u53d6\u9f99\u6e38\u901atoken")
    public Object queryToken() {
        String token = this.lytUserService.queryToken();
        JSONObject result = new JSONObject();
        result.put("token", (Object)token);
        return ResultVo.success((Object)result);
    }

    @GetMapping(value={"/test"})
    public String getMapping(String name) {
        return name;
    }

    @GetMapping(value={"/getUserInfo"})
    @ApiOperation(value="\u6839\u636eappUserId\u83b7\u53d6\u7528\u6237\u57fa\u7840\u4fe1\u606f")
    public Object getUserInfo(@RequestParam(value="appUserId") String appUserId, HttpServletResponse response) throws IOException {
        String token = this.lytUserService.queryToken();
        LytUser lytUser = this.lytUserService.queryLytAppUserInfo(appUserId, token);
        return ResultVo.success((Object)lytUser);
    }

    @PostMapping(value={"/login-pc"})
    public Object loginBackend(@RequestParam(value="phone") String phone, @RequestParam(value="userName") String userName) {
        JSONObject json = new JSONObject();
        String decodedPhone = Base64.decodeStr((CharSequence)phone);
        log.info("\u89e3\u7801\u540e\u7684phone\uff1a" + decodedPhone);
        phone = decodedPhone;
        String decodedUserName = Base64.decodeStr((CharSequence)userName);
        log.info("\u89e3\u7801\u540e\u7684userName\uff1a" + decodedUserName);
        userName = decodedUserName;
        LytUser lytUser = this.lytUserService.queryUserAllInfoByPhoneOrName(phone, userName);
        Set recodeList = this.lytUserService.queryUserRegionList(lytUser.getUserId());
        String loginToken = UUID.randomUUID().toString();
        json.put("lytUser", (Object)lytUser);
        json.put("regionCodes", (Object)recodeList);
        json.put("companyId", (Object)this.companyId);
        json.put("loginToken", (Object)loginToken);
        String jwtToken = JwtUtil.createToken((LytUser)lytUser);
        json.put("jwtToken", (Object)jwtToken);
        this.stringRedisTemplate.opsForValue().set((Object)("loginToken" + lytUser.getMobile()), (Object)loginToken, 72L, TimeUnit.HOURS);
        return ResultVo.success((Object)json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/login-check"})
    @ApiOperation(value="\u767b\u5f55\u6709\u6548\u671f\u76d1\u6d4b")
    public Object checkLoginFlag(@RequestBody String body) {
        JSONObject resJson = new JSONObject();
        JSONObject json = null;
        try {
            json = JSONObject.parseObject((String)body);
            String phone = json.getString("mobile");
            String token = json.getString("loginToken");
            String loginUUID = (String)this.stringRedisTemplate.opsForValue().get((Object)("loginToken" + phone));
            if (Objects.equals(loginUUID, token)) {
                resJson.put("flag", (Object)1);
            }
            resJson.put("flag", (Object)0);
            resJson.put("loginUrl", (Object)"https://lytapi.longyou.gov.cn/man/sxsf/farm_lyt/organ/index.html#/");
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u662f\u5426\u767b\u5f55\u62a5\u9519\uff1a", (Object)e.getMessage());
            resJson.put("flag", (Object)0);
            resJson.put("loginUrl", (Object)"https://lytapi.longyou.gov.cn/man/sxsf/farm_lyt/organ/index.html#/");
        }
        finally {
            return ResultVo.success((Object)resJson);
        }
    }

    @PostMapping(value={"/login"})
    @ApiOperation(value="\u7528\u6237\u624b\u673a\u53f7\u514d\u5bc6\u767b\u5f55\u63a5\u53e3")
    public Object loginByPhone(@RequestParam(value="phone") String phone, @RequestParam(value="appUserId", required=false, defaultValue="") String appUserId, HttpServletRequest request) {
        GridUserInfo gridUser;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LytUser lytUser = this.lytUserService.queryUserAllInfoByPhone(phone, "");
        if (lytUser == null) {
            String token = this.lytUserService.queryToken();
            lytUser = this.lytUserService.queryLytAppUserInfo(appUserId, token);
        }
        List roleList = lytUser.getRoleList();
        JSONObject json = new JSONObject();
        Set roleLevelSet = this.lytUserService.queryUserLevel(lytUser.getUserId(), roleList);
        Set recodeList = this.lytUserService.queryUserRegionList(lytUser.getUserId());
        if (roleLevelSet.contains(0)) {
            recodeList.add("330825");
        }
        if ((gridUser = this.lytUserService.queryGridUserByPhone(phone)) != null && StringUtils.isNotBlank((String)gridUser.getGridCode())) {
            json.put("gridRegionCode", (Object)gridUser.getGridCode());
        }
        JSONObject landlordJson = this.lytUserService.queryLandlordByPhone(phone);
        Integer roleLevel = (Integer)roleLevelSet.stream().min(Integer::compareTo).get();
        json.put("roleLevel", (Object)roleLevel);
        json.put("recodeList", (Object)recodeList);
        json.put("companyId", (Object)this.companyId);
        json.put("userInfo", (Object)lytUser);
        json.put("landlord", (Object)landlordJson);
        stopWatch.stop();
        try {
            SysOperLog sysOperLog = new SysOperLog();
            sysOperLog.setTitle("\u767b\u5f55");
            sysOperLog.setBusinessType(Integer.valueOf(0));
            sysOperLog.setRequestMethod("POST");
            sysOperLog.setMethod("AppUserInfoController.loginByPhone()");
            sysOperLog.setOperatorType(Integer.valueOf(2));
            sysOperLog.setOperName("");
            sysOperLog.setOperUrl("/farm_lyt/user/login");
            sysOperLog.setOperIp(request.getRemoteAddr());
            sysOperLog.setOperParam("{phone:" + phone + "},{appUserId:" + appUserId + "}");
            sysOperLog.setJsonResult(json.toJSONString());
            sysOperLog.setStatus(Integer.valueOf(0));
            sysOperLog.setOperTime(new Date());
            this.operLogService.insertOperlog(sysOperLog);
            sysOperLog.setOperParam("");
            sysOperLog.setJsonResult("");
            log.error("lyzhln\u64cd\u4f5c\u65e5\u5fd7:" + sysOperLog.toString() + ",\u8017\u65f6\uff1a" + stopWatch.getTime());
        }
        catch (Exception e) {
            log.error("\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25");
        }
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/gridUser"})
    @ApiOperation(value="\u83b7\u53d6\u7f51\u683c\u5458\u4fe1\u606f\u5217\u8868")
    public Object queryGridUserList(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) throws IOException {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.lytUserService.queryGridUserList(regionCode, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/gridUser"})
    @ApiOperation(value="\u5206\u914d\u7f51\u683c\u5458\u4fe1\u606f")
    public Object postGridUser(@RequestBody String body) throws IOException {
        JSONObject json = JSONObject.parseObject((String)body);
        GridUserInfo gridUserInfo = (GridUserInfo)json.toJavaObject(GridUserInfo.class);
        JSONObject resJson = this.lytUserService.postGridUser(gridUserInfo);
        return ResultVo.success((Object)resJson);
    }

    @GetMapping(value={"/region/detail"})
    @ApiOperation(value="\u7ec4\u7ec7\u67b6\u6784\u70b9\u51fb\u83b7\u53d6\u7528\u6237\u8be6\u60c5")
    public Object queryUserDetail(@RequestParam(value="userId") String userId) {
        JSONObject json = new JSONObject();
        LytUser lytUser = this.lytUserService.queryUserAllInfoByUserId(userId);
        Set roleLevelSet = this.lytUserService.queryUserLevel(lytUser.getUserId(), lytUser.getRoleList());
        Set recodeList = this.lytUserService.queryUserRegionList(lytUser.getUserId());
        LinkedList<DoubleLabelResultMap> list = new LinkedList<DoubleLabelResultMap>();
        for (String code : recodeList) {
            String regionName = this.configService.queryDetailAddress(code);
            DoubleLabelResultMap it = new DoubleLabelResultMap(code, regionName);
            list.add(it);
        }
        GridUserInfo gridUser = this.lytUserService.queryGridUserByPhone(lytUser.getMobile());
        json.put("gridUser", (Object)gridUser);
        json.put("user", (Object)lytUser);
        json.put("roleLevelSet", (Object)roleLevelSet);
        json.put("regionList", list);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/region/post"})
    @ApiOperation(value="\u7ed9\u7528\u6237\u5206\u914d\u533a\u57df\uff0c\u89d2\u8272\uff0c\u7ec4\u7ec7\u67b6\u6784")
    public Object postUserDetail(@RequestBody String body) {
        JSONArray orgArray;
        JSONArray roleArray;
        JSONObject json = JSONObject.parseObject((String)body);
        String userId = json.getString("userId");
        if (json.containsKey((Object)"userName")) {
            String userName = json.getString("userName");
            LytUser lytUser = new LytUser();
            lytUser.setUserId(userId);
            lytUser.setUserName(userName);
            this.lytUserService.updateUserInfo(lytUser);
        }
        if (json.containsKey((Object)"gridUser")) {
            GridUserInfo gridUser = (GridUserInfo)json.getJSONObject("gridUser").toJavaObject(GridUserInfo.class);
            this.lytUserService.postGridUser(gridUser);
        } else {
            this.lytUserService.delGridUser(userId);
        }
        if (json.containsKey((Object)"roleUser") && (roleArray = json.getJSONArray("roleUser")).size() > 0) {
            this.roleService.postRoleUser(roleArray, userId);
        }
        if (json.containsKey((Object)"organization") && (orgArray = json.getJSONArray("organization")).size() > 0) {
            this.organService.upsertOrgUser(orgArray, userId);
        }
        if (json.containsKey((Object)"manageArea")) {
            JSONArray areaArray = json.getJSONArray("manageArea");
            if (areaArray.size() > 0) {
                this.lytUserService.delUserArea(userId);
                this.lytUserService.insertOrUpdateUserArea(areaArray, userId);
            } else {
                this.lytUserService.delUserArea(userId);
            }
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u7528\u6237\u5206\u914d\u533a\u57df\uff0c\u89d2\u8272\uff0c\u7ec4\u7ec7\u67b6\u6784")
    public Object addUserDetail(@RequestBody String body) {
        String userId;
        String avatar;
        String userName;
        JSONObject resJson = new JSONObject();
        JSONObject json = JSONObject.parseObject((String)body);
        String mobile = json.getString("mobile");
        LytUser lytUser = this.lytUserService.upSertLytUser(mobile, userName = json.getString("userName"), avatar = json.getString("avatar"), userId = "sx" + mobile);
        if (!lytUser.getUserId().equals(userId)) {
            resJson.put("success", (Object)0);
            return ResultVo.success((Object)resJson);
        }
        if (json.containsKey((Object)"gridUser")) {
            GridUserInfo gridUser = (GridUserInfo)json.getJSONObject("gridUser").toJavaObject(GridUserInfo.class);
            this.lytUserService.postGridUser(gridUser);
        }
        if (json.containsKey((Object)"roleUser")) {
            JSONArray roleArray = json.getJSONArray("roleUser");
            this.roleService.postRoleUser(roleArray, userId);
        }
        if (json.containsKey((Object)"organization")) {
            JSONArray orgArray = json.getJSONArray("organization");
            this.organService.upsertOrgUser(orgArray, userId);
        }
        if (json.containsKey((Object)"manageArea")) {
            JSONArray areaArray = json.getJSONArray("manageArea");
            this.lytUserService.insertOrUpdateUserArea(areaArray, userId);
        }
        resJson.put("success", (Object)1);
        return ResultVo.success((Object)resJson);
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237")
    public Object delUser(@RequestParam String userId) {
        this.lytUserService.delUser(userId);
        return ResultVo.success();
    }

    @GetMapping(value={"/loginFirstFlag"})
    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u662f\u5426\u9996\u6b21\u767b\u5f55")
    public Object queryUserFirstLoginFlag(@RequestParam String phone) {
        Boolean loginFlag = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)("login" + phone), (Object)"1");
        JSONObject json = new JSONObject();
        json.put("flag", (Object)loginFlag);
        return ResultVo.success((Object)json);
    }
}

