/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.ZnmFarmer;
import com.farm.bean.ZnmField;
import com.farm.bean.resultMap.ZnmFieldResultMap;
import com.farm.service.ConfigService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import com.farm.util.ZnmUtil;
import com.qiniu.http.Response;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/config"})
@RestController
@Api(tags={"\u516c\u5171\u63a5\u53e3"})
@RefreshScope
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private final UploadManager uploadManager;
    private final Auth auth;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value(value="${qiniu.bucket}")
    private String bucket;
    @Value(value="${qiniu.ip}")
    private String addressIp;
    @Value(value="${qiniu.prefix}")
    private String prefix;
    private StringMap putPolicy;
    @Value(value="${farm.serverUrl}")
    private String serverUrl;
    @Value(value="${farm.esUrl}")
    private String esUrl;
    private String appKey = "42bac59996324003b3af0ecbe9d9100d";
    private String secretKey = "afb283553bec49898c0a999d0f3a4475";
    @Autowired
    private ConfigService configService;
    @Value(value="${farm.companyId}")
    private Integer companyId;
    @Autowired
    private MongoTemplate mongoTemplate;
    private List<String> pictureSuffixList = Arrays.asList("JPG", "JPEG", "PNG", "GIF", "BMP", "TIFF", "SVG", "WEBP", "PSD", "ICON", "jpg", "jpeg", "png", "gif", "bmp", "tiff", "svg", "webp", "psd", "icon", "mp4", "avi", "mov", "wmv", "mkv", "flv", "rmvb", "MP4", "AVI", "MOV", "WMV", "MKV", "FLV", "RMVB");
    @Autowired
    private ZnmUtil znmUtil;

    @Autowired
    public ConfigController(UploadManager uploadManager, Auth auth) {
        this.uploadManager = uploadManager;
        this.auth = auth;
    }

    private String getUploadToken() {
        return this.auth.uploadToken(this.bucket, null, 3600L, this.putPolicy);
    }

    @GetMapping(value={"/health"})
    public ResultVo queryHealth() {
        return ResultVo.success();
    }

    @GetMapping(value={"/all"})
    public Object queryAllConfig() {
        JSONObject json = new JSONObject();
        json.put("company", (Object)this.companyId);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/yun"}, consumes={"multipart/form-data"})
    @CrossOrigin
    @ApiOperation(value="\u56fe\u7247\u4e0a\u4f20\u63a5\u53e3")
    public Object uploadYunFile(@RequestParam(value="file") MultipartFile file, @RequestParam(required=false, value="path", defaultValue="common") String path) throws IOException {
        if (file.isEmpty()) {
            return ResultVo.error();
        }
        String originalFilename = file.getOriginalFilename();
        String fileSuffix = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
        if (!this.pictureSuffixList.contains(fileSuffix)) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u7684\u540e\u7f00\uff1a{} \u4e0d\u652f\u6301\uff01\u5141\u8bb8\u4e0a\u4f20\u56fe\u7247/\u89c6\u9891\u7c7b\u578b", (Object)fileSuffix);
            return ResultVo.error((String)"\u53ea\u5141\u8bb8\u4e0a\u4f20\u56fe\u7247/\u89c6\u9891\u7c7b\u578b");
        }
        StringBuffer fileName0 = new StringBuffer(this.prefix);
        fileName0.append("ly").append(path).append("/").append(RandomUtils.nextInt()).append(LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8))).append(originalFilename.substring(originalFilename.indexOf(".")));
        try {
            Response response = this.uploadManager.put(file.getBytes(), fileName0.toString(), this.getUploadToken());
            for (int retry = 0; response.needRetry() && retry < 3; ++retry) {
                response = this.uploadManager.put(file.getBytes(), fileName0.toString(), this.getUploadToken());
            }
            if (response.isOK()) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.bodyString());
                String yunFileName = jsonObject.getString("key");
                String yunFilePath = this.addressIp + yunFileName;
                log.info("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)yunFilePath);
                JSONObject result = new JSONObject();
                result.put("url", (Object)yunFilePath);
                return ResultVo.success((Object)result);
            }
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            return ResultVo.error();
        }
        catch (IOException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)System.getProperty("user.dir"));
            return ResultVo.error();
        }
    }

    public String uploadFileBytes(byte[] fileBytes) {
        String yunFilePath = "";
        StringBuffer fileName0 = new StringBuffer(this.prefix);
        fileName0.append("/lyzzd/").append(RandomUtils.nextInt()).append(LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8))).append(".jpg");
        try {
            Response response = this.uploadManager.put(fileBytes, fileName0.toString(), this.getUploadToken());
            for (int retry = 0; response.needRetry() && retry < 2; ++retry) {
                response = this.uploadManager.put(fileBytes, fileName0.toString(), this.getUploadToken());
            }
            if (response.isOK()) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.bodyString());
                String yunFileName = jsonObject.getString("key");
                yunFilePath = this.addressIp + yunFileName;
                return yunFilePath;
            }
            log.error("\u3010\u6d59\u653f\u9489\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            return yunFilePath;
        }
        catch (IOException e) {
            return yunFilePath;
        }
    }

    @CrossOrigin
    @PostMapping(value={"/uploadBase64"})
    public ResultVo uploadBase64(@RequestBody String body) {
        JSONObject obj = JSONObject.parseObject((String)body);
        String base64 = obj.getString("base64");
        String fileName = obj.getString("fileName");
        String path = obj.getString("path");
        StringBuilder lyFileName = new StringBuilder(this.prefix).append("ly").append(path).append("/").append(RandomUtils.nextInt()).append(LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8))).append(fileName);
        try {
            Response response = this.uploadManager.put(Base64Utils.decodeFromString((String)base64), lyFileName.toString(), this.getUploadToken());
            for (int retry = 0; response.needRetry() && retry < 1; ++retry) {
                response = this.uploadManager.put(Base64Utils.decodeFromString((String)base64), lyFileName.toString(), this.getUploadToken());
            }
            if (response.isOK()) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.bodyString());
                String yunFileName = jsonObject.getString("key");
                String yunFilePath = this.addressIp + yunFileName;
                log.info("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)yunFilePath);
                JSONObject result = new JSONObject();
                result.put("url", (Object)yunFilePath);
                return ResultVo.success((Object)result);
            }
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            return ResultVo.error();
        }
        catch (IOException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)System.getProperty("user.dir"));
            return ResultVo.error();
        }
    }

    @PostMapping(value={"/common/post-body"})
    public Object sendCommonPost1(@RequestBody Map<String, Object> body) throws Exception {
        String url = body.get("url").toString();
        String requestBody = "";
        if (body.containsKey("body")) {
            requestBody = body.get("body").toString();
        }
        String requestParam = "";
        if (body.containsKey("params")) {
            JSONObject paramJson = JSONObject.parseObject((String)body.get("params").toString());
            StringBuffer paramStr = new StringBuffer();
            Set keySet = paramJson.keySet();
            for (String key : keySet) {
                paramStr.append(key).append("=").append(URLEncoder.encode(paramJson.get((Object)key).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            requestParam = "?" + paramStr.toString();
        }
        String response = HttpSendUtil.sendHttpPost((String)this.serverUrl, (String)url, (String)requestParam, (String)requestBody);
        return response;
    }

    @PostMapping(value={"/common/post"})
    public Object sendCommonPost(@RequestBody Map<String, Object> body, @RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuffer paramStr = new StringBuffer();
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.parseObject((String)params);
            Set keySet = paramJson.keySet();
            for (String key : keySet) {
                paramStr.append(key).append("=").append(URLEncoder.encode(paramJson.get((Object)key).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            params = paramStr.toString();
        }
        String response = HttpSendUtil.sendHttpPost((String)this.serverUrl, (String)url, (String)params, (String)JSONObject.toJSONString(body));
        return response;
    }

    @GetMapping(value={"/common/get"})
    @ApiOperation(value="server-get\u8f6c\u53d1\u63a5\u53e3")
    public Object sendCommonGet(@RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuffer paramStr = new StringBuffer(this.serverUrl);
        paramStr.append(url);
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.parseObject((String)params);
            Set keySet = paramJson.keySet();
            for (String key : keySet) {
                paramStr.append(key).append("=").append(URLEncoder.encode(paramJson.get((Object)key).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            url = paramStr.toString();
        }
        String response = HttpSendUtil.sendHttpGet((String)url);
        return response;
    }

    @GetMapping(value={"/common-es/get"})
    @ApiOperation(value="es-get\u8f6c\u53d1\u63a5\u53e3")
    public Object sendCommonEsGet(@RequestParam(value="params", required=false, defaultValue="") String params, @RequestParam(value="url") String url) throws Exception {
        StringBuffer paramStr = new StringBuffer(this.esUrl);
        paramStr.append(url);
        if (!StringUtils.isEmpty((Object)params)) {
            paramStr.append("?");
            params = URLDecoder.decode(params, "UTF-8");
            JSONObject paramJson = JSONObject.parseObject((String)params);
            Set keySet = paramJson.keySet();
            for (String key : keySet) {
                paramStr.append(key).append("=").append(URLEncoder.encode(paramJson.get((Object)key).toString(), "UTF-8")).append("&");
            }
            paramStr.append("hash=").append("x");
            url = paramStr.toString();
        }
        String response = HttpSendUtil.sendHttpGet((String)url);
        return response;
    }

    @GetMapping(value={"/ly-token"})
    @ApiOperation(value="\u9f99\u6e38\u653f\u52a1\u7cfb\u7edf\u83b7\u53d6token-1\u8bf7\u6c42\u7b2c\u4e09\u65b9/0\u7f13\u5b58")
    public Object queryLyFieldToken(@RequestParam(required=false, defaultValue="0") Integer flag) {
        String token = this.configService.queryLyFieldToken(this.appKey, this.secretKey, flag);
        JSONObject json = new JSONObject();
        json.put("token", (Object)token);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/ly-field"})
    @ApiOperation(value="\u9f99\u6e38\u653f\u52a1\u7cfb\u7edf\u83b7\u53d6\u786e\u6743\u571f\u5730\u63a5\u53e3")
    public Object queryLyField(@RequestParam(value="flag", required=false, defaultValue="0") Integer flag, @RequestParam(value="page", required=false, defaultValue="1") String page, @RequestParam(value="dkbm", required=false, defaultValue="3308251112") String dkbm) {
        Long timeSecond = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String md5Key = this.configService.queryLyFieldToken(this.appKey, this.secretKey, flag);
        String sign = this.appKey + md5Key + timeSecond;
        String md5 = DigestUtils.md5DigestAsHex((byte[])sign.getBytes()).toLowerCase();
        StringBuffer params = new StringBuffer();
        params.append("?dkbm=").append(dkbm).append("&pageNum=").append(page).append("&appKey=").append(this.appKey).append("&sign=").append(md5).append("&requestTime=").append(timeSecond.toString());
        String response = HttpSendUtil.sendHttpGet((String)("http://dw.qz.gov.cn/gateway/api/001008013007/dataSharing/7rcF0V8y74bG59cf.htm" + params.toString()));
        return JSONObject.parseObject((String)response);
    }

    @GetMapping(value={"/ly-post"})
    @ApiOperation(value="\u901a\u7528\u8f6c\u53d1\u83b7\u53d6\u9f99\u6e38\u901a\u7684\u6570\u636e\u63a5\u53e3")
    public Object queryLyField1(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        String url = json.getString("url");
        String response = HttpSendUtil.sendHttpGet((String)url);
        return JSONObject.parseObject((String)response);
    }

    @GetMapping(value={"/ly-region"})
    @ApiOperation(value="\u83b7\u53d6\u9f99\u6e38\u901a\u7684\u533a\u57df-\u9012\u5f52")
    public Object queryAreaByRegion(@RequestParam(value="regionCode", defaultValue="330825", required=false) String regionCode) {
        JSONObject json = this.configService.queryAreaByRegionLoop(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/dataReq"})
    @ApiOperation(value="\u6570\u636e\u90e8\u95e8\u8bf7\u6c42")
    public Object sendDataReq(@RequestParam(value="url", defaultValue="/lyFieldDates?format=json", required=false) String url) {
        String response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083" + url));
        JSONObject json = JSONObject.parseObject((String)response);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/downRegion"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u7ea7\u533a\u57df")
    public Object queryDownRegion(@RequestParam(value="regionCode", defaultValue="330825", required=false) String regionCode) {
        JSONObject json = this.configService.queryDownRegion(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/downRegionBoundary"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u7ea7\u533a\u57df\u8fb9\u754c")
    public Object queryDownRegionBoundary(@RequestParam(value="regionCode", defaultValue="330825", required=false) String regionCode) {
        Criteria criteria = Criteria.where((String)"adcode").is((Object)regionCode);
        Query query = new Query((CriteriaDefinition)criteria);
        JSONObject json = (JSONObject)this.mongoTemplate.findOne(query, JSONObject.class, "district");
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/downloadFieldZnm"})
    @ApiOperation(value="\u7530\u5757\u6d59\u519c\u7801\u7533\u8bf7\u4e0b\u8f7d")
    public Object downloadZnm(Integer fieldId) {
        List fieldInfoList = this.configService.queryFieldInfo(fieldId);
        if (CollectionUtils.isEmpty((Collection)fieldInfoList)) {
            return ResultVo.success((Object)"\u4e0d\u7b26\u5408\u7533\u8bf7\u7801\u9700\u6c42");
        }
        ZnmFieldResultMap fieldInfo = (ZnmFieldResultMap)fieldInfoList.get(0);
        String yunPicUrl = "";
        ZnmField znmField = this.configService.queryZnmByFieldId(fieldId);
        if (znmField != null) {
            return ResultVo.success((Object)znmField.getUrl());
        }
        String dkbm = fieldInfo.getDkbm();
        String farmerName = fieldInfo.getFarmerName();
        String fieldName = fieldInfo.getFieldName();
        String znmBatchId = this.znmUtil.znmFieldCodeApply(dkbm, farmerName, fieldName);
        String znm = this.znmUtil.downQrCodeList(dkbm);
        yunPicUrl = this.uploadYunFileBase64(znm, znmBatchId);
        this.configService.upsertZnmField(dkbm, znmBatchId, yunPicUrl, fieldId, farmerName, fieldName);
        return ResultVo.success((Object)yunPicUrl);
    }

    @GetMapping(value={"/downloadFarmerZnm"})
    @ApiOperation(value="\u519c\u6237\u6d59\u519c\u7801\u7533\u8bf7\u4e0b\u8f7d")
    public Object downloadZnm(String address, String identityCard, String farmerName, String phone, String regionCode) {
        ZnmFarmer farmer = this.configService.queryByIdentityCard(identityCard);
        if (farmer != null) {
            return ResultVo.success((Object)farmer.getUrl());
        }
        String znmBatchId = this.znmUtil.znmFarmerCodeApply(address, identityCard, farmerName, phone, regionCode);
        String znm = this.znmUtil.downQrCodeList(identityCard);
        String yunPicUrl = this.uploadYunFileBase64(znm, znmBatchId);
        farmer = ZnmFarmer.builder().identityCard(identityCard).farmerName(farmerName).znmBatchId(znmBatchId).url(yunPicUrl).phone(phone).build();
        this.configService.insertZnmFarmer(farmer);
        return ResultVo.success((Object)yunPicUrl);
    }

    @PostMapping(value={"/upload-base64"})
    @ApiOperation(value="base64\u4e0a\u4f20")
    public String uploadYunFileBase64(String base64, String picName) {
        StringBuffer fileName = new StringBuffer(this.prefix);
        fileName.append("ly/znm/").append(System.currentTimeMillis()).append(picName).append(".png");
        try {
            Response response = this.uploadManager.put(Base64Utils.decodeFromString((String)base64), fileName.toString(), this.getUploadToken());
            for (int retry = 0; response.needRetry() && retry < 1; ++retry) {
                response = this.uploadManager.put(Base64Utils.decodeFromString((String)base64), fileName.toString(), this.getUploadToken());
            }
            if (response.isOK()) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.bodyString());
                String yunFileName = jsonObject.getString("key");
                String yunFilePath = this.addressIp + yunFileName;
                log.info("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)yunFilePath);
                return yunFilePath;
            }
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            return "";
        }
        catch (IOException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)System.getProperty("user.dir"));
            return "";
        }
    }
}

