/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.farm.bean.FertilizationPlan;
import com.farm.bean.excelEntrty.DiFei;
import com.farm.bean.excelEntrty.FertilizationPlanExcel;
import com.farm.bean.excelEntrty.NongHu;
import com.farm.bean.excelEntrty.ZhongZhi;
import com.farm.bean.excelEntrty.ZuiFei;
import com.farm.bean.resultMap.FieldDSExcelResultMap;
import com.farm.handler.ExcelColumnWidthHandler;
import com.farm.handler.MultiHeadDataListener;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.service.ConfigService;
import com.farm.service.DownloadService;
import com.farm.service.FertilizationPlanService;
import com.farm.util.ExportUtil2;
import com.farm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/excel"})
@RestController
@Api(value="Excel\u8868\u683c\u5de5\u5177")
public class ExcelController {
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private ConfigService configService;
    @Autowired
    private FertilizationPlanService fertilizationPlanService;

    @GetMapping(value={"/out/field-status1"})
    @ApiOperation(value="\u5bfc\u51fa\u7530\u5757\u5b9e\u65f6\u72b6\u6001-\u5168\u90e8\u5b57\u6bb5")
    public void download(HttpServletResponse response, @RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u7530\u5757\u5b9e\u65f6\u72b6\u6001\u7edf\u8ba1\u8868" + LocalDate.now().toString(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), FieldDSExcelResultMap.class).sheet("\u7530\u5757\u5b9e\u65f6\u72b6\u6001\u7edf\u8ba1\u8868").doWrite((Collection)this.fieldStatusData(regionCode));
    }

    private List<FieldDSExcelResultMap> fieldStatusData(String regionCode) {
        Integer count = this.fieldDoubleStatusMapper.queryCountByRegion(regionCode);
        Integer pages = count / 1000;
        LinkedList<FieldDSExcelResultMap> list = new LinkedList<FieldDSExcelResultMap>();
        List tranList = new ArrayList();
        if (count > 0) {
            for (int i = 0; i < pages + 1; ++i) {
                tranList = this.fieldDoubleStatusMapper.queryFieldStatusSummaryList(regionCode, i * 1000, 1000);
                for (FieldDSExcelResultMap it : tranList) {
                    it.setHamlet(this.configService.queryHamletAddress(it.getRegionCode()));
                    it.setTown(this.configService.queryTownAddress(it.getRegionCode()));
                }
                list.addAll(tranList);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/out/field-status"})
    @ApiOperation(value="\u5bfc\u51fa\u7530\u5757\u5b9e\u65f6\u72b6\u6001")
    public void downloadFdStatusByColumns(HttpServletResponse response, @RequestParam(value="regionCode", required=false, defaultValue="330825111") String regionCode, @RequestParam(value="columns", required=false, defaultValue="") String columns) throws IOException {
        LinkedHashMap<String, String> headMap = new LinkedHashMap<String, String>();
        headMap.put("name", "\u7530\u540d\u79f0");
        headMap.put("address", "\u7530\u5757\u5730\u5740");
        headMap.put("area", "\u4ea9\u6570");
        headMap.put("town", "\u6240\u5c5e\u9547");
        headMap.put("hamlet", "\u6240\u5c5e\u6751");
        headMap.put("gridUserName", "\u7f51\u683c\u5458");
        headMap.put("ownerName", "\u786e\u6743\u519c\u6237");
        headMap.put("phone", "\u519c\u6237\u624b\u673a\u53f7");
        headMap.put("createDate", "\u521b\u5efa\u65e5\u671f");
        headMap.put("idenDate", "\u786e\u8ba4\u65e5\u671f");
        headMap.put("fixDate", "\u6574\u6539\u65e5\u671f");
        headMap.put("status", "\u5f53\u524d\u72b6\u6001");
        headMap.put("cropName", "\u5f53\u524d\u79cd\u690d\u4f5c\u7269");
        headMap.put("areaType", "\u7530\u5757\u6240\u5c5e\u533a\u57df");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u7530\u5757\u5b9e\u65f6\u72b6\u6001\u7edf\u8ba1\u8868" + LocalDate.now().toString(), "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        HashSet<String> excludeColumnFiledNames = new HashSet<String>();
        for (String column : headMap.keySet()) {
            if (columns.indexOf(column) >= 0) continue;
            excludeColumnFiledNames.add(column);
        }
        ExcelWriter excelWriter = null;
        try {
            excelWriter = ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), FieldDSExcelResultMap.class).excludeColumnFiledNames(excludeColumnFiledNames)).head(this.fieldStatusDataByColumnHead(columns, headMap))).registerWriteHandler((WriteHandler)new ExcelColumnWidthHandler())).build();
            WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u7530\u5757\u5b9e\u65f6\u72b6\u6001\u7edf\u8ba1\u8868").build();
            excelWriter.write((Collection)this.fieldStatusDataByColumn(regionCode, columns), writeSheet);
        }
        finally {
            if (excelWriter != null) {
                excelWriter.finish();
            }
        }
    }

    private List<FieldDSExcelResultMap> fieldStatusDataByColumn(String regionCode, String columns) {
        String columnSql = "ds.regionCode,ds.".concat(columns.replace(",", ",ds."));
        if (columnSql.indexOf("hamlet") > -1) {
            columnSql = columnSql.replace("ds.hamlet,", "").replace(",ds.hamlet", "");
        }
        if (columnSql.indexOf("town") > -1) {
            columnSql = columnSql.replace("ds.town,", "").replace(",ds.town", "");
        }
        LinkedList<FieldDSExcelResultMap> list = new LinkedList<FieldDSExcelResultMap>();
        List tranList = new ArrayList();
        tranList = this.fieldDoubleStatusMapper.queryFieldStatusSummaryListByColumn(regionCode, 0, 60000, columnSql);
        if (columns.indexOf("hamlet") > -1 && columns.indexOf("town") > -1) {
            tranList.forEach(it -> {
                it.setHamlet(this.configService.queryHamletAddress(it.getRegionCode()));
                it.setTown(this.configService.queryTownAddress(it.getRegionCode()));
            });
        } else if (columns.indexOf("hamlet") > -1) {
            tranList.forEach(it -> it.setHamlet(this.configService.queryHamletAddress(it.getRegionCode())));
        } else if (columns.indexOf("town") > -1) {
            tranList.forEach(it -> it.setTown(this.configService.queryTownAddress(it.getRegionCode())));
        }
        if (columns.indexOf("areaType") > -1) {
            tranList.forEach(it -> it.setAreaType(this.calAreaType(it.getAreaType())));
        }
        list.addAll(tranList);
        return list;
    }

    private String calAreaType(String areaType) {
        if (areaType.contains("0")) {
            return "\u7cae\u98df\u529f\u80fd\u533a";
        }
        if (areaType.contains("1")) {
            return "\u6c38\u4e45\u519c\u7530\u533a";
        }
        if (areaType.contains("2")) {
            return "\u4e00\u822c\u8015\u5730";
        }
        return "\u5176\u4ed6";
    }

    private List<List<String>> fieldStatusDataByColumnHead(String columns, Map<String, String> headMap) {
        String[] array = columns.split(",");
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (String head : array) {
            ArrayList<String> headList = new ArrayList<String>();
            headList.add(headMap.get(head));
            list.add(headList);
        }
        return list;
    }

    @GetMapping(value={"/exportAllFertilizationPlan"})
    @ApiOperation(value="\u4e0b\u8f7d\u65bd\u80a5\u65b9\u6848", notes="\u4e0b\u8f7d\u65bd\u80a5\u65b9\u6848")
    public void exportAllFertilizationPlan(HttpServletResponse response) {
        List list = this.fertilizationPlanService.exportAllFertilizationPlan();
        if (list != null) {
            String column = "id,orderNum";
            if (StringUtils.isNotEmpty((String)column)) {
                List<String> columns = Arrays.asList(column.split(","));
                ExportUtil2.exportExcel((HttpServletResponse)response, FertilizationPlan.class, (String)"\u65bd\u80a5\u65b9\u6848", (List)list, columns);
            } else {
                ExportUtil2.exportExcel((HttpServletResponse)response, FertilizationPlan.class, (String)"\u65bd\u80a5\u65b9\u6848", (List)list);
            }
        }
    }

    @GetMapping(value={"/exportFertilizationPlan"})
    @ApiOperation(value="\u4e0b\u8f7d\u65bd\u80a5\u65b9\u6848\uff0c\u6700\u8fd1\u4e00\u6b21", notes="\u4e0b\u8f7d\u65bd\u80a5\u65b9\u6848\uff0c\u6700\u8fd1\u4e00\u6b21")
    public void exportFertilizationPlan(HttpServletResponse response) {
        List list = this.fertilizationPlanService.exportFertilizationPlan();
        if (list != null) {
            String column = "id,orderNum";
            if (StringUtils.isNotEmpty((String)column)) {
                List<String> columns = Arrays.asList(column.split(","));
                ExportUtil2.exportExcel((HttpServletResponse)response, FertilizationPlan.class, (String)"\u65bd\u80a5\u65b9\u6848", (List)list, columns);
            } else {
                ExportUtil2.exportExcel((HttpServletResponse)response, FertilizationPlan.class, (String)"\u65bd\u80a5\u65b9\u6848", (List)list);
            }
        }
    }

    @GetMapping(value={"/downInChargeOfTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u672c\u5730excel\u6a21\u7248", notes="\u4e0b\u8f7d\u672c\u5730excel\u6a21\u7248")
    public void downInChargeOfTemplate(HttpServletResponse response, String fileName) {
        this.downloadService.downInChargeOfTemplate(response, fileName);
    }

    @PostMapping(value={"/importExcel"})
    @ApiOperation(value="\u5927\u5c4f\u65bd\u80a5\u65b9\u6848\u6570\u636e\u5bfc\u5165")
    public void importExcel(@RequestParam(value="file") MultipartFile file, String type) {
        try {
            switch (type) {
                case "fertilizationPlan": {
                    EasyExcel.read((InputStream)file.getInputStream(), FertilizationPlanExcel.class, (ReadListener)new MultiHeadDataListener()).sheet().doRead();
                    break;
                }
                case "nongHu": {
                    EasyExcel.read((InputStream)file.getInputStream(), NongHu.class, (ReadListener)new MultiHeadDataListener()).sheet().doRead();
                    break;
                }
                case "zhongZhi": {
                    EasyExcel.read((InputStream)file.getInputStream(), ZhongZhi.class, (ReadListener)new MultiHeadDataListener()).sheet().doRead();
                    break;
                }
                case "diFei": {
                    EasyExcel.read((InputStream)file.getInputStream(), DiFei.class, (ReadListener)new MultiHeadDataListener()).sheet().doRead();
                    break;
                }
                case "zuiFei": {
                    EasyExcel.read((InputStream)file.getInputStream(), ZuiFei.class, (ReadListener)new MultiHeadDataListener()).sheet().doRead();
                    break;
                }
                default: {
                    throw new RuntimeException("\u672a\u627e\u5230\u9002\u914d\u7684\u6a21\u7248\uff01");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

