/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DoubleFieldFile;
import com.farm.bean.FieldDoubleHistoryLog;
import com.farm.bean.FieldDoubleHistoryPic;
import com.farm.bean.FieldDoubleStatisticsNew;
import com.farm.bean.FieldDoubleStatus;
import com.farm.bean.FieldGridRecord;
import com.farm.service.FieldDoubleStatusService;
import com.farm.service.RegionStatusAreaService;
import com.farm.util.HttpSendUtil;
import com.farm.util.LngLatUtil;
import com.farm.util.MD5Util;
import com.farm.util.RedisUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/field"})
@Api(tags={"\u4e24\u975e\u6a21\u5757"})
public class FieldDoubleStatusController {
    private static final Logger log = LoggerFactory.getLogger(FieldDoubleStatusController.class);
    @Resource
    private FieldDoubleStatusService fieldDoubleStatusService;
    @Resource
    private RegionStatusAreaService regionStatusAreaService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisUtil redisUtil;
    private static final String appKey = "A330825404623202107016691";
    private static final String appSecret = "1f60c1c1209b42879220da0ce8bb3154";
    private static final String REQUEST_SECRET = "requestSecret";

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5927\u5c4f\u533a\u57df\u5185\u786e\u6743\u7530\u5757\u5217\u8868")
    public Object queryList(@RequestParam Integer companyId, @RequestParam(defaultValue="", required=false, value="types") String types, @RequestParam(value="statusTypes", required=false, defaultValue="") String statusTypes, @RequestParam(defaultValue="", required=false, value="regionCode") String regionCode, @RequestParam(value="areaType", required=false, defaultValue="") String areaType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="") Integer pageSize) {
        ArrayList typeList = types.equals("") ? new ArrayList() : Arrays.stream(types.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        ArrayList statusTypeList = statusTypes.equals("") ? new ArrayList() : Arrays.stream(statusTypes.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryListByCompanyId(companyId, start, pageSize, typeList, regionCode, areaType, statusTypeList);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/list-distance"})
    @ApiOperation(value="\u8ddd\u79bb\u67e5\u8be2-\u5927\u5c4f\u786e\u6743\u7530\u5757\u5217\u8868")
    public Object queryNearList(@RequestParam Double lng, @RequestParam Double lat, @RequestParam(defaultValue="", required=false, value="regionCode") String regionCode, @RequestParam(defaultValue="0,1,2,3,4", required=false, value="types") String types, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        List typeList = Arrays.stream(types.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        JSONObject json = new JSONObject();
        Point point = new Point(lng.doubleValue(), lat.doubleValue());
        Criteria criteria = Criteria.where((String)"location").near(point);
        criteria.and("status").in(typeList);
        if (StringUtils.isNotBlank((String)regionCode)) {
            criteria.and("region_code").is((Object)regionCode);
        }
        Query query = Query.query((CriteriaDefinition)criteria);
        query.with((Pageable)PageRequest.of((int)(page - 1), (int)pageSize));
        query.fields().exclude("_id");
        List list = this.mongoTemplate.find(query, JSONObject.class, "t_field_double_status");
        json.put("list", (Object)list);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/gridUserList"})
    @ApiOperation(value="\u7f51\u683c\u5458\u4eba\u5458\u5217\u8868")
    public Object queryGridUserList(@RequestParam Integer companyId, @RequestParam(value="regionCode", required=false, defaultValue="") String regionCode, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        Integer start = 0;
        if (pageSize != null) {
            start = (page - 1) * pageSize;
        }
        JSONObject json = this.fieldDoubleStatusService.queryGridUserList(companyId, start, pageSize, regionCode);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="\u4e24\u975e\u72b6\u6001\u6307\u5b9a\u7f51\u683c\u5458")
    public Object queryGridUserList(@RequestParam Integer id, @RequestParam String name, @RequestParam Integer userId) {
        FieldDoubleStatus fieldDoubleStatus = new FieldDoubleStatus();
        fieldDoubleStatus.setId(id);
        fieldDoubleStatus.setGridUserId(userId);
        fieldDoubleStatus.setGridUserName(name);
        fieldDoubleStatus = this.fieldDoubleStatusService.update(fieldDoubleStatus);
        Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)id);
        Query query = Query.query((CriteriaDefinition)criteria);
        this.mongoTemplate.upsert(query, Update.update((String)"grid_user_id", (Object)userId), "t_field_double_status");
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u5355\u4e2a\u533a\u57df\u5b9e\u65f6\u4e24\u975e\u8be6\u60c5")
    public Object queryList(@RequestParam Integer id) {
        JSONObject json = this.fieldDoubleStatusService.queryById(id);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/rectify-upload-img"})
    @ApiOperation(value="\u4e0a\u4f20\u7530\u5757\u6574\u6539\u56fe\u7247")
    public ResultVo uploadImgToFieldHistoryLog(@RequestBody String body) {
        FieldDoubleHistoryPic fieldDoubleHistoryPic = (FieldDoubleHistoryPic)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FieldDoubleHistoryPic.class);
        this.fieldDoubleStatusService.uploadImgToFieldHistoryLog(fieldDoubleHistoryPic);
        return ResultVo.success();
    }

    @GetMapping(value={"/rectify-img"})
    @ApiOperation(value="\u67e5\u8be2\u7530\u5757\u6574\u6539\u56fe\u7247")
    public ResultVo queryFieldRectifyImg(@RequestParam(value="fieldId") Integer fieldId, @RequestParam(value="historyId") Integer historyId) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldRectifyImg(fieldId, historyId));
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u4e24\u975e\u5386\u53f2\u5220\u9664")
    public Object delete(@RequestParam(value="idList") List<Integer> idList) {
        this.fieldDoubleStatusService.removeByIds(idList);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary-status"})
    @ApiOperation(value="h5-\u67e5\u8be2\u5f53\u524d\u533a\u57df\u7530\u5757\u6570\u636e\u6c47\u603b")
    public Object queryFieldSummaryByUserId(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="areaType", required=false, defaultValue="0") Integer areaType) {
        JSONObject result = this.fieldDoubleStatusService.queryFieldSummaryByRegionCode(regionCode, areaType);
        return ResultVo.success((Object)result);
    }

    @GetMapping(value={"/list-double"})
    @ApiOperation(value="h5-\u4e24\u975e\u7530\u5757\u5217\u8868\u67e5\u8be2")
    public Object queryDoubleUserFieldList(@RequestParam Integer companyId, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="type", required=false, defaultValue="1") Integer type, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryDoubleUserFieldList(companyId, start, pageSize, userId, type, search);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/listByGrid"})
    @ApiOperation(value="h5-\u6839\u636e\u7f51\u683c\u533a\u57df\u67e5\u8be2\u4e24\u975e\u7530\u5757\u5217\u8868")
    public Object queryDoubleFieldListByRegion(@RequestParam(value="regionCode", required=false, defaultValue="") String regionCode, @RequestParam(value="type", required=false, defaultValue="1") Integer type, @RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryDoubleFieldListByRegion(start, pageSize, type, regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/list-double/distance"})
    @ApiOperation(value="h5-\u8ddd\u79bb\u4e24\u975e\u7530\u5757\u5217\u8868\u67e5\u8be2")
    public Object queryDoubleUserFieldList(@RequestParam Double lng, @RequestParam Double lat, @RequestParam String regionCode, @RequestParam(value="areaType", required=false, defaultValue="") Integer areaType, @RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="type", required=false, defaultValue="1") Integer type, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="searchType", required=false, defaultValue="0") Integer searchType) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = new JSONObject();
        json = searchType == 0 ? this.fieldDoubleStatusService.queryDoubleUserFieldListByStatus(lng, lat, regionCode, areaType, type, start, pageSize) : this.fieldDoubleStatusService.queryDoubleUserFieldListByStatus1(regionCode, areaType, type, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/double/post"})
    @ApiOperation(value="h5-\u4e24\u975e\u533a\u57df\u6570\u636e\u786e\u8ba4")
    public Object postDoubleField(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        FieldDoubleHistoryLog log = (FieldDoubleHistoryLog)json.toJavaObject(FieldDoubleHistoryLog.class);
        if (log.getId() == null) {
            this.fieldDoubleStatusService.postDoubleField(log);
        } else {
            this.fieldDoubleStatusService.updateDoubleField(log);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/double/m-list"})
    @ApiOperation(value="h5-\u4e24\u975e\u95ee\u9898\u7edf\u8ba1")
    public Object queryDFStatusByCode(@RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="regionCode") String regionCode) {
        JSONObject json = new JSONObject();
        List fieldList = new LinkedList();
        JSONObject landJson = new JSONObject();
        List noRlandList = new LinkedList();
        List noFlandList = new LinkedList();
        if (type == 0) {
            noFlandList = this.fieldDoubleStatusService.queryDFLandTypeByCode(regionCode, Integer.valueOf(4));
            noRlandList = this.fieldDoubleStatusService.queryDFLandTypeByCode(regionCode, Integer.valueOf(5));
            List<Integer> iStatusList = Arrays.asList(4, 5, 6);
            fieldList = this.fieldDoubleStatusService.queryFieldSummaryByStatusList(iStatusList, regionCode);
        } else {
            noFlandList = this.fieldDoubleStatusService.queryDFLandTypeByCode(regionCode, Integer.valueOf(7));
            noRlandList = this.fieldDoubleStatusService.queryDFLandTypeByCode(regionCode, Integer.valueOf(8));
            List<Integer> fStatusList = Arrays.asList(7, 8, 9);
            fieldList = this.fieldDoubleStatusService.queryFieldSummaryByStatusList(fStatusList, regionCode);
        }
        landJson.put("noRlandList", noRlandList);
        landJson.put("noFlandList", noFlandList);
        json.put("fieldList", fieldList);
        json.put("landJson", (Object)landJson);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/submit-time"})
    @ApiOperation(value="\u7f51\u683c\u957f\u63d0\u4ea4\u4e0b\u8fbe\u901a\u77e5\u548c\u6574\u6539\u9884\u8ba1\u65f6\u95f4")
    public Object submitDFIdenTime(@RequestBody String body) {
        FieldGridRecord fieldGridRecord = (FieldGridRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FieldGridRecord.class);
        this.fieldDoubleStatusService.submitDFIdenTime(fieldGridRecord);
        return ResultVo.success();
    }

    @GetMapping(value={"/gridLeaderField/list"})
    @ApiOperation(value="\u7f51\u683c\u957f-\u7530\u5217\u8868")
    public Object queryGridLeaderFieldList(@RequestParam String regionCode, @RequestParam(value="areaType", required=false, defaultValue="") String areaType, @RequestParam(value="lat", required=false, defaultValue="") Double lat, @RequestParam(value="lng", required=false, defaultValue="") Double lng, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="fixingType", required=false, defaultValue="3") Integer fixingType, @RequestParam(value="statusType", required=false, defaultValue="1") Integer statusType, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        List<Object> statusList = new ArrayList<Integer>();
        List<Object> auditFlagList = new ArrayList();
        if (type == 0) {
            auditFlagList = Arrays.asList(4);
        } else if (type == 1) {
            if (fixingType == 3) {
                auditFlagList = Arrays.asList(1, 0, 3, 2);
            } else if (fixingType == 2) {
                auditFlagList = Arrays.asList(0, 3);
            } else if (fixingType == 1) {
                auditFlagList = Arrays.asList(1);
            } else if (fixingType == 0) {
                auditFlagList = Arrays.asList(2);
            }
        } else if (type == 2) {
            auditFlagList = Arrays.asList(1);
        }
        if (statusType == 1 && type == 0) {
            statusList.add(4);
        } else if (statusType == 2 && type == 0) {
            statusList.add(5);
        } else if (statusType == 3 && type == 0) {
            statusList.add(6);
        } else if (statusType == 4 && type == 0) {
            statusList = Arrays.asList(4, 5, 6);
        } else if (statusType == 1 && type == 1) {
            statusList.add(10);
        } else if (statusType == 2 && type == 1) {
            statusList.add(11);
        } else if (statusType == 3 && type == 1) {
            statusList.add(12);
        } else if (statusType == 4 && type == 1) {
            statusList = Arrays.asList(10, 11, 12);
        } else if (statusType == 1 && type == 2) {
            statusList.add(7);
        } else if (statusType == 2 && type == 2) {
            statusList.add(8);
        } else if (statusType == 3 && type == 2) {
            statusList.add(9);
        } else if (statusType == 4 && type == 2) {
            statusList = Arrays.asList(7, 8, 9);
        }
        Integer count = this.fieldDoubleStatusService.countGridLeaderFieldList(regionCode, search, statusList, auditFlagList, areaType);
        List list = new LinkedList();
        if (lng == null || lat == null) {
            Integer start = (page - 1) * pageSize;
            list = this.fieldDoubleStatusService.queryGridLeaderFieldList(regionCode, start, pageSize, search, statusList, auditFlagList, areaType);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject itJson = (JSONObject)list.get(i);
                itJson.put("img", (Object)("http://imgs.shuxitech.com/farm/field_img/" + itJson.getString("img")));
            }
        } else {
            Point point = new Point(lng.doubleValue(), lat.doubleValue());
            Criteria criteria = Criteria.where((String)"location").near(point);
            criteria.and("status").in(statusList);
            criteria.and("region_code").regex(regionCode + ".*");
            criteria.and("auditFlag").in(auditFlagList);
            Query query = Query.query((CriteriaDefinition)criteria);
            query.with((Pageable)PageRequest.of((int)(page - 1), (int)pageSize));
            query.fields().exclude("boundary").exclude("_id");
            list = this.mongoTemplate.find(query, JSONObject.class, "t_field_double_status");
            for (int i = 0; i < list.size(); ++i) {
                JSONObject itJson = (JSONObject)list.get(i);
                itJson.put("distance", (Object)LngLatUtil.calDistance((JSONArray)itJson.getJSONArray("location"), (Double)lng, (Double)lat));
                itJson.put("img", (Object)("http://imgs.shuxitech.com/farm/field_img/" + itJson.getString("img")));
            }
        }
        Integer count0 = this.fieldDoubleStatusService.countGridLeaderFieldList(regionCode, "", Arrays.asList(4, 5, 6), Arrays.asList(4), "");
        Integer count1 = this.fieldDoubleStatusService.countGridLeaderFieldList(regionCode, "", Arrays.asList(10, 11, 12), Arrays.asList(1, 0, 3, 2), "");
        Integer count2 = this.fieldDoubleStatusService.countGridLeaderFieldList(regionCode, "", Arrays.asList(7, 8, 9), Arrays.asList(1), "");
        JSONObject json = new JSONObject();
        json.put("list", list);
        json.put("count", (Object)count);
        json.put("count0", (Object)count0);
        json.put("count1", (Object)count1);
        json.put("count2", (Object)count2);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/ds-date"})
    @ApiOperation(value="\u65f6\u95f4\u67e5\u8be2\u52a8\u6001\u7edf\u8ba1")
    public Object queryDailyDataStatistics(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="type") Integer type, @RequestParam(value="date") String date) {
        return this.regionStatusAreaService.queryDailyDataStatistics(regionCode, date, type);
    }

    @ApiOperation(value="\u7f51\u683c\u957f\u83b7\u53d6\u6574\u6539\u6587\u4ef6\u5217\u8868")
    @GetMapping(value={"/dsFilelist"})
    public Object queryDsFilelist(@RequestParam String phone, @RequestParam String regionCode, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List list = this.regionStatusAreaService.queryDsFilelist(phone, regionCode, start, pageSize);
        return ResultVo.success((Object)list);
    }

    @PostMapping(value={"/gridLeader/send"})
    @ApiOperation(value="\u7f51\u683c\u957f\u63a8\u9001\u6574\u6539\u6587\u4ef6")
    public Object sendGridLeaderFixInfo(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        JSONArray array = json.getJSONArray("phoneArray");
        JSONArray regionCodeArray = json.getJSONArray("regionCodeArray");
        DoubleFieldFile fieldFile = (DoubleFieldFile)JSONObject.toJavaObject((JSON)json, DoubleFieldFile.class);
        this.regionStatusAreaService.sendGridLeaderFixInfo(fieldFile, array, regionCodeArray);
        return ResultVo.success();
    }

    @GetMapping(value={"/double-history/carbon-copy"})
    @ApiOperation(value="\u4e24\u975e\u5ba1\u6838\u6284\u9001\u5217\u8868")
    public ResultVo queryFieldDoubleHistoryCarbonCopyList(@RequestParam(value="userId") String userId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldDoubleHistoryCarbonCopyList(userId, start, pageSize));
    }

    @PostMapping(value={"/double-statistics"})
    @ApiOperation(value="\u4e24\u975e\u5927\u5c4f\u6570\u636e\u7ef4\u62a4")
    public ResultVo maintainFieldDoubleStatistics(@RequestBody List<FieldDoubleStatisticsNew> fieldDoubleStatisticsNewList) {
        this.fieldDoubleStatusService.maintainFieldDoubleStatistics(fieldDoubleStatisticsNewList);
        return ResultVo.success();
    }

    @PostMapping(value={"/doubleUpdate"})
    @ApiOperation(value="\u4e24\u975e\u8bc6\u522b\u6279\u91cf\u66f4\u65b0\u7530\u5757\u72b6\u6001")
    public ResultVo updateFieldDoubleFieldStatus(@RequestBody List<FieldDoubleStatus> list) {
        this.fieldDoubleStatusService.updateFieldDoubleFieldStatus(list);
        return ResultVo.success();
    }

    @PostMapping(value={"/pushDateToStatic"})
    @ApiOperation(value="\u624b\u52a8\u63a8\u4e24\u975e\u5927\u5c4f\u76f8\u5173\u6570\u636e")
    public ResultVo pushDateToStatic(@RequestParam(required=false) String regionCode) {
        this.fieldDoubleStatusService.updateStatisticsOfFieldDoubleField(regionCode);
        return ResultVo.success();
    }

    @PostMapping(value={"/summaryUpdate"})
    @ApiOperation(value="\u66f4\u65b0\u6751\uff0c\u7f51\u683c\u975e\u7cae\u6570\u636e\u7edf\u8ba1")
    public ResultVo updateRegionFieldSummary(@RequestParam(required=false) String regionCode) {
        this.fieldDoubleStatusService.updateRegionFieldSummary(regionCode);
        return ResultVo.success();
    }

    @GetMapping(value={"/double-history"})
    public ResultVo queryFieldDoubleHistory(@RequestParam(value="fieldDoubleId") Integer fieldDoubleId) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldDoubleHistory(fieldDoubleId));
    }

    @GetMapping(value={"/test"})
    public ResultVo queryTest() throws IOException {
        return ResultVo.success((Object)this.PopBasicInfo());
    }

    @GetMapping(value={"/recycle"})
    public String recycle(String recycleName) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/g7RE8E8rR58d94d8.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&hsdmc=" + recycleName;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/machine1"})
    public String machine1(String phone) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/H1H39j975iZd74Ca.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&sjhm=" + phone;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/machine2"})
    public String machine2(String username) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/N0d8I47mmgb7A5f4.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&xm=" + username;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/machine3"})
    public String machine3(String username) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/eTL27A36c5Y274S8.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&xm=" + username;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/machine4"})
    public String machine4(String username) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/6gab7RcT4B30Spm3.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&xm=" + username;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/machine5"})
    public String machine5(String username) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/f4cob33Nv57SFQ08.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&xm=" + username;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/insect"})
    public String insect(String deviceId) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/N0Vabz8fdym8f9gb.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&jcd=" + deviceId;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/subsidy"})
    public String subsidy(String startTime, String endTime) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/DcweRD794XXWac4c.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&kssj=" + startTime + "&jssj=" + endTime;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/subsidy1"})
    public String fieldInfo(String fieldName) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/8Jp3A4b9Jw18H8ta.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&ztmc=" + fieldName;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/userFarmer"})
    public String userFarmer(String username) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/en344fW40kJa0D38.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&dhxm=" + username;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/insect-warn"})
    public String insectWarn(String startTime, String endTime) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/59G3xa04c0iOD4Q7.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&kssj=" + startTime + "&jssj=" + endTime;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/subsidy-summary"})
    public String subsidySummary(String startTime, String endTime) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/Kb1ia1GF244JOT19.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&kssj=" + startTime + "&jssj=" + endTime;
        return HttpSendUtil.sendHttpGet((String)url);
    }

    @GetMapping(value={"/token"})
    public String PopBasicInfo() throws IOException {
        Object requestSecret = this.redisUtil.getStr(REQUEST_SECRET);
        if (null != requestSecret) {
            return requestSecret.toString();
        }
        long l = System.currentTimeMillis();
        String sign = MD5Util.MD5((String)("A3308254046232021070166911f60c1c1209b42879220da0ce8bb3154" + l));
        String url = "http://dw.qz.gov.cn/gateway/app/refreshTokenByKey.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l;
        String result = JSONObject.parseObject((String)HttpSendUtil.sendHttpGet((String)url)).getJSONObject("datas").getString(REQUEST_SECRET);
        this.redisUtil.putExpireTimeValueStr(REQUEST_SECRET, (Object)result, 900L);
        return result;
    }

    @GetMapping(value={"/agri-supervisory"})
    public String agriSupervisory(@RequestParam(value="phone", required=false, defaultValue="") String phone) throws IOException {
        long l = System.currentTimeMillis();
        String requestSecret = this.PopBasicInfo();
        String sign = MD5Util.MD5((String)(appKey + requestSecret + l));
        String url = "http://dw.qz.gov.cn/gateway/api/001008013007024/dataSharing/9CMfc9aEfPwcfC6f.htm?appKey=A330825404623202107016691&sign=" + sign + "&requestTime=" + l + "&sj=" + phone;
        String result = HttpSendUtil.sendHttpGet((String)url);
        log.error("\u519c\u8d44\u76d1\u7ba1\u4fe1\u606f\u5316\u8d2d\u9500\u53f0\u8d26\u7cfb\u7edf\u540d\u5355\u67e5\u8be2\u7ed3\u679c" + result);
        return result;
    }
}

