/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.BaseUserImport;
import com.farm.service.OrganService;
import com.farm.util.ExcelExpertListener;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/organ"})
@Api(tags={"\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2"})
public class OraganizationController {
    @Autowired
    private OrganService organService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u67b6\u6784")
    public Object queryOrganList(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="orgId", required=false) String orgId) {
        List list = this.organService.queryOrganList(userId, orgId);
        return ResultVo.success((Object)list);
    }

    @GetMapping(value={"/queryUserList"})
    @ApiOperation(value="\u67e5\u8be2\u8be5\u7ec4\u7ec7\u67b6\u6784\u4e0b\u9762\u7684\u7528\u6237\u5217\u8868")
    public Object queryUserList(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="pageNo", required=false, defaultValue="1") Integer pageNo, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="orgId") String orgId) {
        Integer begin = (pageNo - 1) * pageSize;
        JSONObject json = this.organService.queryUserList(userId, orgId, begin, pageSize, search);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/queryUserList/export"})
    @ApiOperation(value="\u7ec4\u7ec7\u67b6\u6784\u4e0b\u9762\u7684\u7528\u6237\u5217\u8868\u5bfc\u51fa")
    public void exportQueryUserListInfo(HttpServletResponse response, @RequestParam(value="orgId") String orgId) throws IOException {
        this.organService.exportQueryUserListInfo(response, orgId);
    }

    @PostMapping(value={"/addOrUpdateOraganization"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u90e8\u95e8")
    public Object addOrUpdateOraganization(@RequestParam(value="userId") String userId, @RequestParam(value="orgId", required=false, defaultValue="") String orgId, @RequestParam(value="orgPid") String orgPid, @RequestParam(value="orgName") String orgName, @RequestParam(value="fromType") Integer fromType, @RequestParam(value="organizationType", required=false) Integer organizationType) {
        this.organService.addOrUpdateOraganization(userId, orgId, orgPid, orgName, fromType, organizationType);
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u90e8\u95e8")
    public Object delOraganization(@RequestParam(value="String") String ids) {
        String[] idArray = ids.split(",");
        this.organService.delOraganization(idArray);
        return ResultVo.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5237\u7528\u6237\u6570\u636e")
    public ResultVo importExpert(@RequestParam(value="file") MultipartFile file) {
        List list = null;
        ExcelExpertListener excelListener = new ExcelExpertListener();
        String errMsg = null;
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, BaseUserImport.class, (ReadListener)excelListener).sheet().doRead();
            list = excelListener.getList();
            errMsg = excelListener.getErrMsg();
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                ResultVo resultVo = ResultVo.error((String)errMsg);
                return resultVo;
            }
            if (list.size() < 1) {
                ResultVo resultVo = ResultVo.error((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                return resultVo;
            }
            this.organService.batchInsert(list);
            ResultVo resultVo = ResultVo.success();
            return resultVo;
        }
        catch (Exception e) {
            errMsg = excelListener.getErrMsg();
            if (errMsg == null) {
                errMsg = "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
            }
            ResultVo resultVo = ResultVo.error((String)("\u6279\u91cf\u65b0\u589e\u5931\u8d25:" + errMsg));
            return resultVo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (list != null && list.size() != 0) {
                list.clear();
            }
        }
    }
}

