/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.service.RegionStatusAreaService;
import com.farm.service.RoleService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"})
@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
public class RoleController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private RegionStatusAreaService regionStatusAreaService;

    @GetMapping(value={"/queryRoleList"})
    @ApiOperation(value="\u67e5\u8be2\u81ea\u5efa\u89d2\u8272\u5217\u8868")
    public Object queryRoleList(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="pageNo", required=false, defaultValue="1") Integer pageNo, @RequestParam(value="rolePid", required=false, defaultValue="") String rolePid, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="roleName", required=false, defaultValue="") String roleName) {
        Integer begin = (pageNo - 1) * pageSize;
        JSONObject json = this.roleService.queryRoleList(userId, begin, pageSize, roleName, rolePid);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/queryUserPermissionList"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u6743\u9650\u4fe1\u606f")
    public Object queryUserPermissionList(@RequestParam(value="userId", required=false, defaultValue="") String userId) {
        JSONObject json = this.roleService.queryUserPermissionList(userId);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/allPermissionList"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7528\u6237\u6743\u9650\u4fe1\u606f")
    public Object queryAllPermissionList() {
        JSONObject json = this.roleService.queryAllPermissionList();
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/addUserPermission"})
    @ApiOperation(value="\u4fee\u6539\u5f53\u524d\u89d2\u8272\u7684\u6743\u9650")
    public Object addUserPermission(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="roleId") Integer roleId, @RequestParam(value="permissionIds", required=false) String permissionIds) {
        this.roleService.addUserPermission(userId, roleId, permissionIds);
        return ResultVo.success();
    }

    @PostMapping(value={"/addOrUpdateUserRole"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u89d2\u8272\u6743\u9650")
    public Object addOrUpdateUserRole(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="roleId", required=false) Integer roleId, @RequestParam(value="rolePid", required=false) Integer rolePid, @RequestParam(value="group") Integer group, @RequestParam(value="permissionIds", required=false) String permissionIds, @RequestParam(value="roleName") String roleName) {
        this.roleService.addOrUpdateUserRole(userId, roleId, roleName, rolePid, group, permissionIds);
        return ResultVo.success();
    }

    @PostMapping(value={"/delUserRole"})
    @ApiOperation(value="\u5220\u9664\u7528\u6237\u89d2\u8272")
    public Object delUserRole(@RequestParam(value="userId", required=false, defaultValue="") String userId, @RequestParam(value="roleId") Integer roleId) {
        this.roleService.delUserRole(userId, roleId);
        return ResultVo.success();
    }

    @GetMapping(value={"/gridLeaderList"})
    @ApiOperation(value="\u7f51\u683c\u957f\u7ba1\u7406")
    public Object queryGridLeaderList(@RequestParam String regionCode) {
        JSONObject json = this.regionStatusAreaService.queryGridLeaderList(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/userList"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u89d2\u8272\u7684\u7528\u6237\u5217\u8868")
    public ResultVo queryUserListByRoleId(@RequestParam(value="roleId") Integer roleId) {
        return ResultVo.success((Object)this.roleService.queryUserListByRoleId(roleId));
    }
}

