/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DoubleListResultMap;
import com.farm.bean.FieldAutoAudit;
import com.farm.bean.LabelResultMap;
import com.farm.bean.resultMap.FieldDSMap;
import com.farm.service.ConfigService;
import com.farm.service.FieldAutoAuditService;
import com.farm.service.FieldDoubleStatusService;
import com.farm.service.FieldSpecialLandService;
import com.farm.service.RegionStatusAreaService;
import com.farm.service.SmsService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/field"})
@RestController
@Api(tags={"\u4e24\u975e\u5927\u5c4f\u6a21\u5757"})
public class DatavController {
    @Resource
    private FieldDoubleStatusService fieldDoubleStatusService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ConfigService configService;
    @Autowired
    private RegionStatusAreaService regionStatusAreaService;
    @Autowired
    private FieldAutoAuditService fieldAutoAuditService;
    @Autowired
    private FieldSpecialLandService fieldSpecialLandService;

    @GetMapping(value={"/field-summary"})
    @ApiOperation(value="\u5927\u5c4f\u786e\u6743\u7530\u5757\u7edf\u8ba1")
    public Object queryFieldSummary(@RequestParam Integer companyId, @RequestParam(value="areaType", required=false, defaultValue="0") Integer areaType, @RequestParam(value="regionCode", required=false, defaultValue="") String regionCode) {
        JSONObject json = this.fieldDoubleStatusService.queryFieldSummary(companyId, regionCode, areaType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/field-record"})
    @ApiOperation(value="\u5927\u5c4f-\u7f51\u683c\u5458\u786e\u8ba4\u4fe1\u606f\u5217\u8868")
    public Object queryDoubleFieldHistoryLogs(@RequestParam Integer companyId, @RequestParam(value="regionCode", required=false, defaultValue="") String regionCode, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="statusType", required=false) Integer statusType, @RequestParam(value="areaType", required=false, defaultValue="") String areaType, @RequestParam(value="apiFlag", required=false, defaultValue="0") Integer apiFlag, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryDoubleFieldHistoryLogs(companyId, regionCode, start, pageSize, search, statusType, areaType, apiFlag);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/field-recordpics"})
    @ApiOperation(value="\u5927\u5c4f-\u7f51\u683c\u5458\u786e\u8ba4\u4fe1\u606f\u5217\u8868")
    public Object queryDoubleFieldHistoryLogsFPics(@RequestParam Integer companyId, @RequestParam(value="regionCode", required=false, defaultValue="") String regionCode, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="statusType", required=false) Integer statusType, @RequestParam(value="areaType", required=false, defaultValue="") String areaType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryDoubleFieldHistoryLogsFPic(companyId, regionCode, start, pageSize, search, statusType, areaType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/field-record/count"})
    @ApiOperation(value="\u5927\u5c4f-\u7f51\u683c\u5458\u786e\u8ba4\u4fe1\u606f\u7530\u5757\u6570\u91cf")
    public Object queryDoubleFieldHistoryLogCount(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(value="areaType", required=false, defaultValue="") Integer areaType) {
        JSONObject json = this.fieldDoubleStatusService.queryDoubleFieldHistoryLogCount(regionCode, areaType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary/log"})
    @ApiOperation(value="\u5927\u5c4f-\u4eca\u65e5\u7edf\u8ba1")
    public Object queryStatusLogSummary(@RequestParam Integer companyId, @RequestParam(value="areaType", required=false, defaultValue="0") Integer areaType, @RequestParam(value="regionCode", required=false, defaultValue="") String regionCode) {
        JSONObject json = this.fieldDoubleStatusService.queryStatusLogSummary(companyId, regionCode, areaType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary/double"})
    @ApiOperation(value="\u5927\u5c4f-\u5404\u6751\u975e\u519c\u975e\u7cae\u629b\u8352\u7edf\u8ba1")
    public Object queryDoubleStatusSummaryByHamlet(@RequestParam(value="areaType", required=false, defaultValue="0") Integer areaType, @RequestParam(value="regionCode", required=false, defaultValue="") String regionCode) {
        ArrayList<DoubleListResultMap> doubleListResultMapList = new ArrayList<DoubleListResultMap>();
        List regions = this.configService.queryDownRegionNames(regionCode);
        for (LabelResultMap label : regions) {
            List list = this.fieldDoubleStatusService.queryDoubleStatusSummaryByRegionCode(label.getLabel(), areaType);
            double area = 0.0;
            if (list != null && list.size() > 0) {
                area = list.stream().mapToDouble(LabelResultMap::getArea).sum();
            }
            DoubleListResultMap doubleListResultMap = new DoubleListResultMap(list, label.getName(), Double.valueOf(area), label.getLabel());
            doubleListResultMapList.add(doubleListResultMap);
        }
        JSONObject json = new JSONObject();
        json.put("array", doubleListResultMapList.stream().sorted(Comparator.comparing(DoubleListResultMap::getArea)).collect(Collectors.toList()));
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary/double-city"})
    @ApiOperation(value="\u53bf\u7ea7\u975e\u519c\u975e\u7cae\u629b\u8352\u7edf\u8ba1")
    public Object queryDoubleStatusSummaryByHamlet(@RequestParam(value="areaType", required=false, defaultValue="0") Integer areaType) {
        List<String> regionCodes = Arrays.asList("330825001", "330825002", "330825101", "330825102", "330825109", "330825110", "330825111", "330825106", "330825201", "330825203", "330825212", "330825213", "330825207", "330825209", "330825211");
        JSONObject res = new JSONObject();
        LinkedList<DoubleListResultMap> array = new LinkedList<DoubleListResultMap>();
        for (String regionCode : regionCodes) {
            String townName = this.configService.queryTownAddress(regionCode);
            List list = this.fieldDoubleStatusService.queryDoubleStatusSummaryByRegionCode(regionCode, areaType);
            double area = 0.0;
            if (list != null && list.size() > 0) {
                area = list.stream().mapToDouble(LabelResultMap::getArea).sum();
            }
            DoubleListResultMap itDeskTop = new DoubleListResultMap(list, townName, Double.valueOf(area), regionCode);
            array.add(itDeskTop);
        }
        res.put("array", array);
        return ResultVo.success((Object)res);
    }

    @GetMapping(value={"/manage/fieldList"})
    @ApiOperation(value="\u540e\u53f0\u7ba1\u7406-\u7530\u5757\u5217\u8868")
    public Object queryManageFieldList(@RequestParam(value="userId") String userId, @RequestParam(value="pageNo", required=false, defaultValue="1") Integer pageNo, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="fieldName", required=false, defaultValue="") String fieldName) {
        Integer begin = (pageNo - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryManageFieldList(userId, begin, pageSize, fieldName);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/list-pc"})
    @ApiOperation(value="PC-\u4e24\u975e\u7530\u5757\u5217\u8868\u67e5\u8be2")
    public Object queryPCDoubleUserFieldList(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="statusType", required=false) Integer statusType, @RequestParam(value="areaType", required=false, defaultValue="") String areaType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="beginDate", required=false, defaultValue="") String beginDate, @RequestParam(value="endDate", required=false, defaultValue="") String endDate, @RequestParam(value="userName", required=false, defaultValue="") String userName, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        if (StringUtils.isNotBlank((String)endDate)) {
            endDate = LocalDate.parse(endDate).plusDays(1L).toString();
        }
        JSONObject json = this.fieldDoubleStatusService.queryPCDoubleUserFieldList(search, start, pageSize, regionCode, status, statusType, beginDate, endDate, userName, areaType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary/func-status"})
    @ApiOperation(value="\u4e09\u5927\u529f\u80fd\u533a-\u5b9e\u65f6\u4e24\u975e\u6574\u6539\u8be6\u60c5\u6570\u636e\u7edf\u8ba1")
    public Object queryFuncAndStatusDetailList(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        JSONArray array = this.fieldDoubleStatusService.queryFuncAndStatusDetailList(regionCode);
        return ResultVo.success((Object)array);
    }

    @GetMapping(value={"/summary/func-type"})
    @ApiOperation(value="\u4e09\u5927\u529f\u80fd\u533a-\u5b9e\u65f6\u4e24\u975e\u8be6\u7ec6\u7c7b\u578b\u6570\u636e\u7edf\u8ba1")
    public Object queryFuncAndTypeDetailList(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(value="statusType", required=false, defaultValue="1") Integer statusType) {
        List<Object> statusList = new ArrayList();
        statusList = statusType == 1 ? Arrays.asList(10, 11, 12) : Arrays.asList(7, 8, 9);
        List list0 = this.fieldDoubleStatusService.queryFuncAndTypeDetailList(regionCode, 0, statusList, statusType);
        List list1 = this.fieldDoubleStatusService.queryFuncAndTypeDetailList(regionCode, 1, statusList, statusType);
        List list2 = this.fieldDoubleStatusService.queryFuncAndTypeDetailList(regionCode, 2, statusList, statusType);
        JSONArray array = new JSONArray();
        array.add((Object)list0);
        array.add((Object)list1);
        array.add((Object)list2);
        return ResultVo.success((Object)array);
    }

    @GetMapping(value={"/summary/function-area"})
    @ApiOperation(value="\u529f\u80fd\u533a\u6570\u636e\u7edf\u8ba1")
    public Object querySummaryByFunctionArea(@RequestParam String regionCode) {
        JSONObject json = this.fieldDoubleStatusService.querySummaryByFunctionArea(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary/group-status"})
    @ApiOperation(value="\u6839\u636e\u65e5\u671f\u72b6\u6001\u7edf\u8ba1\u6570\u636e")
    public Object querySummaryGroupStatus(@RequestParam String regionCode, @RequestParam(required=false, value="areaType", defaultValue="") String areaType, @RequestParam(required=false, value="statusType", defaultValue="") String statusType, @RequestParam(required=false, value="date", defaultValue="") String date) {
        if (StringUtils.isBlank((String)date)) {
            date = LocalDate.now().toString();
        }
        FieldDSMap dsMap = this.regionStatusAreaService.querySummaryGroupStatus(regionCode, date, areaType, statusType);
        JSONObject json = new JSONObject();
        json.put("dsMap", (Object)dsMap);
        json.put("date", (Object)date);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary/group-status/down"})
    @ApiOperation(value="\u6839\u636e\u72b6\u6001\u7edf\u8ba1\u6570\u636e-\u4e0b\u7ea7")
    public Object queryDownSummaryGroupStatus(@RequestParam String regionCode, @RequestParam(required=false, value="statusType", defaultValue="") String statusType, @RequestParam(required=false, value="areaType", defaultValue="") String areaType, @RequestParam(required=false, value="date", defaultValue="") String date) {
        if (StringUtils.isBlank((String)date)) {
            date = LocalDate.now().toString();
        }
        List array = this.regionStatusAreaService.queryDownSummaryGroupStatus(regionCode, date, areaType, statusType);
        JSONObject json = new JSONObject();
        json.put("list", (Object)array);
        json.put("date", (Object)date);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/audit/list"})
    @ApiOperation(value="\u5ba1\u6838\u6743\u9650\u7530\u5757\u5217\u8868")
    public Object queryAuditList(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(value="flag", required=false, defaultValue="0") Integer flag, @RequestParam(value="areaType", required=false) Integer areaType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="search", required=false, defaultValue="") String search) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.fieldDoubleStatusService.queryAuditList(regionCode, flag, areaType, start, pageSize, search);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/audit"})
    @ApiOperation(value="\u5ba1\u6838\u4e24\u975e\u7530\u5757")
    public Object auditDoubleField(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        String userId = json.getString("userId");
        String msg = json.getString("msg");
        Integer id = json.getInteger("id");
        Integer auditFlag = json.getInteger("auditFlag");
        Integer resFlag = this.fieldDoubleStatusService.auditDoubleField(id, auditFlag, userId, msg);
        JSONObject resJson = new JSONObject();
        if (resFlag == 1) {
            resJson.put("msg", (Object)"\u91cd\u590d\u5ba1\u6838");
        } else {
            resJson.put("msg", (Object)"\u5ba1\u6838\u6210\u529f");
        }
        return ResultVo.success((Object)resJson);
    }

    @PostMapping(value={"/audit/detail"})
    @ApiOperation(value="\u4e24\u975e\u7530\u5757\u5ba1\u6838\u8be6\u60c5")
    public Object queryAuditDoubleFieldDetail(@RequestParam Integer logId) {
        JSONObject resJson = new JSONObject();
        return ResultVo.success((Object)resJson);
    }

    @PostMapping(value={"/audit/mult"})
    @ApiOperation(value="\u6279\u91cf\u5ba1\u6838")
    public Object multAuditStatus(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        String userId = json.getString("userId");
        String msg = json.getString("msg");
        Integer auditFlag = json.getInteger("auditFlag");
        JSONArray idArray = json.getJSONArray("idArray");
        LinkedList<Integer> flagList = new LinkedList<Integer>();
        for (int i = 0; i < idArray.size(); ++i) {
            Integer id = idArray.getInteger(i);
            Integer resFlag = this.fieldDoubleStatusService.auditDoubleField(id, auditFlag, userId, msg);
            flagList.add(resFlag);
        }
        JSONObject resJson = new JSONObject();
        resJson.put("idArray", (Object)idArray);
        resJson.put("flagList", flagList);
        return ResultVo.success((Object)resJson);
    }

    @GetMapping(value={"/audit-button"})
    @ApiOperation(value="\u67e5\u8be2\u533a\u57df\u7684\u5ba1\u6838\u5f00\u5173-\u9ed8\u8ba4\u5173")
    public Object queryRegionAuditFlag(@RequestParam String regionCode, HttpServletResponse response, HttpServletRequest request) {
        FieldAutoAudit dto = new FieldAutoAudit();
        dto.setRegionCode(regionCode);
        List list = this.fieldAutoAuditService.queryAllByRegionCode(dto);
        if (list == null || list.size() == 0) {
            String regionName = this.configService.queryRegionName(regionCode);
            dto = new FieldAutoAudit(regionCode, Boolean.valueOf(false), Integer.valueOf(1), regionName);
            FieldAutoAudit dto2 = new FieldAutoAudit(regionCode, Boolean.valueOf(false), Integer.valueOf(2), regionName);
            list.add(dto);
            list.add(dto2);
        }
        return ResultVo.success((Object)list);
    }

    @PostMapping(value={"/audit-button/update"})
    @ApiOperation(value="\u66f4\u65b0\u533a\u57df\u7684\u5ba1\u6838\u5f00\u5173")
    public Object updateAuditFlag(@RequestBody FieldAutoAudit dto) {
        FieldAutoAudit fieldAutoAudit = new FieldAutoAudit();
        fieldAutoAudit.setRegionCode(dto.getRegionCode());
        fieldAutoAudit.setType(dto.getType());
        List list = this.fieldAutoAuditService.queryAllByRegionCode(fieldAutoAudit);
        if (list != null && list.size() > 0) {
            this.fieldAutoAuditService.update(dto);
        } else {
            this.fieldAutoAuditService.insert(dto);
        }
        if (dto.getFlag().booleanValue()) {
            this.fieldAutoAuditService.autoAuditStatusList(dto.getRegionCode());
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/map-date"})
    @ApiOperation(value="\u7530\u5757\u536b\u661f\u56fe\u65e5\u671f\u5217\u8868")
    public Object queryFieldDates(@RequestParam Integer fieldId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="200") Integer pageSize) {
        Criteria criteria = Criteria.where((String)"field_double_status_id").is((Object)fieldId);
        Query query = Query.query((CriteriaDefinition)criteria);
        query.with((Pageable)PageRequest.of((int)(page - 1), (int)pageSize));
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"date"}));
        query.fields().include("date").exclude("_id");
        List list = this.mongoTemplate.find(query, JSONObject.class, "gs_double_status");
        return ResultVo.success((Object)list);
    }

    @GetMapping(value={"/area-type/statistics"})
    @ApiOperation(value="\u7530\u5757\u7c7b\u578b\u7edf\u8ba1")
    public ResultVo queryFieldAreaTypeStatistics(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="areaType", required=false) Integer areaType) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldAreaTypeStatistics(regionCode, areaType));
    }

    @GetMapping(value={"/regionCode/statistics"})
    @ApiOperation(value="\u53bf/\u9547/\u6751\u975e\u7cae\u7edf\u8ba1")
    public ResultVo queryFieldStatisticsByRegionCode(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="areaType") Integer areaType) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldStatisticsByParentCode(regionCode, areaType));
    }

    @GetMapping(value={"/double-date/statistics"})
    @ApiOperation(value="\u6309\u65e5\u671f\u7edf\u8ba1\u4e24\u975e\u6570\u636e")
    public ResultVo queryFieldDoubleStatisticsByDate(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="dateTime") String dateTime, @RequestParam(value="areaType") Integer areaType) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldDoubleStatisticsByDate(regionCode, dateTime, areaType));
    }

    @GetMapping(value={"/special/fieldinfo"})
    @ApiOperation(value="\u6309\u65e5\u671f\u7edf\u8ba1\u4e24\u975e\u6570\u636e")
    public ResultVo querySpecialFieldInfo(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="type") String type) {
        return ResultVo.success((Object)this.fieldSpecialLandService.pageList(regionCode, type));
    }

    @GetMapping(value={"/fieldDoubleStatusCount"})
    @ApiOperation(value="\u975e\u7cae\u7530\u5757\u6570\u91cf")
    public ResultVo queryFieldDoubleStatusCount(@RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", required=false, defaultValue="") Integer year, @RequestParam(value="date", required=false, defaultValue="") String date) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryFieldDoubleStatusCount(regionCode, year, date));
    }

    @GetMapping(value={"/fieldDoubleStatusArea"})
    public ResultVo fieldDoubleStatusArea(@RequestParam(value="regionCode") String regionCode) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.fieldDoubleStatusArea(regionCode));
    }

    @GetMapping(value={"/queryLotList"})
    public ResultVo queryLotList(@RequestParam(value="year", required=false, defaultValue="") Integer year) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryLotList(year));
    }

    @GetMapping(value={"/queryStatistics"})
    public ResultVo queryStatistics(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="year", required=false, defaultValue="") Integer year, @RequestParam(value="date", required=false, defaultValue="") String date) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryStatistics(regionCode, year, date));
    }

    @GetMapping(value={"/queryAreaTypeStatistics"})
    public ResultVo queryAreaTypeStatistics(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="type") Integer type, @RequestParam(value="year", required=false, defaultValue="") Integer year, @RequestParam(value="date", required=false, defaultValue="") String date) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryAreaTypeStatistics(regionCode, type, year, date));
    }

    @GetMapping(value={"/queryWarningDetail"})
    public ResultVo queryWarningDetail(@RequestParam(value="id") Integer id, @RequestParam(value="relId") Integer relId) {
        return ResultVo.success((Object)this.fieldDoubleStatusService.queryWarningDetail(id, relId));
    }
}

