/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav.dpService;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriserveMachineInspect;
import com.farm.bean.ExportMachineVo;
import com.farm.bean.MachineExportInfo;
import com.farm.bean.Warning;
import com.farm.bean.bo.WarningBo;
import com.farm.bean.bo.WarningStatusBo;
import com.farm.mapper.AgriculturalMachineInspectMapper;
import com.farm.service.AgriculturalMachineService;
import com.farm.service.AgriserveMachineService;
import com.farm.service.WarningService;
import com.farm.util.EasyExcelUtil;
import com.farm.util.ResultVo;
import com.farm.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/warn"})
@RestController
public class WarningController {
    @Resource
    private WarningService warningService;
    @Autowired
    private AgriserveMachineService machineService;
    @Autowired
    private AgriculturalMachineService agriculturalMachineService;
    @Autowired
    private AgriculturalMachineInspectMapper agriculturalMachineInspectMapper;

    @PostMapping(value={"/saveOrUpdate"})
    public ResultVo saveOrUpdate(@RequestBody List<WarningBo> list) {
        return ResultVo.success((Object)this.warningService.saveOrUpdate(list));
    }

    @GetMapping(value={"/queryWarningList"})
    public ResultVo queryWarningList(@RequestParam(value="dateType", required=false, defaultValue="") Integer dateType, @RequestParam(name="date", required=false, defaultValue="") String date, @RequestParam(value="modules") String modules, @RequestParam(value="status", required=false) String status, @RequestParam(value="warningType", required=false) Integer warningType, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.warningService.queryList(dateType, date, modules, status, warningType, pageNum, pageSize));
    }

    @GetMapping(value={"/queryNjWarningList"})
    public ResultVo queryNjWarningList(@RequestParam(value="dateType", required=false, defaultValue="") Integer dateType, @RequestParam(name="date", required=false, defaultValue="") String date, @RequestParam(value="modules") String modules, @RequestParam(value="status", required=false) String status, @RequestParam(value="warningType", required=false) Integer warningType, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.warningService.queryNjWarningList(dateType, date, modules, status, warningType, pageNum, pageSize));
    }

    @GetMapping(value={"/queryFlWarningList"})
    public ResultVo queryFlWarningList(@RequestParam(value="dateType", required=false, defaultValue="") Integer dateType, @RequestParam(name="date", required=false, defaultValue="") String date, @RequestParam(value="modules") String modules, @RequestParam(value="status", required=false) String status, @RequestParam(value="warningType", required=false) Integer warningType, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.warningService.queryFlWarningList(dateType, date, modules, status, warningType, pageNum, pageSize));
    }

    @GetMapping(value={"/queryDataGroup"})
    public ResultVo queryDataGroup(@RequestParam(value="modules") String modules, @RequestParam(value="dateType") Integer dateType, @RequestParam(name="date") String date) {
        return ResultVo.success((Object)this.warningService.queryDataGroup(modules, dateType, date));
    }

    @PostMapping(value={"/batchSave"})
    public ResultVo save(@RequestBody List<WarningBo> list) {
        Boolean aBoolean = false;
        if (list != null && list.size() > 0) {
            aBoolean = this.warningService.saveOrUpdate(list);
        }
        return ResultVo.success((Object)aBoolean);
    }

    @PostMapping(value={"/updateStatus"})
    public ResultVo updateStatus(@RequestBody WarningStatusBo bo) {
        Boolean aBoolean = false;
        if (bo.getIds() != null && bo.getIds().size() > 0 && bo.getStatus() != null) {
            aBoolean = this.warningService.updateStatus(bo);
        }
        return ResultVo.success((Object)aBoolean);
    }

    @GetMapping(value={"/queryDataGroupResult"})
    public ResultVo queryDataGroupResult(@RequestParam(value="modules") String modules, @RequestParam(value="dateType") Integer dateType, @RequestParam(value="date") String date) {
        return ResultVo.success((Object)this.warningService.queryDataGroupResult(modules, dateType, date));
    }

    @GetMapping(value={"/queryHomeDataGroup"})
    public ResultVo queryHomeDataGroup() {
        return ResultVo.success((Object)this.warningService.queryHomeDataGroup());
    }

    @GetMapping(value={"/queryInsectWarnCount"})
    public ResultVo queryInsectWarnCount(@RequestParam(value="warningType", required=false) Integer warningType, @RequestParam(value="dateType", required=false) Integer dateType, @RequestParam(value="date", required=false) String date) {
        return ResultVo.success((Object)this.warningService.queryInsectWarnCount(warningType, dateType, date));
    }

    @GetMapping(value={"/queryWarnLogs"})
    public ResultVo queryWarnLogs(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.warningService.queryWarnLogs(id));
    }

    @GetMapping(value={"/queryMachineInspect"})
    public ResultVo queryMachineInspect(@RequestParam(name="engineNumber", required=false) String engineNumber, @RequestParam(name="frameNumber", required=false) String frameNumber, @RequestParam(name="inspection", required=false) String inspection, @RequestParam(name="registrationNumber", required=false) String registrationNumber, @RequestParam(name="carNumber", required=false) String carNumber, @RequestParam(name="phone", required=false) String phone, @RequestParam(name="status") Integer status, @RequestParam(name="state") Integer state, @RequestParam(name="type") Integer type, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="50") Integer pageSize) {
        List list = this.agriculturalMachineService.readAll(engineNumber, frameNumber, inspection, registrationNumber, carNumber, phone, status, state, type, pageNum, pageSize);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("list", (Object)list);
        jsonObject.put("count", (Object)this.agriculturalMachineService.getCount(registrationNumber, carNumber, inspection, phone, status, state, type));
        return ResultVo.success((Object)jsonObject);
    }

    @PostMapping(value={"/update"})
    public ResultVo update(@RequestParam(name="relId") String relId) {
        List<Object> str = new ArrayList();
        ArrayList<Integer> collect = new ArrayList<Integer>();
        if (relId.contains(",")) {
            String[] split = relId.split(",");
            str = Arrays.asList(split);
            for (String string : str) {
                int num = Integer.parseInt(string);
                collect.add(num);
            }
        } else {
            int num = Integer.parseInt(relId);
            collect.add(num);
        }
        this.agriculturalMachineService.update(collect);
        return ResultVo.success();
    }

    @GetMapping(value={"/queryOne"})
    public ResultVo queryOne(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.warningService.queryWarnLogs(id));
    }

    @GetMapping(value={"/export"})
    public void exportData(@RequestParam(value="relId") String relId, HttpServletResponse response) throws IOException {
        List<Object> str = new ArrayList();
        ArrayList<Integer> collect = new ArrayList<Integer>();
        if (relId.contains(",")) {
            String[] split = relId.split(",");
            str = Arrays.asList(split);
            for (String string : str) {
                int num = Integer.parseInt(string);
                collect.add(num);
            }
        } else {
            int num = Integer.parseInt(relId);
            collect.add(num);
        }
        List list = this.agriculturalMachineInspectMapper.readAllByIds(collect);
        String downloadFilename = System.currentTimeMillis() + ".zip";
        downloadFilename = URLEncoder.encode(downloadFilename, "UTF-8");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + downloadFilename);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        int i = 0;
        for (ExportMachineVo string : list) {
            if (Objects.isNull(string)) continue;
            if (string.getVoucher().contains(",")) {
                String[] split = string.getVoucher().split(",");
                for (int num = 0; num < split.length; ++num) {
                    String voucher = split[num];
                    URL url = new URL(voucher);
                    HttpURLConnection urlcon = (HttpURLConnection)url.openConnection();
                    String message = urlcon.getHeaderField(0);
                    if (!StringUtils.isNotEmpty((String)message) || message.startsWith("HTTP/1.1 404")) continue;
                    if (StringUtils.isNotEmpty((String)string.getVoucher())) {
                        String format = voucher.substring(voucher.lastIndexOf(".") + 1);
                        zipOutputStream.putNextEntry(new ZipEntry((StringUtils.isNotBlank((CharSequence)string.getFrameNumber()) ? string.getCarType() + "_" + string.getFrameNumber() + ++i : string.getCarType() + ++i) + "." + format));
                    }
                    InputStream fis = urlcon.getInputStream();
                    byte[] buffer = new byte[1024];
                    int r = 0;
                    while ((r = fis.read(buffer)) != -1) {
                        zipOutputStream.write(buffer, 0, r);
                    }
                    fis.close();
                }
                continue;
            }
            URL url = new URL(string.getVoucher());
            HttpURLConnection urlcon = (HttpURLConnection)url.openConnection();
            String message = urlcon.getHeaderField(0);
            if (!StringUtils.isNotEmpty((String)message) || message.startsWith("HTTP/1.1 404")) continue;
            if (StringUtils.isNotEmpty((String)string.getVoucher())) {
                String format = string.getVoucher().substring(string.getVoucher().lastIndexOf(".") + 1);
                zipOutputStream.putNextEntry(new ZipEntry((StringUtils.isNotBlank((CharSequence)string.getFrameNumber()) ? string.getCarType() + "_" + string.getFrameNumber() + ++i : string.getCarType() + ++i) + "." + format));
            }
            InputStream fis = urlcon.getInputStream();
            byte[] buffer = new byte[1024];
            int r = 0;
            while ((r = fis.read(buffer)) != -1) {
                zipOutputStream.write(buffer, 0, r);
            }
            fis.close();
        }
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @GetMapping(value={"/getDetail"})
    public ResultVo getDetail(@RequestParam(value="type") Integer type, @RequestParam(value="dateType", defaultValue="1") Integer dateType, @RequestParam(value="date") String date) {
        return this.agriculturalMachineService.getDetail(type, dateType, date);
    }

    @GetMapping(value={"/getAllMachineNum"})
    public ResultVo getAllMachineNum(@RequestParam(value="dateType", defaultValue="1") Integer dateType, @RequestParam(value="date") String date) {
        return this.agriculturalMachineService.getAllMachineNum(dateType, date);
    }

    @GetMapping(value={"/getProportion"})
    public ResultVo getProportion(@RequestParam(value="dateType", defaultValue="1") Integer dateType, @RequestParam(value="date") String date) {
        return this.agriculturalMachineService.getProportion(dateType, date);
    }

    @GetMapping(value={"/getAreaNum"})
    public ResultVo getAreaNum(@RequestParam(value="dateType", defaultValue="1") Integer dateType, @RequestParam(value="date") String date, @RequestParam(value="regionCode", required=false) String regionCode) {
        return this.agriculturalMachineService.getAreaNum(dateType, date, regionCode);
    }

    @GetMapping(value={"/getAreaList"})
    public ResultVo getAreaList(@RequestParam(value="dateType", defaultValue="1") Integer dateType, @RequestParam(value="date") String date, @RequestParam(value="regionCode") String regionCode, @RequestParam(required=false, defaultValue="", value="types") String types) {
        List<Object> machineTypeList = types.equals("") ? new ArrayList() : Arrays.asList(types.split(","));
        return this.agriculturalMachineService.getAreaList(dateType, date, regionCode, machineTypeList);
    }

    @GetMapping(value={"/getOneInsectWarning"})
    public ResultVo getOneInsectWarning(@RequestParam(value="id") Integer id) {
        return this.warningService.getOneInsectWarning(id);
    }

    @GetMapping(value={"/getOneInsectDetail"})
    public ResultVo getOneInsectDetail(@RequestParam(value="dateType") Integer dateType, @RequestParam(value="date") String date) {
        return this.warningService.getOneInsectDetail(dateType, date);
    }

    @GetMapping(value={"/getOneRecycleWarning"})
    public ResultVo getOneRecycleWarning(@RequestParam(value="id") Integer id) {
        return this.warningService.getOneRecycleWarning(id);
    }

    @GetMapping(value={"/getCultivatedLandWarnLogs"})
    public ResultVo getCultivatedLandWarnLogs(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.warningService.getCultivatedLandWarnLogs(id));
    }

    @GetMapping(value={"/exportMachineInfo"})
    public void exportMachineInfo(HttpServletResponse response, @RequestParam(value="date", required=false) String date, @RequestParam(value="status", required=false) Integer status) throws IOException {
        List list = this.agriculturalMachineInspectMapper.findByDate(null, null);
        EasyExcelUtil.createFixedHeadFile((HttpServletResponse)response, (String)"\u519c\u673a\u4fe1\u606f\u6570\u636e", MachineExportInfo.class, (String)"\u519c\u673a\u4fe1\u606f", (List)MachineExportInfo.handle((List)list, (String)date));
    }

    @Transactional
    @GetMapping(value={"/firstAdd"})
    public ResultVo firstAdd() {
        List list = this.agriculturalMachineInspectMapper.findByDate(null, null);
        Collection<MachineExportInfo> tljList = list.stream().filter(info -> "0".equals(info.getType()) || "2".equals(info.getType()) || "4".equals(info.getType()) || "3".equals(info.getType())).collect(Collectors.toMap(MachineExportInfo::getFrameNumber, p -> p, (p1, p2) -> p1)).values();
        Collection<MachineExportInfo> wrjList = list.stream().filter(info -> "1".equals(info.getType())).collect(Collectors.toMap(MachineExportInfo::getEngineNumber, p -> p, (p1, p2) -> p1)).values();
        ArrayList<MachineExportInfo> machineExportInfos = new ArrayList<MachineExportInfo>();
        machineExportInfos.addAll(tljList);
        machineExportInfos.addAll(wrjList);
        machineExportInfos.forEach(info -> {
            Warning warning = new Warning();
            warning.setStatus(Integer.valueOf(-1));
            warning.setCompany("\u519c\u673a\u53d1\u5c55\u4e2d\u5fc3");
            warning.setLeader("\u65b9\u8d85");
            warning.setWarningType(Integer.valueOf(Integer.parseInt(info.getType()) == 0 || Integer.parseInt(info.getType()) == 2 ? 0 : 1));
            warning.setRelId(Integer.toString(info.getId()));
            warning.setContent((Integer.parseInt(info.getType()) == 0 ? "\u62d6\u62c9\u673a" : (Integer.parseInt(info.getType()) == 1 ? "\u63d2\u79e7\u673a" : (Integer.parseInt(info.getType()) == 2 ? "\u6536\u5272\u673a" : (Integer.parseInt(info.getType()) == 3 ? "\u70d8\u5e72\u673a" : "\u65e0\u4eba\u673a")))) + info.getFrameNumber() + "\u5df2\u7ecf\u8d85\u8fc7\u4e00\u5e74\u672a\u5e74\u68c0");
            warning.setModule(Integer.valueOf(6));
            warning.setRule(Integer.valueOf(Integer.parseInt(info.getType()) == 0 || Integer.parseInt(info.getType()) == 2 ? 1 : 2));
            this.warningService.insertOne(warning);
        });
        List inspectList = machineExportInfos.stream().map(inspect -> {
            AgriserveMachineInspect result = new AgriserveMachineInspect();
            result.setMachineId(Integer.toString(inspect.getId()));
            result.setInspection(new SimpleDateFormat("yyyy").format(new Date()));
            result.setIsInspect(Integer.valueOf(0));
            result.setIsSign(Integer.valueOf(0));
            return result;
        }).collect(Collectors.toList());
        this.machineService.batchInsert(inspectList);
        return ResultVo.success();
    }
}

