/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.dvim;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DpChildrenData;
import com.farm.bean.DpData;
import com.farm.bean.DpDataBo;
import com.farm.bean.DpDataExport;
import com.farm.bean.Warning;
import com.farm.bean.annotaion.TypeCode;
import com.farm.bean.dpBean.DpBase;
import com.farm.config.DPBeanFactory;
import com.farm.config.excelhandler.ExcelListenerForField;
import com.farm.mapper.DpDataMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.DpDataService;
import com.farm.service.WaringHandleService;
import com.farm.task.InsectWarningTask;
import com.farm.task.MachineWarningTask;
import com.farm.util.ResultVo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dp/temp"})
public class DpController {
    @Resource
    private Map<String, WaringHandleService> map;
    @Resource
    private DpDataService dpDataService;
    @Resource
    private DpDataMapper dpDataMapper;
    @Resource
    private WarningMapper warningMapper;
    @Resource
    private MachineWarningTask machineWarningTask;
    @Resource
    private InsectWarningTask insectWarningTask;

    @PostMapping(value={"/saveData"})
    public ResultVo saveData(@RequestBody DpDataBo dpData) {
        return ResultVo.success((Object)this.dpDataService.saveData(dpData));
    }

    @GetMapping(value={"/queryDataByTypeCode"})
    public ResultVo queryDataByTypeCode(@RequestParam(value="typeCode") Integer typeCode, @RequestParam(value="businessId", required=false, defaultValue="") String businessId, @RequestParam(value="type", defaultValue="0", required=false) Integer type, @RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="sort", required=false) Integer sort, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="year", required=false, defaultValue="") String year, @RequestParam(value="month", required=false, defaultValue="") String month, @RequestParam(value="dateType", required=false) Integer dateType, @RequestParam(value="date", required=false) String date, @RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return ResultVo.success((Object)this.dpDataService.queryDataByTypeCode(typeCode, businessId, type, title, sort, startTime, endTime, year, month, pageNum, pageSize, dateType, date));
    }

    @PostMapping(value={"/delData"})
    public ResultVo delData(@RequestParam(value="uuids") String uuids) {
        return ResultVo.success((Object)this.dpDataService.delData(uuids));
    }

    @PostMapping(value={"/importData"})
    public void importData(@RequestParam(value="file") MultipartFile file, @RequestParam(value="typeCode") String code, @RequestParam(value="type", defaultValue="0", required=false) Integer type) throws IOException {
        if (code.contains(",")) {
            code = code.split(",")[0];
        }
        DpBase beanByCode = DPBeanFactory.getBeanByCode((String)code);
        assert (beanByCode != null);
        ExcelListenerForField excelListener = new ExcelListenerForField(beanByCode.getClass());
        EasyExcel.read((InputStream)file.getInputStream(), beanByCode.getClass(), (ReadListener)excelListener).sheet(Integer.valueOf(0)).doRead();
        List data = JSONObject.parseArray((String)JSONArray.toJSONString((Object)excelListener.list)).toJavaList(beanByCode.getClass());
        if (data.size() == 0) {
            return;
        }
        this.dpDataService.delDataByCode(code);
        DpData dpData = new DpData();
        String dataJson = JSONObject.toJSONString(data.get(data.size() - 1));
        dpData.setTypeCode(Integer.valueOf(code));
        dpData.setData(dataJson);
        this.dpDataService.saveParentData(dpData);
        ArrayList childrenData = new ArrayList();
        data.forEach(d -> {
            JSONObject obj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)d));
            DpChildrenData dpChildrenData = new DpChildrenData();
            dpChildrenData.setUuid(IdUtil.simpleUUID());
            dpChildrenData.setParentId(dpData.getId());
            dpChildrenData.setData(JSONObject.toJSONString((Object)d));
            dpChildrenData.setTitle(obj.getString("title"));
            dpChildrenData.setMonth(obj.getString("month"));
            dpChildrenData.setTime(obj.getString("time") == null ? null : (obj.getString("time").length() > 10 ? obj.getString("time").substring(0, 10) : obj.getString("time")));
            dpChildrenData.setSort(obj.getString("sort"));
            dpChildrenData.setYear(obj.getString("year"));
            childrenData.add(dpChildrenData);
        });
        this.dpDataService.saveChildrenData(childrenData);
        WaringHandleService waringHandleService = (WaringHandleService)this.map.get("w" + code);
        if (waringHandleService != null) {
            waringHandleService.handleWaring(childrenData);
        }
        if ("60001".equals(code)) {
            double cSum;
            List hList = this.dpDataMapper.queryListAllWarning("60001");
            List cList = this.dpDataMapper.queryListAllWarning("60002");
            double hSum = this.getSum(hList);
            if (hSum - (cSum = this.getSum(cList)) >= 50.0) {
                Warning warning = new Warning();
                warning.setStatus(Integer.valueOf(-1));
                warning.setCompany("\u79cd\u690d\u4e1a\u4e2d\u5fc3");
                warning.setLeader("\u90d1\u7490\u83b9");
                warning.setWarningDate(DateUtil.now());
                warning.setWarningType(Integer.valueOf(0));
                warning.setContent("\u5e93\u5bb9\u91cf\u226550KG");
                warning.setCreateTime(DateUtil.now());
                warning.setModule(Integer.valueOf(7));
                warning.setRule(Integer.valueOf(1));
                this.warningMapper.insert((Object)warning);
            }
        }
    }

    private double getSum(List<String> list) {
        double sum = 0.0;
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0) {
            for (String s : list) {
                double h = Double.parseDouble(JSONObject.parseObject((String)s).get((Object)"h") + "");
                sum += h;
            }
        }
        return sum;
    }

    @GetMapping(value={"/exportData"})
    public void exportData(@RequestParam(value="typeCode") String code, @RequestParam(value="type", defaultValue="0", required=false) Integer type, HttpServletResponse response) {
        DpBase beanByCode = DPBeanFactory.getBeanByCode((String)code);
        assert (beanByCode != null);
        String fName = beanByCode.getClass().getAnnotation(TypeCode.class).fileName();
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(fName, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        DpDataExport dpDataExport = this.dpDataService.selectExportData(code);
        if (dpDataExport == null || type == 0) {
            EasyExcel.write((OutputStream)response.getOutputStream(), beanByCode.getClass()).sheet().doWrite(new ArrayList());
            return;
        }
        JSONArray array = new JSONArray();
        if (dpDataExport.getChildrenList().size() > 0) {
            dpDataExport.getChildrenList().forEach(c -> array.add((Object)JSONObject.parseObject((String)c.getData())));
        } else {
            array.add((Object)JSONObject.parseObject((String)dpDataExport.getData()));
        }
        List dataList = array.toJavaList(beanByCode.getClass());
        EasyExcel.write((OutputStream)response.getOutputStream(), beanByCode.getClass()).sheet().doWrite((Collection)dataList);
    }

    @GetMapping(value={"/refreshMachineWarningData"})
    public void refreshData() {
        this.machineWarningTask.machineTask();
    }

    @GetMapping(value={"/refreshInsectData"})
    public void refreshInsectData() {
        this.insectWarningTask.insectTask();
    }

    @GetMapping(value={"/getHomeData"})
    public ResultVo getHomeData(@RequestParam(value="dateType", required=false) Integer dateType, @RequestParam(value="date", required=false) String date) {
        return this.dpDataService.getHomeData(dateType, date);
    }
}

