/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.zzd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.LytRole;
import com.farm.bean.LytUser;
import com.farm.service.LytUserService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/govern"})
@RestController
@Api(tags={"\u653f\u5e9c\u5de5\u4f5c\u4eba\u5458\u63a5\u53e3"})
public class GovernmentUserController {
    private static final Logger log = LoggerFactory.getLogger(GovernmentUserController.class);
    @Value(value="${lyt.url}")
    private String baseUrl;
    @Value(value="${lyt.appId}")
    private String appId;
    private String orgId = "1";
    @Value(value="${lyt.lesseeCode}")
    private String lesseeCode;
    @Autowired
    private LytUserService lytUserService;

    @GetMapping(value={"/all"})
    public Object sysc() {
        this.queryOrgTree("", "");
        this.queryOrgUserListByTask("", "");
        this.updateUserInfo("");
        return ResultVo.success((Object)"\u540c\u6b65\u7528\u6237\u6570\u636e\u5b8c\u6210");
    }

    @GetMapping(value={"/ddUser"})
    @ApiOperation(value="\u514d\u767b\u5f55\u6388\u6743\u7801\u83b7\u53d6\u9489\u9489\u7528\u6237\u8be6\u7ec6\u4fe1\u606f")
    public Object queryDDUserInfoFromLyt(@RequestParam(defaultValue="", required=false) String authCode) {
        String url = "base/dingTalk/dingTalkAppUser?authCode=" + authCode;
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url);
        return result;
    }

    @GetMapping(value={"/jsApiToken"})
    @ApiOperation(value="\u9489\u9489JsApiToken-ticket")
    public Object queryDDJsApiToken() {
        String url = "base/dingTalk/getJsApiToken";
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url);
        return result;
    }

    @GetMapping(value={"/userInfo"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8be6\u7ec6\u4fe1\u606f1")
    public Object queryUserInfoByUserId(@RequestParam(defaultValue="210419C058MHK214", required=false) String userId) {
        String url = "/busi/user/getUserInfoByUserId";
        String[] keys = new String[]{"", "", "", userId};
        JSONObject result = this.sendHttpReqGet(keys, url);
        return result;
    }

    @GetMapping(value={"/sync-userInfo"})
    @ApiOperation(value="\u540c\u6b65\u6240\u6709\u7528\u6237\u4fe1\u606f-\u786e\u8ba41")
    public Object updateUserInfo(@RequestParam(value="code", required=false, defaultValue="") String code) {
        if (StringUtils.isBlank((String)code)) {
            code = this.lesseeCode;
        }
        List userIdList = this.lytUserService.queryUserIdList(code);
        String userId = "";
        String url = "/busi/user/getUserInfoByUserId";
        AbstractList userList = new LinkedList<LytUser>();
        for (int i = 0; i < userIdList.size(); ++i) {
            userId = (String)userIdList.get(i);
            String[] keys = new String[]{"", "", "", userId};
            JSONObject result = this.sendHttpReqGet(keys, url);
            LytUser lytUser = (LytUser)JSONObject.toJavaObject((JSON)result.getJSONObject("data"), LytUser.class);
            userList.add(lytUser);
            if (userList.size() != 40 && Integer.compare(i, userIdList.size() - 1) != 0) continue;
            this.lytUserService.updateUserListInfo(userList, code);
            userList = new ArrayList();
        }
        return ResultVo.success((Object)"\u540c\u6b65\u7528\u6237\u6570\u636e\u5b8c\u6210");
    }

    @GetMapping(value={"/sync-userInfoByRole"})
    @ApiOperation(value="\u540c\u6b65\u6240\u6709\u7528\u6237\u4fe1\u606f-\u89d2\u8272\u7528\u6237\u5173\u8054\u786e\u8ba42")
    public Object updateUserInfo2() {
        List userIdList = this.lytUserService.queryUserIdListByRole();
        String userId = "";
        String url = "/busi/user/getUserInfoByUserId";
        AbstractList userList = new LinkedList<LytUser>();
        for (int i = 0; i < userIdList.size(); ++i) {
            userId = (String)userIdList.get(i);
            String[] keys = new String[]{"", "", "", userId};
            JSONObject result = this.sendHttpReqGet(keys, url);
            LytUser lytUser = (LytUser)JSONObject.toJavaObject((JSON)result.getJSONObject("data"), LytUser.class);
            userList.add(lytUser);
            if (userList.size() != 30 && Integer.compare(i, userIdList.size() - 1) != 0) continue;
            this.lytUserService.updateUserListInfo(userList, this.lesseeCode);
            userList = new ArrayList();
        }
        return ResultVo.success((Object)"\u540c\u6b65\u7528\u6237\u6570\u636e\u5b8c\u6210");
    }

    @GetMapping(value={"/orgTree"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811-\u786e\u8ba4")
    public Object queryOrgTree(@RequestParam(value="parentId", required=false, defaultValue="") String parentId, @RequestParam(value="lesseeCode", required=false, defaultValue="") String code) {
        StringBuffer url = new StringBuffer("/busi/organization/getOrgTree");
        if (StringUtils.isBlank((String)code)) {
            code = this.lesseeCode;
        }
        url.append("?lesseeCode=").append(code);
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        JSONArray array = result.getJSONArray("data");
        this.lytUserService.updateOrgInfo(array, code);
        return result;
    }

    @GetMapping(value={"/userByOrgTree"})
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u7528\u6237-\u786e\u8ba4")
    public Object queryOrgUserList(String orgId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="1000") Integer pageSize) {
        StringBuffer url = new StringBuffer("/busi/organization/getUserList");
        url.append("?orgId=").append(orgId).append("&lesseeCode=").append(this.lesseeCode).append("&appId=").append(this.appId).append("&page=").append(page).append("&pageSize=").append(pageSize);
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        return result;
    }

    @GetMapping(value={"/userByOrgId"})
    @ApiOperation(value="\u904d\u5386\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784-\u7528\u6237\u5173\u8054\uff08\u786e\u8ba4\uff09")
    public Object queryOrgUserListByTask(@RequestParam(value="code", required=false, defaultValue="") String code, @RequestParam(value="orgId", required=false, defaultValue="") String orgId) {
        List list = new ArrayList<String>();
        if (StringUtils.isBlank((String)code)) {
            code = this.lesseeCode;
        }
        if (StringUtils.isNotBlank((String)orgId)) {
            list.add(orgId);
        } else {
            list = this.lytUserService.queryUserOrgList(code);
        }
        for (String dbOrgId : list) {
            StringBuffer url = new StringBuffer("/busi/organization/getUserList");
            url.append("?orgId=").append(dbOrgId).append("&lesseeCode=").append(code).append("&appId=").append(this.appId).append("&page=").append(1).append("&pageSize=").append(1000);
            String[] keys = new String[]{"", "", "", ""};
            JSONObject result = this.sendHttpReqGet(keys, url.toString());
            this.lytUserService.updateUserOrgInfo(result.getJSONObject("data").getJSONArray("rows"), dbOrgId, code);
        }
        return null;
    }

    @GetMapping(value={"/orgRoleList"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7ec4\u5217\u8868")
    public Object queryOrgRoleList(Integer lesseeCode) {
        StringBuffer url = new StringBuffer("/busi/role/getRoleGroupList");
        url.append("?lesseeCode=").append(lesseeCode);
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        return result;
    }

    @GetMapping(value={"/orgRoleTreeList"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6811\u5217\u8868-\u786e\u8ba4")
    public Object queryOrgRoleList(@RequestParam(value="lesseeCode", required=false, defaultValue="") String code, @RequestParam(value="parentId", required=false, defaultValue="") String parentId) {
        if (StringUtils.isBlank((String)code)) {
            code = this.lesseeCode;
        }
        StringBuffer url = new StringBuffer("/busi/role/getRoleTree");
        url.append("?lesseeCode=").append(code);
        if (StringUtils.isNotBlank((String)parentId)) {
            url.append("&parentId=").append(parentId);
        }
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        JSONArray array = result.getJSONArray("data");
        for (int i = 0; i < array.size(); ++i) {
            LytRole lytRole = (LytRole)JSONObject.toJavaObject((JSON)array.getJSONObject(i), LytRole.class);
            this.lytUserService.updateLytRoleTree(lytRole, code);
        }
        return result;
    }

    @GetMapping(value={"/userInfoListByRoleId"})
    @ApiOperation(value="\u540c\u6b65\u89d2\u8272\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5217\u8868(\u5206\u9875)-\u786e\u8ba4")
    public Object updateOrgRoleUserList(@RequestParam(value="code", required=false, defaultValue="") String code, @RequestParam(value="roleId", required=false, defaultValue="") String roleId, @RequestParam(value="type", required=false, defaultValue="") String type) {
        if (StringUtils.isBlank((String)code)) {
            code = this.lesseeCode;
        }
        List<LytRole> roleIdList = new ArrayList();
        LytRole lytRole = new LytRole();
        if (StringUtils.isNotBlank((String)roleId)) {
            lytRole.setFromType(Integer.valueOf(type));
            lytRole.setRoleId(Integer.valueOf(roleId));
            roleIdList.add(lytRole);
        } else {
            roleIdList = this.lytUserService.queryUserRoleIdList(code);
        }
        for (int i = 0; i < roleIdList.size(); ++i) {
            lytRole = (LytRole)roleIdList.get(i);
            StringBuffer url = new StringBuffer("busi/role/getUserInfoListByRoleId");
            url.append("?lesseeCode=").append(code).append("&roleId=").append(lytRole.getRoleId()).append("&page=").append(1).append("&pageSize=").append(10000);
            if (lytRole.getFromType() == 1) {
                url.append("&type=").append(2);
            }
            String[] keys = new String[]{"", "", "", ""};
            JSONObject result = this.sendHttpReqGet(keys, url.toString());
            this.lytUserService.updateOrgRoleUserList(result.getJSONObject("data").getJSONArray("rows"), code);
        }
        return ResultVo.success((Object)"\u540c\u6b65\uff08\u89d2\u8272-\u7528\u6237\uff09\u5173\u8054\u6210\u529f");
    }

    @GetMapping(value={"/busi/administration/area/tree"})
    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u5212\u5217\u88681")
    public Object queryAdministrationAreaList(@RequestParam(value="code", required=false, defaultValue="") String code) {
        if (StringUtils.isBlank((String)code)) {
            code = this.lesseeCode;
        }
        StringBuffer url = new StringBuffer("busi/administration/area/tree");
        url.append("?lesseeCode=").append(code);
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        this.lytUserService.updateDistrictInfo(result.getJSONArray("data"));
        return result.getJSONArray("data");
    }

    @GetMapping(value={"/userInfoByPhone"})
    @ApiOperation(value="\u624b\u673a\u53f7\u8f6c\u6362\u4e3a\u540e\u53f0\u7684\u7528\u6237\u4fe1\u606f1")
    public JSONObject queryUserInfoByPhone(String phone) {
        StringBuffer url = new StringBuffer();
        url.append("busi/user/getUserInfoByPhone?phone=").append(phone);
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        LytUser lytUser = (LytUser)JSONObject.toJavaObject((JSON)result.getJSONObject("data"), LytUser.class);
        List<LytUser> userList = Arrays.asList(lytUser);
        this.lytUserService.updateUserListInfo(userList, this.lesseeCode);
        lytUser = this.lytUserService.queryUserAllInfoByPhone(phone, "");
        JSONObject resultJson = new JSONObject();
        resultJson.put("data", (Object)lytUser);
        return result;
    }

    @GetMapping(value={"/dduserInfoByPhone"})
    @ApiOperation(value="\u6d59\u653f\u9489\u76f4\u63a5\u67e5\u8be2\u624b\u673a\u53f7\u8f6c\u6362\u4e3a\u540e\u53f0\u7684\u7528\u6237\u4fe1\u606f1")
    public LytUser queryDDUserInfoByPhone(String phone, HttpServletResponse response) {
        StringBuffer url = new StringBuffer();
        url.append("busi/user/getUserInfoByPhone?phone=").append(phone);
        String[] keys = new String[]{"", "", "", ""};
        JSONObject result = this.sendHttpReqGet(keys, url.toString());
        LytUser lytUser = (LytUser)JSONObject.toJavaObject((JSON)result.getJSONObject("data"), LytUser.class);
        System.out.println(result);
        List<LytUser> userList = Arrays.asList(lytUser);
        this.lytUserService.updateUserListInfo(userList, this.lesseeCode);
        lytUser = this.lytUserService.queryUserAllInfoByPhone(phone, "");
        return lytUser;
    }

    public JSONObject sendHttpReqGet(String[] keys, String url) {
        JSONObject result = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        String token = this.lytUserService.queryToken();
        headers.put("Authorization", token);
        headers.put("appId", this.appId);
        headers.put("orgId", keys[1]);
        headers.put("lesseeCode", this.lesseeCode);
        headers.put("userId", keys[3]);
        String requestUrl = this.baseUrl + url;
        String response = "";
        try {
            response = HttpSendUtil.sendHttpGet((String)requestUrl, headers);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        result = JSONObject.parseObject((String)response);
        if (result.getInteger("code") == 200) {
            return result;
        }
        log.error("\u83b7\u53d6\u9f99\u6e38\u901a\u63a5\u53e3\u4fe1\u606f\u62a5\u9519,\u62a5\u9519\u8def\u5f84,{}\u548c\u4fe1\u606f\uff1a{}", (Object)url, (Object)response);
        return result;
    }

    public JSONObject sendHttpReqPost(String userId, String url, JSONObject body) {
        JSONObject result = new JSONObject();
        HashMap<String, String> headers = new HashMap<String, String>();
        String token = this.lytUserService.queryToken();
        headers.put("Authorization", token);
        headers.put("appId", this.appId);
        headers.put("orgId", this.orgId);
        headers.put("lesseeCode", this.lesseeCode);
        if (StringUtils.isNotBlank((String)userId)) {
            headers.put("userId", userId);
        }
        String response = "";
        try {
            response = HttpSendUtil.sendHttpPost((String)this.baseUrl, (String)url, (String)"", (String)body.toString(), headers);
            result = JSONObject.parseObject((String)response);
            if (result.getInteger("code") == 200) {
                result = result.getJSONObject("data");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

