/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.farm.bean.BaseFertilizer;
import com.farm.bean.FarmInfo;
import com.farm.bean.FertilizationPlan;
import com.farm.bean.PlantInfo;
import com.farm.bean.Topdressing;
import com.farm.bean.excelEntrty.DiFei;
import com.farm.bean.excelEntrty.FertilizationPlanExcel;
import com.farm.bean.excelEntrty.NongHu;
import com.farm.bean.excelEntrty.ZhongZhi;
import com.farm.bean.excelEntrty.ZuiFei;
import com.farm.mapper.FertilizationPlanMapper;
import com.farm.service.BaseFertilizerService;
import com.farm.service.FarmInfoService;
import com.farm.service.FertilizationPlanService;
import com.farm.service.PlantInfoService;
import com.farm.service.TopdressingService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImportExcelService {
    private static final Logger log = LoggerFactory.getLogger(ImportExcelService.class);
    @Resource
    private FertilizationPlanService fertilizationPlanService;
    @Resource
    private FarmInfoService farmInfoService;
    @Resource
    private PlantInfoService plantInfoService;
    @Resource
    private BaseFertilizerService baseFertilizerService;
    @Resource
    private TopdressingService topdressingService;
    @Resource
    private FertilizationPlanMapper mapper;

    public void importExcel(List<FertilizationPlanExcel> list) {
        List fertilizationPlans = BeanUtil.copyToList(list, FertilizationPlan.class);
        if (CollUtil.isNotEmpty((Collection)fertilizationPlans)) {
            int max = 1;
            FertilizationPlan entity = (FertilizationPlan)this.mapper.selectOne((Wrapper)new QueryWrapper().select(new String[]{"max(order_num) as orderNum"}));
            if (entity != null && entity.getOrderNum() != null) {
                max += entity.getOrderNum().intValue();
            }
            int finalMax = max;
            fertilizationPlans.forEach(it -> it.setOrderNum(Integer.valueOf(finalMax)));
            this.fertilizationPlanService.saveBatch((Collection)fertilizationPlans);
        }
    }

    public void importFarmExcel(List<NongHu> list) {
        List farmInfos = BeanUtil.copyToList(list, FarmInfo.class);
        if (CollUtil.isNotEmpty((Collection)farmInfos)) {
            this.farmInfoService.saveBatch((Collection)farmInfos);
        }
    }

    public void importPlantExcel(List<ZhongZhi> list) {
        List plantInfos = BeanUtil.copyToList(list, PlantInfo.class);
        if (CollUtil.isNotEmpty((Collection)plantInfos)) {
            this.plantInfoService.saveBatch((Collection)plantInfos);
        }
    }

    public void importBaseFertilizerExcel(List<DiFei> list) {
        List baseFertilizers = BeanUtil.copyToList(list, BaseFertilizer.class);
        if (CollUtil.isNotEmpty((Collection)baseFertilizers)) {
            this.baseFertilizerService.saveBatch((Collection)baseFertilizers);
        }
    }

    public void importTopdressingExcel(List<ZuiFei> list) {
        List topdressings = BeanUtil.copyToList(list, Topdressing.class);
        if (CollUtil.isNotEmpty((Collection)topdressings)) {
            this.topdressingService.saveBatch((Collection)topdressings);
        }
    }
}

