/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.AgriserveMachineDetail;
import com.farm.bean.AgriserveMachineInspect;
import com.farm.mapper.AgriculturalMachineInspectMapper;
import com.farm.mapper.AgriserveMachineMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.AgriculturalMachineService;
import com.farm.util.ResultVo;
import com.farm.util.StringUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgriculturalMachineServiceImpl
implements AgriculturalMachineService {
    @Autowired
    private AgriculturalMachineInspectMapper agriculturalMachineInspectMapper;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private WarningMapper warningMapper;
    @Autowired
    private AgriserveMachineMapper agriserveMachineMapper;

    public List<AgriserveMachineInspect> readAll(String engineNumber, String frameNumber, String inspection, String registrationNumber, String carNumber, String phone, Integer status, Integer state, Integer type, Integer page, Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List agriserveMachineInspects = this.agriculturalMachineInspectMapper.readAll(engineNumber, frameNumber, inspection, registrationNumber, carNumber, phone, status, state, type, start, pageSize);
        return agriserveMachineInspects;
    }

    public void update(List<Integer> ids) {
        this.agriculturalMachineInspectMapper.update(ids);
    }

    public ResultVo getDetail(Integer type, Integer dateType, String date) {
        AgriserveMachineDetail result = new AgriserveMachineDetail();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        HashMap manuMap = new HashMap();
        HashMap energyMap = new HashMap();
        List list = this.agriserveMachineMapper.getDetail(type, dateType, date);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<String, List<AgriserveMachineDetail>> ListMap = list.stream().collect(Collectors.groupingBy(detail -> {
                if (!Objects.isNull(detail) && StringUtils.isNotNull((Object)detail.getRegisterDate())) {
                    if (ChronoUnit.YEARS.between(LocalDate.parse(detail.getRegisterDate(), DateTimeFormatter.ISO_LOCAL_DATE), LocalDate.now()) >= 3L) {
                        return "1";
                    }
                    if (ChronoUnit.YEARS.between(LocalDate.parse(detail.getRegisterDate(), DateTimeFormatter.ISO_LOCAL_DATE), LocalDate.now()) < 3L) {
                        return "0";
                    }
                }
                return "-1";
            }));
            if (!CollectionUtils.isEmpty((Collection)ListMap.get("1"))) {
                countMap.put("\u4e09\u5e74\u4ee5\u4e0a", ListMap.get("1").size());
            }
            if (!CollectionUtils.isEmpty((Collection)ListMap.get("0"))) {
                countMap.put("\u4e09\u5e74\u4ee5\u4e0b", ListMap.get("0").size());
            }
            if (!CollectionUtils.isEmpty((Collection)ListMap.get("-1"))) {
                countMap.put("\u672a\u77e5\u5e74\u9650", ListMap.get("-1").size());
            }
            result.setAgeStatistics(countMap);
            Map<String, List<AgriserveMachineDetail>> map = list.stream().collect(Collectors.groupingBy(detail -> {
                if (!Objects.isNull(detail)) {
                    return StringUtils.isNotNull((Object)detail.getManufactor()) ? detail.getManufactor() : "\u672a\u77e5\u54c1\u724c";
                }
                return null;
            }));
            map.keySet().forEach(s -> {
                if (!Objects.isNull(s)) {
                    manuMap.put(s, ((List)map.get(s)).size());
                }
            });
            result.setBrandStatistics(manuMap);
            if (type == 3) {
                Map<String, List<AgriserveMachineDetail>> enMap = list.stream().collect(Collectors.groupingBy(detail -> {
                    if (!Objects.isNull(detail)) {
                        return StringUtils.isNotNull((Object)detail.getEnergyType()) ? detail.getEnergyType() : "\u672a\u77e5\u80fd\u6e90";
                    }
                    return null;
                }));
                enMap.keySet().forEach(s -> {
                    if (!Objects.isNull(s)) {
                        energyMap.put(s, ((List)enMap.get(s)).size());
                    }
                });
                result.setEnergyStatistics(energyMap);
            }
        }
        return ResultVo.success((Object)result);
    }

    public ResultVo getAllMachineNum(Integer dateType, String date) {
        List resultMapList = this.agriserveMachineMapper.queryAllCount(dateType, date);
        return ResultVo.success((Object)resultMapList);
    }

    public ResultVo getProportion(Integer dateType, String date) {
        List resultMapList = this.agriserveMachineMapper.queryAllCount(dateType, date);
        long sum = 0L;
        if (!CollectionUtils.isEmpty((Collection)resultMapList)) {
            for (Map resultMap : resultMapList) {
                if (CollectionUtils.isEmpty((Map)resultMap)) continue;
                Long num = (Long)resultMap.get("num");
                sum += num.longValue();
            }
        }
        List warnMapList = this.warningMapper.queryCount(dateType, date);
        long allSum = 0L;
        if (!CollectionUtils.isEmpty((Collection)warnMapList)) {
            for (Map warnMap : warnMapList) {
                if (CollectionUtils.isEmpty((Map)warnMap)) continue;
                long num = (Long)warnMap.get("num");
                allSum += num;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", "\u672a\u9884\u8b66");
        result.put("num", sum - allSum < 0L ? 0L : sum - allSum);
        warnMapList.add(result);
        return ResultVo.success((Object)warnMapList);
    }

    public ResultVo getAreaNum(Integer dateType, String date, String regionCode) {
        return ResultVo.success((Object)this.agriserveMachineMapper.getAreaNum(dateType, date, regionCode));
    }

    public ResultVo getAreaList(Integer dateType, String date, String regionCode, List<String> types) {
        List list = this.agriserveMachineMapper.getAreaList(dateType, date, regionCode, types);
        return ResultVo.success((Object)list);
    }

    public Integer getCount(String registrationNumber, String carNumber, String inspection, String phone, Integer status, Integer state, Integer type) {
        return this.agriculturalMachineInspectMapper.getCount(registrationNumber, carNumber, inspection, phone, status, state, type);
    }
}

