/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.client.http.PostClient;
import com.farm.bean.LabelResultMap;
import com.farm.bean.ZnmFarmer;
import com.farm.bean.ZnmField;
import com.farm.bean.resultMap.RegionResultMap;
import com.farm.bean.resultMap.ZnmFieldResultMap;
import com.farm.config.ZzdConfig;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.mapper.LytDistrictMapper;
import com.farm.mapper.ZnmFarmerMapper;
import com.farm.mapper.ZnmFieldMapper;
import com.farm.service.ConfigService;
import com.farm.service.OrganService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class ConfigServiceImpl
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Resource(name="fieldDoubleStatusMapper")
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private LytDistrictMapper lytDistrictMapper;
    @Autowired
    private OrganService organService;
    @Autowired
    private ZnmFieldMapper znmFieldMapper;
    @Autowired
    private ZnmFarmerMapper znmFarmerMapper;

    public List<String> queryDownRegions(String regionCode) {
        List<String> firList = Arrays.asList(regionCode);
        List list = this.queryDownRegionsByLoop(firList, firList);
        return list;
    }

    public List<String> queryDownRegionsByLoop(List<String> firList, List<String> regionCodes) {
        ArrayList<String> firList1 = new ArrayList<String>(firList);
        List downCodes = this.fieldDoubleStatusMapper.queryDownRegions(regionCodes);
        if (downCodes == null || downCodes.size() == 0) {
            return firList;
        }
        firList1.addAll(downCodes);
        return this.queryDownRegionsByLoop(firList1, downCodes);
    }

    public List<LabelResultMap> queryDownRegionNames(String regionCode) {
        List list = this.fieldDoubleStatusMapper.queryDownRegionNames(regionCode);
        if (list == null || list.size() == 0) {
            LabelResultMap it = this.fieldDoubleStatusMapper.querySelfRegionNames(regionCode);
            list.add(it);
        }
        return list;
    }

    public String queryLyFieldToken(String appKey, String secretKey, Integer flag) {
        Long timeSecond = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String reqKey = "lytGoveRequestSec";
        String freKey = "lytGoveFreshSec";
        String requestSecret = "";
        String refreshSecret = "";
        if (flag == 0) {
            requestSecret = (String)this.redisTemplate.opsForValue().get((Object)reqKey);
            refreshSecret = (String)this.redisTemplate.opsForValue().get((Object)freKey);
        }
        String url = "";
        String md5Key = "";
        if (StringUtils.isBlank((String)requestSecret)) {
            if (StringUtils.isBlank((String)refreshSecret)) {
                url = "http://dw.qz.gov.cn/gateway/app/refreshTokenByKey.htm";
                md5Key = secretKey;
            } else {
                url = "http://dw.qz.gov.cn/gateway/app/refreshTokenBySec.htm";
                md5Key = refreshSecret;
            }
            String sign = appKey + md5Key + timeSecond;
            String md5 = DigestUtils.md5DigestAsHex((byte[])sign.getBytes()).toLowerCase();
            StringBuffer params = new StringBuffer();
            params.append("?appKey=").append(appKey).append("&sign=").append(md5).append("&requestTime=").append(timeSecond.toString());
            String response = HttpSendUtil.sendHttpGet((String)(url + params.toString()));
            JSONObject resJson = JSONObject.parseObject((String)response).getJSONObject("datas");
            Long reqDurationTime = resJson.getLong("requestSecretEndTime") - timeSecond;
            Long freDurationTime = resJson.getLong("refreshSecretEndTime") - timeSecond;
            requestSecret = resJson.getString("requestSecret");
            refreshSecret = resJson.getString("refreshSecret");
            this.redisTemplate.opsForValue().set((Object)reqKey, (Object)requestSecret, reqDurationTime.longValue(), TimeUnit.MILLISECONDS);
            this.redisTemplate.opsForValue().set((Object)freKey, (Object)refreshSecret, freDurationTime.longValue(), TimeUnit.MILLISECONDS);
        }
        return requestSecret;
    }

    public JSONObject queryAreaByRegionLoop(String regionCode) {
        JSONObject json = new JSONObject();
        List list = this.lytDistrictMapper.queryAllDownRegions(regionCode);
        RegionResultMap it = (RegionResultMap)list.get(0);
        it = this.queryByRegionLoop(it, list);
        json.put("it", (Object)it);
        return json;
    }

    public String queryDetailAddress(String regionCode) {
        return this.queryTownAddress(regionCode) + this.queryHamletAddress(regionCode);
    }

    public String queryTownAddress(String regionCode) {
        String town = "";
        if (regionCode.length() > 8 && StringUtils.isBlank((String)(town = (String)this.redisTemplate.opsForValue().get((Object)regionCode.substring(0, 9))))) {
            town = this.lytDistrictMapper.queryRegionName(regionCode.substring(0, 9));
            if (town != null) {
                this.redisTemplate.opsForValue().set((Object)regionCode.substring(0, 9), (Object)town);
            } else {
                town = "";
            }
        }
        return town;
    }

    public String queryHamletAddress(String regionCode) {
        String hamlet = "";
        if (regionCode.length() > 11 && StringUtils.isBlank((String)(hamlet = (String)this.redisTemplate.opsForValue().get((Object)regionCode.substring(0, 12))))) {
            hamlet = this.lytDistrictMapper.queryRegionName(regionCode.substring(0, 12));
            if (hamlet != null) {
                this.redisTemplate.opsForValue().set((Object)regionCode.substring(0, 12), (Object)hamlet);
            } else {
                hamlet = "";
            }
        }
        return hamlet;
    }

    public String queryRegionName(String regionCode) {
        String regionName = (String)this.redisTemplate.opsForValue().get((Object)regionCode);
        if (StringUtils.isBlank((String)regionName)) {
            regionName = this.lytDistrictMapper.queryRegionName(regionCode);
            if (regionName != null) {
                this.redisTemplate.opsForValue().set((Object)regionCode, (Object)regionName);
            } else {
                regionName = "";
            }
        }
        return regionName;
    }

    public JSONObject sendDingTalkPostReq(String api, Map<String, String> paramMap) {
        ZzdConfig zzdConfig = new ZzdConfig();
        PostClient postClient = zzdConfig.genExecutableClient().newPostClient(api);
        for (String key : paramMap.keySet()) {
            postClient.addParameter(key, paramMap.get(key));
        }
        postClient.addParameter("access_token", this.organService.queryAccessToken());
        JSONObject json = JSONObject.parseObject((String)postClient.post());
        return json;
    }

    public JSONObject queryDownRegion(String regionCode) {
        List list = this.fieldDoubleStatusMapper.queryDownRegionNames(regionCode);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        return json;
    }

    public void upsertZnmField(String dkbm, String znmBatchId, String yunPicUrl, Integer fieldId, String farmerName, String fieldName) {
        ZnmField znmField = new ZnmField();
        znmField.setCode(dkbm);
        List list = this.znmFieldMapper.queryAll(znmField);
        if (list == null || list.size() == 0) {
            znmField.setFieldId(fieldId);
            znmField.setUrl(yunPicUrl);
            znmField.setZnmBatchId(znmBatchId);
            znmField.setFieldName(fieldName);
            znmField.setFarmerName(farmerName);
            this.znmFieldMapper.insert(znmField);
        }
    }

    public ZnmField queryZnmByFieldId(Integer fieldId) {
        ZnmField znmField = new ZnmField();
        znmField.setFieldId(fieldId);
        List list = this.znmFieldMapper.queryAll(znmField);
        if (list != null && list.size() > 0) {
            return (ZnmField)list.get(0);
        }
        return null;
    }

    public List<ZnmFieldResultMap> queryFieldInfo(Integer fieldId) {
        return this.fieldDoubleStatusMapper.queryZnmById(fieldId);
    }

    public ZnmFarmer queryZnmByFarmerId(String farmerId) {
        return this.znmFarmerMapper.queryByFarmerId(farmerId);
    }

    public ZnmFarmer queryByIdentityCard(String identityCard) {
        return this.znmFarmerMapper.queryByIdentityCard(identityCard);
    }

    public Integer insertZnmFarmer(ZnmFarmer farmer) {
        return this.znmFarmerMapper.insertZnmFarmer(farmer);
    }

    public JSONObject sendPlatformFour(JSONObject reqJson) {
        JSONObject resJson = new JSONObject();
        try {
            String result = HttpSendUtil.sendHttpPost((String)"https://zldq.qzdj.gov.cn/api/slgcapi/four/plate/report/api", (String)"", (String)"", (String)reqJson.toJSONString());
            log.info("\u63a8\u9001\u7ed3\u679c\uff1a{},{}", (Object)result);
            resJson = JSONObject.parseObject((String)result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("\u63a8\u9001\u7ed9\u56db\u5e73\u53f0\u7684\u6570\u636e\u7ed3\u679c{}", (Object)resJson);
        return resJson;
    }

    private RegionResultMap queryByRegionLoop(RegionResultMap parent, List<RegionResultMap> list) {
        Iterator<RegionResultMap> iterator = list.iterator();
        List sonList = parent.getSubList();
        while (iterator.hasNext()) {
            RegionResultMap son = iterator.next();
            if (!son.getParentId().equals(parent.getId())) continue;
            son = this.queryByRegionLoop(son, list);
            sonList.add(son);
        }
        parent.setSubList(sonList);
        return parent;
    }
}

